/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.process;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.edit.Commands;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xmlutil.XMLCatalogs;
import com.xmlmind.xmleditapp.process.Msg;
import com.xmlmind.xmleditapp.process.ProcessCommand;
import com.xmlmind.xmleditapp.process.ProcessCommandItem;
import com.xmlmind.xmleditapp.process.ProcessCommandItemException;
import com.xmlmind.xmleditapp.process.ProcessThread;
import com.xmlmind.xmleditapp.process.StyleSheetCache;
import java.io.File;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class TransformItem
extends ProcessCommandItem
implements ErrorListener {
    private String styleSheet;
    private boolean cacheStyleSheet;
    private String input;
    private String output;
    private String[] parameters;
    private int styleSheetIndex;
    private String styleSheetProperty;
    private Console console = null;

    public TransformItem(String string, boolean bl, String string2, String string3, String[] stringArray) {
        this.styleSheet = string;
        this.cacheStyleSheet = bl;
        this.input = string2;
        this.output = string3;
        this.parameters = stringArray;
        this.styleSheetIndex = -1;
        this.styleSheetProperty = null;
    }

    void setProcessCommand(ProcessCommand processCommand) {
        super.setProcessCommand(processCommand);
        int n = 0;
        ProcessCommandItem[] processCommandItemArray = processCommand.getItems();
        int n2 = 0;
        while (n2 < processCommandItemArray.length) {
            ProcessCommandItem processCommandItem = processCommandItemArray[n2];
            if (processCommandItem == this) {
                this.styleSheetIndex = n;
                break;
            }
            if (processCommandItem instanceof TransformItem) {
                ++n;
            }
            ++n2;
        }
    }

    public String getStyleSheet() {
        return this.styleSheet;
    }

    public void setStyleSheet(String string) {
        this.styleSheet = string;
    }

    public boolean isStyleSheetCached() {
        return this.cacheStyleSheet;
    }

    public String getInput() {
        return this.input;
    }

    public String getOutput() {
        return this.output;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public void setParameters(String[] stringArray) {
        this.parameters = stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(Document document, File file, String[] stringArray, String[] stringArray2, Console console) throws Exception {
        this.console = console;
        try {
            this.doExecute(file, stringArray, stringArray2);
            Object var7_6 = null;
            this.console = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.console = null;
            throw throwable;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(File file, String[] stringArray, String[] stringArray2) throws Exception {
        String[] stringArray3;
        CharSequence charSequence;
        String string = null;
        URL uRL = this.getCustomStyleSheet();
        if (uRL != null) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("<property name=\"");
            ((StringBuffer)charSequence).append(this.styleSheetProperty);
            ((StringBuffer)charSequence).append("\">");
            string = ((StringBuffer)charSequence).toString();
        }
        if (string == null) {
            string = ProcessCommandItem.substitute(this.styleSheet, stringArray, stringArray2);
        }
        charSequence = ProcessCommandItem.substitute(this.input, stringArray, stringArray2);
        String string2 = ProcessCommandItem.substitute(this.output, stringArray, stringArray2);
        this.console.showMessage(Msg.msg("transformingXML", charSequence, string2, string), 0);
        File file2 = ProcessCommandItem.resolve((String)charSequence, file);
        if (!file2.isFile()) {
            throw new ProcessCommandItemException(Msg.msg("notAFile", file2));
        }
        File file3 = ProcessCommandItem.resolve(string2, file);
        if (file3.isDirectory()) {
            file3 = new File(file3, file2.getName());
        }
        if (uRL == null) {
            uRL = XMLCatalogs.resolveURI(string, this.processCommand.getConfigurationURL());
        }
        this.console.showMessage(Msg.msg("compilingStyleSheet", URLUtil.toDisplayForm(uRL)), 0);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setErrorListener(this);
        URIResolver uRIResolver = XMLCatalogs.getURIResolver();
        transformerFactory.setURIResolver(uRIResolver);
        Transformer transformer = this.cacheStyleSheet ? StyleSheetCache.newTransformer(transformerFactory, uRL) : transformerFactory.newTransformer(new StreamSource(uRL.toExternalForm()));
        if (ProcessThread.canceled()) {
            return;
        }
        this.console.showMessage(Msg.msg("processingXML", file2), 0);
        transformer.setErrorListener(this);
        if (this.parameters != null) {
            stringArray3 = ProcessCommandItem.substituteParameters(this.parameters, stringArray, stringArray2);
            int n = 0;
            while (n < stringArray3.length) {
                transformer.setParameter(stringArray3[n], stringArray3[n + 1]);
                n += 2;
            }
        }
        stringArray3 = TransformItem.newXMLReader();
        stringArray3.setEntityResolver(XMLCatalogs.getEntityResolver());
        SAXSource sAXSource = new SAXSource((XMLReader)stringArray3, new InputSource(FileUtil.fileToURL(file2).toExternalForm()));
        transformer.setURIResolver(uRIResolver);
        FileOutputStream fileOutputStream = new FileOutputStream(file3);
        StreamResult streamResult = new StreamResult(fileOutputStream);
        streamResult.setSystemId(FileUtil.fileToURL(file3).toExternalForm());
        try {
            transformer.transform(sAXSource, streamResult);
            Object var18_18 = null;
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }

    private URL getCustomStyleSheet() {
        Object object;
        block5: {
            CharSequence charSequence;
            if (this.styleSheetProperty == null && this.styleSheetIndex >= 0 && (object = Commands.getName(this.processCommand)) != null) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append((String)object);
                ((StringBuffer)charSequence).append(".transform");
                if (this.styleSheetIndex > 0) {
                    ((StringBuffer)charSequence).append('.');
                    ((StringBuffer)charSequence).append(this.styleSheetIndex + 1);
                }
                this.styleSheetProperty = ((StringBuffer)charSequence).toString();
            }
            if (this.styleSheetProperty == null) {
                return null;
            }
            object = null;
            charSequence = System.getProperty(this.styleSheetProperty);
            if (charSequence == null) break block5;
            try {
                object = new URL((String)charSequence);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return object;
    }

    private static final XMLReader newXMLReader() throws ParserConfigurationException, SAXException {
        return SAXParserFactory.newInstance().newSAXParser().getXMLReader();
    }

    public void warning(TransformerException transformerException) throws TransformerException {
        this.console.showMessage(Msg.msg("transformWarning", transformerException.getMessage()), 1);
    }

    public void error(TransformerException transformerException) throws TransformerException {
        this.console.showMessage(Msg.msg("transformError", transformerException.getMessage()), 2);
    }

    public void fatalError(TransformerException transformerException) throws TransformerException {
        this.console.showMessage(Msg.msg("transformFatalError", transformerException.getMessage()), 2);
        throw transformerException;
    }

    static {
        if (System.getProperty("javax.xml.parsers.SAXParserFactory") == null) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", "com.jclark.xml.jaxp.SAXParserFactoryImpl");
        }
        if (System.getProperty("javax.xml.transform.TransformerFactory") == null) {
            System.setProperty("javax.xml.transform.TransformerFactory", "com.icl.saxon.TransformerFactoryImpl");
        }
    }
}

