/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.process;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmleditapp.process.Msg;
import com.xmlmind.xmleditapp.process.ProcessCommandItem;
import com.xmlmind.xmleditapp.process.ProcessCommandItemException;
import com.xmlmind.xmleditapp.process.ProcessThread;
import com.xmlmind.xmleditapp.upload.DAVUpload;
import com.xmlmind.xmleditapp.upload.FTPUpload;
import com.xmlmind.xmleditapp.upload.FileUpload;
import com.xmlmind.xmleditapp.upload.Upload;
import com.xmlmind.xmleditapp.upload.UploadInvoker;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public final class UploadItem
extends ProcessCommandItem {
    private String base;
    private CopyAction[] copyActions;

    public UploadItem(String string, CopyAction[] copyActionArray) {
        this.base = string;
        this.copyActions = copyActionArray;
    }

    public String getBase() {
        return this.base;
    }

    public CopyAction[] getCopyActions() {
        return this.copyActions;
    }

    public String execute(Document document, File file, String[] stringArray, String[] stringArray2, final Console console) throws Exception {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        String string = ProcessCommandItem.substitute(this.base, stringArray, stringArray2);
        if (string.endsWith("//") && string.length() > 2) {
            string = string.substring(0, string.length() - 1);
        }
        URL uRL = new URL(string);
        console.showMessage(Msg.msg("uploadingFilesTo", URLUtil.toDisplayForm(uRL)), 0);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        int n = 0;
        while (n < this.copyActions.length) {
            File[] fileArray;
            CopyAction copyAction = this.copyActions[n];
            if (copyAction.singleFile) {
                object3 = ProcessCommandItem.substitute(copyAction.pattern, stringArray, stringArray2);
                serializable = ProcessCommandItem.resolve((String)object3, file);
                if (!((File)serializable).isFile()) {
                    throw new ProcessCommandItemException(Msg.msg("notAFile", serializable));
                }
                arrayList.add(FileUtil.fileToURL((File)serializable));
                fileArray = ProcessCommandItem.substitute(copyAction.destination, stringArray, stringArray2);
                arrayList.add(new URL(uRL, (String)fileArray));
            } else {
                object3 = ProcessCommandItem.substitute(copyAction.pattern, stringArray, stringArray2);
                serializable = ProcessCommandItem.resolve((String)object3, file);
                fileArray = ProcessCommandItem.glob((File)serializable);
                object2 = ProcessCommandItem.substitute(copyAction.destination, stringArray, stringArray2);
                if (!((String)object2).endsWith("/")) {
                    object2 = (String)object2 + '/';
                }
                object = new URL(uRL, (String)object2);
                UploadItem.addAll(fileArray, (URL)object, arrayList);
            }
            ++n;
        }
        int n2 = arrayList.size();
        if (n2 == 0) {
            return null;
        }
        object3 = new URL[n2];
        arrayList.toArray((T[])object3);
        serializable = URLUtil.getRoot(uRL, true);
        int n3 = 1;
        while (n3 < ((URL[])object3).length) {
            if (!URLUtil.getRoot(object3[n3], true).equals(serializable)) {
                throw new ProcessCommandItemException(Msg.msg("useMultipleUploadItems", URLUtil.toDisplayForm(object3[n3])));
            }
            n3 += 2;
        }
        object = uRL.getProtocol();
        if ("file".equals(object)) {
            object2 = new FileUpload();
        } else if ("http".equals(object) || "https".equals(object)) {
            object2 = new DAVUpload();
        } else if ("ftp".equals(object)) {
            object2 = new FTPUpload();
        } else {
            throw new ProcessCommandItemException(Msg.msg("uploadProtocolNotSupported", object));
        }
        if ("Professional".equals("Standard") && !"file".equals(object)) {
            throw new ProcessCommandItemException(Msg.msg("uploadProtocolDisabled", object) + "\n\n" + Msg.msg("notRestrictedInProEdition"));
        }
        ((Upload)object2).setInvoker(new UploadInvoker(){

            public void beginUpload() {
            }

            public void endUpload() {
            }

            public boolean uploading(URL uRL, URL uRL2, int n, int n2) {
                console.showMessage(Upload.uploadingMessage(uRL, uRL2, n, n2), 0);
                return !ProcessThread.canceled();
            }

            public boolean missingSource(URL uRL) {
                console.showMessage(Upload.missingSourceMessage(uRL), 0);
                return !ProcessThread.canceled();
            }
        });
        String string2 = ((Upload)object2).upload((URL[])object3, true);
        if (string2 != null) {
            throw new ProcessCommandItemException(string2);
        }
        return null;
    }

    private static final void addAll(File[] fileArray, URL uRL, ArrayList arrayList) throws MalformedURLException {
        int n = 0;
        while (n < fileArray.length) {
            File file = fileArray[n];
            String string = URIUtil.quotePath(file.getName());
            if (file.isDirectory()) {
                File[] fileArray2 = file.listFiles();
                if (fileArray2 != null && fileArray2.length > 0) {
                    if (!string.endsWith("/")) {
                        string = string + '/';
                    }
                    URL uRL2 = new URL(uRL, string);
                    UploadItem.addAll(fileArray2, uRL2, arrayList);
                }
            } else {
                arrayList.add(FileUtil.fileToURL(file));
                arrayList.add(new URL(uRL, string));
            }
            ++n;
        }
    }

    public static final class CopyAction {
        private String pattern;
        private String destination;
        private boolean singleFile;

        public CopyAction(String string, String string2, boolean bl) {
            this.pattern = string;
            this.destination = string2;
            this.singleFile = bl;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getDestination() {
            return this.destination;
        }

        public boolean isSingleFile() {
            return this.singleFile;
        }
    }
}

