/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.process;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.ZipUtil;
import com.xmlmind.xmleditapp.process.Msg;
import com.xmlmind.xmleditapp.process.ProcessCommandItem;
import com.xmlmind.xmleditapp.process.ProcessCommandItemException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.zip.ZipOutputStream;

public class ZipItem
extends ProcessCommandItem {
    protected String archive;
    protected FileSet[] fileSets;

    public ZipItem(String string, FileSet[] fileSetArray) {
        this.archive = string;
        this.fileSets = fileSetArray;
    }

    public String getArchive() {
        return this.archive;
    }

    public FileSet[] getFileSets() {
        return this.fileSets;
    }

    public String execute(Document document, File file, String[] stringArray, String[] stringArray2, Console console) throws IOException, ProcessCommandItemException {
        String string = ProcessCommandItem.substitute(this.archive, stringArray, stringArray2);
        console.showMessage(Msg.msg("creatingZipArchive", "zip", string), 0);
        File file2 = ProcessCommandItem.resolve(string, file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
        this.zipFiles(zipOutputStream, file2, file, stringArray, stringArray2, console);
        return null;
    }

    protected void zipFiles(ZipOutputStream zipOutputStream, File file, File file2, String[] stringArray, String[] stringArray2, Console console) throws IOException, ProcessCommandItemException {
        ZipUtil.Archive archive = new ZipUtil.Archive(zipOutputStream);
        HashSet<File> hashSet = new HashSet<File>();
        hashSet.add(file);
        int n = 0;
        while (n < this.fileSets.length) {
            FileSet fileSet = this.fileSets[n];
            String string = ProcessCommandItem.substitute(fileSet.baseDir, stringArray, stringArray2);
            File file3 = ProcessCommandItem.resolve(string, file2);
            if (!file3.isDirectory()) {
                throw new ProcessCommandItemException(Msg.msg("notADir", file3));
            }
            String string2 = ProcessCommandItem.substitute(fileSet.files, stringArray, stringArray2);
            File file4 = ProcessCommandItem.resolve(string2, file3);
            File[] fileArray = ProcessCommandItem.glob(file4);
            int n2 = 0;
            while (n2 < fileArray.length) {
                File file5 = fileArray[n2].getCanonicalFile();
                if (hashSet.add(file5)) {
                    console.showMessage(Msg.msg("addingToZip", file5, file), 0);
                    try {
                        archive.add(file5, file3);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ProcessCommandItemException(Msg.msg("cannotAddToZip", file5, file3, file, MiscUtil.reason(illegalArgumentException)));
                    }
                    if (file5.isDirectory()) {
                        this.addAll(file5, file3, file, archive, hashSet, console);
                    }
                }
                ++n2;
            }
            ++n;
        }
        archive.close();
    }

    private void addAll(File file, File file2, File file3, ZipUtil.Archive archive, HashSet hashSet, Console console) throws IOException, ProcessCommandItemException {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("cannot list directory '" + file + "'");
        }
        int n = 0;
        while (n < fileArray.length) {
            File file4 = fileArray[n].getCanonicalFile();
            if (hashSet.add(file4)) {
                console.showMessage(Msg.msg("addingToZip", file4, file3), 0);
                try {
                    archive.add(file4, file2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ProcessCommandItemException(Msg.msg("cannotAddToZip", file4, file2, file3, MiscUtil.reason(illegalArgumentException)));
                }
                if (file4.isDirectory()) {
                    this.addAll(file4, file2, file3, archive, hashSet, console);
                }
            }
            ++n;
        }
    }

    public static final class FileSet {
        public String files;
        public String baseDir;

        public FileSet(String string, String string2) {
            this.files = string;
            this.baseDir = string2;
        }
    }
}

