/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.spreadsheet;

public final class CellRef {
    public static final byte UNSPECIFIED = 0;
    public static final byte ABSOLUTE = 1;
    public static final byte RELATIVE = 2;
    public static final byte OFFSET = 3;
    public int row;
    public int column;
    public byte rowType;
    public byte columnType;

    public static CellRef fromString(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (string.startsWith("$[")) {
            if (!string.endsWith("]")) {
                return null;
            }
            int n5 = string.indexOf(44);
            if (n5 < 0) {
                return null;
            }
            String string2 = string.substring(2, n5);
            String string3 = string.substring(n5 + 1, string.length() - 1);
            if (string2.length() > 0) {
                switch (string2.charAt(0)) {
                    case '+': {
                        string2 = string2.substring(1);
                    }
                    case '-': {
                        n3 = 3;
                        break;
                    }
                    default: {
                        n3 = 1;
                    }
                }
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                if (n == 0) {
                    n3 = 3;
                }
            }
            if (string3.length() > 0) {
                switch (string3.charAt(0)) {
                    case '+': {
                        string3 = string3.substring(1);
                    }
                    case '-': {
                        n4 = 3;
                        break;
                    }
                    default: {
                        n4 = 1;
                    }
                }
                try {
                    n2 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                if (n2 == 0) {
                    n4 = 3;
                }
            }
        } else {
            char c;
            int n6 = string.indexOf(58);
            if (n6 >= 0) {
                string = string.substring(0, n6);
            }
            string = string.toUpperCase();
            int n7 = string.length();
            int n8 = 0;
            boolean bl = false;
            if (n8 < n7 && string.charAt(n8) == '$') {
                ++n8;
                bl = true;
            }
            int n9 = n8;
            while (n8 < n7 && (c = string.charAt(n8)) >= 'A' && c <= 'Z') {
                ++n8;
            }
            if (n8 > n9) {
                n2 = CellRef.labelToNumber(string.substring(n9, n8));
                n4 = bl ? 1 : 2;
                bl = false;
                if (n8 < n7 && string.charAt(n8) == '$') {
                    ++n8;
                    bl = true;
                }
            }
            if (n8 < n7) {
                try {
                    n = Integer.parseInt(string.substring(n8));
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                if (n <= 0) {
                    return null;
                }
                n3 = bl ? 1 : 2;
            }
        }
        try {
            return new CellRef(n, n3, n2, n4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private CellRef() {
    }

    public CellRef(int n, int n2, int n3, int n4) {
        this.row = n;
        this.rowType = (byte)n2;
        this.column = n3;
        this.columnType = (byte)n4;
        this.check();
    }

    private void check() throws IllegalArgumentException {
        if (this.rowType < 0 || this.rowType > 3) {
            throw new IllegalArgumentException("invalid row type " + this.rowType);
        }
        if (this.columnType < 0 || this.columnType > 3) {
            throw new IllegalArgumentException("invalid column type " + this.columnType);
        }
        if (this.rowType == 0 && this.columnType == 0) {
            throw new IllegalArgumentException("both row and column types are unspecified");
        }
        if (this.rowType == 2 && this.columnType == 3 || this.rowType == 3 && this.columnType == 2) {
            throw new IllegalArgumentException("cannot mix RELATIVE and OFFSET types");
        }
        if (this.row <= 0 && (this.rowType == 1 || this.rowType == 2)) {
            throw new IllegalArgumentException("invalid row number " + this.row);
        }
        if (this.column <= 0 && (this.columnType == 1 || this.columnType == 2)) {
            throw new IllegalArgumentException("invalid column number " + this.column);
        }
    }

    public boolean isAbsolute() {
        return !(this.rowType != 1 && this.rowType != 0 || this.columnType != 1 && this.columnType != 0);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CellRef)) {
            return false;
        }
        CellRef cellRef = (CellRef)object;
        return this.rowType == cellRef.rowType && this.columnType == cellRef.columnType && (this.row == cellRef.row || this.rowType == 0 && cellRef.rowType == 0) && (this.column == cellRef.column || this.columnType == 0 && cellRef.columnType == 0);
    }

    public String toString() {
        return this.toString(true, null, false);
    }

    public String toString(boolean bl, CellRef cellRef, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(bl, cellRef, bl2, stringBuffer);
        return stringBuffer.toString();
    }

    public void toString(boolean bl, CellRef cellRef, boolean bl2, StringBuffer stringBuffer) {
        this.check();
        if (cellRef != null) {
            cellRef.check();
            if (cellRef.rowType != 1 || cellRef.columnType != 1) {
                throw new IllegalArgumentException("base must be ABSOLUTE");
            }
        }
        if (this.rowType == 0) {
            switch (this.columnType) {
                case 1: {
                    if (bl) {
                        String string = CellRef.numberToLabel(this.column);
                        stringBuffer.append('$');
                        stringBuffer.append(string);
                        if (bl2) break;
                        stringBuffer.append(":$");
                        stringBuffer.append(string);
                        break;
                    }
                    stringBuffer.append("$[,");
                    stringBuffer.append(this.column);
                    stringBuffer.append(']');
                    break;
                }
                case 2: {
                    if (bl || cellRef == null) {
                        String string = CellRef.numberToLabel(this.column);
                        stringBuffer.append(string);
                        if (bl2) break;
                        stringBuffer.append(':');
                        stringBuffer.append(string);
                        break;
                    }
                    int n = this.column - cellRef.column;
                    stringBuffer.append("$[,");
                    if (n >= 0) {
                        stringBuffer.append('+');
                    }
                    stringBuffer.append(n);
                    stringBuffer.append(']');
                    break;
                }
                case 3: {
                    int n;
                    boolean bl3 = false;
                    if (bl && cellRef != null && (n = cellRef.column + this.column) >= 1) {
                        String string = CellRef.numberToLabel(n);
                        stringBuffer.append(string);
                        if (!bl2) {
                            stringBuffer.append(':');
                            stringBuffer.append(string);
                        }
                        bl3 = true;
                    }
                    if (bl3) break;
                    stringBuffer.append("$[,");
                    if (this.column >= 0) {
                        stringBuffer.append('+');
                    }
                    stringBuffer.append(this.column);
                    stringBuffer.append(']');
                }
            }
        } else if (this.columnType == 0) {
            switch (this.rowType) {
                case 1: {
                    if (bl) {
                        stringBuffer.append('$');
                        stringBuffer.append(this.row);
                        if (bl2) break;
                        stringBuffer.append(":$");
                        stringBuffer.append(this.row);
                        break;
                    }
                    stringBuffer.append("$[");
                    stringBuffer.append(this.row);
                    stringBuffer.append(",]");
                    break;
                }
                case 2: {
                    if (bl || cellRef == null) {
                        stringBuffer.append(this.row);
                        if (bl2) break;
                        stringBuffer.append(':');
                        stringBuffer.append(this.row);
                        break;
                    }
                    int n = this.row - cellRef.row;
                    stringBuffer.append("$[");
                    if (n >= 0) {
                        stringBuffer.append('+');
                    }
                    stringBuffer.append(n);
                    stringBuffer.append(",]");
                    break;
                }
                case 3: {
                    int n;
                    boolean bl4 = false;
                    if (bl && cellRef != null && (n = cellRef.row + this.row) >= 1) {
                        stringBuffer.append(n);
                        if (!bl2) {
                            stringBuffer.append(':');
                            stringBuffer.append(n);
                        }
                        bl4 = true;
                    }
                    if (bl4) break;
                    stringBuffer.append("$[");
                    if (this.row >= 0) {
                        stringBuffer.append('+');
                    }
                    stringBuffer.append(this.row);
                    stringBuffer.append(",]");
                }
            }
        } else {
            int n;
            int n2;
            if (bl && (this.rowType == 3 || this.columnType == 3) && cellRef == null) {
                bl = false;
            } else if (!(bl || this.rowType != 2 && this.columnType != 2 || cellRef != null)) {
                bl = true;
            }
            boolean bl5 = false;
            if (bl) {
                n2 = this.rowType == 3 ? cellRef.row + this.row : this.row;
                int n3 = n = this.columnType == 3 ? cellRef.column + this.column : this.column;
                if (n >= 1 && n2 >= 1) {
                    if (this.columnType == 1) {
                        stringBuffer.append('$');
                    }
                    stringBuffer.append(CellRef.numberToLabel(n));
                    if (this.rowType == 1) {
                        stringBuffer.append('$');
                    }
                    stringBuffer.append(n2);
                    bl5 = true;
                }
            }
            if (!bl5) {
                n2 = this.rowType == 2 ? this.row - cellRef.row : this.row;
                n = this.columnType == 2 ? this.column - cellRef.column : this.column;
                stringBuffer.append("$[");
                if (this.rowType != 1 && n2 >= 0) {
                    stringBuffer.append('+');
                }
                stringBuffer.append(n2);
                stringBuffer.append(',');
                if (this.columnType != 1 && n >= 0) {
                    stringBuffer.append('+');
                }
                stringBuffer.append(n);
                stringBuffer.append(']');
            }
        }
    }

    public static String numberToLabel(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n > 0) {
            int n2 = --n % 26;
            stringBuffer.insert(0, (char)(65 + n2));
            n /= 26;
        }
        return stringBuffer.toString();
    }

    public static int labelToNumber(String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            n = n * 26 + (c - 65 + 1);
            ++n3;
        }
        return n;
    }
}

