/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.spreadsheet;

import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.ObjectVariant;
import com.xmlmind.xmledit.xpath.Variant;
import com.xmlmind.xmledit.xsd.datatype.DateTimeValue;
import com.xmlmind.xmledit.xsd.datatype.DateValue;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.TimeValue;
import com.xmlmind.xmleditapp.spreadsheet.Msg;
import java.util.Date;

public abstract class DateVariantBase
extends ObjectVariant {
    protected DateVariantBase(Date date) {
        super(date);
    }

    public Date convertToDate() {
        return (Date)this.obj;
    }

    public double convertToNumber() {
        long l = ((Date)this.obj).getTime();
        return (double)(l / 1000L) + (double)(l % 1000L) / 1000.0;
    }

    public boolean convertToBoolean() {
        return true;
    }

    public abstract String convertToString();

    public static Date toDate(Variant variant) throws EvalException {
        if (variant instanceof DateVariantBase) {
            return (Date)((DateVariantBase)variant).obj;
        }
        if (variant.isNumber()) {
            return DateVariantBase.toDate(variant.convertToNumber());
        }
        String string = variant.convertToString();
        try {
            double d = Double.parseDouble(string);
            return DateVariantBase.toDate(d);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                if (string.indexOf(84) > 0) {
                    DateTimeValue dateTimeValue = DateTimeValue.parseDateTime(string);
                    return dateTimeValue.toDate();
                }
                int n = string.indexOf(58);
                if (n > 0 && string.indexOf(58, n + 1) > 0) {
                    TimeValue timeValue = TimeValue.parseTime(string);
                    return timeValue.toDate();
                }
                DateValue dateValue = DateValue.parseDate(string);
                return dateValue.toDate();
            }
            catch (InvalidDataException invalidDataException) {
                throw new EvalException(Msg.msg("cannotParseDate", string, invalidDataException.getMessage()));
            }
        }
    }

    public static Date toDate(double d) {
        long l = (long)d;
        long l2 = (long)((d - Math.floor(d)) * 1000.0);
        return new Date(l * 1000L + l2);
    }
}

