/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.spreadsheet;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.styledview.TableBodyVP;
import com.xmlmind.xmledit.util.LinearHashtable;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xpath.ArrayNodeIterator;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.NodeIterator;
import com.xmlmind.xmledit.xpath.NullNodeIterator;
import com.xmlmind.xmledit.xpath.PermanentNodeSetVariant;
import com.xmlmind.xmledit.xpath.SimpleExprContext;
import com.xmlmind.xmledit.xpath.SingleNodeIterator;
import com.xmlmind.xmledit.xpath.Variant;
import com.xmlmind.xmleditapp.spreadsheet.CellRef;
import com.xmlmind.xmleditapp.spreadsheet.CellsReference;
import com.xmlmind.xmleditapp.spreadsheet.CellsReferenceNode;
import com.xmlmind.xmleditapp.spreadsheet.Msg;

public class EvalContext
extends SimpleExprContext {
    LinearHashtable localVariables;
    Element referenceElement;
    TableBodyVP.RowColumn referenceCell;
    private static PermanentNodeSetVariant EMPTY_NODE_SET_VARIANT;

    public Variant getVariableValue(Name name, XNode xNode) throws EvalException {
        Variant variant;
        Object object = null;
        if (this.localVariables != null) {
            object = this.localVariables.get(name.getLocalPart());
        }
        if (object == null) {
            return null;
        }
        if (object instanceof CellsReference) {
            CellsReference cellsReference = (CellsReference)object;
            variant = cellsReference.value;
            if (variant == null) {
                CellsReferenceNode cellsReferenceNode = cellsReference.reference;
                TableBodyVP tableBodyVP = null;
                if (cellsReferenceNode.tableID != null) {
                    tableBodyVP = this.getTableWithId(cellsReferenceNode.tableID, xNode);
                } else {
                    this.checkReferenceCell(cellsReferenceNode);
                    tableBodyVP = this.referenceCell.table;
                }
                CellRef cellRef = cellsReferenceNode.ref1;
                int n = -1;
                int n2 = -1;
                if (cellRef.rowType == 3) {
                    this.checkReferenceCell(cellsReferenceNode);
                    n = cellRef.row + this.referenceCell.row;
                } else {
                    n = cellRef.row;
                }
                if (cellRef.columnType == 3) {
                    this.checkReferenceCell(cellsReferenceNode);
                    n2 = cellRef.column + this.referenceCell.column;
                } else {
                    n2 = cellRef.column;
                }
                CellRef cellRef2 = cellsReferenceNode.ref2;
                int n3 = -1;
                int n4 = -1;
                if (cellRef2 == null) {
                    n3 = n;
                    n4 = n2;
                } else {
                    if (cellRef2.rowType == 3) {
                        this.checkReferenceCell(cellsReferenceNode);
                        n3 = cellRef2.row + this.referenceCell.row;
                    } else {
                        n3 = cellRef2.row;
                    }
                    if (cellRef2.columnType == 3) {
                        this.checkReferenceCell(cellsReferenceNode);
                        n4 = cellRef2.column + this.referenceCell.column;
                    } else {
                        n4 = cellRef2.column;
                    }
                }
                NodeIterator nodeIterator = null;
                if (n == n3 && n2 == n4 && n >= 1 && n2 >= 1) {
                    Element element = tableBodyVP.getElement(n, n2);
                    if (element != null) {
                        nodeIterator = new SingleNodeIterator(element);
                    }
                } else {
                    XNode[] xNodeArray = tableBodyVP.getElements(n, n2, n3, n4);
                    if (xNodeArray != null && xNodeArray.length > 0) {
                        nodeIterator = new ArrayNodeIterator(xNodeArray);
                    }
                }
                if (nodeIterator == null) {
                    variant = EMPTY_NODE_SET_VARIANT;
                } else {
                    try {
                        variant = new PermanentNodeSetVariant(nodeIterator);
                    }
                    catch (EvalException evalException) {
                        // empty catch block
                    }
                }
                cellsReference.value = variant;
            }
        } else {
            variant = (Variant)object;
        }
        return variant;
    }

    private TableBodyVP getTableWithId(String string, XNode xNode) throws EvalException {
        Element element = (Element)this.findElementWithId(xNode, string);
        if (element == null) {
            throw new EvalException(Msg.msg("unknownId", string));
        }
        TableBodyVP tableBodyVP = TableBodyVP.findTable(element);
        if (tableBodyVP == null) {
            throw new EvalException(Msg.msg("notATable", string));
        }
        return tableBodyVP;
    }

    private void checkReferenceCell(CellsReferenceNode cellsReferenceNode) throws EvalException {
        if (this.referenceCell == null) {
            this.referenceCell = TableBodyVP.findRowColumn(this.referenceElement);
            if (this.referenceCell == null) {
                throw new EvalException(Msg.msg("cellRefOutsideATable", cellsReferenceNode.spec));
            }
        }
    }

    static {
        try {
            EMPTY_NODE_SET_VARIANT = new PermanentNodeSetVariant(new NullNodeIterator());
        }
        catch (EvalException evalException) {}
    }
}

