/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.spreadsheet;

import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.Variant;
import com.xmlmind.xmleditapp.spreadsheet.DateVariantBase;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;

public final class FormatUtil {
    private static Locale[] availableLocales = null;
    private static HashMap localeMap = null;
    public static final int UNKNOWN_TYPE = 0;
    public static final int NUMBER_TYPE = 1;
    public static final int DATE_TYPE = 2;
    public static final int TIME_TYPE = 3;
    public static final int DATE_TIME_TYPE = 4;
    private static HashMap formatMap = new HashMap();
    private static FormatEntry probe = new FormatEntry(null, null, null);
    private static DecimalFormatSymbols defaultSymbols = null;
    private static FieldPosition ignoredFieldPosition = new FieldPosition(0);

    public static Locale[] getAvailableLocales() {
        if (availableLocales == null) {
            availableLocales = Locale.getAvailableLocales();
        }
        return availableLocales;
    }

    public static String toLabel(Locale locale) {
        return locale.toString().replace('_', '-');
    }

    public static Locale getLocale(String string) {
        if (localeMap == null) {
            localeMap = new HashMap();
            Locale[] localeArray = FormatUtil.getAvailableLocales();
            int n = 0;
            while (n < localeArray.length) {
                Locale locale = localeArray[n];
                String string2 = locale.toString().toLowerCase();
                localeMap.put(string2, locale);
                string2 = string2.replace('_', '-');
                localeMap.put(string2, locale);
                ++n;
            }
        }
        return (Locale)localeMap.get(string.toLowerCase());
    }

    public static Format getFormat(String string, Locale locale, int n) throws IllegalArgumentException {
        if (string.length() == 0) {
            switch (n) {
                case 1: {
                    if (locale == null) {
                        return NumberFormat.getInstance();
                    }
                    return NumberFormat.getInstance(locale);
                }
                case 2: {
                    if (locale == null) {
                        return DateFormat.getDateInstance(3);
                    }
                    return DateFormat.getDateInstance(3, locale);
                }
                case 3: {
                    if (locale == null) {
                        return DateFormat.getTimeInstance(3);
                    }
                    return DateFormat.getTimeInstance(3, locale);
                }
                case 4: {
                    if (locale == null) {
                        return DateFormat.getDateTimeInstance(3, 3);
                    }
                    return DateFormat.getDateTimeInstance(3, 3, locale);
                }
            }
            throw new IllegalArgumentException("empty pattern");
        }
        FormatUtil.probe.pattern = string;
        FormatUtil.probe.locale = locale;
        FormatEntry formatEntry = (FormatEntry)formatMap.get(probe);
        if (formatEntry == null) {
            Format format;
            if (string.indexOf(35) >= 0 || string.indexOf(48) >= 0) {
                DecimalFormatSymbols decimalFormatSymbols;
                if (locale == null) {
                    if (defaultSymbols == null) {
                        defaultSymbols = new DecimalFormatSymbols();
                        FormatUtil.setDecimalFormatSymbols(defaultSymbols);
                    }
                    decimalFormatSymbols = defaultSymbols;
                } else {
                    decimalFormatSymbols = new DecimalFormatSymbols(locale);
                    FormatUtil.setDecimalFormatSymbols(decimalFormatSymbols);
                }
                format = new DecimalFormat(string, decimalFormatSymbols);
            } else {
                format = locale == null ? new SimpleDateFormat(string) : new SimpleDateFormat(string, locale);
            }
            formatEntry = new FormatEntry(string, locale, format);
            formatMap.put(formatEntry, formatEntry);
        }
        return formatEntry.format;
    }

    private static void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        decimalFormatSymbols.setNaN("NaN");
        decimalFormatSymbols.setInfinity("Infinity");
    }

    public static String getPattern(Format format) {
        if (format instanceof DecimalFormat) {
            return ((DecimalFormat)format).toPattern();
        }
        if (format instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)format).toPattern();
        }
        return null;
    }

    public static String format(String string, Format format, String string2, Variant variant) throws EvalException {
        if (string == null && format == null && string2 == null) {
            return variant.convertToString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
        }
        FormatUtil.format(format, variant, stringBuffer);
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String format(Format format, Variant variant) throws EvalException {
        StringBuffer stringBuffer = new StringBuffer();
        FormatUtil.format(format, variant, stringBuffer);
        return stringBuffer.toString();
    }

    public static void format(Format format, Variant variant, StringBuffer stringBuffer) throws EvalException {
        if (format != null) {
            if (format instanceof NumberFormat) {
                ((NumberFormat)format).format(variant.convertToNumber(), stringBuffer, ignoredFieldPosition);
            } else if (format instanceof DateFormat) {
                ((DateFormat)format).format(DateVariantBase.toDate(variant), stringBuffer, ignoredFieldPosition);
            } else {
                stringBuffer.append(variant.convertToString());
            }
        } else {
            stringBuffer.append(variant.convertToString());
        }
    }

    private static final class FormatEntry {
        public String pattern;
        public Locale locale;
        public Format format;

        public FormatEntry(String string, Locale locale, Format format) {
            this.pattern = string;
            this.locale = locale;
            this.format = format;
        }

        public int hashCode() {
            int n = this.pattern.hashCode();
            if (this.locale != null) {
                n ^= this.locale.hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof FormatEntry)) {
                return false;
            }
            FormatEntry formatEntry = (FormatEntry)object;
            return this.pattern.equals(formatEntry.pattern) && (this.locale == null && formatEntry.locale == null || this.locale != null && this.locale.equals(formatEntry.locale));
        }
    }
}

