/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.spreadsheet;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.doctype.Field;
import com.xmlmind.xmledit.doctype.UnconstrainedElementType;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.DialogBase;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.styledview.TableBodyVP;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.PlatformUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.SimpleExprContext;
import com.xmlmind.xmledit.xpath.Variant;
import com.xmlmind.xmleditapp.spreadsheet.AssignNode;
import com.xmlmind.xmleditapp.spreadsheet.CellRef;
import com.xmlmind.xmleditapp.spreadsheet.CellsReferenceNode;
import com.xmlmind.xmleditapp.spreadsheet.Constants;
import com.xmlmind.xmleditapp.spreadsheet.EvalContext;
import com.xmlmind.xmleditapp.spreadsheet.ExpressionNode;
import com.xmlmind.xmleditapp.spreadsheet.FormatUtil;
import com.xmlmind.xmleditapp.spreadsheet.FormulaFunction;
import com.xmlmind.xmleditapp.spreadsheet.FormulaFunctions;
import com.xmlmind.xmleditapp.spreadsheet.FormulaNode;
import com.xmlmind.xmleditapp.spreadsheet.FunctionCallNode;
import com.xmlmind.xmleditapp.spreadsheet.Msg;
import com.xmlmind.xmleditapp.spreadsheet.ParseException;
import com.xmlmind.xmleditapp.spreadsheet.ParsedPIData;
import com.xmlmind.xmleditapp.spreadsheet.Parser;
import com.xmlmind.xmleditapp.spreadsheet.ParserUtil;
import com.xmlmind.xmleditapp.spreadsheet.TokenMgrError;
import com.xmlmind.xmleditapp.spreadsheet.TranslatedFormula;
import com.xmlmind.xmleditapp.spreadsheet.VariableReferenceNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.StringReader;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.html.HTMLEditorKit;

public class FormulaEditor
extends DialogBase
implements CaretListener,
MouseListener,
ListSelectionListener,
HyperlinkListener,
ExpressionNode.Checker,
Constants {
    private JTabbedPane tabs;
    private JButton evalButton;
    private JButton evalSelectionButton;
    private JButton functionHelpButton;
    private JTextArea formulaText;
    private JCheckBox formatToggle;
    private JTextField formatPrefixText;
    private JTextField formatText;
    private JButton formatMenuButton;
    private JPopupMenu formatMenu;
    private JComboBox localeCombo;
    private int formatMenuWidth;
    private JTextField formatSuffixText;
    private JCheckBox attributeToggle;
    private JComboBox attributeCombo;
    private JCheckBox disabledToggle;
    private JComboBox categoryCombo;
    private JList functionList;
    private JButton pasteButton;
    private JEditorPane docPane;
    private Element parentElement = null;
    private FormulaFunctions moreFunctions = null;
    private CellRef cellRefBase = null;
    private ElementType elementType = null;
    private SimpleExprContext idMaps = null;
    private HashSet localVariables = null;
    private boolean updatingBrowser = false;
    private String result = null;
    private static String[] localeComboData = null;
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$spreadsheet$FormulaEditor;

    public FormulaEditor(Component component) {
        super(component, Msg.msg("FE.title"), true);
        this.initialize(component, 94);
    }

    protected Component createForm() {
        this.tabs = new JTabbedPane();
        JPanel jPanel = this.createEditor();
        String string = Msg.msg("FE.formula");
        this.tabs.addTab(DialogUtil.buttonLabel(string), jPanel);
        DialogUtil.setDisplayedMnemonic(this.tabs, 0, string);
        JPanel jPanel2 = this.createBrowser();
        string = Msg.msg("FE.pasteFunction");
        this.tabs.addTab(DialogUtil.buttonLabel(string), jPanel2);
        DialogUtil.setDisplayedMnemonic(this.tabs, 1, string);
        return this.tabs;
    }

    public String editFormula(String string, Element element) {
        this.parentElement = element;
        this.moreFunctions = (FormulaFunctions)element.getDocument().getProperty("com.xmlmind.xmleditapp.spreadsheet.FORMULA_FUNCTIONS");
        TableBodyVP.RowColumn rowColumn = TableBodyVP.findRowColumn(element);
        this.cellRefBase = rowColumn != null ? new CellRef(rowColumn.row, 1, rowColumn.column, 1) : null;
        this.elementType = DocumentTypeUtil.getElementType(element);
        this.initEditor(string);
        this.initBrowser();
        this.tabs.setSelectedIndex(0);
        this.dialogButtons[0].setEnabled(element.isEditable());
        this.getRootPane().setDefaultButton(this.dialogButtons[0]);
        this.pack();
        this.setLocationRelativeTo(this.dialogAnchor);
        this.formulaText.requestFocus();
        this.setVisible(true);
        this.parentElement = null;
        this.moreFunctions = null;
        this.cellRefBase = null;
        this.elementType = null;
        return this.result;
    }

    private JPanel createEditor() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        this.formulaText = new JTextArea(5, 80);
        Font font = this.formulaText.getFont();
        this.formulaText.setFont(new Font("Monospaced", 0, Math.max(12, font.getSize() - 2)));
        this.formulaText.setLineWrap(false);
        this.formulaText.setWrapStyleWord(false);
        this.formulaText.addCaretListener(this);
        int n = PlatformUtil.IS_MAC_OS ? 4 : 2;
        Keymap keymap = JTextArea.addKeymap(null, this.formulaText.getKeymap());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, n), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormulaEditor.this.ok();
            }
        });
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(112, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormulaEditor.this.functionHelp();
            }
        });
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(113, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormulaEditor.this.evaluate(true);
            }
        });
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(114, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormulaEditor.this.evaluate(false);
            }
        });
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(')'), new ShowMatchingChar('(', ')'));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(']'), new ShowMatchingChar('[', ']'));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke('}'), new ShowMatchingChar('{', '}'));
        this.formulaText.setKeymap(keymap);
        JScrollPane jScrollPane = new JScrollPane(this.formulaText);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)jToolBar, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 0));
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        String string = Msg.msg("FE.disabled");
        this.disabledToggle = new JCheckBox(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.disabledToggle, string);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)this.disabledToggle, gridBagConstraints);
        this.functionHelpButton = new JButton(new ImageIcon((class$com$xmlmind$xmleditapp$spreadsheet$FormulaEditor == null ? (class$com$xmlmind$xmleditapp$spreadsheet$FormulaEditor = FormulaEditor.class$("com.xmlmind.xmleditapp.spreadsheet.FormulaEditor")) : class$com$xmlmind$xmleditapp$spreadsheet$FormulaEditor).getResource("funchelp.gif")));
        DialogUtil.setIconic(this.functionHelpButton);
        this.functionHelpButton.setToolTipText("F1 " + Msg.msg("FE.functionHelpToolTip"));
        this.functionHelpButton.setActionCommand("functionHelp");
        this.functionHelpButton.addActionListener(this);
        jToolBar.add(this.functionHelpButton);
        this.evalSelectionButton = new JButton(new ImageIcon((class$com$xmlmind$xmleditapp$spreadsheet$FormulaEditor == null ? (class$com$xmlmind$xmleditapp$spreadsheet$FormulaEditor = FormulaEditor.class$("com.xmlmind.xmleditapp.spreadsheet.FormulaEditor")) : class$com$xmlmind$xmleditapp$spreadsheet$FormulaEditor).getResource("evalsel.gif")));
        DialogUtil.setIconic(this.evalSelectionButton);
        this.evalSelectionButton.setToolTipText("F2 " + Msg.msg("FE.evalSelectionToolTip"));
        this.evalSelectionButton.setActionCommand("evalSelection");
        this.evalSelectionButton.addActionListener(this);
        jToolBar.add(this.evalSelectionButton);
        this.evalButton = new JButton(new ImageIcon((class$com$xmlmind$xmleditapp$spreadsheet$FormulaEditor == null ? (class$com$xmlmind$xmleditapp$spreadsheet$FormulaEditor = FormulaEditor.class$("com.xmlmind.xmleditapp.spreadsheet.FormulaEditor")) : class$com$xmlmind$xmleditapp$spreadsheet$FormulaEditor).getResource("eval.gif")));
        DialogUtil.setIconic(this.evalButton);
        this.evalButton.setToolTipText("F3 " + Msg.msg("FE.evalToolTip"));
        this.evalButton.setActionCommand("eval");
        this.evalButton.addActionListener(this);
        jToolBar.add(this.evalButton);
        string = Msg.msg("FE.setAttribute");
        this.attributeToggle = new JCheckBox(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.attributeToggle, string);
        this.attributeToggle.setActionCommand("toggleAttribute");
        this.attributeToggle.addActionListener(this);
        jPanel3.add(this.attributeToggle);
        this.attributeCombo = new JComboBox();
        this.attributeCombo.setEditable(true);
        JTextField jTextField = (JTextField)this.attributeCombo.getEditor().getEditorComponent();
        jTextField.setColumns(20);
        jPanel3.add(this.attributeCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        string = Msg.msg("FE.format");
        this.formatToggle = new JCheckBox(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.formatToggle, string);
        this.formatToggle.setActionCommand("toggleFormat");
        this.formatToggle.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.formatToggle, gridBagConstraints);
        this.formatPrefixText = new JTextField(15);
        this.formatPrefixText.setActionCommand("ok");
        this.formatPrefixText.addActionListener(this);
        ++gridBagConstraints.gridx;
        jPanel2.add((Component)this.formatPrefixText, gridBagConstraints);
        this.formatText = new JTextField(20);
        this.formatText.setActionCommand("ok");
        this.formatText.addActionListener(this);
        ++gridBagConstraints.gridx;
        jPanel2.add((Component)this.formatText, gridBagConstraints);
        this.formatMenuButton = new JButton(new ImageIcon((class$com$xmlmind$xmleditapp$spreadsheet$FormulaEditor == null ? (class$com$xmlmind$xmleditapp$spreadsheet$FormulaEditor = FormulaEditor.class$("com.xmlmind.xmleditapp.spreadsheet.FormulaEditor")) : class$com$xmlmind$xmleditapp$spreadsheet$FormulaEditor).getResource("list.gif")));
        DialogUtil.setIconic(this.formatMenuButton);
        this.formatMenuButton.setToolTipText(Msg.msg("FE.formatMenuToolTip"));
        this.formatMenuButton.addMouseListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 1;
        jPanel2.add((Component)this.formatMenuButton, gridBagConstraints);
        this.localeCombo = new JComboBox<String>(FormulaEditor.getLocaleComboData());
        ++gridBagConstraints.gridx;
        jPanel2.add((Component)this.localeCombo, gridBagConstraints);
        this.formatSuffixText = new JTextField(15);
        this.formatSuffixText.setActionCommand("ok");
        this.formatSuffixText.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 5;
        jPanel2.add((Component)this.formatSuffixText, gridBagConstraints);
        return jPanel;
    }

    private static final String[] getLocaleComboData() {
        if (localeComboData == null) {
            Locale[] localeArray = FormatUtil.getAvailableLocales();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("-");
            int n = 0;
            while (n < localeArray.length) {
                Locale locale = localeArray[n];
                String string = locale.getVariant();
                if (string == null || string.length() <= 0) {
                    arrayList.add(FormatUtil.toLabel(locale));
                }
                ++n;
            }
            localeComboData = new String[arrayList.size()];
            arrayList.toArray(localeComboData);
            Arrays.sort(localeComboData, 1, localeComboData.length);
        }
        return localeComboData;
    }

    private void initEditor(String string) {
        ParsedPIData parsedPIData = new ParsedPIData();
        String[] stringArray = new String[5];
        if (string != null) {
            try {
                ParsedPIData.splitData(string, stringArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (stringArray[0] != null) {
            try {
                parsedPIData.formula = ParsedPIData.parseFormula(stringArray[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (stringArray[1] != null) {
            try {
                parsedPIData.locale = ParsedPIData.parseLocale(stringArray[1]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (stringArray[2] != null) {
            Object[] objectArray = new Object[3];
            try {
                ParsedPIData.parseFormat(stringArray[2], objectArray, parsedPIData.locale);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            parsedPIData.formatPrefix = (String)objectArray[0];
            parsedPIData.format = (Format)objectArray[1];
            parsedPIData.formatSuffix = (String)objectArray[2];
        }
        if (stringArray[3] != null) {
            parsedPIData.disabled = ParsedPIData.parseDisabled(stringArray[3]);
        }
        if (stringArray[4] != null) {
            try {
                parsedPIData.attributeName = ParsedPIData.parseAttributeName(stringArray[4], this.parentElement);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (parsedPIData.formula == null) {
            if (stringArray[0] == null) {
                this.formulaText.setText("=");
                this.formulaText.setCaretPosition(1);
            } else {
                this.formulaText.setText(stringArray[0]);
                this.formulaText.moveCaretPosition(0);
            }
        } else {
            this.formulaText.setText(parsedPIData.formula.toString(true, this.cellRefBase));
            this.formulaText.setCaretPosition(0);
        }
        this.formulaText.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
        if (parsedPIData.format != null || parsedPIData.formatPrefix != null || parsedPIData.formatSuffix != null) {
            this.formatToggle.setSelected(true);
            this.formatPrefixText.setText(parsedPIData.formatPrefix == null ? "" : parsedPIData.formatPrefix);
            this.formatText.setText(parsedPIData.format == null ? "" : FormatUtil.getPattern(parsedPIData.format));
            if (parsedPIData.locale != null) {
                this.localeCombo.setSelectedItem(FormatUtil.toLabel(parsedPIData.locale));
            } else {
                this.localeCombo.setSelectedIndex(0);
            }
            this.formatSuffixText.setText(parsedPIData.formatSuffix == null ? "" : parsedPIData.formatSuffix);
        } else {
            this.formatToggle.setSelected(false);
            this.formatPrefixText.setText("");
            this.formatText.setText("");
            this.localeCombo.setSelectedIndex(0);
            this.formatSuffixText.setText("");
        }
        this.initAttributes(this.attributeCombo);
        if (parsedPIData.attributeName != null) {
            this.attributeToggle.setSelected(true);
            this.attributeCombo.setSelectedItem(new AttributeItem(parsedPIData.attributeName));
        } else {
            this.attributeToggle.setSelected(false);
            this.attributeCombo.setSelectedIndex(0);
        }
        this.disabledToggle.setSelected(parsedPIData.disabled);
        this.toggleAttribute();
        this.toggleFormat();
        this.evalSelectionButton.setEnabled(false);
        this.functionHelpButton.setEnabled(false);
    }

    private void initAttributes(JComboBox jComboBox) {
        DefaultComboBoxModel<AttributeItem> defaultComboBoxModel = new DefaultComboBoxModel<AttributeItem>();
        defaultComboBoxModel.addElement(new AttributeItem(null));
        if (this.elementType != null) {
            Object object;
            IdentityHashMap<Name[], Name[]> identityHashMap = new IdentityHashMap<Name[], Name[]>();
            Field[] fieldArray = this.elementType.getAttributeFields();
            int n = 0;
            while (n < fieldArray.length) {
                object = fieldArray[n].getFieldName();
                if (object != null) {
                    identityHashMap.put((Name[])object, (Name[])object);
                }
                ++n;
            }
            object = new Name[identityHashMap.size()];
            identityHashMap.values().toArray((T[])object);
            if (((Name[])object).length > 1) {
                Arrays.sort(object, new Comparator(){

                    public int compare(Object object, Object object2) {
                        Name name = (Name)object;
                        Name name2 = (Name)object2;
                        return name.compareTo(name2);
                    }
                });
            }
            int n2 = 0;
            while (n2 < ((Name[])object).length) {
                defaultComboBoxModel.addElement(new AttributeItem(object[n2]));
                ++n2;
            }
        }
        jComboBox.setModel(defaultComboBoxModel);
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getDot() == caretEvent.getMark()) {
            if (this.evalSelectionButton.isEnabled()) {
                this.evalSelectionButton.setEnabled(false);
                this.functionHelpButton.setEnabled(false);
            }
        } else if (!this.evalSelectionButton.isEnabled()) {
            this.evalSelectionButton.setEnabled(true);
            this.functionHelpButton.setEnabled(true);
        }
    }

    public void ok() {
        ParsedPIData parsedPIData;
        String string;
        block11: {
            block12: {
                Object object;
                if (!this.dialogButtons[0].isEnabled()) {
                    return;
                }
                Object[] objectArray = this.compileFormula(false);
                if (objectArray == null) {
                    return;
                }
                string = (String)objectArray[0];
                FormulaNode formulaNode = (FormulaNode)objectArray[1];
                TranslatedFormula translatedFormula = (TranslatedFormula)objectArray[2];
                parsedPIData = new ParsedPIData();
                parsedPIData.formula = formulaNode;
                if (this.attributeToggle.isSelected()) {
                    object = (AttributeItem)this.attributeCombo.getSelectedItem();
                    if (object.attributeName == null) {
                        this.getToolkit().beep();
                        this.attributeCombo.requestFocus();
                        return;
                    }
                    parsedPIData.attributeName = object.attributeName;
                }
                if ((object = this.compileFormat()) == null) {
                    return;
                }
                parsedPIData.formatPrefix = (String)object[0];
                parsedPIData.locale = (Locale)object[1];
                parsedPIData.format = (Format)object[2];
                parsedPIData.formatSuffix = (String)object[3];
                parsedPIData.disabled = this.disabledToggle.isSelected();
                if (this.elementType == null || this.elementType instanceof UnconstrainedElementType) break block11;
                if (parsedPIData.attributeName != null) break block12;
                switch (this.elementType.getElementContentType()) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: {
                        break block11;
                    }
                    default: {
                        String string2 = this.parentElement.getName().format(false, this.parentElement);
                        Alert.showError(this, Msg.msg("FE.cannotContainText", string2));
                        return;
                    }
                }
            }
            boolean bl = false;
            Field[] fieldArray = this.elementType.getAttributeFields();
            int n = 0;
            while (n < fieldArray.length) {
                if (parsedPIData.attributeName == fieldArray[n].getFieldName()) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                String string3 = this.parentElement.getName().format(false, this.parentElement);
                String string4 = parsedPIData.attributeName.format(true, this.parentElement);
                Alert.showError(this, Msg.msg("FE.notAnAttribute", string4, string3));
                return;
            }
        }
        this.result = parsedPIData.toString(string, this.parentElement);
        this.setVisible(false);
        this.dispose();
    }

    private Object[] compileFormula(boolean bl) {
        String string = null;
        string = bl ? this.formulaText.getSelectedText() : this.formulaText.getText();
        if (string != null) {
            string = string.trim();
            if (bl && !string.startsWith("=")) {
                string = "=" + string;
            }
        }
        if (string == null || "=".equals(string)) {
            Alert.showError(this, Msg.msg("FE.nothingToCompile"));
            this.formulaText.requestFocus();
            return null;
        }
        FormulaNode formulaNode = null;
        String string2 = null;
        int n = -1;
        int n2 = -1;
        try {
            formulaNode = Parser.parse(string);
        }
        catch (ParseException parseException) {
            n = ParserUtil.getLine(parseException);
            n2 = ParserUtil.getColumn(parseException);
            string2 = Msg.msg("FE.syntaxError", parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            string2 = Msg.msg("FE.syntaxError", tokenMgrError.getMessage());
        }
        if (string2 != null) {
            Alert.showError(this, string2);
            if (!bl && n > 0) {
                try {
                    int n3 = this.formulaText.getLineStartOffset(n - 1);
                    if (n2 > 0) {
                        n3 += n2 - 1;
                    }
                    this.formulaText.setCaretPosition(n3);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            this.formulaText.requestFocus();
            return null;
        }
        this.idMaps = new SimpleExprContext();
        this.localVariables = new HashSet();
        String string3 = (String)formulaNode.check(this);
        this.idMaps = null;
        this.localVariables = null;
        if (string3 != null) {
            Alert.showError(this, string3);
            this.formulaText.requestFocus();
            return null;
        }
        TranslatedFormula translatedFormula = null;
        try {
            string = formulaNode.toString(false, this.cellRefBase);
            formulaNode = ParsedPIData.parseFormula(string);
            translatedFormula = TranslatedFormula.translate(formulaNode, (PrefixToNamespace)this.parentElement, this.moreFunctions);
        }
        catch (Exception exception) {
            Alert.showError(this, Msg.msg("FE.cannotTranslateToXPath", MiscUtil.reason(exception)));
            this.formulaText.requestFocus();
            return null;
        }
        return new Object[]{string, formulaNode, translatedFormula};
    }

    public Object check(ExpressionNode expressionNode) {
        String string;
        if (expressionNode instanceof FunctionCallNode) {
            FunctionCallNode functionCallNode = (FunctionCallNode)expressionNode;
            if (!functionCallNode.name.startsWith("_")) {
                FormulaFunction formulaFunction = this.getFunction(functionCallNode.name);
                if (formulaFunction == null) {
                    return Msg.msg("FE.unknownFunction", functionCallNode.name);
                }
                int n = functionCallNode.arguments.length;
                int n2 = formulaFunction.getMinParameterCount();
                if (n < n2) {
                    return Msg.msg("FE.tooFewArgs", functionCallNode.name, new Integer(n), new Integer(n2));
                }
                int n3 = formulaFunction.getMaxParameterCount();
                if (n > n3) {
                    return Msg.msg("FE.tooManyArgs", functionCallNode.name, new Integer(n), new Integer(n3));
                }
            }
        } else if (expressionNode instanceof CellsReferenceNode) {
            CellsReferenceNode cellsReferenceNode = (CellsReferenceNode)expressionNode;
            if (this.cellRefBase != null) {
                if (!FormulaEditor.checkOffset(cellsReferenceNode.ref1, this.cellRefBase) || cellsReferenceNode.ref2 != null && !FormulaEditor.checkOffset(cellsReferenceNode.ref2, this.cellRefBase)) {
                    return Msg.msg("FE.negativeRowColumn", cellsReferenceNode.spec, this.cellRefBase.toString());
                }
            } else {
                if (cellsReferenceNode.tableID == null) {
                    return Msg.msg("cellRefOutsideATable", cellsReferenceNode.spec);
                }
                Element element = null;
                try {
                    element = (Element)this.idMaps.findElementWithId(this.parentElement, cellsReferenceNode.tableID);
                }
                catch (EvalException evalException) {
                    // empty catch block
                }
                if (element == null) {
                    return "\"" + cellsReferenceNode.tableID + "\"!" + cellsReferenceNode.spec + ":\n" + Msg.msg("unknownId", cellsReferenceNode.tableID);
                }
                TableBodyVP tableBodyVP = TableBodyVP.findTable(element);
                if (tableBodyVP == null) {
                    return "\"" + cellsReferenceNode.tableID + "\"!" + cellsReferenceNode.spec + ":\n" + Msg.msg("notATable", cellsReferenceNode.tableID);
                }
                if (!cellsReferenceNode.ref1.isAbsolute() || cellsReferenceNode.ref2 != null && !cellsReferenceNode.ref2.isAbsolute()) {
                    return Msg.msg("cellRefOutsideATable", cellsReferenceNode.spec);
                }
            }
        } else if (expressionNode instanceof AssignNode) {
            this.localVariables.add(((AssignNode)expressionNode).variable);
        } else if (expressionNode instanceof VariableReferenceNode && !this.localVariables.contains(string = ((VariableReferenceNode)expressionNode).name)) {
            return Msg.msg("FE.unknownVariable", string);
        }
        return null;
    }

    private static final boolean checkOffset(CellRef cellRef, CellRef cellRef2) {
        if (cellRef.rowType == 3 && cellRef.row + cellRef2.row < 1) {
            return false;
        }
        return cellRef.columnType != 3 || cellRef.column + cellRef2.column >= 1;
    }

    private Object[] compileFormat() {
        String string = null;
        Locale locale = null;
        Format format = null;
        String string2 = null;
        if (this.formatToggle.isSelected()) {
            String string3;
            string = this.formatPrefixText.getText();
            if (string.trim().length() == 0) {
                string = null;
            }
            if ((string3 = this.formatText.getText()).trim().length() == 0) {
                string3 = null;
            }
            if ((string2 = this.formatSuffixText.getText()).trim().length() == 0) {
                string2 = null;
            }
            if (string == null && string3 == null && string2 == null) {
                this.getToolkit().beep();
                this.formatText.requestFocus();
                return null;
            }
            String string4 = (String)this.localeCombo.getSelectedItem();
            locale = "-".equals(string4) ? null : FormatUtil.getLocale(string4);
            if (string3 != null) {
                try {
                    format = FormatUtil.getFormat(string3, locale, 0);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Alert.showError(this, Msg.msg("FE.invalidFormat", string3, MiscUtil.reason(illegalArgumentException)));
                    this.formatText.requestFocus();
                    return null;
                }
            } else {
                format = new MessageFormat("{0}");
            }
        }
        return new Object[]{string, locale, format, string2};
    }

    public void cancel() {
        this.result = null;
        this.setVisible(false);
        this.dispose();
    }

    public void eval() {
        this.evaluate(false);
    }

    public void evalSelection() {
        this.evaluate(true);
    }

    private void evaluate(boolean bl) {
        Object object;
        Object object2;
        Object[] objectArray = this.compileFormula(bl);
        if (objectArray == null) {
            return;
        }
        TranslatedFormula translatedFormula = (TranslatedFormula)objectArray[2];
        String string = null;
        Locale locale = null;
        Format format = null;
        String string2 = null;
        if (!bl) {
            object2 = this.compileFormat();
            if (object2 == null) {
                return;
            }
            string = (String)object2[0];
            locale = (Locale)object2[1];
            format = (Format)object2[2];
            string2 = (String)object2[3];
        }
        object2 = null;
        String string3 = null;
        EvalContext evalContext = new EvalContext();
        try {
            object = translatedFormula.eval(this.parentElement, evalContext);
            object2 = object.convertToString();
            if (!(bl || string == null && format == null && string2 == null)) {
                string3 = FormatUtil.format(string, format, string2, (Variant)object);
            }
        }
        catch (EvalException evalException) {
            Alert.showError(this, Msg.msg("FE.cannotEvaluate", evalException.getMessage()));
            this.formulaText.requestFocus();
            return;
        }
        object = new StringBuffer();
        ((StringBuffer)object).append(Msg.msg("FE.result"));
        ((StringBuffer)object).append('\n');
        ((StringBuffer)object).append((String)object2);
        if (string3 != null) {
            ((StringBuffer)object).append("\n\n");
            ((StringBuffer)object).append(Msg.msg("FE.formattedResult"));
            ((StringBuffer)object).append('\n');
            ((StringBuffer)object).append(string3);
        }
        Alert.showInfo(this, ((StringBuffer)object).toString());
        this.formulaText.requestFocus();
    }

    public void functionHelp() {
        String string = this.formulaText.getSelectedText();
        if (string == null) {
            return;
        }
        if (!this.go(string.trim().toLowerCase())) {
            this.getToolkit().beep();
        } else {
            this.tabs.setSelectedIndex(1);
        }
    }

    public void toggleAttribute() {
        boolean bl = this.attributeToggle.isSelected();
        this.attributeCombo.setEnabled(bl);
    }

    public void toggleFormat() {
        boolean bl = this.formatToggle.isSelected();
        this.formatPrefixText.setEnabled(bl);
        this.formatText.setEnabled(bl);
        this.formatMenuButton.setEnabled(bl);
        this.localeCombo.setEnabled(bl);
        this.formatSuffixText.setEnabled(bl);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        JButton jButton = (JButton)mouseEvent.getSource();
        if (!jButton.isEnabled()) {
            return;
        }
        if (this.formatMenu == null) {
            this.formatMenu = new JPopupMenu();
            String[] stringArray = new String[]{"-", "0", "0.0", "0.00", "0.000", "0.0000", "0.00000", "0.000000", "0.###E0", "00.###E0", "000.###E0", "#,##0.00", "-", "dd/MM/yyyy", "MM/dd/yyyy", "yyyy-MM-dd", "HH:mm:ss", "hh:mm:ss a", "dd/MM/yyyy HH:mm:ss", "MM/dd/yyyy hh:mm:ss a", "yyyy-MM-dd HH:mm:ss"};
            int n = 0;
            while (n < stringArray.length) {
                this.formatMenu.add(new FormatMenuAction(stringArray[n]));
                ++n;
            }
            this.formatMenu.pack();
            Dimension dimension = this.formatMenu.getPreferredSize();
            this.formatMenuWidth = dimension.width;
        }
        this.formatMenu.show(jButton, -this.formatMenuWidth, jButton.getHeight());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private JPanel createBrowser() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        String string = Msg.msg("FE.category");
        JLabel jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.categoryCombo = new JComboBox();
        this.categoryCombo.setActionCommand("selectCategory");
        this.categoryCombo.addActionListener(this);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 1;
        jPanel.add((Component)this.categoryCombo, gridBagConstraints);
        jLabel.setLabelFor(this.categoryCombo);
        this.functionList = new JList();
        this.functionList.setSelectionMode(0);
        this.functionList.setPrototypeCellValue("xxxxxxxxxxxxxxxxxxxx");
        this.functionList.setVisibleRowCount(10);
        this.functionList.addListSelectionListener(this);
        this.functionList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    FormulaEditor.this.pasteFunction();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.functionList);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        string = Msg.msg("FE.paste");
        this.pasteButton = new JButton(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.pasteButton, string);
        this.pasteButton.setActionCommand("pasteFunction");
        this.pasteButton.addActionListener(this);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)this.pasteButton, gridBagConstraints);
        this.docPane = new JEditorPane();
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)this.docPane.getEditorKitForContentType("text/html");
        hTMLEditorKit.getStyleSheet().addRule("body { font-family: sans-serif; font-size: 12pt; }");
        this.docPane.setEditorKit(hTMLEditorKit);
        this.docPane.setEditable(false);
        this.docPane.addHyperlinkListener(this);
        FontMetrics fontMetrics = this.docPane.getFontMetrics(this.docPane.getFont());
        int n = fontMetrics.charWidth('x');
        jScrollPane = new JScrollPane(this.docPane);
        jScrollPane.setPreferredSize(new Dimension(61 * n, 41 * n));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBrowser() {
        this.updatingBrowser = true;
        try {
            this.categoryCombo.setModel(new DefaultComboBoxModel<String>(this.getCategories()));
            Object var2_1 = null;
            this.updatingBrowser = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.updatingBrowser = false;
            throw throwable;
        }
        this.selectCategory(Msg.msg("FE.all"));
        this.selectFunction(0);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.updatingBrowser) {
            return;
        }
        FormulaFunction formulaFunction = this.getSelectedFunction();
        if (formulaFunction == null) {
            return;
        }
        this.showDoc(formulaFunction);
    }

    private FormulaFunction getSelectedFunction() {
        String string = (String)this.functionList.getSelectedValue();
        if (string == null) {
            return null;
        }
        return this.getFunction(string);
    }

    private FormulaFunction getFunction(String string) {
        FormulaFunctions formulaFunctions = FormulaFunctions.getRegistry();
        FormulaFunction formulaFunction = formulaFunctions.get(string);
        if (formulaFunction == null && this.moreFunctions != null) {
            formulaFunction = this.moreFunctions.get(string);
        }
        return formulaFunction;
    }

    private void showDoc(FormulaFunction formulaFunction) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body>\n");
        stringBuffer.append("<b>");
        XMLUtil.escapeXML(formulaFunction.getName(), stringBuffer);
        stringBuffer.append("</b>(");
        String[] stringArray = formulaFunction.getParameters();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (n > 0) {
                stringBuffer.append(", ");
            }
            if (string.endsWith("+")) {
                string = string.substring(0, string.length() - 1);
                FormulaEditor.appendParam(string, true, stringBuffer);
                stringBuffer.append(", ... , ");
                FormulaEditor.appendParam(string, false, stringBuffer);
            } else if (string.endsWith("*")) {
                string = string.substring(0, string.length() - 1);
                FormulaEditor.appendParam(string, false, stringBuffer);
                stringBuffer.append(", ... , ");
                FormulaEditor.appendParam(string, false, stringBuffer);
            } else if (string.endsWith("?")) {
                string = string.substring(0, string.length() - 1);
                FormulaEditor.appendParam(string, false, stringBuffer);
            } else {
                FormulaEditor.appendParam(string, true, stringBuffer);
            }
            ++n;
        }
        stringBuffer.append(")\n<hr noshade size=\"2\">\n");
        stringBuffer.append(formulaFunction.getDescription());
        stringBuffer.append("</body></html>\n");
        try {
            this.docPane.read(new StringReader(stringBuffer.toString()), null);
        }
        catch (IOException iOException) {
            System.err.println("Internal error: " + MiscUtil.reason(iOException));
            System.err.println("Cannot display this documentation:");
            System.err.println("----------------------------------------");
            System.err.println(stringBuffer.toString());
            System.err.println("----------------------------------------");
        }
        this.docPane.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
    }

    private static final void appendParam(String string, boolean bl, StringBuffer stringBuffer) {
        if (bl) {
            stringBuffer.append("<b>");
        }
        stringBuffer.append("<i>");
        XMLUtil.escapeXML(string, stringBuffer);
        stringBuffer.append("</i>");
        if (bl) {
            stringBuffer.append("</b>");
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        String string;
        if (this.updatingBrowser) {
            return;
        }
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (string = hyperlinkEvent.getDescription()).startsWith("#")) {
            this.go(string.substring(1));
        }
    }

    private boolean go(String string) {
        FormulaFunction formulaFunction = this.getFunction(string);
        if (formulaFunction == null) {
            return false;
        }
        String string2 = formulaFunction.getCategory();
        String[] stringArray = this.getCategory(string2);
        if (stringArray == null) {
            return false;
        }
        int n = StringUtil.indexOf(stringArray, string);
        if (n < 0) {
            return false;
        }
        this.selectCategory(string2);
        this.selectFunction(n);
        return true;
    }

    private String[] getCategory(String string) {
        String[] stringArray;
        FormulaFunctions formulaFunctions = FormulaFunctions.getRegistry();
        String[] stringArray2 = null;
        if (Msg.msg("FE.all").equals(string)) {
            stringArray = formulaFunctions.getFunctions();
            if (this.moreFunctions != null) {
                stringArray2 = this.moreFunctions.getFunctions();
            }
        } else {
            stringArray = formulaFunctions.getFunctions(string);
            if (this.moreFunctions != null) {
                stringArray2 = this.moreFunctions.getFunctions(string);
            }
        }
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        if (stringArray2 != null && stringArray2.length > 0) {
            stringArray = FormulaEditor.merge(stringArray, stringArray2);
        }
        return stringArray;
    }

    private static final String[] merge(String[] stringArray, String[] stringArray2) {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < stringArray.length) {
            hashSet.add(stringArray[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray2.length) {
            hashSet.add(stringArray2[n2]);
            ++n2;
        }
        Object[] objectArray = new String[hashSet.size()];
        hashSet.toArray(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private String[] getCategories() {
        String[] stringArray;
        FormulaFunctions formulaFunctions = FormulaFunctions.getRegistry();
        String[] stringArray2 = formulaFunctions.getCategories();
        if (this.moreFunctions != null && (stringArray = this.moreFunctions.getCategories()) != null) {
            stringArray2 = FormulaEditor.merge(stringArray2, stringArray);
        }
        stringArray = new String[1 + stringArray2.length];
        stringArray[0] = Msg.msg("FE.all");
        System.arraycopy(stringArray2, 0, stringArray, 1, stringArray2.length);
        return stringArray;
    }

    public void selectCategory() {
        if (this.updatingBrowser) {
            return;
        }
        String string = (String)this.categoryCombo.getSelectedItem();
        if (string == null) {
            return;
        }
        this.selectCategory(string);
        this.selectFunction(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectCategory(String string) {
        String[] stringArray = this.getCategory(string);
        if (stringArray == null) {
            return;
        }
        this.updatingBrowser = true;
        try {
            this.categoryCombo.setSelectedItem(string);
            this.functionList.setListData(stringArray);
            Object var4_3 = null;
            this.updatingBrowser = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.updatingBrowser = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectFunction(int n) {
        this.updatingBrowser = true;
        try {
            this.functionList.setSelectedIndex(n);
            this.functionList.ensureIndexIsVisible(n);
            this.showDoc(this.getSelectedFunction());
            Object var3_2 = null;
            this.updatingBrowser = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.updatingBrowser = false;
            throw throwable;
        }
    }

    public void pasteFunction() {
        FormulaFunction formulaFunction = this.getSelectedFunction();
        if (formulaFunction == null) {
            return;
        }
        String string = formulaFunction.getName() + "()";
        int n = this.formulaText.getCaretPosition();
        try {
            this.formulaText.getDocument().insertString(n, string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        n += string.length();
        if (formulaFunction.getMaxParameterCount() > 0) {
            --n;
        }
        this.formulaText.setCaretPosition(n);
        this.tabs.setSelectedIndex(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class FormatMenuAction
    extends AbstractAction {
        private String pattern;

        public FormatMenuAction(String string) {
            this.pattern = string;
            this.putValue("Name", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ("-".equals(this.pattern)) {
                FormulaEditor.this.formatText.setText("");
            } else {
                FormulaEditor.this.formatText.setText(this.pattern);
            }
        }
    }

    public final class AttributeItem {
        public Name attributeName;

        public AttributeItem(Name name) {
            this.attributeName = name;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof AttributeItem)) {
                return false;
            }
            return this.attributeName == ((AttributeItem)object).attributeName;
        }

        public String toString() {
            if (this.attributeName == null) {
                return "-";
            }
            return this.attributeName.format(true, FormulaEditor.this.parentElement);
        }

        public AttributeItem valueOf(String string) {
            Name name = Name.parse(string.trim(), true, FormulaEditor.this.parentElement);
            return new AttributeItem(name);
        }
    }

    public final class ShowMatchingChar
    extends AbstractAction
    implements Highlighter.HighlightPainter {
        private char openChar;
        private char closeChar;

        public ShowMatchingChar(char c, char c2) {
            this.openChar = c;
            this.closeChar = c2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Document document = FormulaEditor.this.formulaText.getDocument();
            int n = FormulaEditor.this.formulaText.getCaretPosition();
            String string = null;
            try {
                string = document.getText(0, n);
                document.insertString(n, Character.toString(this.closeChar), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            int n2 = -1;
            int n3 = 1;
            int n4 = string.length() - 1;
            while (n4 >= 0) {
                char c = string.charAt(n4);
                if (c == this.closeChar) {
                    ++n3;
                } else if (c == this.openChar && --n3 == 0) {
                    n2 = n4;
                    break;
                }
                --n4;
            }
            if (n2 < 0) {
                FormulaEditor.this.getToolkit().beep();
                return;
            }
            Highlighter highlighter = FormulaEditor.this.formulaText.getHighlighter();
            Object object = null;
            try {
                object = highlighter.addHighlight(n2, n2 + 1, this);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            Object object2 = object;
            Timer timer = new Timer(500, new ActionListener(this, highlighter, object2){
                private final /* synthetic */ Highlighter val$highlighter;
                private final /* synthetic */ Object val$highlight;
                private final /* synthetic */ ShowMatchingChar this$1;
                {
                    this.this$1 = showMatchingChar;
                    this.val$highlighter = highlighter;
                    this.val$highlight = object;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$highlighter.removeHighlight(this.val$highlight);
                }
            });
            timer.setRepeats(false);
            timer.start();
        }

        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            Rectangle rectangle = null;
            try {
                rectangle = jTextComponent.modelToView(n);
                rectangle.add(jTextComponent.modelToView(n2));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            graphics.setColor(Color.pink);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

