/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.spreadsheet;

import com.xmlmind.xmledit.xpath.SimpleFunction;
import com.xmlmind.xmleditapp.spreadsheet.MacroFunction;
import com.xmlmind.xmleditapp.spreadsheet.Msg;
import java.lang.reflect.Method;

public final class FormulaFunction
implements SimpleFunction {
    private String name;
    private String[] parameters;
    private String category;
    private String description;
    private Method staticMethod;
    private MacroFunction macroFunction;
    private boolean predefined;
    private int[] parameterCount;

    public FormulaFunction(Method method, String string, String[] stringArray, String string2, String string3) throws IllegalArgumentException {
        this(method, string, stringArray, string2, string3, false);
        if (method == null) {
            throw new IllegalArgumentException(Msg.msg("invalidFormulaFunction"));
        }
    }

    public FormulaFunction(MacroFunction macroFunction, String string, String string2) throws IllegalArgumentException {
        this(macroFunction, string, string2, false);
    }

    FormulaFunction(Method method, String string, String[] stringArray, String string2, String string3, boolean bl) throws IllegalArgumentException {
        if (string == null || stringArray == null || string2 == null || string3 == null) {
            throw new IllegalArgumentException(Msg.msg("invalidFormulaFunction"));
        }
        this.name = string;
        this.parameters = stringArray;
        this.category = string2;
        this.description = string3;
        this.staticMethod = method;
        this.macroFunction = null;
        this.predefined = bl;
    }

    FormulaFunction(MacroFunction macroFunction, String string, String string2, boolean bl) throws IllegalArgumentException {
        if (macroFunction == null || string == null || string2 == null) {
            throw new IllegalArgumentException(Msg.msg("invalidFormulaFunction"));
        }
        this.name = macroFunction.getFunctionName();
        this.parameters = macroFunction.getParameterNames();
        this.category = string;
        this.description = string2;
        this.staticMethod = null;
        this.macroFunction = macroFunction;
        this.predefined = bl;
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public boolean isIntrinsic() {
        return this.staticMethod == null && this.macroFunction == null;
    }

    public boolean isNative() {
        return this.staticMethod != null;
    }

    public boolean isMacro() {
        return this.macroFunction != null;
    }

    public Method getStaticMethod() {
        return this.staticMethod;
    }

    public MacroFunction getMacroFunction() {
        return this.macroFunction;
    }

    public String getName() {
        return this.name;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public int[] getParameterCount() {
        if (this.parameterCount == null) {
            this.parameterCount = new int[2];
            int n = 0;
            while (n < this.parameters.length) {
                String string = this.parameters[n];
                if (string.endsWith("+")) {
                    this.parameterCount[0] = this.parameterCount[0] + 1;
                    this.parameterCount[1] = Integer.MAX_VALUE;
                } else if (string.endsWith("*")) {
                    this.parameterCount[1] = Integer.MAX_VALUE;
                } else if (string.endsWith("?")) {
                    if (this.parameterCount[1] != Integer.MAX_VALUE) {
                        this.parameterCount[1] = this.parameterCount[1] + 1;
                    }
                } else {
                    this.parameterCount[0] = this.parameterCount[0] + 1;
                    if (this.parameterCount[1] != Integer.MAX_VALUE) {
                        this.parameterCount[1] = this.parameterCount[1] + 1;
                    }
                }
                ++n;
            }
        }
        return this.parameterCount;
    }

    public int getMinParameterCount() {
        int[] nArray = this.getParameterCount();
        return nArray[0];
    }

    public int getMaxParameterCount() {
        int[] nArray = this.getParameterCount();
        return nArray[1];
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FormulaFunction[");
        stringBuffer.append("name=");
        stringBuffer.append(this.name);
        stringBuffer.append(",parameters=");
        int n = 0;
        while (n < this.parameters.length) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.parameters[n]);
            ++n;
        }
        stringBuffer.append(",category=");
        stringBuffer.append(this.category);
        stringBuffer.append(",description=");
        stringBuffer.append(this.description);
        stringBuffer.append(",staticMethod=");
        stringBuffer.append(this.staticMethod);
        stringBuffer.append(",macroFunction=");
        stringBuffer.append(this.macroFunction);
        stringBuffer.append(",predefined=");
        stringBuffer.append(this.predefined);
        return stringBuffer.toString();
    }

    public Object getObject() {
        return this.macroFunction != null ? this.macroFunction : null;
    }

    public Method getMethod() {
        return this.macroFunction != null ? this.macroFunction.getMethod() : this.staticMethod;
    }
}

