/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.spreadsheet;

import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.PreferredPrefix;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xpath.SimpleFunction;
import com.xmlmind.xmledit.xpath.SimpleFunctionTable;
import com.xmlmind.xmleditapp.spreadsheet.Constants;
import com.xmlmind.xmleditapp.spreadsheet.FormulaFunction;
import com.xmlmind.xmleditapp.spreadsheet.MacroFunction;
import com.xmlmind.xmleditapp.spreadsheet.Msg;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class FormulaFunctions
implements SimpleFunctionTable,
Constants {
    private HashMap functions = new HashMap();
    private String[] categories = null;
    private String[] functionNames = null;
    private HashMap categoryToFunctions = new HashMap();
    private static FormulaFunctions registry = null;
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$spreadsheet$FunctionLibrary;
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$spreadsheet$FormulaFunctions;

    public void register(FormulaFunction formulaFunction) throws IllegalArgumentException {
        String string = formulaFunction.getName();
        FormulaFunction formulaFunction2 = (FormulaFunction)this.functions.get(string);
        if (formulaFunction2 != null && formulaFunction2.isPredefined()) {
            throw new IllegalArgumentException(Msg.msg("predefinedFormulaFunction", string));
        }
        this.functions.put(string, formulaFunction);
        this.categories = null;
        this.functionNames = null;
        this.categoryToFunctions.clear();
    }

    public FormulaFunction get(String string) {
        return (FormulaFunction)this.functions.get(string);
    }

    public int size() {
        return this.functions.size();
    }

    public Iterator iterator() {
        return this.functions.values().iterator();
    }

    public void unregisterAllNonPredefined() {
        HashMap<String, FormulaFunction> hashMap = new HashMap<String, FormulaFunction>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            FormulaFunction formulaFunction = (FormulaFunction)iterator.next();
            if (!formulaFunction.isPredefined()) continue;
            hashMap.put(formulaFunction.getName(), formulaFunction);
        }
        this.functions = hashMap;
        this.categories = null;
        this.functionNames = null;
        this.categoryToFunctions.clear();
    }

    public String[] getCategories() {
        if (this.categories == null) {
            this.initCategories();
        }
        return this.categories;
    }

    public String[] getFunctions() {
        if (this.categories == null) {
            this.initCategories();
        }
        return this.functionNames;
    }

    public String[] getFunctions(String string) {
        if (this.categories == null) {
            this.initCategories();
        }
        return (String[])this.categoryToFunctions.get(string);
    }

    private void initCategories() {
        Object[] objectArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        this.categoryToFunctions.clear();
        Iterator iterator = this.functions.values().iterator();
        while (iterator.hasNext()) {
            objectArray = (Object[])iterator.next();
            String string = objectArray.getName();
            String string2 = objectArray.getCategory();
            hashMap.put(string2, string2);
            arrayList.add(string);
            String[] stringArray = (String[])this.categoryToFunctions.get(string2);
            stringArray = stringArray == null ? new String[]{string} : StringUtil.append(stringArray, string);
            this.categoryToFunctions.put(string2, stringArray);
        }
        this.categories = new String[hashMap.size()];
        hashMap.values().toArray(this.categories);
        if (this.categories.length > 1) {
            Arrays.sort(this.categories);
        }
        this.functionNames = new String[arrayList.size()];
        arrayList.toArray(this.functionNames);
        if (this.functionNames.length > 1) {
            Arrays.sort(this.functionNames);
        }
        iterator = this.categoryToFunctions.values().iterator();
        while (iterator.hasNext()) {
            objectArray = (String[])iterator.next();
            if (objectArray.length <= 1) continue;
            Arrays.sort(objectArray);
        }
    }

    public SimpleFunction getSimpleFunction(String string) {
        return (SimpleFunction)this.functions.get(string);
    }

    public static FormulaFunction[] load(URL uRL) throws IOException {
        return FormulaFunctions.load(uRL, false);
    }

    private static FormulaFunction[] load(URL uRL, boolean bl) throws IOException {
        Object object;
        if (System.getProperty("javax.xml.parsers.SAXParserFactory") == null) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", "com.jclark.xml.jaxp.SAXParserFactoryImpl");
        }
        SAXParser sAXParser = null;
        try {
            object = SAXParserFactory.newInstance();
            ((SAXParserFactory)object).setNamespaceAware(true);
            ((SAXParserFactory)object).setValidating(false);
            sAXParser = ((SAXParserFactory)object).newSAXParser();
        }
        catch (Exception exception) {
            throw new IOException(Msg.msg("cannotCreateXMLParser", MiscUtil.reason(exception)));
        }
        object = new ArrayList();
        PreferredPrefix preferredPrefix = new PreferredPrefix();
        String string = null;
        try {
            sAXParser.parse(uRL.toString(), (DefaultHandler)new FunctionLoader((ArrayList)object, preferredPrefix));
        }
        catch (SAXParseException sAXParseException) {
            string = Msg.msg("syntaxErrorInFunctionsFile", new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()), sAXParseException.getMessage());
        }
        catch (Exception exception) {
            string = MiscUtil.reason(exception);
        }
        if (string != null) {
            throw new IOException(Msg.msg("cannotLoadFunctionsFile", uRL, string));
        }
        int n = ((ArrayList)object).size();
        FormulaFunction[] formulaFunctionArray = new FormulaFunction[n];
        int n2 = 0;
        while (n2 < n) {
            FunctionRecord functionRecord = (FunctionRecord)((ArrayList)object).get(n2);
            if ((functionRecord.intrinsic || functionRecord.runtime) && !bl) {
                throw new IOException(Msg.msg("predefinedFunctionNotAllowed", functionRecord.name));
            }
            try {
                Method method = null;
                MacroFunction macroFunction = null;
                if (functionRecord.runtime) {
                    method = FormulaFunctions.loadMethod(class$com$xmlmind$xmleditapp$spreadsheet$FunctionLibrary == null ? FormulaFunctions.class$("com.xmlmind.xmleditapp.spreadsheet.FunctionLibrary") : class$com$xmlmind$xmleditapp$spreadsheet$FunctionLibrary, functionRecord.name);
                } else if (functionRecord.method != null) {
                    method = FormulaFunctions.loadMethod(functionRecord.method);
                } else if (functionRecord.macro != null) {
                    macroFunction = new MacroFunction(functionRecord.name, functionRecord.parameters, functionRecord.macro, (PrefixToNamespace)preferredPrefix);
                }
                formulaFunctionArray[n2] = macroFunction != null ? new FormulaFunction(macroFunction, functionRecord.category, functionRecord.description, bl) : new FormulaFunction(method, functionRecord.name, functionRecord.parameters, functionRecord.category, functionRecord.description, bl);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException(Msg.msg("cannotLoadFunction", functionRecord.name, illegalArgumentException.getMessage()));
            }
            ++n2;
        }
        return formulaFunctionArray;
    }

    private static Method loadMethod(String string) throws IOException {
        Class<?> clazz;
        String string2 = null;
        String string3 = null;
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string2 = string.substring(0, n).trim();
            string3 = string.substring(n + 1).trim();
        }
        if (string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0) {
            throw new IOException(Msg.msg("invalidMethodName", string));
        }
        try {
            clazz = Class.forName(string2);
        }
        catch (Exception exception) {
            throw new IOException(Msg.msg("dontFindClass", string2, MiscUtil.reason(exception)));
        }
        return FormulaFunctions.loadMethod(clazz, string3);
    }

    private static Method loadMethod(Class clazz, String string) throws IOException {
        Method method = null;
        try {
            method = clazz.getMethod(string, SimpleFunction.METHOD_PARAMETER_TYPES);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (method == null) {
            try {
                method = clazz.getMethod("_" + string, SimpleFunction.METHOD_PARAMETER_TYPES);
            }
            catch (Exception exception) {
                throw new IOException(Msg.msg("dontFindMethod", clazz.getName() + ".[_]" + string, MiscUtil.reason(exception)));
            }
        }
        return method;
    }

    public static FormulaFunctions getRegistry() {
        if (registry == null) {
            registry = new FormulaFunctions();
            FormulaFunctions.initRegistry();
        }
        return registry;
    }

    private static void initRegistry() {
        FormulaFunction[] formulaFunctionArray;
        URL uRL = FormulaFunctions.getHelpURL();
        if (uRL == null) {
            System.err.println("cannot find help.xml file");
            return;
        }
        try {
            formulaFunctionArray = FormulaFunctions.load(uRL, true);
        }
        catch (Exception exception) {
            System.err.println("cannot load help.xml file:" + MiscUtil.reason(exception));
            return;
        }
        HashMap hashMap = FormulaFunctions.registry.functions;
        int n = 0;
        while (n < formulaFunctionArray.length) {
            FormulaFunction formulaFunction = formulaFunctionArray[n];
            hashMap.put(formulaFunction.getName(), formulaFunction);
            ++n;
        }
    }

    private static URL getHelpURL() {
        Locale locale = Locale.getDefault();
        String[] stringArray = new String[]{locale.getLanguage(), locale.getCountry(), locale.getVariant()};
        URL uRL = null;
        int n = stringArray.length - 1;
        while (n >= 0) {
            if (stringArray[n] != null && stringArray[n].length() != 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("help");
                int n2 = 0;
                while (n2 <= n) {
                    stringBuffer.append('_');
                    stringBuffer.append(stringArray[n2]);
                    ++n2;
                }
                stringBuffer.append(".xml");
                String string = stringBuffer.toString();
                uRL = (class$com$xmlmind$xmleditapp$spreadsheet$FormulaFunctions == null ? FormulaFunctions.class$("com.xmlmind.xmleditapp.spreadsheet.FormulaFunctions") : class$com$xmlmind$xmleditapp$spreadsheet$FormulaFunctions).getResource(string);
                if (uRL != null) break;
            }
            --n;
        }
        if (uRL == null) {
            uRL = (class$com$xmlmind$xmleditapp$spreadsheet$FormulaFunctions == null ? (class$com$xmlmind$xmleditapp$spreadsheet$FormulaFunctions = FormulaFunctions.class$("com.xmlmind.xmleditapp.spreadsheet.FormulaFunctions")) : class$com$xmlmind$xmleditapp$spreadsheet$FormulaFunctions).getResource("help.xml");
        }
        return uRL;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class FunctionLoader
    extends DefaultHandler {
        private ArrayList records;
        private PreferredPrefix preferredPrefixes;
        private Locator locator;
        private String systemId;
        private int line;
        private int column;
        private FunctionRecord record = null;
        private StringBuffer buffer = null;
        private boolean html = false;

        public FunctionLoader(ArrayList arrayList, PreferredPrefix preferredPrefix) {
            this.records = arrayList;
            this.preferredPrefixes = preferredPrefix;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
            this.systemId = locator.getSystemId();
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
            this.preferredPrefixes.add(Namespace.get(string2), string);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.html) {
                this.buffer.append('<');
                this.buffer.append(string2);
                int n = attributes.getLength();
                int n2 = 0;
                while (n2 < n) {
                    this.buffer.append(' ');
                    this.buffer.append(attributes.getLocalName(n2));
                    this.buffer.append('=');
                    this.buffer.append(XMLUtil.quoteXML(attributes.getValue(n2)));
                    ++n2;
                }
                this.buffer.append('>');
            } else if ("name".equals(string2) || "parameters".equals(string2) || "category".equals(string2) || "description".equals(string2) || "method".equals(string2) || "macro".equals(string2)) {
                if (this.record == null || this.buffer != null || this.html) {
                    this.throwException();
                }
                this.buffer = new StringBuffer();
                if ("description".equals(string2)) {
                    this.html = true;
                }
            } else if ("intrinsic".equals(string2) || "runtime".equals(string2)) {
                if (this.record == null || this.buffer != null || this.html) {
                    this.throwException();
                }
            } else if ("function".equals(string2) || "functions".equals(string2)) {
                if (this.record != null || this.buffer != null || this.html) {
                    this.throwException();
                }
                if ("function".equals(string2)) {
                    this.line = this.locator.getLineNumber();
                    this.column = this.locator.getColumnNumber();
                    this.record = new FunctionRecord();
                }
            } else {
                this.throwException();
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.html && !"description".equals(string2)) {
                this.buffer.append("</");
                this.buffer.append(string2);
                this.buffer.append('>');
            } else if ("function".equals(string2)) {
                int n = 0;
                if (this.record.intrinsic) {
                    ++n;
                }
                if (this.record.runtime) {
                    ++n;
                }
                if (this.record.method != null) {
                    ++n;
                }
                if (this.record.macro != null) {
                    ++n;
                }
                if (this.record.name == null || this.record.parameters == null || this.record.category == null || this.record.description == null || n != 1) {
                    this.throwException();
                }
                this.records.add(this.record);
                this.record = null;
            } else if ("name".equals(string2) || "parameters".equals(string2) || "category".equals(string2) || "description".equals(string2) || "method".equals(string2) || "macro".equals(string2)) {
                String string4 = this.buffer.toString().trim();
                if (string4.length() == 0 && !"parameters".equals(string2)) {
                    this.throwException();
                }
                if ("name".equals(string2)) {
                    this.record.name = string4;
                } else if ("parameters".equals(string2)) {
                    this.record.parameters = XMLUtil.splitList(string4);
                } else if ("category".equals(string2)) {
                    this.record.category = string4;
                } else if ("description".equals(string2)) {
                    this.record.description = string4;
                } else if ("method".equals(string2)) {
                    this.record.method = string4;
                } else if ("macro".equals(string2)) {
                    this.record.macro = string4;
                }
                this.buffer = null;
                this.html = false;
            } else if ("intrinsic".equals(string2)) {
                this.record.intrinsic = true;
            } else if ("runtime".equals(string2)) {
                this.record.runtime = true;
            }
        }

        private void throwException() throws SAXParseException {
            throw new SAXParseException(Msg.msg("invalidFunctionsFile"), null, this.systemId, this.line, this.column);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.buffer != null) {
                if (this.html) {
                    XMLUtil.escapeXML(cArray, n, n2, this.buffer);
                } else {
                    this.buffer.append(cArray, n, n2);
                }
            }
        }
    }

    private static final class FunctionRecord {
        public String name;
        public String[] parameters;
        public String category;
        public String description;
        public boolean intrinsic;
        public boolean runtime;
        public String method;
        public String macro;

        private FunctionRecord() {
        }
    }
}

