/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.spreadsheet;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.ImageResource;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledgadget.Styleable;
import com.xmlmind.xmledit.util.PlatformUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.view.NodeView;
import com.xmlmind.xmledit.view.TextNodeView;
import com.xmlmind.xmledit.view.TextNodeViewPart;
import com.xmlmind.xmleditapp.spreadsheet.Constants;
import com.xmlmind.xmleditapp.spreadsheet.Spreadsheet;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;

public final class FormulaTVP
extends Gadget
implements Styleable,
TextNodeViewPart,
Constants {
    private Style style;
    private TextNodeView view;
    private byte status;
    private Image[] icons;
    private static Image[] defaultIcons = null;
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$spreadsheet$FormulaTVP;

    public FormulaTVP(Style style, TextNodeView textNodeView) {
        this.style = style;
        this.view = textNodeView;
        this.updateStatus();
        if (defaultIcons == null) {
            defaultIcons = new Image[5];
            FormulaTVP.defaultIcons[0] = ImageResource.get(class$com$xmlmind$xmleditapp$spreadsheet$FormulaTVP == null ? (class$com$xmlmind$xmleditapp$spreadsheet$FormulaTVP = FormulaTVP.class$("com.xmlmind.xmleditapp.spreadsheet.FormulaTVP")) : class$com$xmlmind$xmleditapp$spreadsheet$FormulaTVP, "unknown.gif");
            FormulaTVP.defaultIcons[1] = ImageResource.get(class$com$xmlmind$xmleditapp$spreadsheet$FormulaTVP == null ? (class$com$xmlmind$xmleditapp$spreadsheet$FormulaTVP = FormulaTVP.class$("com.xmlmind.xmleditapp.spreadsheet.FormulaTVP")) : class$com$xmlmind$xmleditapp$spreadsheet$FormulaTVP, "parseerror.gif");
            FormulaTVP.defaultIcons[2] = ImageResource.get(class$com$xmlmind$xmleditapp$spreadsheet$FormulaTVP == null ? (class$com$xmlmind$xmleditapp$spreadsheet$FormulaTVP = FormulaTVP.class$("com.xmlmind.xmleditapp.spreadsheet.FormulaTVP")) : class$com$xmlmind$xmleditapp$spreadsheet$FormulaTVP, "disabled.gif");
            FormulaTVP.defaultIcons[3] = ImageResource.get(class$com$xmlmind$xmleditapp$spreadsheet$FormulaTVP == null ? (class$com$xmlmind$xmleditapp$spreadsheet$FormulaTVP = FormulaTVP.class$("com.xmlmind.xmleditapp.spreadsheet.FormulaTVP")) : class$com$xmlmind$xmleditapp$spreadsheet$FormulaTVP, "active.gif");
            FormulaTVP.defaultIcons[4] = ImageResource.get(class$com$xmlmind$xmleditapp$spreadsheet$FormulaTVP == null ? (class$com$xmlmind$xmleditapp$spreadsheet$FormulaTVP = FormulaTVP.class$("com.xmlmind.xmleditapp.spreadsheet.FormulaTVP")) : class$com$xmlmind$xmleditapp$spreadsheet$FormulaTVP, "evalerror.gif");
        }
        this.setIcons(defaultIcons);
    }

    public void setIcons(Image[] imageArray) {
        this.icons = imageArray;
        Image image = imageArray[0];
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
    }

    public Image[] getIcons() {
        return this.icons;
    }

    public NodeView getView() {
        return this.view;
    }

    public TextNodeView getTextNodeView() {
        return this.view;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Style getStyle() {
        return this.style;
    }

    public void refresh() {
        this.updateStatus();
        this.repaint(0, 0, this.width, this.height);
    }

    private void updateStatus() {
        Spreadsheet.Field field = this.getField();
        this.status = (byte)(field == null ? 0 : field.getStatus());
    }

    private Spreadsheet.Field getField() {
        Spreadsheet spreadsheet;
        ProcessingInstruction processingInstruction = (ProcessingInstruction)this.view.getTextNode();
        Document document = processingInstruction.getDocument();
        if (document != null && (spreadsheet = (Spreadsheet)document.getProperty("com.xmlmind.xmleditapp.spreadsheet.SPREADSHEET")) != null) {
            return spreadsheet.getField(processingInstruction);
        }
        return null;
    }

    public void layout(int n, int n2, boolean bl) {
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.icons[this.status], 0, 0, null);
    }

    public boolean grabsMouseButton(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        return n == 16 || n == 8 || PlatformUtil.IS_MAC_OS && n == 24;
    }

    public void handleMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 500) {
            DocumentView documentView = (DocumentView)this.getRoot();
            if (mouseEvent.getModifiers() == 16) {
                switch (mouseEvent.getClickCount()) {
                    case 1: {
                        documentView.selectNode(this.view.getTextNode());
                        Spreadsheet.Field field = this.getField();
                        if (field == null) break;
                        ShowStatus.showStatus(field.getStatusLine());
                        break;
                    }
                    case 2: {
                        documentView.executeCommand("setFormula", null, -1, -1);
                    }
                }
            } else {
                documentView.selectNode(this.view.getTextNode());
                Spreadsheet.Field field = this.getField();
                if (field != null) {
                    documentView.executeCommand("removeFormulas", "toggle", -1, -1);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

