/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.spreadsheet;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.xmlutil.NamespacePrefixMap;
import com.xmlmind.xmledit.xpath.BooleanVariant;
import com.xmlmind.xmledit.xpath.Converter;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.ExprContext;
import com.xmlmind.xmledit.xpath.NodeIterator;
import com.xmlmind.xmledit.xpath.NodeSetVariant;
import com.xmlmind.xmledit.xpath.NumberVariant;
import com.xmlmind.xmledit.xpath.StringVariant;
import com.xmlmind.xmledit.xpath.Variant;
import com.xmlmind.xmledit.xpath.VariantExpr;
import com.xmlmind.xmleditapp.spreadsheet.DateTimeVariant;
import com.xmlmind.xmleditapp.spreadsheet.DateVariant;
import com.xmlmind.xmleditapp.spreadsheet.DateVariantBase;
import com.xmlmind.xmleditapp.spreadsheet.ExpressionNode;
import com.xmlmind.xmleditapp.spreadsheet.FormatUtil;
import com.xmlmind.xmleditapp.spreadsheet.FormulaFunction;
import com.xmlmind.xmleditapp.spreadsheet.FormulaFunctions;
import com.xmlmind.xmleditapp.spreadsheet.FormulaNode;
import com.xmlmind.xmleditapp.spreadsheet.FunctionCallNode;
import com.xmlmind.xmleditapp.spreadsheet.MoreMath;
import com.xmlmind.xmleditapp.spreadsheet.Msg;
import com.xmlmind.xmleditapp.spreadsheet.ParsedPIData;
import com.xmlmind.xmleditapp.spreadsheet.TimeVariant;
import com.xmlmind.xmleditapp.spreadsheet.TranslatedFormula;
import com.xmlmind.xmleditapp.spreadsheet.VariableReferenceNode;
import com.xmlmind.xmleditapp.spreadsheet.XPathExpressionNode;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class FunctionLibrary {
    private static final int COLLECT_SUM = 0;
    private static final int COLLECT_PRODUCT = 1;
    private static final int COLLECT_COUNT = 2;
    private static final int COLLECT_AVERAGE = 3;
    private static final int COLLECT_MIN = 4;
    private static final int COLLECT_MAX = 5;
    private static final int COLLECT_AVEDEV = 6;
    private static final int COLLECT_STDEV = 7;
    private static final int COLLECT_VAR = 8;
    private static final int MATH0_PI = 0;
    private static final int MATH0_RAND = 1;
    private static final int MATH1_ABS = 0;
    private static final int MATH1_ACOS = 1;
    private static final int MATH1_ASIN = 2;
    private static final int MATH1_ATAN = 3;
    private static final int MATH1_COS = 4;
    private static final int MATH1_COSH = 5;
    private static final int MATH1_SIN = 6;
    private static final int MATH1_SINH = 7;
    private static final int MATH1_TAN = 8;
    private static final int MATH1_TANH = 9;
    private static final int MATH1_DEGREES = 10;
    private static final int MATH1_RADIANS = 11;
    private static final int MATH1_EXP = 12;
    private static final int MATH1_ACOSH = 13;
    private static final int MATH1_ASINH = 14;
    private static final int MATH1_ATANH = 15;
    private static final int MATH1_LN = 16;
    private static final int MATH1_LOG10 = 17;
    private static final int MATH1_SIGN = 18;
    private static final int MATH1_SQRT = 19;
    private static final int MATH1_TRUNC = 20;
    private static final int MATH1_INT = 21;
    private static final int MATH2_ATAN2 = 0;
    private static final int MATH2_LOG = 1;
    private static final int MATH2_MOD = 2;
    private static final int MATH2_ROUND = 3;
    private static final int MATH2_ROUNDDOWN = 4;
    private static final int MATH2_ROUNDUP = 5;
    private static final int FILTER_SUMIF = 0;
    private static final int FILTER_COUNTIF = 1;
    private static final String[] FILTER_PARAM_NAMES = new String[]{"x"};
    private static final FilterChecker filterChecker = new FilterChecker();
    private static HashMap compiledFilters = new HashMap();
    private static final int STRING1_TRIM = 0;
    private static final int STRING1_UPPER = 1;
    private static final int STRING1_LOWER = 2;
    private static final int SUBSTRING_LEFT = 0;
    private static final int SUBSTRING_RIGHT = 1;
    private static final int FINDER_FIND = 0;
    private static final int FINDER_SEARCH = 1;

    public static Variant numbervalue(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        double d;
        FunctionLibrary.checkArgCount("numbervalue", variantExprArray, 1, 3);
        Variant variant = variantExprArray[0].eval(xNode, exprContext);
        if (variantExprArray.length == 1) {
            d = variant.convertToNumber();
        } else {
            String string = variant.convertToString();
            Format format = FunctionLibrary.getFormat("numbervalue", 1, variantExprArray, xNode, exprContext);
            if (!(format instanceof NumberFormat)) {
                throw new EvalException(Msg.msg("notANumberFormatArg", "numbervalue", FormatUtil.getPattern(format)));
            }
            try {
                Number number = ((NumberFormat)format).parse(string);
                d = number.doubleValue();
            }
            catch (ParseException parseException) {
                throw new EvalException(Msg.msg("cannotParseNumber", string, parseException.getMessage()));
            }
        }
        return new NumberVariant(d);
    }

    public static Variant checknumber(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("checknumber", variantExprArray, 1, 1);
        double d = variantExprArray[0].eval(xNode, exprContext).convertToNumber();
        return new BooleanVariant(!Double.isNaN(d));
    }

    private static Variant collect(int n, String string, VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        double d;
        int n2 = 0;
        double d2 = 0.0;
        DoubleList doubleList = null;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                d2 = 1.0;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                d2 = Double.MAX_VALUE;
                break;
            }
            case 5: {
                d2 = -1.7976931348623157E308;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                doubleList = new DoubleList();
            }
        }
        int n3 = 0;
        while (n3 < variantExprArray.length) {
            Variant variant = variantExprArray[n3].eval(xNode, exprContext);
            if (variant.isNodeSet()) {
                XNode xNode2;
                NodeIterator nodeIterator = variant.convertToNodeSet();
                while ((xNode2 = nodeIterator.next()) != null) {
                    d = Converter.toNumber(Converter.toString(xNode2));
                    if (Double.isNaN(d)) continue;
                    switch (n) {
                        case 0: {
                            d2 += d;
                            break;
                        }
                        case 1: {
                            d2 *= d;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            d2 += d;
                            break;
                        }
                        case 4: {
                            if (!(d < d2)) break;
                            d2 = d;
                            break;
                        }
                        case 5: {
                            if (!(d > d2)) break;
                            d2 = d;
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            d2 += d;
                            doubleList.add(d);
                        }
                    }
                    ++n2;
                }
            } else {
                double d3 = variant.convertToNumber();
                if (Double.isNaN(d3)) {
                    throw FunctionLibrary.notANumber(variant);
                }
                switch (n) {
                    case 0: {
                        d2 += d3;
                        break;
                    }
                    case 1: {
                        d2 *= d3;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        d2 += d3;
                        break;
                    }
                    case 4: {
                        if (!(d3 < d2)) break;
                        d2 = d3;
                        break;
                    }
                    case 5: {
                        if (!(d3 > d2)) break;
                        d2 = d3;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        d2 += d3;
                        doubleList.add(d3);
                    }
                }
                ++n2;
            }
            ++n3;
        }
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                if (n2 != 0) break;
                d2 = 0.0;
                break;
            }
            case 2: {
                d2 = n2;
                break;
            }
            case 3: {
                if (n2 <= true) break;
                d2 /= (double)n2;
                break;
            }
            case 4: {
                if (n2 != 0) break;
                d2 = 0.0;
                break;
            }
            case 5: {
                if (n2 != 0) break;
                d2 = 0.0;
                break;
            }
            case 6: {
                if (n2 > 1) {
                    double d4 = d2 / (double)n2;
                    d2 = 0.0;
                    int n4 = 0;
                    while (n4 < doubleList.size) {
                        d2 += Math.abs(doubleList.list[n4] - d4);
                        ++n4;
                    }
                    d2 /= (double)n2;
                    break;
                }
                d2 = 0.0;
                break;
            }
            case 7: 
            case 8: {
                if (n2 > 1) {
                    double d5 = d2 / (double)n2;
                    d2 = 0.0;
                    int n5 = 0;
                    while (n5 < doubleList.size) {
                        d = doubleList.list[n5] - d5;
                        d2 += d * d;
                        ++n5;
                    }
                    d2 /= (double)(n2 - 1);
                    if (n != 7) break;
                    d2 = Math.sqrt(d2);
                    break;
                }
                d2 = 0.0;
            }
        }
        return new NumberVariant(d2);
    }

    private static EvalException notANumber(Variant variant) {
        String string = "";
        try {
            string = variant.convertToString();
        }
        catch (EvalException evalException) {
            // empty catch block
        }
        return new EvalException(Msg.msg("notANumber", string));
    }

    public static Variant sum(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.collect(0, "sum", variantExprArray, xNode, exprContext);
    }

    public static Variant product(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.collect(1, "product", variantExprArray, xNode, exprContext);
    }

    public static Variant count(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.collect(2, "count", variantExprArray, xNode, exprContext);
    }

    public static Variant average(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.collect(3, "average", variantExprArray, xNode, exprContext);
    }

    public static Variant min(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.collect(4, "min", variantExprArray, xNode, exprContext);
    }

    public static Variant max(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.collect(5, "max", variantExprArray, xNode, exprContext);
    }

    public static Variant avedev(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.collect(6, "avedev", variantExprArray, xNode, exprContext);
    }

    public static Variant stdev(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.collect(7, "stdev", variantExprArray, xNode, exprContext);
    }

    public static Variant var(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.collect(8, "var", variantExprArray, xNode, exprContext);
    }

    public static Variant math0(int n, String string, VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        double d = 0.0;
        switch (n) {
            case 0: {
                d = Math.PI;
                break;
            }
            case 1: {
                d = Math.random();
            }
        }
        return new NumberVariant(d);
    }

    public static Variant pi(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math0(0, "pi", variantExprArray, xNode, exprContext);
    }

    public static Variant rand(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math0(1, "rand", variantExprArray, xNode, exprContext);
    }

    private static Variant math1(int n, String string, VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount(string, variantExprArray, 1, 1);
        Variant variant = variantExprArray[0].eval(xNode, exprContext);
        double d = variant.convertToNumber();
        if (Double.isNaN(d)) {
            throw FunctionLibrary.notANumber(variant);
        }
        double d2 = 0.0;
        switch (n) {
            case 0: {
                d2 = Math.abs(d);
                break;
            }
            case 1: {
                d2 = Math.acos(d);
                break;
            }
            case 2: {
                d2 = Math.asin(d);
                break;
            }
            case 3: {
                d2 = Math.atan(d);
                break;
            }
            case 4: {
                d2 = Math.cos(d);
                break;
            }
            case 5: {
                d2 = MoreMath.cosh(d);
                break;
            }
            case 6: {
                d2 = Math.sin(d);
                break;
            }
            case 7: {
                d2 = MoreMath.sinh(d);
                break;
            }
            case 8: {
                d2 = Math.tan(d);
                break;
            }
            case 9: {
                d2 = MoreMath.tanh(d);
                break;
            }
            case 10: {
                d2 = Math.toDegrees(d);
                break;
            }
            case 11: {
                d2 = Math.toRadians(d);
                break;
            }
            case 12: {
                d2 = Math.exp(d);
                break;
            }
            case 13: {
                d2 = MoreMath.acosh(d);
                break;
            }
            case 14: {
                d2 = MoreMath.asinh(d);
                break;
            }
            case 15: {
                d2 = MoreMath.atanh(d);
                break;
            }
            case 16: {
                d2 = Math.log(d);
                break;
            }
            case 17: {
                d2 = MoreMath.log10(d);
                break;
            }
            case 18: {
                d2 = d == 0.0 ? 0.0 : (d > 0.0 ? 1.0 : -1.0);
                break;
            }
            case 19: {
                d2 = Math.sqrt(d);
                break;
            }
            case 20: {
                d2 = (int)d;
                break;
            }
            case 21: {
                d2 = Math.floor(d);
            }
        }
        return new NumberVariant(d2);
    }

    public static Variant abs(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(0, "abs", variantExprArray, xNode, exprContext);
    }

    public static Variant acos(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(1, "acos", variantExprArray, xNode, exprContext);
    }

    public static Variant asin(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(2, "asin", variantExprArray, xNode, exprContext);
    }

    public static Variant atan(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(3, "atan", variantExprArray, xNode, exprContext);
    }

    public static Variant cos(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(4, "cos", variantExprArray, xNode, exprContext);
    }

    public static Variant cosh(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(5, "cosh", variantExprArray, xNode, exprContext);
    }

    public static Variant sin(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(6, "sin", variantExprArray, xNode, exprContext);
    }

    public static Variant sinh(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(7, "sinh", variantExprArray, xNode, exprContext);
    }

    public static Variant tan(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(8, "tan", variantExprArray, xNode, exprContext);
    }

    public static Variant tanh(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(9, "tanh", variantExprArray, xNode, exprContext);
    }

    public static Variant degrees(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(10, "degrees", variantExprArray, xNode, exprContext);
    }

    public static Variant radians(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(11, "radians", variantExprArray, xNode, exprContext);
    }

    public static Variant exp(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(12, "exp", variantExprArray, xNode, exprContext);
    }

    public static Variant acosh(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(13, "acosh", variantExprArray, xNode, exprContext);
    }

    public static Variant asinh(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(14, "asinh", variantExprArray, xNode, exprContext);
    }

    public static Variant atanh(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(15, "atanh", variantExprArray, xNode, exprContext);
    }

    public static Variant ln(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(16, "ln", variantExprArray, xNode, exprContext);
    }

    public static Variant log10(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(17, "log10", variantExprArray, xNode, exprContext);
    }

    public static Variant sign(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(18, "sign", variantExprArray, xNode, exprContext);
    }

    public static Variant sqrt(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(19, "sqrt", variantExprArray, xNode, exprContext);
    }

    public static Variant trunc(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(20, "trunc", variantExprArray, xNode, exprContext);
    }

    public static Variant _int(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math1(21, "int", variantExprArray, xNode, exprContext);
    }

    private static Variant math2(int n, String string, VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("atan2", variantExprArray, 2, 2);
        Variant variant = variantExprArray[0].eval(xNode, exprContext);
        double d = variant.convertToNumber();
        if (Double.isNaN(d)) {
            throw FunctionLibrary.notANumber(variant);
        }
        variant = variantExprArray[1].eval(xNode, exprContext);
        double d2 = variant.convertToNumber();
        if (Double.isNaN(d2)) {
            throw FunctionLibrary.notANumber(variant);
        }
        double d3 = 0.0;
        switch (n) {
            case 0: {
                d3 = Math.atan2(d2, d);
                break;
            }
            case 1: {
                d3 = MoreMath.log(d, d2);
                break;
            }
            case 2: {
                d3 = d - d2 * Math.floor(d / d2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (d == 0.0) {
                    d3 = d;
                    break;
                }
                int n2 = (int)d2;
                double d4 = 1.0;
                if (n2 < 0) {
                    d4 = Math.pow(10.0, -n2);
                    d /= d4;
                } else if (n2 > 0) {
                    d4 = Math.pow(10.0, n2);
                    d *= d4;
                }
                switch (n) {
                    case 3: {
                        d = Math.rint(d);
                        break;
                    }
                    case 4: {
                        if (d < 0.0) {
                            d = Math.ceil(d);
                            break;
                        }
                        d = Math.floor(d);
                        break;
                    }
                    case 5: {
                        d = d < 0.0 ? Math.floor(d) : Math.ceil(d);
                    }
                }
                if (n2 < 0) {
                    d *= d4;
                } else if (n2 > 0) {
                    d /= d4;
                }
                d3 = d;
            }
        }
        return new NumberVariant(d3);
    }

    public static Variant atan2(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math2(0, "atan2", variantExprArray, xNode, exprContext);
    }

    public static Variant log(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math2(1, "log", variantExprArray, xNode, exprContext);
    }

    public static Variant mod(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math2(2, "mod", variantExprArray, xNode, exprContext);
    }

    public static Variant round(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math2(3, "round", variantExprArray, xNode, exprContext);
    }

    public static Variant rounddown(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math2(4, "rounddown", variantExprArray, xNode, exprContext);
    }

    public static Variant roundup(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.math2(5, "roundup", variantExprArray, xNode, exprContext);
    }

    private static TranslatedFormula getFilter(String string, XNode xNode) throws EvalException {
        TranslatedFormula translatedFormula = (TranslatedFormula)compiledFilters.get(string);
        if (translatedFormula == null) {
            FormulaNode formulaNode = null;
            try {
                formulaNode = ParsedPIData.parseFormula("= " + string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new EvalException(Msg.msg("cannotCompileFilter", string, illegalArgumentException.getMessage()));
            }
            if (!filterChecker.process(formulaNode)) {
                throw new EvalException(Msg.msg("notAFilter", string));
            }
            NamespacePrefixMap namespacePrefixMap = xNode.namespacePrefixMap();
            Document document = (Document)xNode.document();
            FormulaFunctions formulaFunctions = (FormulaFunctions)document.getProperty("com.xmlmind.xmleditapp.spreadsheet.FORMULA_FUNCTIONS");
            try {
                translatedFormula = TranslatedFormula.translate(formulaNode, namespacePrefixMap, formulaFunctions, true);
            }
            catch (Exception exception) {
                throw new EvalException(Msg.msg("cannotCompileFilter", string, exception.getMessage()));
            }
            if (filterChecker.lastProcessedIsCacheable()) {
                compiledFilters.put(string, translatedFormula);
            }
        }
        return translatedFormula;
    }

    private static Variant filter(int n, String string, VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        XNode xNode2;
        int n2 = 0;
        double d = 0.0;
        switch (n) {
            case 0: {
                break;
            }
        }
        String string2 = variantExprArray[1].eval(xNode, exprContext).convertToString();
        TranslatedFormula translatedFormula = FunctionLibrary.getFilter(string2, xNode);
        NodeIterator nodeIterator = variantExprArray[0].eval(xNode, exprContext).convertToNodeSet();
        NodeIterator nodeIterator2 = null;
        if (variantExprArray.length >= 3) {
            nodeIterator2 = variantExprArray[2].eval(xNode, exprContext).convertToNodeSet();
        }
        while ((xNode2 = nodeIterator.next()) != null) {
            Variant[] variantArray;
            XNode xNode3 = null;
            if (nodeIterator2 != null && (xNode3 = nodeIterator2.next()) == null) break;
            boolean bl = true;
            Variant[] variantArray2 = Converter.toString(xNode2);
            switch (n) {
                case 0: {
                    if (!Double.isNaN(Converter.toNumber((String)variantArray2))) break;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                bl = false;
                variantArray = new Variant[]{new StringVariant((String)variantArray2)};
                try {
                    Variant variant = translatedFormula.eval(FILTER_PARAM_NAMES, variantArray, xNode, exprContext);
                    bl = variant.convertToBoolean();
                }
                catch (EvalException evalException) {
                    throw new EvalException(Msg.msg("cannotEvalFilter", string2, variantArray2, evalException.getMessage()));
                }
            }
            if (!bl) continue;
            variantArray = xNode3 == null ? variantArray2 : Converter.toString(xNode3);
            switch (n) {
                case 0: {
                    double d2 = Converter.toNumber((String)variantArray);
                    if (Double.isNaN(d2)) break;
                    d += d2;
                    ++n2;
                    break;
                }
                case 1: {
                    ++n2;
                }
            }
        }
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                d = n2;
            }
        }
        return new NumberVariant(d);
    }

    public static Variant sumif(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("sumif", variantExprArray, 2, 3);
        return FunctionLibrary.filter(0, "sumif", variantExprArray, xNode, exprContext);
    }

    public static Variant countif(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("countif", variantExprArray, 2, 2);
        return FunctionLibrary.filter(1, "countif", variantExprArray, xNode, exprContext);
    }

    public static Variant apply(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("apply", variantExprArray, 2, 3);
        String string = variantExprArray[0].eval(xNode, exprContext).convertToString();
        TranslatedFormula translatedFormula = FunctionLibrary.getFilter(string, xNode);
        NodeIterator nodeIterator = variantExprArray[1].eval(xNode, exprContext).convertToNodeSet();
        boolean bl = false;
        if (variantExprArray.length >= 3) {
            bl = variantExprArray[2].eval(xNode, exprContext).convertToBoolean();
        }
        return new NodeSetVariant(new ApplyIterator(nodeIterator, translatedFormula, bl, xNode, exprContext));
    }

    public static Variant _char(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("char", variantExprArray, 1, 1);
        Variant variant = variantExprArray[0].eval(xNode, exprContext);
        double d = variant.convertToNumber();
        if (Double.isNaN(d) || d < 0.0 || d > 65535.0) {
            throw new EvalException(Msg.msg("invalidCharCode", variant.convertToString()));
        }
        return new StringVariant(Character.toString((char)d));
    }

    public static Variant code(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("code", variantExprArray, 1, 1);
        String string = variantExprArray[0].eval(xNode, exprContext).convertToString();
        if (string.length() == 0) {
            throw new EvalException(Msg.msg("emptyStringArg", "code"));
        }
        return new NumberVariant(string.charAt(0));
    }

    public static Variant text(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        String string;
        FunctionLibrary.checkArgCount("text", variantExprArray, 1, 3);
        Variant variant = variantExprArray[0].eval(xNode, exprContext);
        if (variantExprArray.length == 1) {
            string = variant.convertToString();
        } else {
            int n = variant.isNumber() ? 1 : (variant instanceof DateVariant ? 2 : (variant instanceof TimeVariant ? 3 : (variant instanceof DateTimeVariant ? 4 : 0)));
            Format format = FunctionLibrary.getFormat("text", n, variantExprArray, xNode, exprContext);
            string = FormatUtil.format(format, variant);
        }
        return new StringVariant(string);
    }

    private static Format getFormat(String string, int n, VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        Object object;
        Locale locale = null;
        if (variantExprArray.length >= 3 && (locale = FormatUtil.getLocale((String)(object = variantExprArray[2].eval(xNode, exprContext).convertToString()))) == null) {
            throw new EvalException(Msg.msg("unknownLocaleArg", string, object));
        }
        object = null;
        if (variantExprArray.length >= 2) {
            String string2 = variantExprArray[1].eval(xNode, exprContext).convertToString();
            try {
                object = FormatUtil.getFormat(string2, locale, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new EvalException(Msg.msg("invalidFormatArg", string, string2, MiscUtil.reason(illegalArgumentException)));
            }
        }
        return object;
    }

    public static Variant len(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("len", variantExprArray, 1, 1);
        String string = variantExprArray[0].eval(xNode, exprContext).convertToString();
        return new NumberVariant(string.length());
    }

    private static Variant string1(int n, String string, VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount(string, variantExprArray, 1, 1);
        String string2 = variantExprArray[0].eval(xNode, exprContext).convertToString();
        String string3 = "";
        switch (n) {
            case 0: {
                string3 = string2.trim();
                break;
            }
            case 1: {
                string3 = string2.toUpperCase();
                break;
            }
            case 2: {
                string3 = string2.toLowerCase();
            }
        }
        return new StringVariant(string3);
    }

    public static Variant trim(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.string1(0, "trim", variantExprArray, xNode, exprContext);
    }

    public static Variant upper(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.string1(1, "upper", variantExprArray, xNode, exprContext);
    }

    public static Variant lower(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.string1(2, "lower", variantExprArray, xNode, exprContext);
    }

    private static Variant substring(int n, String string, VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount(string, variantExprArray, 1, 2);
        String string2 = variantExprArray[0].eval(xNode, exprContext).convertToString();
        int n2 = 1;
        if (variantExprArray.length >= 2) {
            n2 = (int)variantExprArray[1].eval(xNode, exprContext).convertToNumber();
        }
        int n3 = string2.length();
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > n3) {
            n2 = n3;
        }
        String string3 = "";
        switch (n) {
            case 0: {
                if (n2 <= 0) break;
                string3 = string2.substring(0, n2);
                break;
            }
            case 1: {
                if (n2 <= 0) break;
                string3 = string2.substring(n3 - n2, n3);
            }
        }
        return new StringVariant(string3);
    }

    public static Variant left(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.substring(0, "left", variantExprArray, xNode, exprContext);
    }

    public static Variant right(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.substring(1, "right", variantExprArray, xNode, exprContext);
    }

    public static Variant mid(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("mid", variantExprArray, 3, 3);
        String string = variantExprArray[0].eval(xNode, exprContext).convertToString();
        int n = (int)variantExprArray[1].eval(xNode, exprContext).convertToNumber();
        if (n < 1) {
            throw new EvalException(Msg.msg("invalidCharPosition", new Integer(n)));
        }
        --n;
        int n2 = (int)variantExprArray[2].eval(xNode, exprContext).convertToNumber();
        if (n2 < 0) {
            throw new EvalException(Msg.msg("invalidCharCount", new Integer(n2)));
        }
        String string2 = "";
        int n3 = string.length();
        if (n < n3) {
            int n4 = n + n2;
            if (n4 > n3) {
                n4 = n3;
            }
            string2 = string.substring(n, n4);
        }
        return new StringVariant(string2);
    }

    private static final String toRE(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '*': {
                    stringBuffer.append(".*");
                    bl = true;
                    break;
                }
                case '?': {
                    stringBuffer.append('.');
                    bl = true;
                    break;
                }
                case '~': {
                    char c2;
                    if (n2 + 1 < n && ((c2 = string.charAt(n2 + 1)) == '*' || c2 == '?')) {
                        stringBuffer.append('\\');
                        stringBuffer.append(c2);
                        ++n2;
                    } else {
                        stringBuffer.append("\\~");
                    }
                    bl = true;
                    break;
                }
                default: {
                    if (!Character.isLetterOrDigit(c)) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return bl ? stringBuffer.toString() : null;
    }

    private static Variant finder(int n, String string, VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount(string, variantExprArray, 2, 3);
        String string2 = variantExprArray[0].eval(xNode, exprContext).convertToString();
        String string3 = variantExprArray[1].eval(xNode, exprContext).convertToString();
        int n2 = string3.length();
        int n3 = 0;
        if (variantExprArray.length >= 3) {
            n3 = (int)variantExprArray[2].eval(xNode, exprContext).convertToNumber();
            if (n3 < 1 || n3 > n2) {
                throw new EvalException(Msg.msg("invalidCharPosition", new Integer(n3)));
            }
            --n3;
        }
        int n4 = -1;
        switch (n) {
            case 0: {
                n4 = string3.indexOf(string2, n3);
                break;
            }
            case 1: {
                Matcher matcher;
                String string4 = FunctionLibrary.toRE(string2);
                if (string4 == null) {
                    n4 = string3.toLowerCase().indexOf(string2.toLowerCase(), n3);
                    break;
                }
                Pattern pattern = null;
                try {
                    pattern = Pattern.compile(string4, 2);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    patternSyntaxException.printStackTrace();
                }
                if (pattern == null || !(matcher = pattern.matcher(string3)).find(n3)) break;
                n4 = matcher.start();
            }
        }
        if (n4 < 0) {
            throw new EvalException(Msg.msg("textNotFound", string2, string3, new Integer(1 + n3)));
        }
        return new NumberVariant(1 + n4);
    }

    public static Variant find(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.finder(0, "find", variantExprArray, xNode, exprContext);
    }

    public static Variant search(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.finder(1, "search", variantExprArray, xNode, exprContext);
    }

    public static Variant substitute(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("substitute", variantExprArray, 3, 4);
        String string = variantExprArray[0].eval(xNode, exprContext).convertToString();
        String string2 = variantExprArray[1].eval(xNode, exprContext).convertToString();
        if (string2.length() == 0) {
            return new StringVariant(string);
        }
        String string3 = variantExprArray[2].eval(xNode, exprContext).convertToString();
        int n = -1;
        if (variantExprArray.length >= 4) {
            n = (int)variantExprArray[3].eval(xNode, exprContext).convertToNumber();
            --n;
        }
        return new StringVariant(FunctionLibrary.doSubstitute(string, string2, string3, n));
    }

    private static final String doSubstitute(String string, String string2, String string3, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = string2.length();
        int n4 = 0;
        int n5 = 0;
        while ((n2 = string.indexOf(string2, n5)) >= 0) {
            if (n2 > n5) {
                stringBuffer.append(string.substring(n5, n2));
            }
            if (n < 0 || n4 == n) {
                stringBuffer.append(string3);
            } else {
                stringBuffer.append(string2);
            }
            ++n4;
            n5 = n2 + n3;
        }
        if (n5 < string.length()) {
            stringBuffer.append(string.substring(n5));
        }
        return stringBuffer.toString();
    }

    public static Variant replace(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("replace", variantExprArray, 4, 4);
        String string = variantExprArray[0].eval(xNode, exprContext).convertToString();
        int n = (int)variantExprArray[1].eval(xNode, exprContext).convertToNumber();
        if (n < 1) {
            throw new EvalException(Msg.msg("invalidCharPosition", new Integer(n)));
        }
        --n;
        int n2 = (int)variantExprArray[2].eval(xNode, exprContext).convertToNumber();
        if (n2 < 0) {
            throw new EvalException(Msg.msg("invalidCharCount", new Integer(n2)));
        }
        String string2 = variantExprArray[3].eval(xNode, exprContext).convertToString();
        String string3 = string;
        int n3 = string.length();
        if (n < n3) {
            int n4 = n + n2;
            if (n4 > n3) {
                n4 = n3;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (n > 0) {
                stringBuffer.append(string.substring(0, n));
            }
            stringBuffer.append(string2);
            if (n4 < n3) {
                stringBuffer.append(string.substring(n4));
            }
            string3 = stringBuffer.toString();
        }
        return new StringVariant(string3);
    }

    public static Variant datevalue(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.datetimevalue("datevalue", 2, variantExprArray, xNode, exprContext);
    }

    public static Variant timevalue(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.datetimevalue("timevalue", 3, variantExprArray, xNode, exprContext);
    }

    public static Variant datetimevalue(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return FunctionLibrary.datetimevalue("datetimevalue", 4, variantExprArray, xNode, exprContext);
    }

    private static Variant datetimevalue(String string, int n, VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        Date date;
        FunctionLibrary.checkArgCount(string, variantExprArray, 1, 3);
        Variant variant = variantExprArray[0].eval(xNode, exprContext);
        if (variantExprArray.length == 1) {
            date = DateVariantBase.toDate(variant);
        } else {
            String string2 = variant.convertToString();
            Format format = FunctionLibrary.getFormat(string, n, variantExprArray, xNode, exprContext);
            if (!(format instanceof DateFormat)) {
                throw new EvalException(Msg.msg("notADateFormatArg", string, FormatUtil.getPattern(format)));
            }
            try {
                date = ((DateFormat)format).parse(string2);
            }
            catch (ParseException parseException) {
                throw new EvalException(Msg.msg("cannotParseDate", string2, parseException.getMessage()));
            }
        }
        if ("datevalue".equals(string)) {
            return new DateVariant(date);
        }
        if ("timevalue".equals(string)) {
            return new TimeVariant(date);
        }
        return new DateTimeVariant(date);
    }

    public static Variant date(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("date", variantExprArray, 3, 4);
        return FunctionLibrary.datetime("date", variantExprArray, xNode, exprContext);
    }

    public static Variant time(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("time", variantExprArray, 3, 4);
        return FunctionLibrary.datetime("time", variantExprArray, xNode, exprContext);
    }

    public static Variant datetime(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("datetime", variantExprArray, 6, 7);
        return FunctionLibrary.datetime("datetime", variantExprArray, xNode, exprContext);
    }

    public static Variant datetime(String string, VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        if ("date".equals(string)) {
            String string2 = null;
            if (variantExprArray.length >= 4) {
                string2 = variantExprArray[3].eval(xNode, exprContext).convertToString();
            }
            Calendar calendar = FunctionLibrary.getCalendar(string2);
            calendar.set((int)variantExprArray[0].eval(xNode, exprContext).convertToNumber(), (int)variantExprArray[1].eval(xNode, exprContext).convertToNumber() - 1, (int)variantExprArray[2].eval(xNode, exprContext).convertToNumber(), 0, 0, 0);
            return new DateVariant(calendar.getTime());
        }
        if ("time".equals(string)) {
            String string3 = null;
            if (variantExprArray.length >= 4) {
                string3 = variantExprArray[3].eval(xNode, exprContext).convertToString();
            }
            Calendar calendar = FunctionLibrary.getCalendar(string3);
            double d = variantExprArray[2].eval(xNode, exprContext).convertToNumber();
            calendar.set(1970, 0, 1, (int)variantExprArray[0].eval(xNode, exprContext).convertToNumber(), (int)variantExprArray[1].eval(xNode, exprContext).convertToNumber(), (int)d);
            return new TimeVariant(calendar.getTime());
        }
        String string4 = null;
        if (variantExprArray.length >= 7) {
            string4 = variantExprArray[6].eval(xNode, exprContext).convertToString();
        }
        Calendar calendar = FunctionLibrary.getCalendar(string4);
        double d = variantExprArray[5].eval(xNode, exprContext).convertToNumber();
        calendar.set((int)variantExprArray[0].eval(xNode, exprContext).convertToNumber(), (int)variantExprArray[1].eval(xNode, exprContext).convertToNumber() - 1, (int)variantExprArray[2].eval(xNode, exprContext).convertToNumber(), (int)variantExprArray[3].eval(xNode, exprContext).convertToNumber(), (int)variantExprArray[4].eval(xNode, exprContext).convertToNumber(), (int)d);
        return new DateTimeVariant(calendar.getTime());
    }

    private static Calendar getCalendar(String string) {
        Calendar calendar = string != null ? Calendar.getInstance(TimeZone.getTimeZone(string)) : Calendar.getInstance();
        calendar.setLenient(true);
        calendar.set(14, 0);
        return calendar;
    }

    public static Variant year(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("year", variantExprArray, 1, 1);
        return FunctionLibrary.datefield("year", variantExprArray, xNode, exprContext);
    }

    public static Variant month(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("month", variantExprArray, 1, 1);
        return FunctionLibrary.datefield("month", variantExprArray, xNode, exprContext);
    }

    public static Variant day(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("day", variantExprArray, 1, 1);
        return FunctionLibrary.datefield("day", variantExprArray, xNode, exprContext);
    }

    public static Variant weekday(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("weekday", variantExprArray, 1, 2);
        return FunctionLibrary.datefield("weekday", variantExprArray, xNode, exprContext);
    }

    public static Variant hour(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("hour", variantExprArray, 1, 1);
        return FunctionLibrary.datefield("hour", variantExprArray, xNode, exprContext);
    }

    public static Variant minute(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("minute", variantExprArray, 1, 1);
        return FunctionLibrary.datefield("minute", variantExprArray, xNode, exprContext);
    }

    public static Variant second(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        FunctionLibrary.checkArgCount("second", variantExprArray, 1, 1);
        return FunctionLibrary.datefield("second", variantExprArray, xNode, exprContext);
    }

    private static Variant datefield(String string, VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        int n;
        block13: {
            Calendar calendar;
            block16: {
                block15: {
                    block14: {
                        block12: {
                            Date date = DateVariantBase.toDate(variantExprArray[0].eval(xNode, exprContext));
                            calendar = Calendar.getInstance();
                            calendar.setTime(date);
                            n = 0;
                            if (!"year".equals(string)) break block12;
                            n = calendar.get(1);
                            break block13;
                        }
                        if (!"month".equals(string)) break block14;
                        n = 1 + calendar.get(2);
                        break block13;
                    }
                    if (!"day".equals(string)) break block15;
                    n = calendar.get(5);
                    break block13;
                }
                if (!"weekday".equals(string)) break block16;
                n = calendar.get(7);
                int n2 = 1;
                if (variantExprArray.length > 1) {
                    n2 = (int)variantExprArray[1].eval(xNode, exprContext).convertToNumber();
                }
                switch (n2) {
                    case 2: {
                        if ((n -= 2) < 0) {
                            n += 7;
                        }
                        ++n;
                        break;
                    }
                    case 3: {
                        if ((n -= 2) < 0) {
                            n += 7;
                            break;
                        }
                        break block13;
                    }
                    default: {
                        n = n - 1 + 1;
                        break;
                    }
                }
                break block13;
            }
            if ("hour".equals(string)) {
                n = calendar.get(11);
            } else if ("minute".equals(string)) {
                n = calendar.get(12);
            } else if ("second".equals(string)) {
                n = calendar.get(13);
            }
        }
        return new NumberVariant(n);
    }

    public static Variant today(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        Calendar calendar = FunctionLibrary.getCalendar(null);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return new DateVariant(calendar.getTime());
    }

    public static Variant now(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        return new DateTimeVariant(new Date());
    }

    private static void checkArgCount(String string, VariantExpr[] variantExprArray, int n) throws EvalException {
        FunctionLibrary.checkArgCount(string, variantExprArray, n, Integer.MAX_VALUE);
    }

    private static void checkArgCount(String string, VariantExpr[] variantExprArray, int n, int n2) throws EvalException {
        int n3 = variantExprArray.length;
        if (n3 < n || n3 > n2) {
            String string2 = n == n2 ? Msg.msg("badArgCount1", new Integer(n), string, new Integer(n3)) : (n2 == Integer.MAX_VALUE ? Msg.msg("badArgCount2", new Integer(n), string, new Integer(n3)) : Msg.msg("badArgCount3", new Integer(n), new Integer(n2), string, new Integer(n3)));
            throw new EvalException(string2);
        }
    }

    private static final class ApplyIterator
    implements NodeIterator {
        private NodeIterator source;
        private TranslatedFormula transform;
        private boolean strict;
        private XNode node;
        private ExprContext context;
        private Variant[] values = new Variant[1];

        public ApplyIterator(NodeIterator nodeIterator, TranslatedFormula translatedFormula, boolean bl, XNode xNode, ExprContext exprContext) {
            this.source = nodeIterator;
            this.transform = translatedFormula;
            this.strict = bl;
            this.node = xNode;
            this.context = exprContext;
        }

        public XNode next() throws EvalException {
            Variant variant;
            XNode xNode = this.source.next();
            if (xNode == null) {
                return null;
            }
            this.values[0] = new StringVariant(Converter.toString(xNode));
            if (this.strict) {
                variant = this.transform.eval(FILTER_PARAM_NAMES, this.values, this.node, this.context);
            } else {
                try {
                    variant = this.transform.eval(FILTER_PARAM_NAMES, this.values, this.node, this.context);
                }
                catch (EvalException evalException) {
                    variant = this.values[0];
                }
            }
            return new Text(variant.convertToString());
        }
    }

    private static final class FilterChecker
    implements ExpressionNode.Checker {
        private boolean referencesX;
        private boolean cacheable;

        private FilterChecker() {
        }

        public boolean process(FormulaNode formulaNode) {
            this.referencesX = false;
            this.cacheable = true;
            formulaNode.check(this);
            return this.referencesX;
        }

        public boolean lastProcessedIsCacheable() {
            return this.cacheable;
        }

        public Object check(ExpressionNode expressionNode) {
            if (expressionNode instanceof VariableReferenceNode) {
                if ("x".equals(((VariableReferenceNode)expressionNode).name)) {
                    this.referencesX = true;
                }
            } else if (expressionNode instanceof FunctionCallNode) {
                String string = ((FunctionCallNode)expressionNode).name;
                FormulaFunction formulaFunction = FormulaFunctions.getRegistry().get(string);
                if (formulaFunction == null || !formulaFunction.isPredefined()) {
                    this.cacheable = false;
                }
            } else if (expressionNode instanceof XPathExpressionNode) {
                this.cacheable = false;
            }
            return null;
        }
    }

    private static final class DoubleList {
        public int size = 0;
        public double[] list = new double[0];

        private DoubleList() {
        }

        public void add(double d) {
            if (this.size + 1 > this.list.length) {
                int n = Math.max(10, 2 * this.list.length);
                double[] dArray = new double[n];
                if (this.size > 0) {
                    System.arraycopy(this.list, 0, dArray, 0, this.size);
                }
                this.list = dArray;
            }
            this.list[this.size++] = d;
        }
    }
}

