/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.spreadsheet;

import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xpath.Converter;
import com.xmlmind.xmleditapp.spreadsheet.CellRef;
import com.xmlmind.xmleditapp.spreadsheet.ExpressionNode;
import com.xmlmind.xmleditapp.spreadsheet.ParserConstants;
import com.xmlmind.xmleditapp.spreadsheet.ParserUtil;
import java.util.HashMap;

public class LiteralNode
extends ExpressionNode
implements ParserConstants {
    public int valueType;
    public Object value;

    public LiteralNode(int n, Object object) {
        super(1);
        this.valueType = n;
        this.value = object;
    }

    public void toString(boolean bl, CellRef cellRef, StringBuffer stringBuffer) {
        switch (this.valueType) {
            case 19: {
                stringBuffer.append(this.value.toString());
                break;
            }
            case 20: {
                String string = this.value.toString();
                if (string.endsWith(".0")) {
                    string = string.substring(0, string.length() - 2);
                }
                stringBuffer.append(string);
                break;
            }
            case 23: {
                ParserUtil.quoteString((String)this.value, stringBuffer);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public void translate(HashMap hashMap, boolean[] blArray, StringBuffer stringBuffer) {
        switch (this.valueType) {
            case 19: {
                stringBuffer.append(this.value.toString());
                stringBuffer.append("()");
                break;
            }
            case 20: {
                stringBuffer.append(Converter.toString((Double)this.value));
                break;
            }
            case 23: {
                char c;
                String string = (String)this.value;
                if (string.indexOf(34) >= 0) {
                    if (string.indexOf(39) >= 0) {
                        String[] stringArray = StringUtil.split(string, '\'');
                        StringBuffer stringBuffer2 = new StringBuffer();
                        int n = 0;
                        while (n < stringArray.length) {
                            if (stringBuffer2.length() > 0) {
                                stringBuffer2.append(", ");
                            }
                            if (n > 0) {
                                stringBuffer2.append("\"'\"");
                            }
                            if (stringArray[n].length() > 0) {
                                if (n > 0) {
                                    stringBuffer2.append(", ");
                                }
                                stringBuffer2.append('\'');
                                stringBuffer2.append(stringArray[n]);
                                stringBuffer2.append('\'');
                            }
                            ++n;
                        }
                        stringBuffer.append("concat(");
                        stringBuffer.append(stringBuffer2.toString());
                        stringBuffer.append(')');
                        break;
                    }
                    c = '\'';
                } else {
                    c = '\"';
                }
                stringBuffer.append(c);
                stringBuffer.append(string);
                stringBuffer.append(c);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public Object check(ExpressionNode.Checker checker) {
        return checker.check(this);
    }
}

