/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.spreadsheet;

import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmleditapp.spreadsheet.FormatUtil;
import com.xmlmind.xmleditapp.spreadsheet.FormulaNode;
import com.xmlmind.xmleditapp.spreadsheet.Msg;
import com.xmlmind.xmleditapp.spreadsheet.ParseException;
import com.xmlmind.xmleditapp.spreadsheet.Parser;
import com.xmlmind.xmleditapp.spreadsheet.ParserUtil;
import com.xmlmind.xmleditapp.spreadsheet.TokenMgrError;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

public final class ParsedPIData {
    public FormulaNode formula;
    public Locale locale;
    public String formatPrefix;
    public Format format;
    public String formatSuffix;
    public boolean disabled;
    public Name attributeName;
    private static String[] specParts = new String[5];
    private static Object[] formatParts = new Object[3];

    public static ParsedPIData fromString(String string, PrefixToNamespace prefixToNamespace) throws IllegalArgumentException {
        ParsedPIData.splitData(string, specParts);
        ParsedPIData parsedPIData = new ParsedPIData();
        parsedPIData.formula = ParsedPIData.parseFormula(specParts[0]);
        if (specParts[1] != null) {
            parsedPIData.locale = ParsedPIData.parseLocale(specParts[1]);
        }
        if (specParts[2] != null) {
            ParsedPIData.parseFormat(specParts[2], formatParts, parsedPIData.locale);
            parsedPIData.formatPrefix = (String)formatParts[0];
            parsedPIData.format = (Format)formatParts[1];
            parsedPIData.formatSuffix = (String)formatParts[2];
        }
        if (specParts[3] != null) {
            parsedPIData.disabled = ParsedPIData.parseDisabled(specParts[3]);
        }
        if (specParts[4] != null) {
            parsedPIData.attributeName = ParsedPIData.parseAttributeName(specParts[4], prefixToNamespace);
        }
        return parsedPIData;
    }

    public static void splitData(String string, String[] stringArray) throws IllegalArgumentException {
        stringArray[4] = null;
        stringArray[3] = null;
        stringArray[2] = null;
        stringArray[1] = null;
        stringArray[0] = null;
        String[] stringArray2 = ProcessingInstruction.parsePseudoAttributes(string);
        if (stringArray2 == null) {
            throw new IllegalArgumentException(Msg.msg("unstructuredPIData", string));
        }
        int n = 0;
        while (n < stringArray2.length) {
            String string2 = stringArray2[n];
            String string3 = stringArray2[n + 1];
            int n2 = -1;
            if ("formula".equals(string2)) {
                n2 = 0;
            } else if ("locale".equals(string2)) {
                n2 = 1;
            } else if ("format".equals(string2)) {
                n2 = 2;
            } else if ("disabled".equals(string2)) {
                n2 = 3;
            } else if ("attribute".equals(string2)) {
                n2 = 4;
            }
            if (n2 >= 0) {
                if (stringArray[n2] != null) {
                    throw new IllegalArgumentException(Msg.msg("pseudoAttributeAlreadyDefined", string2));
                }
            } else {
                throw new IllegalArgumentException(Msg.msg("unknownPseudoAttribute", string2));
            }
            stringArray[n2] = XMLUtil.unescapeXML(string3);
            n += 2;
        }
        if (stringArray[0] == null) {
            throw new IllegalArgumentException(Msg.msg("missingFormula", string));
        }
    }

    public static FormulaNode parseFormula(String string) throws IllegalArgumentException {
        try {
            return Parser.parse(string);
        }
        catch (ParseException parseException) {
            int n = ParserUtil.getLine(parseException);
            int n2 = ParserUtil.getColumn(parseException);
            throw new IllegalArgumentException(Msg.msg("syntaxError", new Integer(n), new Integer(n2), parseException.getMessage()));
        }
        catch (TokenMgrError tokenMgrError) {
            throw new IllegalArgumentException(Msg.msg("lexicalError", tokenMgrError.getMessage()));
        }
    }

    public static Locale parseLocale(String string) throws IllegalArgumentException {
        Locale locale = FormatUtil.getLocale(string = string.trim());
        if (locale == null) {
            throw new IllegalArgumentException(Msg.msg("unknownLocale", string));
        }
        return locale;
    }

    public static void parseFormat(String string, Object[] objectArray, Locale locale) throws IllegalArgumentException {
        String string2;
        objectArray[2] = null;
        objectArray[1] = null;
        objectArray[0] = null;
        int n = string.length();
        int n2 = string.indexOf(123);
        while (n2 >= 0 && n2 + 1 < n && string.charAt(n2 + 1) == '{') {
            n2 = string.indexOf(123, n2 + 2);
        }
        int n3 = string.lastIndexOf(125);
        while (n3 >= 0 && n3 - 1 >= 0 && string.charAt(n3 - 1) == '}') {
            n3 = string.lastIndexOf(125, n3 - 2);
        }
        if (n2 < 0 && n3 < 0) {
            string2 = string;
        } else {
            if (n2 < 0 || n3 < 0 || n3 < n2) {
                throw new IllegalArgumentException(Msg.msg("invalidFormat", string));
            }
            string2 = string.substring(n2 + 1, n3);
        }
        if (string2.length() == 0) {
            if (string2 == string) {
                throw new IllegalArgumentException(Msg.msg("emptyFormat"));
            }
            objectArray[1] = new MessageFormat("{0}");
        } else {
            try {
                objectArray[1] = FormatUtil.getFormat(string2, locale, 0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(Msg.msg("invalidFormatPattern", string2, MiscUtil.reason(illegalArgumentException)));
            }
        }
        if (string2 != string) {
            objectArray[0] = string.substring(0, n2);
            if (((String)objectArray[0]).length() == 0) {
                objectArray[0] = null;
            }
            if (objectArray[0] != null && ParsedPIData.containsFormatQuotes((String)objectArray[0])) {
                objectArray[0] = ParsedPIData.unquoteFormat((String)objectArray[0]);
            }
            objectArray[2] = string.substring(n3 + 1);
            if (((String)objectArray[2]).length() == 0) {
                objectArray[2] = null;
            }
            if (objectArray[2] != null && ParsedPIData.containsFormatQuotes((String)objectArray[2])) {
                objectArray[2] = ParsedPIData.unquoteFormat((String)objectArray[2]);
            }
        }
    }

    private static final boolean containsFormatQuotes(String string) {
        return string.indexOf(123) >= 0 || string.indexOf(125) >= 0;
    }

    private static final String unquoteFormat(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '{': 
                case '}': {
                    if (n2 + 1 >= n || string.charAt(n2 + 1) != c) break;
                    ++n2;
                }
            }
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static boolean parseDisabled(String string) {
        string = string.trim();
        return "true".equals(string);
    }

    public static Name parseAttributeName(String string, PrefixToNamespace prefixToNamespace) throws IllegalArgumentException {
        Name name = Name.parse(string = string.trim(), true, prefixToNamespace);
        if (name == null) {
            throw new IllegalArgumentException(Msg.msg("malformedQName", string));
        }
        return name;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(NamespaceToPrefixes namespaceToPrefixes) {
        return this.toString(this.formula.toString(), namespaceToPrefixes);
    }

    public String toString(String string, NamespaceToPrefixes namespaceToPrefixes) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("formula='");
        XMLUtil.escapeXML(string, stringBuffer);
        stringBuffer.append('\'');
        if (this.format != null) {
            String string2;
            if (this.locale != null) {
                stringBuffer.append("\nlocale='");
                stringBuffer.append(FormatUtil.toLabel(this.locale));
                stringBuffer.append('\'');
            }
            stringBuffer.append("\nformat='");
            if (this.formatPrefix != null) {
                string2 = this.formatPrefix;
                if (ParsedPIData.containsFormatQuotes(string2)) {
                    string2 = ParsedPIData.quoteFormat(string2);
                }
                XMLUtil.escapeXML(string2, stringBuffer);
            }
            stringBuffer.append('{');
            if (this.format instanceof DecimalFormat) {
                XMLUtil.escapeXML(((DecimalFormat)this.format).toPattern(), stringBuffer);
            } else if (this.format instanceof SimpleDateFormat) {
                XMLUtil.escapeXML(((SimpleDateFormat)this.format).toPattern(), stringBuffer);
            }
            stringBuffer.append('}');
            if (this.formatSuffix != null) {
                string2 = this.formatSuffix;
                if (ParsedPIData.containsFormatQuotes(string2)) {
                    string2 = ParsedPIData.quoteFormat(string2);
                }
                XMLUtil.escapeXML(string2, stringBuffer);
            }
            stringBuffer.append('\'');
        }
        if (this.disabled) {
            stringBuffer.append("\ndisabled='true'");
        }
        if (this.attributeName != null) {
            stringBuffer.append("\nattribute='");
            stringBuffer.append(this.attributeName.format(true, namespaceToPrefixes));
            stringBuffer.append('\'');
        }
        return stringBuffer.toString();
    }

    private static final String quoteFormat(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '{': 
                case '}': {
                    stringBuffer.append(c);
                }
            }
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }
}

