/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.spreadsheet;

import com.xmlmind.xmleditapp.spreadsheet.ParseException;

public final class ParserUtil {
    public static void quoteXPath(String string, StringBuffer stringBuffer) {
        stringBuffer.append('`');
        ParserUtil.escape(string, '`', stringBuffer);
        stringBuffer.append('`');
    }

    public static void quoteString(String string, StringBuffer stringBuffer) {
        if (string.indexOf(34) < 0) {
            stringBuffer.append('\"');
            ParserUtil.escape(string, '\"', stringBuffer);
            stringBuffer.append('\"');
        } else {
            stringBuffer.append('\'');
            ParserUtil.escape(string, '\'', stringBuffer);
            stringBuffer.append('\'');
        }
    }

    private static void escape(String string, char c, StringBuffer stringBuffer) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            if (c2 == c) {
                stringBuffer.append(c);
                stringBuffer.append(c);
            } else {
                stringBuffer.append(c2);
            }
            ++n2;
        }
    }

    public static String unquoteXPath(String string) {
        return ParserUtil.unescape(string.substring(1, string.length() - 1), '`');
    }

    public static String unquoteString(String string) {
        return ParserUtil.unescape(string.substring(1, string.length() - 1), string.charAt(0));
    }

    private static String unescape(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            if (c2 == c && n2 + 1 < n && string.charAt(n2 + 1) == c) {
                stringBuffer.append(c);
                ++n2;
            } else {
                stringBuffer.append(c2);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static int getLine(ParseException parseException) {
        if (parseException.currentToken.next == null) {
            return parseException.currentToken.endLine <= 0 ? 1 : parseException.currentToken.endLine;
        }
        return parseException.currentToken.next.beginLine;
    }

    public static int getColumn(ParseException parseException) {
        if (parseException.currentToken.next == null) {
            return parseException.currentToken.endColumn <= 0 ? 1 : parseException.currentToken.endColumn;
        }
        return parseException.currentToken.next.beginColumn;
    }
}

