/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.spreadsheet;

import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmleditapp.spreadsheet.Constants;
import com.xmlmind.xmleditapp.spreadsheet.Msg;
import com.xmlmind.xmleditapp.spreadsheet.ParsedPIData;
import java.util.ArrayList;

public class RemoveFormulas
extends RecordableCommand
implements Traversal.Handler,
Constants {
    private int op;
    private Node fromNode;
    private Node toNode;
    private ArrayList piList;
    private static final int REMOVE = 0;
    private static final int ENABLE = 1;
    private static final int DISABLE = 2;
    private static final int TOGGLE = 3;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        this.toNode = null;
        this.fromNode = null;
        this.piList = null;
        DocumentView documentView = (DocumentView)gadget;
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null) {
            return false;
        }
        NodeMark nodeMark = markManager.getSelected();
        if (nodeMark != null) {
            NodeMark nodeMark2 = markManager.getSelected2();
            if (nodeMark2 == null) {
                nodeMark2 = nodeMark;
            }
            this.fromNode = nodeMark.getNode();
            this.toNode = nodeMark2.getNode();
        } else {
            TextLocation textLocation = markManager.getDot();
            if (textLocation == null) {
                return false;
            }
            TextLocation textLocation2 = markManager.getMark();
            if (textLocation2 == null || textLocation2.getTextNode() == textLocation.getTextNode() && textLocation2.getOffset() == textLocation.getOffset()) {
                if (string == null || !string.endsWith("[implicitElement]")) return false;
                this.fromNode = this.toNode = textLocation.getTextNode().getParentElement();
            } else {
                this.fromNode = textLocation2.getTextNode();
                this.toNode = textLocation.getTextNode();
                if (this.fromNode == this.toNode) {
                    this.toNode = null;
                    this.fromNode = null;
                    return false;
                }
            }
        }
        if (string != null) {
            if (string.startsWith("toggle")) {
                this.op = 3;
                return true;
            } else if (string.startsWith("disable")) {
                this.op = 2;
                return true;
            } else if (string.startsWith("enable")) {
                this.op = 1;
                return true;
            } else {
                if (!string.startsWith("remove")) return false;
                this.op = 0;
            }
            return true;
        } else {
            this.op = 0;
        }
        return true;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        Object object;
        Document document = documentView.getDocument();
        this.piList = new ArrayList();
        if (Traversal.traverseFrom(this.fromNode, this) == null) {
            this.piList.clear();
            Node node = this.fromNode;
            this.fromNode = this.toNode;
            this.toNode = node;
            Traversal.traverseFrom(this.fromNode, this);
        }
        int n3 = 0;
        int n4 = this.piList.size();
        int n5 = 0;
        while (n5 < n4) {
            block22: {
                object = (ProcessingInstruction)this.piList.get(n5);
                Element element = ((Node)object).getParentElement();
                if (element != null && element.isEditable()) {
                    if (this.op == 0) {
                        if (n3 == 0) {
                            document.beginBatchEditing();
                        }
                        element.removeChild((Node)object);
                        ++n3;
                    } else {
                        ParsedPIData parsedPIData = null;
                        try {
                            parsedPIData = ParsedPIData.fromString(((TextNode)object).getText(), element);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            break block22;
                        }
                        String string2 = null;
                        switch (this.op) {
                            case 3: {
                                parsedPIData.disabled = !parsedPIData.disabled;
                                string2 = parsedPIData.toString(element);
                                break;
                            }
                            case 1: {
                                if (!parsedPIData.disabled) break;
                                parsedPIData.disabled = false;
                                string2 = parsedPIData.toString(element);
                                break;
                            }
                            case 2: {
                                if (parsedPIData.disabled) break;
                                parsedPIData.disabled = true;
                                string2 = parsedPIData.toString(element);
                            }
                        }
                        if (string2 != null) {
                            if (n3 == 0) {
                                document.beginBatchEditing();
                            }
                            element.replaceChild((Node)object, new ProcessingInstruction("xxe-formula", string2));
                            ++n3;
                        }
                    }
                }
            }
            ++n5;
        }
        if (n3 > 0) {
            document.endBatchEditing();
            switch (this.op) {
                case 3: {
                    object = "toggleFormulas";
                    break;
                }
                case 1: {
                    object = "enableFormulas";
                    break;
                }
                case 2: {
                    object = "disableFormulas";
                    break;
                }
                default: {
                    object = "removeFormulas";
                }
            }
            documentView.describeUndo(Msg.msg((String)object));
        }
        if (this.fromNode != this.toNode || this.fromNode instanceof Element) {
            ShowStatus.showStatus(Msg.msg("processedNFormulas", Integer.toString(n3)));
        }
        this.piList = null;
        this.toNode = null;
        this.fromNode = null;
        return null;
    }

    public Object processText(Text text) {
        if (text == this.toNode) {
            return this.toNode;
        }
        return null;
    }

    public Object processPI(ProcessingInstruction processingInstruction) {
        if ("xxe-formula".equals(processingInstruction.getTarget())) {
            this.piList.add(processingInstruction);
        }
        if (processingInstruction == this.toNode) {
            return this.toNode;
        }
        return null;
    }

    public Object processComment(Comment comment) {
        if (comment == this.toNode) {
            return this.toNode;
        }
        return null;
    }

    public Object enterElement(Element element) {
        return null;
    }

    public Object leaveElement(Element element) {
        if (element == this.toNode) {
            return this.toNode;
        }
        return null;
    }
}

