/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.spreadsheet;

import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.edit.ElementEditor;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.AWTUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmleditapp.spreadsheet.Constants;
import com.xmlmind.xmleditapp.spreadsheet.FormulaEditor;
import com.xmlmind.xmleditapp.spreadsheet.Msg;
import com.xmlmind.xmleditapp.spreadsheet.SpreadsheetHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;

public class SetFormula
extends RecordableCommand
implements Constants {
    private Element parentElement = null;
    private ProcessingInstruction formulaPI = null;
    private Text textNode = null;
    private int textOffset = -1;
    private FormulaEditor formulaEditor = null;

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        Node node;
        this.parentElement = null;
        this.formulaPI = null;
        this.textNode = null;
        this.textOffset = -1;
        DocumentView documentView = (DocumentView)gadget;
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null) {
            return false;
        }
        NodeMark nodeMark = markManager.getSelected();
        if (nodeMark != null) {
            NodeMark nodeMark2 = markManager.getSelected2();
            if (nodeMark2 != null) {
                return false;
            }
            node = nodeMark.getNode();
        } else {
            TextLocation textLocation = markManager.getMark();
            if (textLocation != null) {
                return false;
            }
            TextLocation textLocation2 = markManager.getDot();
            if (textLocation2 == null) {
                return false;
            }
            node = textLocation2.getTextNode();
            this.textOffset = textLocation2.getOffset();
        }
        switch (node.getNodeType()) {
            case 2: {
                if (!((ProcessingInstruction)node).getTarget().equals("xxe-formula")) break;
                this.parentElement = node.getParentElement();
                this.formulaPI = (ProcessingInstruction)node;
                this.textNode = null;
                this.textOffset = -1;
                return true;
            }
            case 4: {
                if (!((Element)node).hasNoContent()) break;
                this.parentElement = (Element)node;
                this.formulaPI = null;
                this.textNode = null;
                this.textOffset = -1;
                return true;
            }
            case 0: {
                if (this.textOffset < 0) break;
                this.parentElement = node.getParentElement();
                this.formulaPI = null;
                this.textNode = (Text)node;
                return true;
            }
        }
        return false;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        String string2;
        Container container = documentView.getPanel();
        FormulaEditor formulaEditor = this.getFormulaEditor(container);
        String string3 = formulaEditor.editFormula(this.formulaPI == null ? null : this.formulaPI.getText(), this.parentElement);
        if (string3 == null) {
            return Command.EXECUTION_FAILED;
        }
        Document document = documentView.getDocument();
        if (document.getProperty("com.xmlmind.xmleditapp.spreadsheet.SPREADSHEET") == null) {
            SpreadsheetHelper.setSpreadsheet(document, container);
        }
        MarkManager markManager = documentView.getMarkManager();
        markManager.beginBatchMarking();
        ProcessingInstruction processingInstruction = new ProcessingInstruction("xxe-formula", string3);
        if (this.formulaPI == null) {
            if (this.textNode != null) {
                ElementEditor elementEditor = documentView.getElementEditor();
                elementEditor.editElement(this.parentElement);
                elementEditor.insert(this.textNode, this.textOffset, processingInstruction);
            } else {
                this.parentElement.appendChild(processingInstruction);
            }
            string2 = "insertFormula";
        } else {
            this.parentElement.replaceChild(this.formulaPI, processingInstruction);
            string2 = "editFormula";
        }
        documentView.describeUndo(Msg.msg(string2));
        documentView.selectNode(processingInstruction);
        markManager.endBatchMarking();
        return null;
    }

    public FormulaEditor getFormulaEditor(Component component) {
        Window window = AWTUtil.getDialogOwner(component);
        if (this.formulaEditor == null || this.formulaEditor.getOwner() != window) {
            this.formulaEditor = new FormulaEditor(component);
        }
        return this.formulaEditor;
    }
}

