/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.spreadsheet;

import com.xmlmind.xmledit.doc.BatchEditingEvent;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentEvent;
import com.xmlmind.xmledit.doc.DocumentListener;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.ElementAttributeEvent;
import com.xmlmind.xmledit.doc.ElementStructureEvent;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.ProcessingInstructionEvent;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextEvent;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.edit.ApplyChangesEvent;
import com.xmlmind.xmledit.edit.ContextChangeEvent;
import com.xmlmind.xmledit.edit.ContextChangeListener;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.SimpleDocumentCache;
import com.xmlmind.xmledit.edit.UndoEvent;
import com.xmlmind.xmledit.edit.UndoListener;
import com.xmlmind.xmledit.edit.UndoManager;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.styledview.PseudoElementCustomView;
import com.xmlmind.xmledit.styledview.TableBodyVP;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xpath.DocumentManager;
import com.xmlmind.xmledit.xpath.Variant;
import com.xmlmind.xmleditapp.spreadsheet.CellRef;
import com.xmlmind.xmleditapp.spreadsheet.Constants;
import com.xmlmind.xmleditapp.spreadsheet.EvalContext;
import com.xmlmind.xmleditapp.spreadsheet.ExpressionNode;
import com.xmlmind.xmleditapp.spreadsheet.FormatUtil;
import com.xmlmind.xmleditapp.spreadsheet.FormulaFunctions;
import com.xmlmind.xmleditapp.spreadsheet.FormulaTVP;
import com.xmlmind.xmleditapp.spreadsheet.Job;
import com.xmlmind.xmleditapp.spreadsheet.JobScheduler;
import com.xmlmind.xmleditapp.spreadsheet.JobSchedulerImpl;
import com.xmlmind.xmleditapp.spreadsheet.Msg;
import com.xmlmind.xmleditapp.spreadsheet.ParsedPIData;
import com.xmlmind.xmleditapp.spreadsheet.SpreadsheetEvent;
import com.xmlmind.xmleditapp.spreadsheet.TranslatedFormula;
import java.text.Format;
import java.util.Arrays;
import java.util.Comparator;
import java.util.IdentityHashMap;

public final class Spreadsheet
implements DocumentListener,
UndoListener,
ContextChangeListener,
Runnable,
Constants {
    public static final int UNKNOWN = 0;
    public static final int PARSE_ERROR = 1;
    public static final int DISABLED = 2;
    public static final int ACTIVE = 3;
    public static final int EVAL_ERROR = 4;
    public static final int STATUS_COUNT = 5;
    public static final int MIN_ITERATION_COUNT = 2;
    public static final int MAX_ITERATION_COUNT = 1000;
    public static final int DEFAULT_ITERATION_COUNT = 20;
    private JobScheduler jobScheduler;
    private Console console;
    private Document document;
    private boolean autoRecalc;
    private int maxIterations;
    private boolean cacheDocuments;
    private boolean trace;
    private IdentityHashMap piToInactiveField;
    private IdentityHashMap piToActiveField;
    private ActiveField[] activeFields;
    private UndoState undoState;
    private EvalContext evalContext;
    private RemoveFields removeFields;
    private AddFields addFields;
    private Job recalcJob;
    private boolean needRecalc;
    private boolean recalculating;
    private boolean batchEditing;
    private boolean newFormulas;
    private static final byte STATIC_FIELD_FLAG = 1;
    private static final byte NEW_FIELD_FLAG = 2;

    public Spreadsheet(Console console) {
        this(new JobSchedulerImpl(), console);
    }

    public Spreadsheet(JobScheduler jobScheduler, Console console) {
        this.jobScheduler = jobScheduler;
        this.console = console;
        this.maxIterations = 20;
        this.piToInactiveField = new IdentityHashMap();
        this.piToActiveField = new IdentityHashMap();
        this.activeFields = new ActiveField[0];
        this.undoState = new UndoState(0);
        this.evalContext = new EvalContext();
        this.setCachingDocuments(true);
        this.removeFields = new RemoveFields();
        this.addFields = new AddFields();
    }

    public JobScheduler getJobScheduler() {
        return this.jobScheduler;
    }

    public Console getConsole() {
        return this.console;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public void setAutoRecalc(boolean bl) {
        if (this.autoRecalc != bl) {
            this.autoRecalc = bl;
            MarkManager markManager = null;
            if (this.document != null) {
                markManager = (MarkManager)this.document.getProperty("MARK_MANAGER");
                this.document.notifyDocumentListeners(new SpreadsheetEvent(this, bl ? 202 : 203));
            }
            if (bl) {
                if (!this.batchEditing && this.needRecalc) {
                    this.scheduleRecalc();
                }
                if (markManager != null) {
                    markManager.addContextChangeListener(this);
                }
            } else {
                this.disposeRecalcJob();
                if (markManager != null) {
                    markManager.removeContextChangeListener(this);
                }
            }
        }
    }

    public boolean isAutoRecalc() {
        return this.autoRecalc;
    }

    public void setCachingDocuments(boolean bl) {
        this.cacheDocuments = bl;
        if (bl) {
            this.evalContext.setDocumentManager(null);
            SimpleDocumentCache.installDefaultDocumentManager();
        } else {
            this.evalContext.setDocumentManager(new SimpleDocumentCache(10));
        }
    }

    public boolean isCachingDocuments() {
        return this.cacheDocuments;
    }

    public void clearDocumentCache() {
        DocumentManager documentManager;
        if (this.cacheDocuments && (documentManager = EvalContext.getDefaultDocumentManager()) != null && documentManager instanceof SimpleDocumentCache) {
            ((SimpleDocumentCache)documentManager).clear();
        }
    }

    public void setMaxIterations(int n) {
        if (n < 2) {
            n = 2;
        } else if (n > 1000) {
            n = 1000;
        }
        this.maxIterations = n;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setDocument(Document document) {
        DocumentListener documentListener;
        if (this.document != null) {
            this.disposeRecalcJob();
            if (this.autoRecalc && (documentListener = (MarkManager)this.document.getProperty("MARK_MANAGER")) != null) {
                ((MarkManager)documentListener).removeContextChangeListener(this);
            }
            if ((documentListener = (UndoManager)this.document.getProperty("UNDO_MANAGER")) != null) {
                ((UndoManager)documentListener).removeUndoListener(this);
            }
            this.document.notifyDocumentListeners(new SpreadsheetEvent(this, 201));
            this.document = null;
            this.newFormulas = false;
            this.batchEditing = false;
            this.recalculating = false;
            this.needRecalc = false;
            this.piToInactiveField.clear();
            this.piToActiveField.clear();
            this.activeFields = new ActiveField[0];
            this.undoState = new UndoState(0);
            this.evalContext = new EvalContext();
        }
        if (document != null) {
            MarkManager markManager;
            this.document = document;
            this.document.addDocumentListener(this, false);
            documentListener = (UndoManager)this.document.getProperty("UNDO_MANAGER");
            if (documentListener != null) {
                ((UndoManager)documentListener).addUndoListener(this);
            }
            if (this.autoRecalc && (markManager = (MarkManager)this.document.getProperty("MARK_MANAGER")) != null) {
                markManager.addContextChangeListener(this);
            }
            if (!document.isReadOnly()) {
                this.addFields.traverse(document.getRootElement());
            }
            this.document.notifyDocumentListeners(new SpreadsheetEvent(this, 200));
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public Field getField(ProcessingInstruction processingInstruction) {
        Field field = (Field)this.piToActiveField.get(processingInstruction);
        if (field == null) {
            field = (Field)this.piToInactiveField.get(processingInstruction);
        }
        return field;
    }

    public void recalc() {
        this.recalc(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalc(boolean bl) {
        this.disposeRecalcJob();
        if (this.document == null) {
            throw new IllegalStateException("no document");
        }
        if (this.recalculating) {
            throw new IllegalStateException("already recalculating");
        }
        this.recalculating = true;
        try {
            this.doRecalc(bl || this.autoRecalc);
            Object var3_2 = null;
            this.recalculating = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.recalculating = false;
            throw throwable;
        }
    }

    private void disposeRecalcJob() {
        if (this.recalcJob != null) {
            this.recalcJob.cancel();
            this.recalcJob = null;
        }
    }

    private void scheduleRecalc() {
        if (this.recalcJob == null && this.jobScheduler != null) {
            this.recalcJob = this.jobScheduler.schedule(this);
        }
    }

    public void run() {
        this.recalc(false);
    }

    public void batchEditingStarted(BatchEditingEvent batchEditingEvent, int n) {
        if (this.recalculating) {
            return;
        }
        this.batchEditing = true;
        this.newFormulas = false;
    }

    public void batchEditingCompleted(BatchEditingEvent batchEditingEvent, int n) {
        if (this.recalculating) {
            return;
        }
        this.batchEditing = false;
        boolean bl = this.newFormulas;
        this.newFormulas = false;
        if (this.needRecalc && (this.autoRecalc || bl)) {
            this.scheduleRecalc();
        }
    }

    public void elementStructureChanged(ElementStructureEvent elementStructureEvent, int n) {
        boolean bl;
        int n2;
        if (this.recalculating) {
            return;
        }
        Node node = elementStructureEvent.getOldChild();
        if (node != null) {
            this.removeFields.traverse(node);
        }
        int n3 = this.activeFields.length;
        Node node2 = elementStructureEvent.getNewChild();
        if (node2 != null) {
            this.addFields.traverse(node2);
        }
        if ((n2 = this.activeFields.length) > 0) {
            this.needRecalc = true;
        }
        boolean bl2 = bl = n2 > n3;
        if (this.batchEditing) {
            this.newFormulas = this.newFormulas || bl;
        } else if (this.needRecalc && (this.autoRecalc || bl)) {
            this.scheduleRecalc();
        }
    }

    public void elementAttributeChanged(ElementAttributeEvent elementAttributeEvent, int n) {
        if (this.recalculating) {
            return;
        }
        if (this.activeFields.length > 0) {
            this.needRecalc = true;
        }
        if (!this.batchEditing && this.needRecalc && this.autoRecalc) {
            this.scheduleRecalc();
        }
    }

    public void processingInstructionChanged(ProcessingInstructionEvent processingInstructionEvent, int n) {
        if (this.recalculating) {
            return;
        }
        if (this.activeFields.length > 0) {
            this.needRecalc = true;
        }
        if (!this.batchEditing && this.needRecalc && this.autoRecalc) {
            this.scheduleRecalc();
        }
    }

    public void textChanged(TextEvent textEvent, int n) {
        if (this.recalculating) {
            return;
        }
        if (this.activeFields.length > 0) {
            this.needRecalc = true;
        }
    }

    public void customEventHappened(DocumentEvent documentEvent, int n) {
        if (this.recalculating) {
            return;
        }
        if (documentEvent instanceof ApplyChangesEvent && this.needRecalc) {
            this.recalc(true);
        }
    }

    public void contextChanged(ContextChangeEvent contextChangeEvent) {
        if (this.recalculating) {
            return;
        }
        if (!this.batchEditing && this.needRecalc) {
            this.scheduleRecalc();
        }
    }

    public void performingUndoAction(UndoEvent undoEvent) {
        if (Spreadsheet.getUndoState(undoEvent) != null) {
            this.recalculating = true;
        }
    }

    private static UndoState getUndoState(UndoEvent undoEvent) {
        Object object = undoEvent.getAction().getClientData();
        return object != null && object instanceof UndoState ? (UndoState)object : null;
    }

    public void undoActionPerformed(UndoEvent undoEvent) {
        UndoState undoState = Spreadsheet.getUndoState(undoEvent);
        if (undoState != null) {
            UndoFieldState[] undoFieldStateArray;
            this.recalculating = false;
            if (undoEvent.isRedo()) {
                this.needRecalc = undoState.needRecalcAfter;
                undoFieldStateArray = undoState.fieldStatesAfter;
            } else {
                this.needRecalc = undoState.needRecalcBefore;
                undoFieldStateArray = undoState.fieldStatesBefore;
            }
            int n = 0;
            while (n < undoFieldStateArray.length) {
                UndoFieldState undoFieldState = undoFieldStateArray[n];
                ActiveField activeField = undoFieldState.field;
                activeField.flags = undoFieldState.flags;
                activeField.status = undoFieldState.status;
                activeField.evalStatusLine = undoFieldState.evalStatusLine;
                this.refreshFieldViews(activeField);
                ++n;
            }
        }
    }

    private void doRecalc(boolean bl) {
        Object object;
        Object object2;
        int n = this.activeFields.length;
        int n2 = 0;
        while (n2 < n) {
            object2 = this.activeFields[n2];
            ((ActiveField)object2).updatedAtIteration = -1;
            this.undoState.fieldStatesBefore[n2].set((ActiveField)object2);
            ++n2;
        }
        this.undoState.needRecalcBefore = this.needRecalc;
        object2 = new boolean[2];
        int n3 = 0;
        while (n3 < this.maxIterations) {
            if (this.trace) {
                Spreadsheet.trace("doRecalc: iteration #" + (1 + n3));
            }
            object2[0] = false;
            this.recalcFields(bl, n3, (boolean[])object2);
            if (object2[0] != false) break;
            ++n3;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            object = this.activeFields[n5];
            if (((ActiveField)object).updatedAtIteration >= 0) {
                ++n4;
            }
            this.undoState.fieldStatesAfter[n5].set((ActiveField)object);
            ++n5;
        }
        if (this.trace) {
            Spreadsheet.trace("doRecalc: updated fields " + n4 + " / " + n);
        }
        if (bl || n4 == n) {
            this.needRecalc = false;
        }
        this.undoState.needRecalcAfter = this.needRecalc;
        if (object2[1] != false) {
            UndoManager.Action action;
            this.document.endBatchEditing();
            object = (UndoManager)this.document.getProperty("UNDO_MANAGER");
            if (object != null && (action = ((UndoManager)object).getTopUndoAction()) != null) {
                if (action.getDescription() == null) {
                    action.setDescription(Msg.msg("recalc"));
                }
                if (action.getClientData() == null) {
                    action.setClientData(this.undoState.copy());
                }
            }
        }
        if (this.trace) {
            Spreadsheet.trace("doRecalc: done after " + (1 + n3) + " iterations");
        }
        this.evalContext.reset();
        object = this.evalContext.getDocumentManager();
        if (object != null) {
            ((SimpleDocumentCache)object).clear();
        }
        boolean bl2 = true;
        int n6 = -1;
        int n7 = 0;
        while (n7 < n) {
            ActiveField activeField = this.activeFields[n7];
            activeField.formula.clearVariables();
            activeField.flags = (byte)(activeField.flags & 0xFFFFFFFD);
            int n8 = activeField.updatedAtIteration;
            if (n8 >= 0) {
                this.refreshFieldViews(activeField);
            }
            if (bl2) {
                if (n8 < n6) {
                    bl2 = false;
                }
                n6 = n8;
            }
            ++n7;
        }
        if (!bl2) {
            if (this.trace) {
                Spreadsheet.trace("doRecalc: sorting " + this.activeFields.length + " fields");
            }
            Arrays.sort(this.activeFields);
        }
        if (n3 == this.maxIterations) {
            this.showMessage(Msg.msg("reachedMaxIterations", new Integer(this.maxIterations)), 2);
        }
    }

    private void showMessage(String string, int n) {
        if (this.console != null) {
            this.console.showMessage(string, n);
        }
    }

    private void refreshFieldViews(Field field) {
        int n = this.document.getDocumentListenerCount(true);
        int n2 = 0;
        while (n2 < n) {
            Object object = field.pi.getDocumentListenerData(n2);
            if (object != null && object instanceof PseudoElementCustomView) {
                PseudoElementCustomView pseudoElementCustomView = (PseudoElementCustomView)object;
                Gadget[] gadgetArray = pseudoElementCustomView.getChildren();
                int n3 = 0;
                while (n3 < gadgetArray.length) {
                    Gadget gadget = gadgetArray[n3];
                    if (gadget instanceof FormulaTVP) {
                        ((FormulaTVP)gadget).refresh();
                        break;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
    }

    private void recalcFields(boolean bl, int n, boolean[] blArray) {
        int n2 = 0;
        int n3 = this.activeFields.length;
        int n4 = 0;
        while (n4 < n3) {
            block10: {
                ActiveField activeField;
                block9: {
                    block11: {
                        boolean bl2;
                        activeField = this.activeFields[n4];
                        boolean bl3 = bl2 = (activeField.flags & 2) != 0;
                        if (!bl && !bl2) break block10;
                        if ((activeField.flags & 1) == 0) break block11;
                        if (!bl2) break block10;
                        activeField.flags = (byte)(activeField.flags & 0xFFFFFFFD);
                    }
                    if (n == 0) {
                        activeField.prevStatus = activeField.status;
                        activeField.prevValue = Spreadsheet.getFieldValue(activeField);
                        activeField.prevEvalStatusLine = activeField.evalStatusLine;
                    }
                    try {
                        Variant variant = activeField.formula.doEval(activeField.parentElement, this.evalContext);
                        activeField.value = FormatUtil.format(activeField.formatPrefix, activeField.format, activeField.formatSuffix, variant);
                        activeField.status = (byte)3;
                        activeField.evalStatusLine = null;
                        if (this.trace) {
                            Spreadsheet.trace("ACTIVE \"" + activeField.pi.getText() + "\" = \"" + activeField.value + "\"");
                        }
                    }
                    catch (Exception exception) {
                        activeField.value = null;
                        activeField.status = (byte)4;
                        activeField.evalStatusLine = MiscUtil.reason(exception);
                        if (!this.trace) break block9;
                        Spreadsheet.trace("EVAL_ERROR in \"" + activeField.pi.getText() + "\": " + activeField.evalStatusLine);
                    }
                }
                if (activeField.status != activeField.prevStatus || activeField.value != null && !activeField.value.equals(activeField.prevValue) || activeField.evalStatusLine != null && !activeField.evalStatusLine.equals(activeField.prevEvalStatusLine)) {
                    if (activeField.value != null && !activeField.value.equals(activeField.prevValue)) {
                        if (!blArray[1]) {
                            this.document.beginBatchEditing();
                            blArray[1] = true;
                        }
                        Spreadsheet.applyFieldValue(activeField);
                    }
                    activeField.prevStatus = activeField.status;
                    activeField.prevValue = activeField.value;
                    activeField.prevEvalStatusLine = activeField.evalStatusLine;
                    activeField.updatedAtIteration = n;
                    ++n2;
                }
            }
            ++n4;
        }
        blArray[0] = n2 == 0;
    }

    private static String getFieldValue(ActiveField activeField) {
        if (activeField.attributeName != null) {
            return activeField.parentElement.getAttribute(activeField.attributeName);
        }
        Node node = activeField.pi.getNextSibling();
        if (node != null && node instanceof Text) {
            return ((Text)node).getText();
        }
        return null;
    }

    private static void applyFieldValue(ActiveField activeField) {
        if (activeField.attributeName != null) {
            activeField.parentElement.putAttribute(activeField.attributeName, activeField.value);
        } else {
            Node node = activeField.pi.getNextSibling();
            if (node != null && node instanceof Text) {
                ((Text)node).setText(activeField.value);
            } else {
                activeField.parentElement.insertChild(node, new Text(activeField.value));
            }
        }
    }

    private static final void trace(String string) {
        System.err.println(string);
    }

    static /* synthetic */ ActiveField[] access$302(Spreadsheet spreadsheet, ActiveField[] activeFieldArray) {
        spreadsheet.activeFields = activeFieldArray;
        return activeFieldArray;
    }

    private static final class UndoState
    implements Cloneable {
        public UndoFieldState[] fieldStatesBefore;
        public boolean needRecalcBefore;
        public UndoFieldState[] fieldStatesAfter;
        public boolean needRecalcAfter;

        public UndoState(int n) {
            this.fieldStatesBefore = new UndoFieldState[n];
            this.fieldStatesAfter = new UndoFieldState[n];
            int n2 = 0;
            while (n2 < n) {
                this.fieldStatesBefore[n2] = new UndoFieldState();
                this.fieldStatesAfter[n2] = new UndoFieldState();
                ++n2;
            }
        }

        public UndoState copy() {
            UndoState undoState;
            try {
                undoState = (UndoState)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
                return null;
            }
            int n = 0;
            while (n < this.fieldStatesBefore.length) {
                undoState.fieldStatesBefore[n] = this.fieldStatesBefore[n].copy();
                undoState.fieldStatesAfter[n] = this.fieldStatesAfter[n].copy();
                ++n;
            }
            return undoState;
        }
    }

    private static final class UndoFieldState
    implements Cloneable {
        public ActiveField field;
        public byte flags;
        public byte status;
        public String evalStatusLine;

        private UndoFieldState() {
        }

        public void set(ActiveField activeField) {
            this.field = activeField;
            this.flags = activeField.flags;
            this.status = activeField.status;
            this.evalStatusLine = activeField.evalStatusLine;
        }

        public UndoFieldState copy() {
            try {
                return (UndoFieldState)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
                return null;
            }
        }
    }

    private final class RemoveFields
    extends FieldProcessor {
        private RemoveFields() {
        }

        public Object enterElement(Element element) {
            if (element.isReadOnly()) {
                return Traversal.LEAVE_ELEMENT;
            }
            return null;
        }

        public Object processPI(ProcessingInstruction processingInstruction) {
            Field field;
            if ("xxe-formula".equals(processingInstruction.getTarget()) && (field = (Field)Spreadsheet.this.piToActiveField.remove(processingInstruction)) == null) {
                Spreadsheet.this.piToInactiveField.remove(processingInstruction);
            }
            return null;
        }
    }

    private final class AddFields
    extends FieldProcessor {
        private AddFields() {
        }

        public Object enterElement(Element element) {
            if (element.isReadOnly()) {
                return Traversal.LEAVE_ELEMENT;
            }
            return null;
        }

        public Object processPI(ProcessingInstruction processingInstruction) {
            if ("xxe-formula".equals(processingInstruction.getTarget())) {
                Element element = (Element)processingInstruction.getParent();
                ParsedPIData parsedPIData = null;
                try {
                    parsedPIData = ParsedPIData.fromString(processingInstruction.getText(), element);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    String string = XMLUtil.collapseWhiteSpace(illegalArgumentException.getMessage());
                    Field field = new Field(processingInstruction, 1, Msg.msg("ignoringInvalidPI", string));
                    processingInstruction.setReadOnly(true);
                    Spreadsheet.this.piToInactiveField.put(processingInstruction, field);
                    Spreadsheet.this.refreshFieldViews(field);
                    if (Spreadsheet.this.trace) {
                        Spreadsheet.trace("PARSE_ERROR in \"" + field.pi.getText() + "\": " + field.parseStatusLine.toString());
                    }
                    return null;
                }
                FormulaFunctions formulaFunctions = (FormulaFunctions)Spreadsheet.this.document.getProperty("com.xmlmind.xmleditapp.spreadsheet.FORMULA_FUNCTIONS");
                TranslatedFormula translatedFormula = null;
                try {
                    translatedFormula = TranslatedFormula.translate(parsedPIData.formula, (PrefixToNamespace)element, formulaFunctions);
                }
                catch (Exception exception) {
                    Field field = new Field(processingInstruction, 1, Msg.msg("ignoringInvalidFormula", MiscUtil.reason(exception)));
                    processingInstruction.setReadOnly(true);
                    Spreadsheet.this.piToInactiveField.put(processingInstruction, field);
                    Spreadsheet.this.refreshFieldViews(field);
                    if (Spreadsheet.this.trace) {
                        Spreadsheet.trace("PARSE_ERROR in \"" + field.pi.getText() + "\": " + field.parseStatusLine.toString());
                    }
                    return null;
                }
                ExpressionNode[] expressionNodeArray = parsedPIData.formula.statements;
                ExpressionNode expressionNode = expressionNodeArray[expressionNodeArray.length - 1];
                if (parsedPIData.disabled) {
                    Field field = new Field(processingInstruction, 2, expressionNode);
                    processingInstruction.setReadOnly(true);
                    Spreadsheet.this.piToInactiveField.put(processingInstruction, field);
                    Spreadsheet.this.refreshFieldViews(field);
                    if (Spreadsheet.this.trace) {
                        Spreadsheet.trace("DISABLED \"" + field.pi.getText() + "\": " + field.parseStatusLine.toString());
                    }
                    return null;
                }
                ActiveField activeField = new ActiveField(processingInstruction, element, 3, expressionNode, translatedFormula, parsedPIData.attributeName, parsedPIData.formatPrefix, parsedPIData.format, parsedPIData.formatSuffix);
                processingInstruction.setReadOnly(true);
                Spreadsheet.this.piToActiveField.put(processingInstruction, activeField);
                Spreadsheet.this.refreshFieldViews(activeField);
            }
            return null;
        }
    }

    private class FieldProcessor
    extends Traversal.HandlerBase
    implements Comparator {
        private FieldProcessor() {
        }

        public void traverse(Node node) {
            int n = Spreadsheet.this.piToActiveField.size();
            Traversal.traverse(node, this);
            int n2 = Spreadsheet.this.piToActiveField.size();
            if (n2 != n) {
                Spreadsheet.access$302(Spreadsheet.this, new ActiveField[n2]);
                Spreadsheet.this.piToActiveField.values().toArray(Spreadsheet.this.activeFields);
                Arrays.sort(Spreadsheet.this.activeFields, this);
                Spreadsheet.this.undoState = new UndoState(n2);
            }
        }

        public int compare(Object object, Object object2) {
            return ((ActiveField)object).pi.compareTo(((ActiveField)object2).pi);
        }
    }

    private static final class ActiveField
    extends Field
    implements Comparable {
        public Element parentElement;
        public TranslatedFormula formula;
        public Name attributeName;
        public String formatPrefix;
        public Format format;
        public String formatSuffix;
        public byte flags;
        public byte prevStatus;
        public String prevValue;
        public String prevEvalStatusLine;
        public String value;
        public int updatedAtIteration;

        public ActiveField(ProcessingInstruction processingInstruction, Element element, int n, Object object, TranslatedFormula translatedFormula, Name name, String string, Format format, String string2) {
            super(processingInstruction, n, object);
            this.parentElement = element;
            this.formula = translatedFormula;
            this.attributeName = name;
            this.formatPrefix = string;
            this.format = format;
            this.formatSuffix = string2;
            this.flags = (byte)2;
            if (translatedFormula.isStatic()) {
                this.flags = (byte)(this.flags | 1);
            }
        }

        public int compareTo(Object object) {
            return this.updatedAtIteration - ((ActiveField)object).updatedAtIteration;
        }
    }

    public static class Field {
        protected ProcessingInstruction pi;
        protected byte status;
        protected Object parseStatusLine;
        protected String evalStatusLine;

        public Field(ProcessingInstruction processingInstruction, int n, Object object) {
            this.pi = processingInstruction;
            this.status = (byte)n;
            this.parseStatusLine = object;
        }

        public int getStatus() {
            return this.status;
        }

        public String getStatusLine() {
            if (this.evalStatusLine != null) {
                return this.evalStatusLine;
            }
            if (this.parseStatusLine instanceof ExpressionNode) {
                Object object;
                CellRef cellRef = null;
                Element element = this.pi.getParentElement();
                if (element != null && element.getDocument() != null && (object = TableBodyVP.findRowColumn(element)) != null) {
                    cellRef = new CellRef(((TableBodyVP.RowColumn)object).row, 1, ((TableBodyVP.RowColumn)object).column, 1);
                }
                object = (ExpressionNode)this.parseStatusLine;
                return "=" + ((ExpressionNode)object).toString(true, cellRef);
            }
            return (String)this.parseStatusLine;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Field)) {
                return false;
            }
            return this.pi == ((Field)object).pi;
        }
    }
}

