/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.spreadsheet;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.edit.SaveOptions;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmleditapp.spreadsheet.Constants;
import com.xmlmind.xmleditapp.spreadsheet.Msg;
import com.xmlmind.xmleditapp.spreadsheet.Spreadsheet;
import java.awt.Component;

public final class SpreadsheetHelper
implements Constants {
    private static boolean autoRecalc = true;
    private static int maxIterations = 20;
    private static boolean cacheDocuments = true;
    private static final String[] IGNORED_PI_TARGETS = new String[]{"xxe-formula"};

    public static void setAutoRecalc(boolean bl) {
        autoRecalc = bl;
    }

    public static boolean isAutoRecalc() {
        return autoRecalc;
    }

    public static void setCachingDocuments(boolean bl) {
        cacheDocuments = bl;
    }

    public static boolean isCachingDocuments() {
        return cacheDocuments;
    }

    public static void setMaxIterations(int n) {
        maxIterations = n;
    }

    public static int getMaxIterations() {
        return maxIterations;
    }

    public static void setSpreadsheet(Document document, Component component) {
        if (document.getRootElement().getNamespace() == Namespace.CONFIGURATION) {
            return;
        }
        Spreadsheet spreadsheet = new Spreadsheet(new Console(){

            public void showMessage(String string, int n) {
                String string2;
                string = XMLUtil.collapseWhiteSpace(string);
                switch (n) {
                    case 0: {
                        string2 = "spreadsheetInfo";
                        break;
                    }
                    case 1: {
                        string2 = "spreadsheetWarning";
                        break;
                    }
                    default: {
                        string2 = "spreadsheetError";
                    }
                }
                ShowStatus.showStatus(Msg.msg(string2, string));
            }
        });
        spreadsheet.setCachingDocuments(cacheDocuments);
        spreadsheet.setMaxIterations(maxIterations);
        spreadsheet.setAutoRecalc(autoRecalc);
        spreadsheet.setDocument(document);
        document.putProperty("com.xmlmind.xmleditapp.spreadsheet.SPREADSHEET", spreadsheet);
        if ("Professional".equals("Standard")) {
            Alert.showInfo(component, Msg.msg("formulasWillNotBeSaved", URLUtil.toLabel(document.getLocation())));
        }
    }

    public static void configureSaveOptions(SaveOptions saveOptions, Document document) {
        if (document.getRootElement().getNamespace() == Namespace.CONFIGURATION) {
            return;
        }
        if ("Professional".equals("Standard")) {
            saveOptions.ignoredProcessingInstructions = IGNORED_PI_TARGETS;
        }
    }
}

