/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.spreadsheet;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.util.LinearHashtable;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xpath.DelegateExprContext;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.ExprContext;
import com.xmlmind.xmledit.xpath.ExprParser;
import com.xmlmind.xmledit.xpath.NodeSetVariant;
import com.xmlmind.xmledit.xpath.ParseException;
import com.xmlmind.xmledit.xpath.SimpleFunction;
import com.xmlmind.xmledit.xpath.SimpleFunctionTable;
import com.xmlmind.xmledit.xpath.Variant;
import com.xmlmind.xmledit.xpath.VariantExpr;
import com.xmlmind.xmleditapp.spreadsheet.AssignNode;
import com.xmlmind.xmleditapp.spreadsheet.CellsReference;
import com.xmlmind.xmleditapp.spreadsheet.CellsReferenceNode;
import com.xmlmind.xmleditapp.spreadsheet.Constants;
import com.xmlmind.xmleditapp.spreadsheet.EvalContext;
import com.xmlmind.xmleditapp.spreadsheet.ExpressionNode;
import com.xmlmind.xmleditapp.spreadsheet.FormulaFunctions;
import com.xmlmind.xmleditapp.spreadsheet.FormulaNode;
import com.xmlmind.xmleditapp.spreadsheet.Msg;
import com.xmlmind.xmleditapp.spreadsheet.ParsedPIData;
import java.util.HashMap;

public final class TranslatedFormula
implements Constants {
    private Object[] equations;
    private LinearHashtable variablesTemplate;
    private LinearHashtable variables;
    private boolean isStatic;
    private static PrefixMap prefixMap = new PrefixMap();
    private static FunctionTable functionTable = new FunctionTable();
    private static HashMap cellToVar;
    private static boolean[] dynamic;

    public static TranslatedFormula translate(String string, PrefixToNamespace prefixToNamespace, FormulaFunctions formulaFunctions) throws Exception {
        return TranslatedFormula.translate(ParsedPIData.parseFormula(string), prefixToNamespace, formulaFunctions);
    }

    public static TranslatedFormula translate(FormulaNode formulaNode, PrefixToNamespace prefixToNamespace, FormulaFunctions formulaFunctions) throws Exception {
        return TranslatedFormula.translate(formulaNode, prefixToNamespace, formulaFunctions, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TranslatedFormula translate(FormulaNode formulaNode, PrefixToNamespace prefixToNamespace, FormulaFunctions formulaFunctions, boolean bl) throws Exception {
        Object[] objectArray = null;
        int n = 0;
        LinearHashtable linearHashtable = null;
        TranslatedFormula.prefixMap.prefixToNS = prefixToNamespace;
        TranslatedFormula.functionTable.moreFunctions = formulaFunctions;
        TranslatedFormula.dynamic[0] = false;
        ExpressionNode[] expressionNodeArray = formulaNode.statements;
        try {
            Object[] objectArray2;
            Object object;
            int n2 = 0;
            while (n2 < expressionNodeArray.length) {
                ExpressionNode expressionNode = expressionNodeArray[n2];
                switch (expressionNode.nodeType) {
                    case 0: {
                        break;
                    }
                    case 4: {
                        n += 2;
                        break;
                    }
                    default: {
                        if (n2 != expressionNodeArray.length - 1) {
                            throw new IllegalArgumentException(Msg.msg("notAFormula", new Integer(expressionNode.nodeType)));
                        }
                        n += 2;
                    }
                }
                ++n2;
            }
            objectArray = new Object[n];
            n = 0;
            int n3 = 0;
            while (n3 < expressionNodeArray.length) {
                object = expressionNodeArray[n3];
                if (((ExpressionNode)object).nodeType != 0) {
                    if (((ExpressionNode)object).nodeType == 4) {
                        objectArray2 = (AssignNode)object;
                        objectArray[n++] = objectArray2.variable;
                        object = objectArray2.value;
                    } else {
                        objectArray[n++] = null;
                    }
                    objectArray2 = ((ExpressionNode)object).translate(cellToVar, dynamic);
                    try {
                        objectArray[n++] = ExprParser.parseVariantExpr((String)objectArray2, prefixMap, true);
                    }
                    catch (ParseException parseException) {
                        throw new ParseException(Msg.msg("xpathCompilationError", objectArray2, parseException.getMessage()));
                    }
                }
                ++n3;
            }
            if (n > 2 || cellToVar.size() > 0) {
                linearHashtable = new LinearHashtable();
                if (cellToVar.size() > 0) {
                    if (bl) {
                        throw new IllegalArgumentException(Msg.msg("cellsReferenceNotAllowed"));
                    }
                    object = cellToVar.values().iterator();
                    while (object.hasNext()) {
                        objectArray2 = (Object[])object.next();
                        linearHashtable.put(objectArray2[0], new CellsReference((CellsReferenceNode)objectArray2[1]));
                    }
                }
            }
        }
        finally {
            TranslatedFormula.prefixMap.prefixToNS = null;
            TranslatedFormula.functionTable.moreFunctions = null;
            cellToVar.clear();
        }
        return new TranslatedFormula(objectArray, linearHashtable, !dynamic[0]);
    }

    private TranslatedFormula(Object[] objectArray, LinearHashtable linearHashtable, boolean bl) {
        this.equations = objectArray;
        if (linearHashtable != null) {
            this.variablesTemplate = linearHashtable;
            this.variables = (LinearHashtable)linearHashtable.clone();
        }
        this.isStatic = bl;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variant eval(Element element, EvalContext evalContext) throws EvalException {
        try {
            Variant variant = this.doEval(element, evalContext);
            Object var5_4 = null;
            this.clearVariables();
            return variant;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.clearVariables();
            throw throwable;
        }
    }

    public void clearVariables() {
        if (this.variablesTemplate != null) {
            this.variables = (LinearHashtable)this.variablesTemplate.clone();
            Object[] objectArray = this.variables.getKeyValueTable();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] != null) {
                    ((CellsReference)objectArray[n + 1]).value = null;
                }
                n += 2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variant doEval(Element element, EvalContext evalContext) throws EvalException {
        evalContext.localVariables = this.variables;
        evalContext.referenceElement = element;
        evalContext.referenceCell = null;
        try {
            int n = 0;
            while (n < this.equations.length) {
                String string = (String)this.equations[n];
                VariantExpr variantExpr = (VariantExpr)this.equations[n + 1];
                Variant variant = variantExpr.eval(element, evalContext);
                if (variant instanceof NodeSetVariant) {
                    variant = ((NodeSetVariant)variant).makePermanent();
                }
                if (string == null) {
                    Variant variant2 = variant;
                    return variant2;
                }
                this.variables.put(string, variant);
                n += 2;
            }
        }
        finally {
            evalContext.localVariables = null;
            evalContext.referenceElement = null;
            evalContext.referenceCell = null;
        }
        throw new EvalException(Msg.msg("notAFormula2"));
    }

    public Variant eval(String[] stringArray, Variant[] variantArray, XNode xNode, ExprContext exprContext) throws EvalException {
        if (variantArray.length != stringArray.length) {
            throw new EvalException(Msg.msg("badNumberOfArgs", new Integer(stringArray.length), new Integer(variantArray.length)));
        }
        LinearHashtable linearHashtable = null;
        if (stringArray.length > 0 || this.variablesTemplate != null) {
            linearHashtable = this.variablesTemplate == null ? new LinearHashtable() : (LinearHashtable)this.variablesTemplate.clone();
        }
        Context context = new Context(linearHashtable, exprContext);
        int n = 0;
        while (n < stringArray.length) {
            Variant variant = variantArray[n];
            if (variant instanceof NodeSetVariant) {
                variant = ((NodeSetVariant)variant).makePermanent();
            }
            linearHashtable.put(stringArray[n], variant);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.equations.length) {
            String string = (String)this.equations[n2];
            VariantExpr variantExpr = (VariantExpr)this.equations[n2 + 1];
            Variant variant = variantExpr.eval(xNode, context);
            if (variant instanceof NodeSetVariant) {
                variant = ((NodeSetVariant)variant).makePermanent();
            }
            if (string == null) {
                return variant;
            }
            linearHashtable.put(string, variant);
            n2 += 2;
        }
        throw new EvalException(Msg.msg("notAFormula2"));
    }

    static {
        ExprParser.setSimpleFunctionTable(Constants.FUNC_NAMESPACE, functionTable);
        cellToVar = new HashMap();
        dynamic = new boolean[1];
    }

    private static final class Context
    extends DelegateExprContext {
        LinearHashtable variables;

        public Context(LinearHashtable linearHashtable, ExprContext exprContext) {
            super(exprContext);
            this.variables = linearHashtable;
        }

        public Variant getVariableValue(Name name, XNode xNode) throws EvalException {
            if (name.getNamespace() == Namespace.NONE && this.variables != null) {
                return (Variant)this.variables.get(name.getLocalPart());
            }
            throw new EvalException(Msg.msg("unexpectedVariable", name.toString()));
        }
    }

    private static final class FunctionTable
    implements SimpleFunctionTable {
        public FormulaFunctions moreFunctions;

        private FunctionTable() {
        }

        public SimpleFunction getSimpleFunction(String string) {
            SimpleFunction simpleFunction = FormulaFunctions.getRegistry().getSimpleFunction(string);
            if (simpleFunction == null && this.moreFunctions != null) {
                simpleFunction = this.moreFunctions.getSimpleFunction(string);
            }
            return simpleFunction;
        }
    }

    private static final class PrefixMap
    implements PrefixToNamespace,
    Constants {
        public PrefixToNamespace prefixToNS;

        private PrefixMap() {
        }

        public Namespace prefixToNamespace(String string) {
            if ("xxefunc".equals(string)) {
                return Constants.FUNC_NAMESPACE;
            }
            if ("xxecell".equals(string)) {
                return Constants.CELL_NAMESPACE;
            }
            return this.prefixToNS.prefixToNamespace(string);
        }
    }
}

