/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.start;

import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.JarUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.PlatformUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLPathUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmleditapp.start.Msg;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class Start {
    private ArrayList jarList = new ArrayList();
    private ArrayList formatPluginClassNameList = new ArrayList();
    private ArrayList foProcessorPluginClassNameList = new ArrayList();
    private ArrayList imageToolkitPluginClassNameList = new ArrayList();
    private ArrayList configurationList = new ArrayList();
    private ArrayList xmlCatalogList = new ArrayList();
    private ArrayList dictionaryList = new ArrayList();
    private URL guiSpecURL = null;
    private ArrayList errorList = new ArrayList();
    private static final String addonBaseName = "addon";
    private static final String guiProperty = "XXE_GUI";
    private static final String addonProperty = "XXE_ADDON_PATH";
    private static final String formatPluginSuffix = "_format.jar";
    private static final String foProcessorPluginSuffix = "_foprocessor.jar";
    private static final String imageToolkitPluginSuffix = "_imagetoolkit.jar";
    private static final String configurationSuffix = ".xxe";
    private static final String xmlCatalogSuffix = "atalog.xml";
    private static final String dictionarySuffix = ".dar";
    private static final String guiSpecBaseName = "custom.xxe_gui";
    private static final String formatPluginService = "com.xmlmind.xmleditapp.structformat.StructuredFormat";
    private static final String foProcessorPluginService = "com.xmlmind.xmleditapp.process.FOProcessor";
    private static final String imageToolkitPluginService = "com.xmlmind.xmledit.imagetoolkit.ImageToolkit";
    private static final CompareURLByBaseName compareURLByBaseName = new CompareURLByBaseName();
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$start$Start;
    static /* synthetic */ Class class$java$util$HashMap;

    public static final File userDir() {
        String string = PlatformUtil.homeDir();
        if (string == null) {
            return null;
        }
        String string2 = PlatformUtil.IS_WINDOWS ? string + "\\Application Data\\XMLmind\\XMLEditor" : string + "/.xxe";
        File file = new File(string2);
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            file = null;
        }
        return file;
    }

    public static final File appDir() {
        String string = System.getProperty("java.class.path");
        if (string == null) {
            return null;
        }
        File file = null;
        String[] stringArray = StringUtil.split(string, File.pathSeparatorChar);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n].trim();
            if (string2.length() != 0) {
                File file2;
                if (string2.endsWith("xxe_app.jar")) {
                    file2 = new File(string2);
                    if (file2.isFile()) {
                        try {
                            file2 = file2.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            break;
                        }
                        file = file2.getParentFile();
                        if (file == null || (file = file.getParentFile()) != null) break;
                        break;
                    }
                } else if (string2.endsWith("class") && (file2 = new File(string2)).isDirectory()) {
                    try {
                        file2 = file2.getCanonicalFile();
                    }
                    catch (IOException iOException) {
                        break;
                    }
                    file = file2.getParentFile();
                    if (file != null) break;
                    break;
                }
            }
            ++n;
        }
        return file;
    }

    public void scanAddonDir(File file) {
        ArrayList arrayList = new ArrayList();
        this.doScanAddonDir(file, arrayList);
        if (arrayList.size() > 1) {
            Collections.sort(arrayList, compareURLByBaseName);
        }
        this.configurationList.addAll(arrayList);
    }

    private void doScanAddonDir(File file, ArrayList arrayList) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            this.errorList.add(Msg.msg("cannotListDir", file));
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            if (file2.isDirectory()) {
                this.doScanAddonDir(file2, arrayList);
            } else {
                String string = file2.getName();
                if (string.endsWith(".jar")) {
                    String string2;
                    URL uRL = FileUtil.fileToURL(file2);
                    this.jarList.add(uRL);
                    if (string.endsWith(formatPluginSuffix)) {
                        string2 = this.serviceImpl(uRL, formatPluginService);
                        if (string2 != null && !this.formatPluginClassNameList.contains(string2)) {
                            this.formatPluginClassNameList.add(string2);
                        }
                    } else if (string.endsWith(foProcessorPluginSuffix)) {
                        string2 = this.serviceImpl(uRL, foProcessorPluginService);
                        if (string2 != null && !this.foProcessorPluginClassNameList.contains(string2)) {
                            this.foProcessorPluginClassNameList.add(string2);
                        }
                    } else if (string.endsWith(imageToolkitPluginSuffix) && (string2 = this.serviceImpl(uRL, imageToolkitPluginService)) != null && !this.imageToolkitPluginClassNameList.contains(string2)) {
                        this.imageToolkitPluginClassNameList.add(string2);
                    }
                } else if (string.endsWith(configurationSuffix)) {
                    arrayList.add(FileUtil.fileToURL(file2));
                } else if (string.endsWith(xmlCatalogSuffix)) {
                    this.xmlCatalogList.add(FileUtil.fileToURL(file2));
                } else if (string.endsWith(dictionarySuffix)) {
                    this.dictionaryList.add(FileUtil.fileToURL(file2));
                } else if (guiSpecBaseName.equals(string) && this.guiSpecURL == null) {
                    this.guiSpecURL = FileUtil.fileToURL(file2);
                }
            }
            ++n;
        }
    }

    private String serviceImpl(URL uRL, String string) {
        String[] stringArray = null;
        try {
            stringArray = JarUtil.getServices(uRL);
        }
        catch (IOException iOException) {
            this.errorList.add(Msg.msg("cannotLoadPluginJar", uRL, MiscUtil.reason(iOException)));
            return null;
        }
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                String string3 = stringArray[n + 1];
                if (string.equals(string2)) {
                    return string3;
                }
                n += 2;
            }
        }
        this.errorList.add(Msg.msg("notAPluginJar", uRL, string));
        return null;
    }

    public String[] getFormatPluginClassNames() {
        String[] stringArray = new String[this.formatPluginClassNameList.size()];
        this.formatPluginClassNameList.toArray(stringArray);
        return stringArray;
    }

    public String[] getFOProcessorPluginClassNames() {
        String[] stringArray = new String[this.foProcessorPluginClassNameList.size()];
        this.foProcessorPluginClassNameList.toArray(stringArray);
        return stringArray;
    }

    public String[] getImageToolkitPluginClassNames() {
        String[] stringArray = new String[this.imageToolkitPluginClassNameList.size()];
        this.imageToolkitPluginClassNameList.toArray(stringArray);
        return stringArray;
    }

    public URL[] getConfigurations() {
        URL[] uRLArray = new URL[this.configurationList.size()];
        this.configurationList.toArray(uRLArray);
        return uRLArray;
    }

    public URL[] getXMLCatalogs() {
        URL[] uRLArray = new URL[this.xmlCatalogList.size()];
        this.xmlCatalogList.toArray(uRLArray);
        return uRLArray;
    }

    public URL[] getDictionaries() {
        URL[] uRLArray = new URL[this.dictionaryList.size()];
        this.dictionaryList.toArray(uRLArray);
        return uRLArray;
    }

    public URL getGUISpecURL() {
        return this.guiSpecURL;
    }

    public String getGUISpecLocation() {
        String string = System.getProperty(guiProperty);
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        if (string != null) {
            return string;
        }
        if (this.guiSpecURL != null) {
            return this.guiSpecURL.toExternalForm();
        }
        return null;
    }

    public String[] getErrors() {
        String[] stringArray = new String[this.errorList.size()];
        this.errorList.toArray(stringArray);
        return stringArray;
    }

    public URL[] getJars() {
        URL[] uRLArray = new URL[this.jarList.size()];
        this.jarList.toArray(uRLArray);
        return uRLArray;
    }

    public URL[] getClassPath() {
        Start.prependClasspath(this.jarList);
        URL[] uRLArray = this.getJars();
        return uRLArray;
    }

    private static final void prependClasspath(ArrayList arrayList) {
        String string = System.getProperty("java.class.path");
        if (string != null) {
            String[] stringArray = StringUtil.split(string, File.pathSeparatorChar);
            int n = stringArray.length - 1;
            while (n >= 0) {
                String string2 = stringArray[n].trim();
                if (string2.length() != 0) {
                    File file;
                    URL uRL = null;
                    try {
                        uRL = new URL(string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (uRL == null && (file = new File(string2)).exists()) {
                        uRL = FileUtil.fileToURL(file);
                    }
                    if (uRL != null) {
                        arrayList.add(0, uRL);
                    }
                }
                --n;
            }
        }
    }

    public void start(String string, String[] stringArray) {
        Object object;
        File file = Start.appDir();
        if (file == null) {
            System.err.println(Msg.msg("appDirNotFound"));
            System.exit(2);
        }
        File file2 = Start.userDir();
        Object[] objectArray = this.addonDirs(file, file2);
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof Listing) {
                object = (Listing)objectArray[n];
                this.scanAddonListing(((Listing)object).paths, ((Listing)object).baseURL);
            } else {
                this.scanAddonDir((File)objectArray[n]);
            }
            ++n;
        }
        object = this.createClassLoader();
        try {
            Object object2 = this.createApp((ClassLoader)object, string, file, file2, stringArray);
            this.initializeApp(object2);
        }
        catch (Exception exception) {
            Throwable throwable = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getTargetException() : exception;
            System.err.println(Msg.msg("cannotCreateApp", MiscUtil.detailedReason(throwable)));
            System.exit(3);
        }
    }

    private Object[] addonDirs(File file, File file2) {
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (file2 != null && file2.isDirectory() && ((File)(object2 = new File(file2, addonBaseName))).isDirectory()) {
            arrayList.add(object2);
        }
        if ((object2 = System.getProperty(addonProperty)) != null && ((String)(object2 = ((String)object2).trim())).length() == 0) {
            object2 = null;
        }
        boolean bl = true;
        if (object2 != null) {
            if (((String)object2).endsWith(";+")) {
                object2 = ((String)object2).substring(0, ((String)object2).length() - 2);
            } else {
                bl = false;
            }
            object = StringUtil.split((String)object2, ';');
            int n = 0;
            while (n < ((Object)object).length) {
                block23: {
                    String string = ((String)object[n]).trim();
                    if (string.length() != 0) {
                        Serializable serializable;
                        if (string.startsWith("@")) {
                            String string2;
                            string = string.substring(1);
                            serializable = null;
                            try {
                                serializable = new URL(string);
                            }
                            catch (MalformedURLException malformedURLException) {
                                this.errorList.add(Msg.msg("badSystemProperty1", addonProperty, string));
                                break block23;
                            }
                            try {
                                string2 = FileUtil.loadString((URL)serializable);
                            }
                            catch (IOException iOException) {
                                this.errorList.add(Msg.msg("badSystemProperty2", addonProperty, string, iOException.getMessage()));
                                break block23;
                            }
                            String[] stringArray = StringUtil.split(string2);
                            if (stringArray.length == 0) {
                                this.errorList.add(Msg.msg("badSystemProperty3", addonProperty, string));
                            } else {
                                arrayList.add(new Listing(stringArray, (URL)serializable));
                            }
                        } else {
                            serializable = null;
                            try {
                                serializable = FileUtil.urlToFile(new URL(string));
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                            if (serializable == null) {
                                serializable = new File(string);
                            }
                            try {
                                serializable = ((File)serializable).getCanonicalFile();
                            }
                            catch (IOException iOException) {
                                serializable = null;
                            }
                            if (serializable == null || !((File)serializable).isDirectory()) {
                                this.errorList.add(Msg.msg("badSystemProperty4", addonProperty, string));
                            } else {
                                arrayList.add(serializable);
                            }
                        }
                    }
                }
                ++n;
            }
        }
        if (bl && ((File)(object = new File(file, addonBaseName))).isDirectory()) {
            arrayList.add(object);
        }
        object = new Object[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    private void scanAddonListing(String[] stringArray, URL uRL) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        int n = 0;
        while (n < stringArray.length) {
            URL uRL2;
            String string = stringArray[n];
            String string2 = URIUtil.unescape(URLPathUtil.baseName(string));
            if (string2.endsWith(".jar")) {
                String string3;
                uRL2 = this.createURL(uRL, string);
                if (uRL2 == null) {
                    return;
                }
                this.jarList.add(uRL2);
                if (string2.endsWith(formatPluginSuffix)) {
                    string3 = this.serviceImpl(uRL2, formatPluginService);
                    if (string3 != null && !this.formatPluginClassNameList.contains(string3)) {
                        this.formatPluginClassNameList.add(string3);
                    }
                } else if (string2.endsWith(foProcessorPluginSuffix)) {
                    string3 = this.serviceImpl(uRL2, foProcessorPluginService);
                    if (string3 != null && !this.foProcessorPluginClassNameList.contains(string3)) {
                        this.foProcessorPluginClassNameList.add(string3);
                    }
                } else if (string2.endsWith(imageToolkitPluginSuffix) && (string3 = this.serviceImpl(uRL2, imageToolkitPluginService)) != null && !this.imageToolkitPluginClassNameList.contains(string3)) {
                    this.imageToolkitPluginClassNameList.add(string3);
                }
            } else if (string2.endsWith(configurationSuffix)) {
                uRL2 = this.createURL(uRL, string);
                if (uRL2 == null) {
                    return;
                }
                arrayList.add(uRL2);
            } else if (string2.endsWith(xmlCatalogSuffix)) {
                uRL2 = this.createURL(uRL, string);
                if (uRL2 == null) {
                    return;
                }
                this.xmlCatalogList.add(uRL2);
            } else if (string2.endsWith(dictionarySuffix)) {
                uRL2 = this.createURL(uRL, string);
                if (uRL2 == null) {
                    return;
                }
                this.dictionaryList.add(uRL2);
            } else if (guiSpecBaseName.equals(string2)) {
                uRL2 = this.createURL(uRL, string);
                if (uRL2 == null) {
                    return;
                }
                if (this.guiSpecURL == null) {
                    this.guiSpecURL = uRL2;
                }
            }
            ++n;
        }
        if (arrayList.size() > 1) {
            Collections.sort(arrayList, compareURLByBaseName);
        }
        this.configurationList.addAll(arrayList);
    }

    private URL createURL(URL uRL, String string) {
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL2 == null) {
            this.errorList.add(Msg.msg("badSystemProperty5", addonProperty, string, uRL));
        }
        return uRL2;
    }

    private ClassLoader createClassLoader() {
        ClassLoader classLoader;
        if (this.jarList.size() > 0) {
            URL[] uRLArray = this.getClassPath();
            classLoader = new URLClassLoader(uRLArray, null);
        } else {
            classLoader = (class$com$xmlmind$xmleditapp$start$Start == null ? (class$com$xmlmind$xmleditapp$start$Start = Start.class$("com.xmlmind.xmleditapp.start.Start")) : class$com$xmlmind$xmleditapp$start$Start).getClassLoader();
        }
        return classLoader;
    }

    private Object createApp(ClassLoader classLoader, String string, File file, File file2, String[] stringArray) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("formatPluginClassNames", this.getFormatPluginClassNames());
        hashMap.put("foProcessorPluginClassNames", this.getFOProcessorPluginClassNames());
        hashMap.put("imageToolkitPluginClassNames", this.getImageToolkitPluginClassNames());
        hashMap.put("configurationURLs", this.getConfigurations());
        hashMap.put("xmlCatalogURLs", this.getXMLCatalogs());
        hashMap.put("dictionaryURLs", this.getDictionaries());
        hashMap.put("guiSpecLocation", this.getGUISpecLocation());
        hashMap.put("startErrors", this.getErrors());
        hashMap.put("installDirectory", file);
        hashMap.put("userPreferencesDirectory", file2);
        hashMap.put("commandLineArguments", stringArray);
        Class<?> clazz = classLoader.loadClass(string);
        Constructor<?> constructor = clazz.getConstructor(class$java$util$HashMap == null ? (class$java$util$HashMap = Start.class$("java.util.HashMap")) : class$java$util$HashMap);
        return constructor.newInstance(hashMap);
    }

    private void initializeApp(Object object) throws Exception {
        Method method = object.getClass().getMethod("initialize", new Class[0]);
        method.invoke(object, new Object[0]);
    }

    public static void main(String[] stringArray) {
        new Start().start("com.xmlmind.xmleditapp.app.Application", stringArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class Listing {
        public String[] paths;
        public URL baseURL;

        public Listing(String[] stringArray, URL uRL) {
            this.paths = stringArray;
            this.baseURL = uRL;
        }
    }

    private static final class CompareURLByBaseName
    implements Comparator {
        private CompareURLByBaseName() {
        }

        public int compare(Object object, Object object2) {
            URL uRL = (URL)object;
            URL uRL2 = (URL)object2;
            return URLUtil.getRawBaseName(uRL).compareTo(URLUtil.getRawBaseName(uRL2));
        }
    }
}

