/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.structformat;

import com.xmlmind.xmledit.util.LinearHashtable;
import com.xmlmind.xmleditapp.structformat.StructuredFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;

public final class StructuredFormats {
    private static LinearHashtable nameToFormat = new LinearHashtable();
    private static LinearHashtable mimeTypeToFormat = null;
    private static LinearHashtable extensionToFormat = null;
    private static StructuredFormatCompare formatCompare = new StructuredFormatCompare();

    public static void register(StructuredFormat structuredFormat) {
        nameToFormat.put(structuredFormat.getName().toLowerCase(), structuredFormat);
        mimeTypeToFormat = null;
        extensionToFormat = null;
    }

    public static StructuredFormat get(String string) {
        return (StructuredFormat)nameToFormat.get(string.toLowerCase());
    }

    public static StructuredFormat[] getAll() {
        Object[] objectArray = new StructuredFormat[nameToFormat.size()];
        nameToFormat.copyElementsInto(objectArray);
        if (objectArray.length > 1) {
            Arrays.sort(objectArray, formatCompare);
        }
        return objectArray;
    }

    public static StructuredFormat getByMimeType(String string) {
        if (mimeTypeToFormat == null) {
            mimeTypeToFormat = new LinearHashtable();
            Enumeration enumeration = nameToFormat.elements();
            while (enumeration.hasMoreElements()) {
                StructuredFormat structuredFormat = (StructuredFormat)enumeration.nextElement();
                mimeTypeToFormat.put(structuredFormat.getMimeType().toLowerCase(), structuredFormat);
            }
        }
        return (StructuredFormat)mimeTypeToFormat.get(string.toLowerCase());
    }

    public static StructuredFormat getByExtension(String string) {
        if (extensionToFormat == null) {
            extensionToFormat = new LinearHashtable();
            Enumeration enumeration = nameToFormat.elements();
            while (enumeration.hasMoreElements()) {
                StructuredFormat structuredFormat = (StructuredFormat)enumeration.nextElement();
                String[] stringArray = structuredFormat.getFileNameExtensions();
                int n = 0;
                while (n < stringArray.length) {
                    extensionToFormat.put(stringArray[n].toLowerCase(), structuredFormat);
                    ++n;
                }
            }
        }
        return (StructuredFormat)extensionToFormat.get(string.toLowerCase());
    }

    private static class StructuredFormatCompare
    implements Comparator {
        private StructuredFormatCompare() {
        }

        public int compare(Object object, Object object2) {
            return ((StructuredFormat)object).getName().compareTo(((StructuredFormat)object2).getName());
        }
    }
}

