/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.upload;

import HTTPClient.AuthorizationInfo;
import HTTPClient.AuthorizationPrompter;
import HTTPClient.CookieModule;
import HTTPClient.DefaultAuthHandler;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpOutputStream;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ProtocolNotSuppException;
import com.jclark.xml.parse.OpenEntity;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentLoader;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLPathUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xsd.datatype.DateTimeValue;
import com.xmlmind.xmleditapp.upload.DAVException;
import com.xmlmind.xmleditapp.upload.DAVLock;
import com.xmlmind.xmleditapp.upload.DAVProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;

public class DAVClient
implements AuthorizationPrompter {
    public static final int DEPTH_INFINITY = -1;
    public static final int TIMEOUT_INFINITE = -1;
    public static final int PROP_CREATIONDATE = 1;
    public static final int PROP_DISPLAYNAME = 2;
    public static final int PROP_GETCONTENTLENGTH = 4;
    public static final int PROP_GETCONTENTLANGUAGE = 8;
    public static final int PROP_GETCONTENTTYPE = 16;
    public static final int PROP_GETETAG = 32;
    public static final int PROP_GETLASTMODIFIED = 64;
    public static final int PROP_SUPPORTEDLOCK = 128;
    public static final int PROP_LOCKDISCOVERY = 256;
    private static String defaultLockOwner;
    private HTTPConnection connection;
    private String lockOwner;
    private DocumentLoader loader;
    private static SimpleDateFormat dateFormat1123;
    private static SimpleDateFormat dateFormat850;
    private static SimpleDateFormat dateFormatAsctime;
    private static final int STATUS_OK = 200;
    private static final int STATUS_CREATED = 201;
    private static final int STATUS_NO_CONTENT = 204;
    private static final int STATUS_MULTI_STATUS = 207;
    private static final int STATUS_MOVED_PERMANENTLY = 301;
    private static final int STATUS_NOT_FOUND = 404;
    private static final Namespace DAV;
    private static final Name MULTISTATUS;
    private static final Name RESPONSE;
    private static final Name HREF;
    private static final Name PROPSTAT;
    private static final Name PROP;
    private static final Name STATUS;
    private static final Name CREATIONDATE;
    private static final Name DISPLAYNAME;
    private static final Name GETCONTENTLENGTH;
    private static final Name GETCONTENTTYPE;
    private static final Name GETCONTENTLANGUAGE;
    private static final Name GETETAG;
    private static final Name GETLASTMODIFIED;
    private static final Name RESOURCETYPE;
    private static final Name COLLECTION;
    private static final Name SUPPORTEDLOCK;
    private static final Name LOCKENTRY;
    private static final Name LOCKSCOPE;
    private static final Name LOCKTYPE;
    private static final Name SHARED;
    private static final Name EXCLUSIVE;
    private static final Name WRITE;
    private static final Name LOCKDISCOVERY;
    private static final Name ACTIVELOCK;
    private static final Name DEPTH;
    private static final Name OWNER;
    private static final Name TIMEOUT;
    private static final Name LOCKTOKEN;

    public DAVClient(String string, String string2, int n) throws ProtocolNotSuppException {
        CookieModule.setCookiePolicyHandler(null);
        this.connection = new HTTPConnection(string, string2, n);
        NVPair[] nVPairArray = new NVPair[]{new NVPair("Host", this.connection.getHost()), new NVPair("User-Agent", "XMLmind XML Editor V3.0p1")};
        this.connection.setDefaultHeaders(nVPairArray);
        this.lockOwner = DAVClient.getDefaultLockOwner();
        this.connection.setAllowUserInteraction(URLConnection.getDefaultAllowUserInteraction());
        DefaultAuthHandler.setAuthorizationPrompter((AuthorizationPrompter)this);
        this.loader = new DocumentLoader();
        this.loader.setNamespaceMode(1);
        this.loader.setAddedProperties(4);
    }

    public String getServer() {
        return this.connection.getProtocol() + "://" + this.connection.getHost() + ":" + this.connection.getPort();
    }

    public static final void setDefaultLockOwner(String string) {
        defaultLockOwner = string;
    }

    public static final String getDefaultLockOwner() {
        if (defaultLockOwner != null) {
            return defaultLockOwner;
        }
        String string = System.getProperty("XXE_DAV_LOCK_OWNER");
        if (string == null && (string = System.getProperty("user.name")) == null) {
            string = URLUtil.getLocalHostName();
            string = string == null ? "(unknown)" : "user@" + string;
        }
        return URIUtil.quoteUserInfo(string);
    }

    public void setLockOwner(String string) {
        this.lockOwner = string;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public boolean isDAVEnabled(String string) {
        while (string != null) {
            try {
                return this.getDAVLevel(string) > 0;
            }
            catch (Exception exception) {
                string = DAVClient.parentPath(string);
            }
        }
        return false;
    }

    public static final String parentPath(String string) {
        String string2;
        if (string.endsWith("/") && string.length() > 1) {
            string = string.substring(0, string.length() - 1);
        }
        if ((string2 = URLPathUtil.parent(string)) != null && !string2.endsWith("/")) {
            string2 = string2 + '/';
        }
        return string2;
    }

    public int getDAVLevel(String string) throws IOException, ModuleException, DAVException {
        HTTPResponse hTTPResponse = this.connection.Options(this.escape(string));
        if (hTTPResponse.getStatusCode() != 200) {
            throw new DAVException(hTTPResponse.getStatusCode(), hTTPResponse.getReasonLine());
        }
        String string2 = hTTPResponse.getHeader("DAV");
        if (string2 == null) {
            return 0;
        }
        if (string2.indexOf(50) >= 0) {
            return 2;
        }
        if (string2.indexOf(49) >= 0) {
            return 1;
        }
        return 0;
    }

    private String escape(String string) {
        return URIUtil.encodeToUTF8(string);
    }

    private String unescape(String string) {
        return URIUtil.decodeFromUTF8(string);
    }

    public NVPair getUsernamePassword(AuthorizationInfo authorizationInfo, boolean bl) {
        PasswordAuthentication passwordAuthentication = Authenticator.requestPasswordAuthentication(authorizationInfo.getHost(), null, authorizationInfo.getPort(), this.connection.getProtocol(), authorizationInfo.getRealm(), authorizationInfo.getScheme());
        if (passwordAuthentication == null) {
            return null;
        }
        return new NVPair(passwordAuthentication.getUserName(), new String(passwordAuthentication.getPassword()));
    }

    public DAVProperties getProperties(String string, int n) throws IOException, ModuleException, DAVException {
        try {
            DAVProperties[] dAVPropertiesArray = this.propfind(string, n, 0);
            return dAVPropertiesArray[0];
        }
        catch (DAVException dAVException) {
            if (dAVException.getStatusCode() == 404) {
                return null;
            }
            throw dAVException;
        }
    }

    public DAVProperties[] propfind(String string, int n, int n2) throws IOException, ModuleException, DAVException {
        String string2 = n2 == 0 ? "0" : (n2 == 1 ? "1" : "infinity");
        NVPair[] nVPairArray = new NVPair[]{new NVPair("Depth", string2), new NVPair("Content-Type", "text/xml; charset=\"utf-8\"")};
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        stringBuffer.append("<propfind xmlns=\"DAV:\">\n");
        stringBuffer.append("  <prop>\n");
        stringBuffer.append("    <resourcetype/>\n");
        if ((n & 1) != 0) {
            stringBuffer.append("    <creationdate/>\n");
        }
        if ((n & 2) != 0) {
            stringBuffer.append("    <displayname/>\n");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("    <getcontentlength/>\n");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("    <getcontentlanguage/>\n");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append("    <getcontenttype/>\n");
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append("    <getetag/>\n");
        }
        if ((n & 0x40) != 0) {
            stringBuffer.append("    <getlastmodified/>\n");
        }
        if ((n & 0x80) != 0) {
            stringBuffer.append("    <supportedlock/>\n");
        }
        if ((n & 0x100) != 0) {
            stringBuffer.append("    <lockdiscovery/>\n");
        }
        stringBuffer.append("  </prop>\n");
        stringBuffer.append("</propfind>");
        HTTPResponse hTTPResponse = this.connection.ExtensionMethod("PROPFIND", this.escape(string), stringBuffer.toString().getBytes("UTF8"), nVPairArray);
        if (hTTPResponse.getStatusCode() != 207) {
            if (DAVClient.retryWithSlash(hTTPResponse, string)) {
                return this.propfind(string + '/', n, n2);
            }
            throw new DAVException(hTTPResponse.getStatusCode(), hTTPResponse.getReasonLine());
        }
        Element element = this.loadResponse(hTTPResponse);
        DAVProperties[] dAVPropertiesArray = this.parseProperties(element, string);
        if (dAVPropertiesArray == null || dAVPropertiesArray.length == 0) {
            throw new IOException("invalid response '" + DAVClient.getText(hTTPResponse) + "'");
        }
        return dAVPropertiesArray;
    }

    private static final boolean retryWithSlash(HTTPResponse hTTPResponse, String string) throws IOException, ModuleException {
        String string2;
        return hTTPResponse.getStatusCode() == 301 && !string.endsWith("/") && (string2 = hTTPResponse.getHeader("Location")) != null && string2.endsWith(string + '/');
    }

    private Element loadResponse(HTTPResponse hTTPResponse) throws IOException, ModuleException {
        URL uRL = FileUtil.fileToURL("bytes");
        OpenEntity openEntity = new OpenEntity(new ByteArrayInputStream(hTTPResponse.getData()), uRL.toExternalForm(), uRL);
        Document document = this.loader.load(openEntity);
        return document.getRootElement();
    }

    private static final String getText(HTTPResponse hTTPResponse) {
        String string = null;
        try {
            string = hTTPResponse.getText();
        }
        catch (Exception exception) {}
        return string;
    }

    private DAVProperties[] parseProperties(Element element, String string) {
        Object object;
        ArrayList<DAVProperties> arrayList = new ArrayList<DAVProperties>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element && ((Element)(object = (Element)node)).getName() == RESPONSE) {
                DAVProperties dAVProperties = this.parseResponse((Element)object, string);
                if (dAVProperties == null) {
                    return null;
                }
                arrayList.add(dAVProperties);
            }
            node = node.getNextSibling();
        }
        object = new DAVProperties[arrayList.size()];
        return arrayList.toArray((T[])object);
    }

    private DAVProperties parseResponse(Element element, String string) {
        DAVProperties dAVProperties = new DAVProperties();
        boolean bl = false;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                boolean bl2;
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == HREF) {
                    String string2 = element2.getText();
                    if (string2 != null) {
                        string2 = this.unescape(string2);
                        string2 = DAVClient.relativize(string2, string);
                    }
                    if (string2 == null) {
                        return null;
                    }
                    dAVProperties.relativePath = string2;
                } else if (name == PROPSTAT && (bl2 = this.parsePropstat(element2, dAVProperties))) {
                    bl = true;
                }
            }
            node = node.getNextSibling();
        }
        if (dAVProperties.relativePath == null || !bl) {
            return null;
        }
        return dAVProperties;
    }

    private static final String relativize(String string, String string2) {
        int n = string.indexOf(string2);
        if (n < 0) {
            return null;
        }
        if ((n += string2.length()) == string.length()) {
            return "";
        }
        String string3 = string.substring(n);
        if (string3.startsWith("/")) {
            string3 = string3.substring(1);
        }
        return string3;
    }

    private boolean parsePropstat(Element element, DAVProperties dAVProperties) {
        boolean bl = false;
        boolean bl2 = false;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                String string;
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == PROP) {
                    if (this.parseProp(element2, dAVProperties)) {
                        bl = true;
                    }
                } else if (name == STATUS && (string = element2.getText()) != null && string.indexOf("200") >= 0) {
                    bl2 = true;
                }
            }
            node = node.getNextSibling();
        }
        return bl && bl2;
    }

    private boolean parseProp(Element element, DAVProperties dAVProperties) {
        boolean bl = false;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Serializable serializable;
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == CREATIONDATE) {
                    String string = DAVClient.getText(element2);
                    if (string != null) {
                        serializable = null;
                        try {
                            serializable = DateTimeValue.parseDateTime(string);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (serializable != null) {
                            dAVProperties.creationdate = serializable.toDate();
                        }
                    }
                } else if (name == DISPLAYNAME) {
                    String string = DAVClient.getText(element2);
                    if (string != null) {
                        dAVProperties.displayname = string;
                    }
                } else if (name == GETCONTENTLENGTH) {
                    long l = -1L;
                    String string = DAVClient.getText(element2);
                    if (string != null) {
                        try {
                            l = Long.parseLong(string.trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (l >= 0L) {
                        dAVProperties.getcontentlength = l;
                    }
                } else if (name == GETCONTENTTYPE) {
                    String string = DAVClient.getText(element2);
                    if (string != null) {
                        dAVProperties.getcontenttype = string;
                    }
                } else if (name == GETCONTENTLANGUAGE) {
                    String string = DAVClient.getText(element2);
                    if (string != null) {
                        dAVProperties.getcontentlanguage = string;
                    }
                } else if (name == GETETAG) {
                    String string = DAVClient.getText(element2);
                    if (string != null) {
                        dAVProperties.getetag = string;
                    }
                } else if (name == GETLASTMODIFIED) {
                    String string = DAVClient.getText(element2);
                    if (string != null && (serializable = DAVClient.parseHTTPDate(string)) != null) {
                        dAVProperties.getlastmodified = serializable;
                    }
                } else if (name == RESOURCETYPE) {
                    bl = true;
                    Element element3 = element2.getChildElement(0);
                    if (element3 != null && element3.getName() == COLLECTION) {
                        dAVProperties.isCollection = true;
                    }
                } else if (name == SUPPORTEDLOCK) {
                    dAVProperties.supportedlock = this.parseSupportedlock(element2);
                } else if (name == LOCKDISCOVERY) {
                    dAVProperties.lockdiscovery = this.parseLockdiscovery(element2);
                }
            }
            node = node.getNextSibling();
        }
        return bl;
    }

    private static final String getText(Element element) {
        String string = element.getText();
        if (string != null) {
            string = string.trim();
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        return string;
    }

    private static final Date parseHTTPDate(String string) {
        if (dateFormat1123 == null) {
            dateFormat1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
            dateFormat1123.setTimeZone(new SimpleTimeZone(0, ""));
        }
        try {
            return dateFormat1123.parse(string);
        }
        catch (ParseException parseException) {
            if (dateFormat850 == null) {
                dateFormat850 = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss 'GMT'", Locale.US);
                dateFormat850.setTimeZone(new SimpleTimeZone(0, ""));
            }
            try {
                return dateFormat850.parse(string);
            }
            catch (ParseException parseException2) {
                if (dateFormatAsctime == null) {
                    dateFormatAsctime = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);
                    dateFormatAsctime.setTimeZone(new SimpleTimeZone(0, ""));
                }
                try {
                    return dateFormatAsctime.parse(string);
                }
                catch (ParseException parseException3) {
                    return null;
                }
            }
        }
    }

    private byte[] parseSupportedlock(Element element) {
        Object object;
        Object object2 = new byte[element.getChildElementCount()];
        int n = 0;
        Node node = element.getFirstChild();
        while (node != null) {
            int n2;
            if (node instanceof Element && ((Element)(object = (Element)node)).getName() == LOCKENTRY && (n2 = this.parseLockentry((Element)object)) != 0) {
                object2[n++] = (byte)n2;
            }
            node = node.getNextSibling();
        }
        if (n != ((byte[])object2).length) {
            object = new byte[n];
            System.arraycopy(object2, 0, object, 0, n);
            object2 = object;
        }
        return object2;
    }

    private int parseLockentry(Element element) {
        int n = 0;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Element element2;
                Element element3 = (Element)node;
                Name name = element3.getName();
                if (name == LOCKSCOPE) {
                    element2 = element3.getChildElement(0);
                    if (element2 != null) {
                        Name name2 = element2.getName();
                        if (name2 == SHARED) {
                            n |= 0x10;
                        } else if (name2 == EXCLUSIVE) {
                            n |= 0x20;
                        }
                    }
                } else if (name == LOCKTYPE && (element2 = element3.getChildElement(0)) != null && element2.getName() == WRITE) {
                    n |= 1;
                }
            }
            node = node.getNextSibling();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(String string, File file) throws IOException, ModuleException, DAVException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.get(string, fileOutputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(String string, OutputStream outputStream) throws IOException, ModuleException, DAVException {
        HTTPResponse hTTPResponse = this.connection.Get(this.escape(string), (String)null);
        if (hTTPResponse.getStatusCode() != 200) {
            throw new DAVException(hTTPResponse.getStatusCode(), hTTPResponse.getReasonLine());
        }
        InputStream inputStream = hTTPResponse.getInputStream();
        byte[] byArray = new byte[8192];
        try {
            int n;
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    public byte[] get(String string) throws IOException, ModuleException, DAVException {
        HTTPResponse hTTPResponse = this.connection.Get(this.escape(string), (String)null);
        if (hTTPResponse.getStatusCode() != 200) {
            throw new DAVException(hTTPResponse.getStatusCode(), hTTPResponse.getReasonLine());
        }
        return hTTPResponse.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(File file, String string) throws IOException, ModuleException, DAVException {
        boolean bl = false;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            bl = this.put(fileInputStream, (int)file.length(), string);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        return bl;
    }

    public boolean put(byte[] byArray, String string) throws IOException, ModuleException, DAVException {
        String[] stringArray = this.getLockTokens2(string);
        return this.put(byArray, string, stringArray);
    }

    public boolean put(InputStream inputStream, int n, String string) throws IOException, ModuleException, DAVException {
        String[] stringArray = this.getLockTokens2(string);
        if (n < 0) {
            return this.put(DAVClient.loadBytes(inputStream), string, stringArray);
        }
        return this.put(inputStream, n, string, stringArray);
    }

    public static final byte[] loadBytes(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public boolean put(byte[] byArray, String string, String[] stringArray) throws IOException, ModuleException, DAVException {
        NVPair[] nVPairArray = this.addIfHeader(null, stringArray);
        HTTPResponse hTTPResponse = this.connection.Put(this.escape(string), byArray, nVPairArray);
        this.trace("PUT", this.escape(string), byArray, nVPairArray, hTTPResponse);
        int n = hTTPResponse.getStatusCode();
        if (n != 201 && n != 204 && n != 200) {
            throw new DAVException(hTTPResponse.getStatusCode(), hTTPResponse.getReasonLine());
        }
        return n == 201;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(InputStream inputStream, int n, String string, String[] stringArray) throws IOException, ModuleException, DAVException {
        if (n < 0) {
            throw new IllegalArgumentException("contentLength < 0");
        }
        HttpOutputStream httpOutputStream = new HttpOutputStream(n);
        NVPair[] nVPairArray = this.addIfHeader(null, stringArray);
        HTTPResponse hTTPResponse = this.connection.Put(this.escape(string), httpOutputStream, nVPairArray);
        byte[] byArray = new byte[8192];
        try {
            int n2;
            while ((n2 = inputStream.read(byArray)) >= 0) {
                httpOutputStream.write(byArray, 0, n2);
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            httpOutputStream.close();
            throw throwable;
        }
        httpOutputStream.close();
        this.trace("PUT", this.escape(string), null, nVPairArray, hTTPResponse);
        int n3 = hTTPResponse.getStatusCode();
        if (n3 != 201 && n3 != 204 && n3 != 200) {
            throw new DAVException(hTTPResponse.getStatusCode(), hTTPResponse.getReasonLine());
        }
        return n3 == 201;
    }

    private String[] getLockTokens(String string) {
        return this.doGetLockTokens(string, null, null, null);
    }

    private String[] getLockTokens2(String string) {
        return this.doGetLockTokens(string, DAVClient.parentPath(string), null, null);
    }

    private String[] getLockTokens4(String string, String string2) {
        String string3;
        String string4;
        String string5 = string;
        String string6 = DAVClient.parentPath(string);
        if (string.equals(string2)) {
            string4 = null;
            string3 = null;
        } else {
            string4 = string2;
            string3 = DAVClient.parentPath(string2);
            if (string6.equals(string3)) {
                string3 = null;
            }
        }
        return this.doGetLockTokens(string5, string6, string4, string3);
    }

    private String[] doGetLockTokens(String string, String string2, String string3, String string4) {
        int n = 0;
        if (string != null) {
            n += 2;
        }
        if (string2 != null) {
            n += 2;
        }
        if (string3 != null) {
            n += 2;
        }
        if (string4 != null) {
            n += 2;
        }
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        n = 0;
        if (string != null) {
            stringArray[n + 1] = this.getLockToken(string);
            if (stringArray[n + 1] != null) {
                stringArray[n] = string;
                n += 2;
            }
        }
        if (string2 != null) {
            stringArray[n + 1] = this.getLockToken(string2);
            if (stringArray[n + 1] != null) {
                stringArray[n] = string2;
                n += 2;
            }
        }
        if (string3 != null) {
            stringArray[n + 1] = this.getLockToken(string3);
            if (stringArray[n + 1] != null) {
                stringArray[n] = string3;
                n += 2;
            }
        }
        if (string4 != null) {
            stringArray[n + 1] = this.getLockToken(string4);
            if (stringArray[n + 1] != null) {
                stringArray[n] = string4;
                n += 2;
            }
        }
        if (n == 0) {
            return null;
        }
        if (n != stringArray.length) {
            String[] stringArray2 = new String[n];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            stringArray = stringArray2;
        }
        return stringArray;
    }

    private String getLockToken(String string) {
        DAVProperties[] dAVPropertiesArray;
        try {
            dAVPropertiesArray = this.propfind(string, 256, 0);
        }
        catch (Exception exception) {
            dAVPropertiesArray = null;
        }
        if (dAVPropertiesArray == null || dAVPropertiesArray.length == 0) {
            return null;
        }
        DAVLock[] dAVLockArray = dAVPropertiesArray[0].lockdiscovery;
        if (dAVLockArray == null || dAVLockArray.length == 0) {
            return null;
        }
        int n = 0;
        while (n < dAVLockArray.length) {
            if (this.lockOwner.equals(dAVLockArray[n].owner)) {
                return dAVLockArray[n].locktoken;
            }
            ++n;
        }
        return null;
    }

    private NVPair[] addIfHeader(NVPair[] nVPairArray, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return nVPairArray;
        }
        NVPair nVPair = new NVPair("If", this.ifHeaderValue(stringArray));
        if (nVPairArray == null) {
            return new NVPair[]{nVPair};
        }
        NVPair[] nVPairArray2 = new NVPair[nVPairArray.length + 1];
        System.arraycopy(nVPairArray, 0, nVPairArray2, 0, nVPairArray.length);
        nVPairArray2[nVPairArray.length] = nVPair;
        return nVPairArray2;
    }

    private String ifHeaderValue(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                if (stringArray[n2].equals(string)) {
                    bl = true;
                    break;
                }
                n2 += 2;
            }
            if (!bl) {
                if (n > 0) {
                    stringBuffer.append(' ');
                }
                this.ifHeaderValue(string, stringArray[n + 1], stringBuffer);
            }
            n += 2;
        }
        return stringBuffer.toString();
    }

    private String ifHeaderValue(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.ifHeaderValue(string, string2, stringBuffer);
        return stringBuffer.toString();
    }

    private void ifHeaderValue(String string, String string2, StringBuffer stringBuffer) {
        stringBuffer.append('<');
        stringBuffer.append(this.toAbsoluteURI(this.escape(string)));
        stringBuffer.append('>');
        stringBuffer.append(" (<");
        stringBuffer.append(string2);
        stringBuffer.append(">)");
    }

    private String toAbsoluteURI(String string) {
        return this.getServer() + string;
    }

    public void mkcol(String string) throws IOException, ModuleException, DAVException {
        String[] stringArray = this.getLockTokens(DAVClient.parentPath(string));
        this.mkcol(string, stringArray);
    }

    public void mkcol(String string, String[] stringArray) throws IOException, ModuleException, DAVException {
        if (!string.endsWith("/")) {
            string = string + '/';
        }
        NVPair[] nVPairArray = this.addIfHeader(null, stringArray);
        HTTPResponse hTTPResponse = this.connection.ExtensionMethod("MKCOL", this.escape(string), (byte[])null, nVPairArray);
        this.trace("MKCOL", this.escape(string), null, nVPairArray, hTTPResponse);
        int n = hTTPResponse.getStatusCode();
        if (n != 201 && n != 200) {
            throw new DAVException(hTTPResponse.getStatusCode(), hTTPResponse.getReasonLine());
        }
    }

    public void delete(String string) throws IOException, ModuleException, DAVException {
        String[] stringArray = this.getLockTokens2(string);
        this.delete(string, stringArray);
    }

    public void delete(String string, String[] stringArray) throws IOException, ModuleException, DAVException {
        NVPair[] nVPairArray = this.addIfHeader(null, stringArray);
        HTTPResponse hTTPResponse = this.connection.Delete(this.escape(string), nVPairArray);
        int n = hTTPResponse.getStatusCode();
        if (n != 204 && n != 200) {
            throw new DAVException(hTTPResponse.getStatusCode(), hTTPResponse.getReasonLine());
        }
    }

    public boolean copy(String string, String string2, boolean bl, int n) throws IOException, ModuleException, DAVException {
        String[] stringArray = this.getLockTokens2(string2);
        return this.copy(string, string2, bl, n, stringArray);
    }

    public boolean copy(String string, String string2, boolean bl, int n, String[] stringArray) throws IOException, ModuleException, DAVException {
        String string3 = n == 0 ? "0" : "infinity";
        NVPair[] nVPairArray = new NVPair[]{new NVPair("Destination", this.toAbsoluteURI(this.escape(string2))), new NVPair("Overwrite", bl ? "T" : "F"), new NVPair("Depth", string3)};
        nVPairArray = this.addIfHeader(nVPairArray, stringArray);
        HTTPResponse hTTPResponse = this.connection.ExtensionMethod("COPY", this.escape(string), (byte[])null, nVPairArray);
        this.trace("COPY", this.escape(string), null, nVPairArray, hTTPResponse);
        int n2 = hTTPResponse.getStatusCode();
        if (n2 != 201 && n2 != 204 && n2 != 200) {
            throw new DAVException(hTTPResponse.getStatusCode(), hTTPResponse.getReasonLine());
        }
        return n2 == 201;
    }

    public boolean move(String string, String string2, boolean bl) throws IOException, ModuleException, DAVException {
        String[] stringArray = this.getLockTokens4(string, string2);
        return this.move(string, string2, bl, stringArray);
    }

    public boolean move(String string, String string2, boolean bl, String[] stringArray) throws IOException, ModuleException, DAVException {
        NVPair[] nVPairArray = new NVPair[]{new NVPair("Destination", this.toAbsoluteURI(this.escape(string2))), new NVPair("Overwrite", bl ? "T" : "F")};
        nVPairArray = this.addIfHeader(nVPairArray, stringArray);
        HTTPResponse hTTPResponse = this.connection.ExtensionMethod("MOVE", this.escape(string), (byte[])null, nVPairArray);
        this.trace("MOVE", this.escape(string), null, nVPairArray, hTTPResponse);
        int n = hTTPResponse.getStatusCode();
        if (n != 201 && n != 204 && n != 200) {
            throw new DAVException(hTTPResponse.getStatusCode(), hTTPResponse.getReasonLine());
        }
        return n == 201;
    }

    public DAVLock lock(String string, int n, int n2, int n3, int n4) throws IOException, ModuleException, DAVException {
        String string2 = n3 == 0 ? "0" : "infinity";
        String string3 = n4 < 0 ? "Infinite" : "Second-" + n4;
        NVPair[] nVPairArray = new NVPair[]{new NVPair("Depth", string2), new NVPair("Timeout", string3), new NVPair("Content-Type", "text/xml; charset=\"utf-8\"")};
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        stringBuffer.append("<lockinfo xmlns=\"DAV:\">\n");
        stringBuffer.append("  <lockscope>");
        if ((n2 & 0x10) != 0) {
            stringBuffer.append("<shared/>");
        }
        if ((n2 & 0x20) != 0) {
            stringBuffer.append("<exclusive/>");
        }
        stringBuffer.append("</lockscope>\n");
        stringBuffer.append("  <locktype>");
        if ((n & 1) != 0) {
            stringBuffer.append("<write/>");
        }
        stringBuffer.append("</locktype>\n");
        stringBuffer.append("  <owner><href>");
        XMLUtil.escapeXML(this.escape(this.lockOwner), stringBuffer);
        stringBuffer.append("</href></owner>\n");
        stringBuffer.append("</lockinfo>");
        HTTPResponse hTTPResponse = this.connection.ExtensionMethod("LOCK", this.escape(string), stringBuffer.toString().getBytes("UTF8"), nVPairArray);
        if (hTTPResponse.getStatusCode() != 200) {
            throw new DAVException(hTTPResponse.getStatusCode(), hTTPResponse.getReasonLine());
        }
        Element element = this.loadResponse(hTTPResponse);
        DAVLock[] dAVLockArray = this.parseLockdiscoveryProp(element);
        if (dAVLockArray == null || dAVLockArray.length == 0) {
            throw new IOException("invalid response '" + DAVClient.getText(hTTPResponse) + "'");
        }
        return dAVLockArray[0];
    }

    private DAVLock[] parseLockdiscoveryProp(Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            if (node instanceof Element && (element2 = (Element)node).getName() == LOCKDISCOVERY) {
                return this.parseLockdiscovery(element2);
            }
            node = node.getNextSibling();
        }
        return null;
    }

    private DAVLock[] parseLockdiscovery(Element element) {
        Object object;
        ArrayList<DAVLock> arrayList = new ArrayList<DAVLock>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element && ((Element)(object = (Element)node)).getName() == ACTIVELOCK) {
                DAVLock dAVLock = this.parseActivelock((Element)object);
                if (dAVLock == null) {
                    return null;
                }
                arrayList.add(dAVLock);
            }
            node = node.getNextSibling();
        }
        object = new DAVLock[arrayList.size()];
        return arrayList.toArray((T[])object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DAVLock parseActivelock(Element element) {
        DAVLock dAVLock = new DAVLock();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Object object;
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == LOCKSCOPE) {
                    object = element2.getChildElement(0);
                    if (object == null) {
                        return null;
                    }
                    Name name2 = ((Element)object).getName();
                    if (name2 == SHARED) {
                        dAVLock.lockscope = (byte)16;
                    } else {
                        if (name2 != EXCLUSIVE) return null;
                        dAVLock.lockscope = (byte)32;
                    }
                } else if (name == LOCKTYPE) {
                    object = element2.getChildElement(0);
                    if (object == null || ((Element)object).getName() != WRITE) {
                        return null;
                    }
                    dAVLock.locktype = 1;
                } else if (name == DEPTH) {
                    object = DAVClient.getText(element2);
                    if (object == null) {
                        return null;
                    }
                    if (((String)object).equalsIgnoreCase("infinity")) {
                        dAVLock.depth = -1;
                    } else {
                        try {
                            dAVLock.depth = Integer.parseInt((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            dAVLock.depth = Integer.MIN_VALUE;
                        }
                    }
                    if (dAVLock.depth != 0 && dAVLock.depth != -1) {
                        return null;
                    }
                } else if (name == OWNER) {
                    object = element2.getChildElement(0);
                    if (object != null && ((Element)object).getName() == HREF) {
                        dAVLock.owner = DAVClient.getText((Element)object);
                        if (dAVLock.owner == null) {
                            return null;
                        }
                        dAVLock.owner = this.unescape(dAVLock.owner);
                    } else {
                        dAVLock.owner = DAVClient.getText(element2);
                        if (dAVLock.owner == null) {
                            dAVLock.owner = "???";
                        }
                    }
                } else if (name == TIMEOUT) {
                    object = DAVClient.getText(element2);
                    if (object == null) {
                        return null;
                    }
                    if (((String)object).equalsIgnoreCase("infinite")) {
                        dAVLock.timeout = -1;
                    } else {
                        if (!((String)object).regionMatches(true, 0, "second-", 0, 7)) return null;
                        try {
                            dAVLock.timeout = Integer.parseInt(((String)object).substring(7));
                        }
                        catch (NumberFormatException numberFormatException) {
                            dAVLock.timeout = Integer.MIN_VALUE;
                        }
                        if (dAVLock.timeout <= 0 && dAVLock.timeout != -1) {
                            return null;
                        }
                    }
                } else if (name == LOCKTOKEN) {
                    object = element2.getChildElement(0);
                    if (object == null || ((Element)object).getName() != HREF) {
                        return null;
                    }
                    dAVLock.locktoken = DAVClient.getText((Element)object);
                    if (dAVLock.locktoken == null) {
                        return null;
                    }
                }
            }
            node = node.getNextSibling();
        }
        if (dAVLock.locktoken != null) return dAVLock;
        return null;
    }

    public DAVLock relock(String string, int n) throws IOException, ModuleException, DAVException {
        String string2 = this.getLockToken(string);
        if (string2 == null) {
            return null;
        }
        return this.relock(string, string2, n);
    }

    public DAVLock relock(String string, String string2, int n) throws IOException, ModuleException, DAVException {
        String string3 = n < 0 ? "Infinite" : "Second-" + n;
        NVPair[] nVPairArray = new NVPair[]{new NVPair("Timeout", string3), new NVPair("If", this.ifHeaderValue(string, string2))};
        HTTPResponse hTTPResponse = this.connection.ExtensionMethod("LOCK", this.escape(string), (byte[])null, nVPairArray);
        if (hTTPResponse.getStatusCode() != 200) {
            throw new DAVException(hTTPResponse.getStatusCode(), hTTPResponse.getReasonLine());
        }
        Element element = this.loadResponse(hTTPResponse);
        DAVLock[] dAVLockArray = this.parseLockdiscoveryProp(element);
        if (dAVLockArray == null || dAVLockArray.length != 1) {
            throw new IOException("invalid response '" + DAVClient.getText(hTTPResponse) + "'");
        }
        return dAVLockArray[0];
    }

    public boolean unlock(String string) throws IOException, ModuleException, DAVException {
        String string2 = this.getLockToken(string);
        if (string2 == null) {
            return false;
        }
        this.unlock(string, string2);
        return true;
    }

    public void unlock(String string, String string2) throws IOException, ModuleException, DAVException {
        NVPair[] nVPairArray = new NVPair[]{new NVPair("Lock-Token", "<" + string2 + ">")};
        HTTPResponse hTTPResponse = this.connection.ExtensionMethod("UNLOCK", this.escape(string), (byte[])null, nVPairArray);
        int n = hTTPResponse.getStatusCode();
        if (n != 204 && n != 200) {
            throw new DAVException(hTTPResponse.getStatusCode(), hTTPResponse.getReasonLine());
        }
    }

    private void trace(String string, String string2, byte[] byArray, NVPair[] nVPairArray, HTTPResponse hTTPResponse) {
    }

    static {
        dateFormat1123 = null;
        dateFormat850 = null;
        dateFormatAsctime = null;
        DAV = Namespace.get("DAV:");
        MULTISTATUS = Name.get(DAV, "multistatus");
        RESPONSE = Name.get(DAV, "response");
        HREF = Name.get(DAV, "href");
        PROPSTAT = Name.get(DAV, "propstat");
        PROP = Name.get(DAV, "prop");
        STATUS = Name.get(DAV, "status");
        CREATIONDATE = Name.get(DAV, "creationdate");
        DISPLAYNAME = Name.get(DAV, "displayname");
        GETCONTENTLENGTH = Name.get(DAV, "getcontentlength");
        GETCONTENTTYPE = Name.get(DAV, "getcontenttype");
        GETCONTENTLANGUAGE = Name.get(DAV, "getcontentlanguage");
        GETETAG = Name.get(DAV, "getetag");
        GETLASTMODIFIED = Name.get(DAV, "getlastmodified");
        RESOURCETYPE = Name.get(DAV, "resourcetype");
        COLLECTION = Name.get(DAV, "collection");
        SUPPORTEDLOCK = Name.get(DAV, "supportedlock");
        LOCKENTRY = Name.get(DAV, "lockentry");
        LOCKSCOPE = Name.get(DAV, "lockscope");
        LOCKTYPE = Name.get(DAV, "locktype");
        SHARED = Name.get(DAV, "shared");
        EXCLUSIVE = Name.get(DAV, "exclusive");
        WRITE = Name.get(DAV, "write");
        LOCKDISCOVERY = Name.get(DAV, "lockdiscovery");
        ACTIVELOCK = Name.get(DAV, "activelock");
        DEPTH = Name.get(DAV, "depth");
        OWNER = Name.get(DAV, "owner");
        TIMEOUT = Name.get(DAV, "timeout");
        LOCKTOKEN = Name.get(DAV, "locktoken");
    }
}

