/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.upload;

import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmleditapp.upload.DAVClient;
import com.xmlmind.xmleditapp.upload.DAVProperties;
import com.xmlmind.xmleditapp.upload.Msg;
import com.xmlmind.xmleditapp.upload.Upload;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

public class DAVUpload
extends Upload {
    private DAVClient davClient;

    public void setDAVClient(DAVClient dAVClient) {
        this.davClient = dAVClient;
    }

    public DAVClient getDAVClient() {
        return this.davClient;
    }

    protected String doUpload(URL[] uRLArray, boolean bl) {
        String string;
        if (this.davClient == null && (string = this.connect(uRLArray[1])) != null) {
            return string;
        }
        return this.doUpload(this.davClient, uRLArray, bl);
    }

    private String connect(URL uRL) {
        String string = null;
        try {
            this.davClient = new DAVClient(uRL.getProtocol(), uRL.getHost(), uRL.getPort());
            if (!this.davClient.isDAVEnabled(uRL.getPath())) {
                throw new IOException(Msg.msg("notDAVEnabled", URLUtil.toDisplayForm(uRL)));
            }
        }
        catch (Exception exception) {
            string = MiscUtil.reason(exception);
        }
        if (string != null) {
            return Msg.msg("cannotConnectToServer", URLUtil.getRoot(uRL, true).toExternalForm(), string);
        }
        return null;
    }

    private String doUpload(DAVClient dAVClient, URL[] uRLArray, boolean bl) {
        URL uRL = URLUtil.getRoot(uRLArray[1], true);
        URL uRL2 = null;
        try {
            uRL2 = new URL(dAVClient.getServer() + "/");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (!uRL.equals(uRL2)) {
            throw new IllegalArgumentException("expected uploadClient to be connected to " + uRL + ", found it connected to " + uRL2);
        }
        this.davClient = dAVClient;
        DAVUpload.trace("lock owner '" + this.davClient.getLockOwner() + "'");
        String[] stringArray = new String[1];
        String string = null;
        int n = 0;
        while (n < uRLArray.length) {
            String string2;
            URL uRL3 = uRLArray[n];
            URL uRL4 = uRLArray[n + 1];
            string = this.uploading(uRL3, uRL4, n / 2, uRLArray.length / 2);
            if (string != null || (string = this.mkcols(string2 = uRL4.getPath())) != null) break;
            DAVUpload.trace("put '" + uRL3 + "' '" + string2 + "'");
            boolean bl2 = this.put(uRL3, string2, bl, stringArray);
            string = stringArray[0];
            if (string != null || !bl2 && (string = this.missingSource(uRL3)) != null) break;
            n += 2;
        }
        return string;
    }

    private static final void trace(String string) {
    }

    private String mkcols(String string) {
        ArrayList<String> arrayList = null;
        String string2 = DAVClient.parentPath(string);
        while (string2 != null && !string2.equals("/")) {
            String string3 = null;
            DAVProperties dAVProperties = null;
            try {
                dAVProperties = this.davClient.getProperties(string2, 0);
            }
            catch (Exception exception) {
                string3 = MiscUtil.reason(exception);
            }
            if (string3 != null) {
                return Msg.msg("cannotCreateDirectory2", string2, string3);
            }
            if (dAVProperties != null) {
                if (dAVProperties.isCollection) break;
                return Msg.msg("invalidFilePath", string, string2);
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(0, string2);
            string2 = DAVClient.parentPath(string2);
        }
        if (arrayList != null) {
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                string2 = (String)arrayList.get(n2);
                DAVUpload.trace("mkdir '" + string2 + "'");
                String string4 = null;
                try {
                    this.davClient.mkcol(string2, null);
                }
                catch (Exception exception) {
                    string4 = MiscUtil.reason(exception);
                }
                if (string4 != null) {
                    return Msg.msg("cannotCreateDirectory2", string2, string4);
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean put(URL uRL, String string, boolean bl, String[] stringArray) {
        stringArray[0] = null;
        String string2 = null;
        InputStream inputStream = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            uRLConnection.setIfModifiedSince(0L);
            inputStream = uRLConnection.getInputStream();
        }
        catch (Exception exception) {
            if (bl) {
                return false;
            }
            string2 = MiscUtil.reason(exception);
        }
        if (inputStream != null) {
            try {
                this.davClient.put(DAVClient.loadBytes(inputStream), string, null);
            }
            catch (Exception exception) {
                string2 = MiscUtil.reason(exception);
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string2 != null) {
            stringArray[0] = Msg.msg("cannotCopyFile2", uRL, string, string2);
            return false;
        }
        return true;
    }
}

