/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.upload;

import com.xmlmind.xmledit.guiutil.AWTUtil;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.util.Log;
import com.xmlmind.xmleditapp.upload.DAVUpload;
import com.xmlmind.xmleditapp.upload.FTPUpload;
import com.xmlmind.xmleditapp.upload.FileUpload;
import com.xmlmind.xmleditapp.upload.Msg;
import com.xmlmind.xmleditapp.upload.Upload;
import com.xmlmind.xmleditapp.upload.UploadInvoker;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class UploadDialog
extends JDialog
implements ActionListener,
UploadInvoker {
    private Component dialogAnchor;
    private JTextArea messages;
    private JButton cancelButton;
    private String messageLog = null;
    private Timer monitorTimer;
    private boolean done;
    private boolean canceled;
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$upload$UploadDialog;

    public UploadDialog(Dialog dialog) {
        super(dialog, Msg.msg("copyingFiles"), true);
        this.initialize(dialog);
    }

    public UploadDialog(Component component) {
        super(AWTUtil.getFrame(component), Msg.msg("copyingFiles"), true);
        this.initialize(component);
    }

    private void initialize(Component component) {
        this.dialogAnchor = AWTUtil.getDialogAnchor(component);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                UploadDialog.this.cancel();
            }
        });
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new GridBagLayout());
        jPanel.registerKeyboardAction(this, "cancel", KeyStroke.getKeyStroke(27, 0), 1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel(new ImageIcon((class$com$xmlmind$xmleditapp$upload$UploadDialog == null ? (class$com$xmlmind$xmleditapp$upload$UploadDialog = UploadDialog.class$("com.xmlmind.xmleditapp.upload.UploadDialog")) : class$com$xmlmind$xmleditapp$upload$UploadDialog).getResource("wait.gif")));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel(Msg.msg("copyingFiles2"));
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.messages = new JTextArea(15, 60);
        Font font = this.messages.getFont();
        this.messages.setFont(new Font(font.getFamily(), 0, Math.max(10, font.getSize() - 2)));
        this.messages.setEditable(false);
        this.messages.setLineWrap(true);
        this.messages.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.messages);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.cancelButton = new JButton();
        DialogUtil.setCancelText(this.cancelButton);
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.pack();
        this.setResizable(true);
    }

    public void setMessageLog(String string) {
        this.messageLog = string;
    }

    public String getMessageLog() {
        return this.messageLog;
    }

    public String upload(URL[] uRLArray) {
        return this.upload(uRLArray, false);
    }

    public String upload(URL[] uRLArray, boolean bl) {
        Upload upload;
        String string = uRLArray[1].getProtocol();
        if ("file".equals(string)) {
            upload = new FileUpload();
        } else if ("http".equals(string) || "https".equals(string)) {
            upload = new DAVUpload();
        } else if ("ftp".equals(string)) {
            upload = new FTPUpload();
        } else {
            return Msg.msg("protocolNotSupported", string);
        }
        return this.upload(upload, uRLArray, bl);
    }

    public String upload(Upload upload, URL[] uRLArray) {
        return this.upload(upload, uRLArray, false);
    }

    public String upload(final Upload upload, final URL[] uRLArray, final boolean bl) {
        upload.setInvoker(this);
        this.messages.setText("");
        this.canceled = false;
        this.cancelButton.setEnabled(true);
        this.done = false;
        final String[] stringArray = new String[1];
        this.pack();
        this.setLocationRelativeTo(this.dialogAnchor);
        this.monitorTimer = new Timer(250, this);
        this.monitorTimer.setRepeats(true);
        this.monitorTimer.setCoalesce(true);
        this.monitorTimer.start();
        Thread thread = new Thread(){

            public void run() {
                stringArray[0] = upload.upload(uRLArray, bl);
                UploadDialog.this.done = true;
            }
        };
        thread.start();
        this.setVisible(true);
        this.monitorTimer.stop();
        this.monitorTimer = null;
        return stringArray[0];
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.monitorTimer) {
            this.monitor();
        } else {
            this.cancel();
        }
    }

    private void monitor() {
        if (this.done && this.isShowing()) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void cancel() {
        this.canceled = true;
        if (this.cancelButton.isEnabled()) {
            this.cancelButton.setEnabled(false);
            String string = Msg.msg("tryingToCancel");
            this.messages.append(string + "\n");
            if (this.messageLog != null) {
                Log.log(this.messageLog, string);
            }
        }
    }

    public void beginUpload() {
    }

    public void endUpload() {
    }

    public boolean uploading(URL uRL, URL uRL2, int n, int n2) {
        String string = Upload.uploadingMessage(uRL, uRL2, n, n2);
        return this.showMessage(string);
    }

    public boolean missingSource(URL uRL) {
        String string = Upload.missingSourceMessage(uRL);
        return this.showMessage(string);
    }

    private boolean showMessage(final String string) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    UploadDialog.this.messages.append(string + "\n");
                    if (UploadDialog.this.messageLog != null) {
                        Log.log(UploadDialog.this.messageLog, string);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return !this.canceled;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

