/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.urlchooser;

import HTTPClient.ModuleException;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLPathUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmleditapp.upload.DAVClient;
import com.xmlmind.xmleditapp.upload.DAVException;
import com.xmlmind.xmleditapp.upload.DAVLock;
import com.xmlmind.xmleditapp.upload.DAVProperties;
import com.xmlmind.xmleditapp.urlchooser.DirectoryLister;
import com.xmlmind.xmleditapp.urlchooser.FileInfo;
import com.xmlmind.xmleditapp.urlchooser.Msg;
import java.io.IOException;
import java.net.URL;

public class DAVLister
extends DirectoryLister {
    private DAVClient davClient;
    private String nonDAVRawPath;

    public DAVLister(URL uRL) throws IOException, ModuleException, DAVException {
        super(uRL);
        int n;
        int n2 = uRL.getPort();
        if (n2 < 0) {
            n2 = uRL.getDefaultPort();
        }
        this.davClient = new DAVClient(uRL.getProtocol(), uRL.getHost(), n2);
        boolean bl = false;
        String string = uRL.getPath();
        while (string != null) {
            try {
                n = this.davClient.getDAVLevel(string);
                if (n > 0) {
                    bl = true;
                    break;
                }
            }
            catch (DAVException dAVException) {
                // empty catch block
            }
            string = URLPathUtil.parent(string);
        }
        if (!bl) {
            throw new IOException(Msg.msg("notDAVEnabled", URLUtil.toLabel(uRL)));
        }
        this.nonDAVRawPath = null;
        string = URLPathUtil.parent(string);
        while (string != null) {
            try {
                n = this.davClient.getDAVLevel(string);
            }
            catch (DAVException dAVException) {
                n = 0;
            }
            if (n <= 0) {
                this.nonDAVRawPath = string;
                break;
            }
            string = URLPathUtil.parent(string);
        }
        if (this.nonDAVRawPath != null && !this.nonDAVRawPath.endsWith("/")) {
            this.nonDAVRawPath = this.nonDAVRawPath + '/';
        }
    }

    protected boolean doIsDirectory(String string) throws IOException, ModuleException, DAVException {
        string = URIUtil.quotePath(string);
        DAVProperties[] dAVPropertiesArray = null;
        try {
            dAVPropertiesArray = this.davClient.propfind(string, 0, 0);
        }
        catch (DAVException dAVException) {
            if (!string.endsWith("/")) {
                string = string + '/';
            }
            if (this.nonDAVRawPath != null && this.nonDAVRawPath.startsWith(string)) {
                return true;
            }
            throw dAVException;
        }
        return dAVPropertiesArray.length > 0 && dAVPropertiesArray[0].isCollection;
    }

    protected FileInfo[] doList(String string) throws IOException, ModuleException, DAVException {
        string = URIUtil.quotePath(string);
        FileInfo[] fileInfoArray = null;
        DAVProperties[] dAVPropertiesArray = null;
        try {
            dAVPropertiesArray = this.davClient.propfind(string, 324, 1);
        }
        catch (DAVException dAVException) {
            if (!string.endsWith("/")) {
                string = string + '/';
            }
            if (this.nonDAVRawPath != null && this.nonDAVRawPath.startsWith(string)) {
                String string2 = this.initialURL.getPath();
                string = string2.substring(string.length());
                int n = string.indexOf(47);
                String string3 = n < 0 ? string : string.substring(0, n);
                return new FileInfo[]{new FileInfo(URIUtil.unescape(string3), true, 0L, 0L, null)};
            }
            throw dAVException;
        }
        if (dAVPropertiesArray.length > 0) {
            fileInfoArray = new FileInfo[dAVPropertiesArray.length - 1];
            int n = 0;
            int n2 = 0;
            while (n2 < dAVPropertiesArray.length) {
                DAVProperties dAVProperties = dAVPropertiesArray[n2];
                if (dAVProperties.relativePath.length() == 0) {
                    if (!dAVProperties.isCollection) {
                        return null;
                    }
                } else {
                    long l;
                    String string4 = dAVProperties.relativePath;
                    if (string4.endsWith("/")) {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                    if ((l = dAVProperties.getcontentlength) < 0L) {
                        l = 0L;
                    }
                    long l2 = dAVProperties.getlastmodified == null ? 0L : dAVProperties.getlastmodified.getTime();
                    String string5 = null;
                    DAVLock[] dAVLockArray = dAVProperties.lockdiscovery;
                    if (dAVLockArray != null && dAVLockArray.length > 0) {
                        StringBuffer stringBuffer = new StringBuffer();
                        int n3 = 0;
                        while (n3 < dAVLockArray.length) {
                            String string6 = dAVLockArray[n3].owner;
                            if (string6 == null || (string6 = string6.trim()).length() == 0) {
                                string6 = "???";
                            }
                            if (n3 > 0) {
                                stringBuffer.append('\n');
                            }
                            stringBuffer.append(URIUtil.unescape(string6));
                            ++n3;
                        }
                        if (stringBuffer.length() > 0) {
                            string5 = stringBuffer.toString();
                        }
                    }
                    fileInfoArray[n++] = new FileInfo(URIUtil.unescape(string4), dAVProperties.isCollection, l, l2, string5);
                }
                ++n2;
            }
        }
        return fileInfoArray;
    }

    protected void doDelete(String string) throws Exception {
        string = URIUtil.quotePath(string);
        this.davClient.delete(string);
    }
}

