/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.urlchooser;

import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLPathUtil;
import com.xmlmind.xmleditapp.urlchooser.FileInfo;
import java.net.URL;

public abstract class DirectoryLister {
    protected URL initialURL;

    protected DirectoryLister(URL uRL) {
        this.initialURL = uRL;
    }

    public URL getInitialURL() {
        return this.initialURL;
    }

    public String getInitialDir() {
        String string = URIUtil.unescape(this.initialURL.getPath());
        if (string.endsWith("/") && !string.equals("/")) {
            string = string.substring(0, string.length() - 1);
        }
        while (string != null && !this.isDirectory(string) && !string.equals("/")) {
            string = URLPathUtil.parent(string);
        }
        return string;
    }

    public boolean isDirectory(String string) {
        if (string.endsWith("/") && !string.equals("/")) {
            string = string.substring(0, string.length() - 1);
        }
        boolean bl = false;
        String string2 = null;
        try {
            bl = this.doIsDirectory(string);
        }
        catch (Exception exception) {
            string2 = MiscUtil.reason(exception);
        }
        if (string2 != null) {
            this.trace("cannot check directory '" + string + "': " + string2);
        }
        return bl;
    }

    protected final void trace(String string) {
    }

    public FileInfo[] list(String string) {
        if (string.endsWith("/") && !string.equals("/")) {
            string = string.substring(0, string.length() - 1);
        }
        FileInfo[] fileInfoArray = null;
        String string2 = null;
        try {
            fileInfoArray = this.doList(string);
        }
        catch (Exception exception) {
            string2 = MiscUtil.reason(exception);
        }
        if (string2 != null) {
            this.trace("cannot list directory '" + string + "': " + string2);
        }
        return fileInfoArray;
    }

    public void delete(String string) throws Exception {
        if (string.endsWith("/") && !string.equals("/")) {
            string = string.substring(0, string.length() - 1);
        }
        this.doDelete(string);
    }

    protected abstract boolean doIsDirectory(String var1) throws Exception;

    protected abstract FileInfo[] doList(String var1) throws Exception;

    protected abstract void doDelete(String var1) throws Exception;

    public void dispose() {
    }
}

