/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.urlchooser;

import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmleditapp.upload.FTPClient;
import com.xmlmind.xmleditapp.upload.FTPException;
import com.xmlmind.xmleditapp.urlchooser.DirectoryLister;
import com.xmlmind.xmleditapp.urlchooser.FileInfo;
import java.io.IOException;
import java.net.URL;

public class FTPLister
extends DirectoryLister {
    private FTPClient ftpClient;

    public FTPLister(URL uRL) throws IOException, FTPException {
        super(uRL);
        String string;
        String string2 = uRL.getHost();
        int n = uRL.getPort();
        String string3 = URLUtil.getRawUserName(uRL);
        if (string3 != null) {
            string3 = URIUtil.unescape(string3);
        }
        if ((string = URLUtil.getRawUserPassword(uRL)) != null) {
            string = URIUtil.unescape(string);
        }
        this.ftpClient = new FTPClient(string2, n, string3, string);
    }

    protected boolean doIsDirectory(String string) throws FTPException {
        try {
            this.ftpClient.chdir(string);
        }
        catch (FTPException fTPException) {
            return false;
        }
        this.ftpClient.chdir("/");
        return true;
    }

    protected FileInfo[] doList(String string) throws FTPException {
        if (!this.doIsDirectory(string)) {
            return null;
        }
        FTPClient.DirEntry[] dirEntryArray = this.ftpClient.dirDetails(string);
        FileInfo[] fileInfoArray = new FileInfo[dirEntryArray.length];
        int n = 0;
        while (n < dirEntryArray.length) {
            FTPClient.DirEntry dirEntry = dirEntryArray[n];
            fileInfoArray[n] = new FileInfo(dirEntry.name, dirEntry.isDirectory, dirEntry.length, dirEntry.lastModified, null);
            ++n;
        }
        return fileInfoArray;
    }

    protected void doDelete(String string) throws FTPException {
        this.deleteFile(string);
        this.ftpClient.chdir("/");
    }

    private void deleteFile(String string) throws FTPException {
        String string2 = this.ftpClient.pwd();
        boolean bl = false;
        try {
            this.ftpClient.chdir(string);
            bl = true;
            this.trace("current dir. is now '" + string + "'");
        }
        catch (FTPException fTPException) {
            // empty catch block
        }
        if (bl) {
            String[] stringArray = this.ftpClient.dir();
            int n = 0;
            while (n < stringArray.length) {
                String string3 = stringArray[n];
                if (!".".equals(string3) && !"..".equals(string3)) {
                    this.deleteFile(string3);
                }
                ++n;
            }
            this.ftpClient.chdir(string2);
            this.trace("back to dir. '" + string2 + "'");
            this.trace("removing emptied dir. '" + string + "'");
            this.ftpClient.rmdir(string);
        } else {
            this.trace("deleting file '" + string + "'");
            this.ftpClient.delete(string);
        }
    }

    public void dispose() {
        if (this.ftpClient != null) {
            try {
                this.ftpClient.quit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ftpClient = null;
        }
    }
}

