/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.urlchooser;

import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.DialogBase;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.FilterByExtension;
import com.xmlmind.xmledit.guiutil.PlaceholderIcon;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.util.URLPathUtil;
import com.xmlmind.xmleditapp.urlchooser.DirectoryLister;
import com.xmlmind.xmleditapp.urlchooser.FileInfo;
import com.xmlmind.xmleditapp.urlchooser.Msg;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FileChooserDialog
extends DialogBase
implements MouseListener,
ListSelectionListener,
TableModelListener {
    private JComboBox ancestorCombo;
    private JButton parentButton;
    private DirectoryModel model;
    private JTable table;
    private JLabel nameLabel;
    private JTextField nameField;
    private JComboBox filterCombo;
    private JPopupMenu deleteMenu = null;
    private boolean dirMode = false;
    private boolean saveMode = false;
    private String selected = null;
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$urlchooser$FileChooserDialog;

    public FileChooserDialog(Dialog dialog) {
        super(dialog, "", true);
        this.initialize(dialog);
    }

    public FileChooserDialog(Component component) {
        super(component, "", true);
        this.initialize(component);
    }

    protected void initialize(Component component) {
        super.initialize(component, 146);
        String string = Msg.msg("browseToolTip");
        if (string.endsWith("...")) {
            string = string.substring(0, string.length() - 3);
        }
        this.setTitle(string);
        this.initGlassPane();
    }

    protected Component createForm() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        String string = Msg.msg("lookIn");
        JLabel jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.ancestorCombo = new JComboBox();
        this.ancestorCombo.setActionCommand("ancestor");
        this.ancestorCombo.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.ancestorCombo, gridBagConstraints);
        jLabel.setLabelFor(this.ancestorCombo);
        this.parentButton = new JButton(new ImageIcon((class$com$xmlmind$xmleditapp$urlchooser$FileChooserDialog == null ? (class$com$xmlmind$xmleditapp$urlchooser$FileChooserDialog = FileChooserDialog.class$("com.xmlmind.xmleditapp.urlchooser.FileChooserDialog")) : class$com$xmlmind$xmleditapp$urlchooser$FileChooserDialog).getResource("parentdir.gif")));
        DialogUtil.setIconic(this.parentButton);
        this.parentButton.setToolTipText(Msg.msg("parentToolTip"));
        this.parentButton.setActionCommand("parent");
        this.parentButton.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.parentButton, gridBagConstraints);
        JScrollPane jScrollPane = this.createTable();
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        string = Msg.msg("fileName");
        this.nameLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(this.nameLabel, string);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)this.nameLabel, gridBagConstraints);
        this.nameField = new JTextField(30);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 5;
        jPanel2.add((Component)this.nameField, gridBagConstraints);
        this.nameLabel.setLabelFor(this.nameField);
        string = Msg.msg("filesOfType");
        jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.filterCombo = new JComboBox();
        this.filterCombo.setActionCommand("filter");
        this.filterCombo.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 5;
        jPanel2.add((Component)this.filterCombo, gridBagConstraints);
        jLabel.setLabelFor(this.filterCombo);
        return jPanel;
    }

    private void initGlassPane() {
        Component component = this.getGlassPane();
        component.setCursor(Cursor.getPredefinedCursor(3));
        component.addMouseListener(new MouseAdapter(){});
        component.addMouseMotionListener(new MouseMotionAdapter(){});
        component.addKeyListener(new KeyAdapter(){});
    }

    private void waitCursor(boolean bl) {
        Component component = this.getGlassPane();
        if (bl && !component.isVisible()) {
            component.setVisible(true);
        } else if (!bl && component.isVisible()) {
            component.setVisible(false);
        }
    }

    private JScrollPane createTable() {
        this.model = new DirectoryModel();
        this.model.addTableModelListener(this);
        this.table = new FileTable(this.model);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        this.table.setAutoResizeMode(4);
        this.table.setShowGrid(false);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addMouseListener(this);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        FontMetrics fontMetrics = this.table.getFontMetrics(this.table.getFont());
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        String string = Msg.msg("name");
        tableColumn.setHeaderValue(string);
        int n = Math.max(fontMetrics.stringWidth(string) + 5, 15 + 30 * fontMetrics.charWidth('x'));
        tableColumn.setPreferredWidth(n);
        tableColumn.setCellRenderer(new FileNameRenderer());
        tableColumn = tableColumnModel.getColumn(1);
        string = Msg.msg("size");
        tableColumn.setHeaderValue(string);
        int n2 = Math.max(fontMetrics.stringWidth(string) + 5, 10 * fontMetrics.charWidth('0'));
        tableColumn.setPreferredWidth(n2);
        tableColumn = tableColumnModel.getColumn(2);
        string = Msg.msg("lastModified");
        tableColumn.setHeaderValue(string);
        int n3 = Math.max(fontMetrics.stringWidth(string) + 5, 18 * fontMetrics.charWidth('x'));
        tableColumn.setPreferredWidth(n3);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setPreferredSize(new Dimension(2 + n + 2 + n2 + 2 + n3 + 2, 2 + 10 * (fontMetrics.getHeight() + 2)));
        return jScrollPane;
    }

    public String selectOpenFile(DirectoryLister directoryLister, FileFilter[] fileFilterArray, FileFilter fileFilter) {
        this.dirMode = false;
        this.saveMode = false;
        return this.doSelect(directoryLister, fileFilterArray, fileFilter);
    }

    public String selectSaveFile(DirectoryLister directoryLister, FileFilter[] fileFilterArray, FileFilter fileFilter) {
        this.dirMode = false;
        this.saveMode = true;
        return this.doSelect(directoryLister, fileFilterArray, fileFilter);
    }

    public String selectOpenDirectory(DirectoryLister directoryLister) {
        this.dirMode = true;
        this.saveMode = false;
        return this.doSelect(directoryLister, null, null);
    }

    public String selectSaveDirectory(DirectoryLister directoryLister) {
        this.dirMode = true;
        this.saveMode = true;
        return this.doSelect(directoryLister, null, null);
    }

    private String doSelect(final DirectoryLister directoryLister, FileFilter[] fileFilterArray, FileFilter fileFilter) {
        String string = this.dirMode ? Msg.msg("dirName") : Msg.msg("fileName");
        this.nameLabel.setText(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(this.nameLabel, string);
        this.model.setLister(null);
        this.model.setFilter(fileFilter);
        DefaultComboBoxModel<FileFilter> defaultComboBoxModel = new DefaultComboBoxModel<FileFilter>();
        defaultComboBoxModel.addElement(new AcceptAll());
        if (fileFilterArray != null && fileFilterArray.length > 0) {
            int n = 0;
            while (n < fileFilterArray.length) {
                defaultComboBoxModel.addElement(fileFilterArray[n]);
                ++n;
            }
        }
        if (fileFilter != null) {
            defaultComboBoxModel.setSelectedItem(fileFilter);
        }
        this.filterCombo.setModel(defaultComboBoxModel);
        this.filterCombo.setEnabled(!this.dirMode);
        this.nameField.setText("");
        this.getRootPane().setDefaultButton(this.dialogButtons[0]);
        this.pack();
        this.setLocationRelativeTo(this.dialogAnchor);
        this.nameField.requestFocus();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                FileChooserDialog.this.waitCursor(true);
                try {
                    FileChooserDialog.this.model.setLister(directoryLister);
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    FileChooserDialog.this.waitCursor(false);
                    throw throwable;
                }
                FileChooserDialog.this.waitCursor(false);
            }
        });
        this.setVisible(true);
        this.model.setLister(null);
        return this.selected;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.ensureRowIsVisible(0);
        String string = this.model.getDirectory();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        String string2 = string;
        while (string2 != null) {
            defaultComboBoxModel.addElement(string2);
            string2 = URLPathUtil.parent(string2);
        }
        this.ancestorCombo.setModel(defaultComboBoxModel);
        this.ancestorCombo.setEnabled(defaultComboBoxModel.getSize() > 0);
        this.parentButton.setEnabled(string != null && !string.equals("/"));
    }

    private void ensureRowIsVisible(int n) {
        Rectangle rectangle = this.table.getCellRect(n, 0, true);
        if (rectangle.width <= 0) {
            rectangle.width = 1;
        }
        if (rectangle.height <= 0) {
            rectangle.height = 1;
        }
        this.table.scrollRectToVisible(rectangle);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        FileInfo fileInfo = this.getSelectedFileInfo();
        if (fileInfo == null) {
            return;
        }
        if (this.dirMode) {
            if (fileInfo.isDirectory) {
                this.nameField.setText(fileInfo.name);
            } else {
                this.nameField.setText("");
            }
        } else if (fileInfo.isDirectory) {
            this.nameField.setText("");
        } else {
            this.nameField.setText(fileInfo.name);
        }
    }

    private FileInfo getSelectedFileInfo() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return null;
        }
        return this.model.getFileInfo(n);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            FileInfo fileInfo = this.getSelectedFileInfo();
            if (fileInfo == null) {
                return;
            }
            if (fileInfo.isDirectory) {
                this.setDirectory(this.absolutePath(fileInfo.name));
            } else if (!this.dirMode) {
                this.ok();
            }
        }
    }

    private String absolutePath(String string) {
        String string2 = this.model.getDirectory();
        if (string2 == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        if (!string2.endsWith("/")) {
            stringBuffer.append('/');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.showDeleteMenu(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.showDeleteMenu(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void showDeleteMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            FileInfo fileInfo;
            Point point = mouseEvent.getPoint();
            int n = this.table.rowAtPoint(point);
            if (n >= 0 && this.table.getSelectedRow() != n) {
                this.table.changeSelection(n, 0, false, false);
            }
            FileInfo fileInfo2 = fileInfo = n >= 0 ? this.model.getFileInfo(n) : null;
            if (this.deleteMenu == null) {
                this.deleteMenu = new JPopupMenu();
                JMenuItem jMenuItem = this.deleteMenu.add(Msg.msg("delete"));
                jMenuItem.addActionListener(this);
                jMenuItem.setActionCommand("deleteFile");
            }
            boolean bl = fileInfo != null && fileInfo.lockOwner == null;
            ((JMenuItem)this.deleteMenu.getComponent(0)).setEnabled(bl);
            this.deleteMenu.show(this.table, point.x, point.y);
        }
    }

    public void deleteFile() {
        int n = this.table.getSelectedRow();
        if (n >= 0) {
            int n2;
            FileInfo fileInfo = this.model.getFileInfo(n);
            if (fileInfo.isDirectory && (n2 = JOptionPane.showConfirmDialog(this, Msg.msg("confirmDeleteDir", fileInfo.name), Msg.msg("confirm"), 2)) != 0) {
                return;
            }
            String string = this.absolutePath(fileInfo.name);
            try {
                this.model.getLister().delete(string);
            }
            catch (Exception exception) {
                Alert.showError(this, Msg.msg("cannotDeleteFile", fileInfo.name, MiscUtil.reason(exception)));
            }
            this.model.update();
            this.nameField.setText("");
            this.ensureRowIsVisible(n);
        }
    }

    public void ancestor() {
        String string = (String)this.ancestorCombo.getSelectedItem();
        if (string == null) {
            return;
        }
        this.setDirectory(string);
    }

    public void parent() {
        String string = this.model.getDirectory();
        if (string == null || string.equals("/")) {
            return;
        }
        this.setDirectory(URLPathUtil.parent(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDirectory(String string) {
        this.waitCursor(true);
        try {
            this.model.setDirectory(string);
            Object var3_2 = null;
            this.waitCursor(false);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.waitCursor(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter() {
        FileFilter fileFilter = (FileFilter)this.filterCombo.getSelectedItem();
        if (fileFilter == null) {
            return;
        }
        this.waitCursor(true);
        try {
            this.model.setFilter(fileFilter);
            Object var3_2 = null;
            this.waitCursor(false);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.waitCursor(false);
            throw throwable;
        }
    }

    public void ok() {
        boolean bl;
        FileInfo fileInfo;
        String string = this.nameField.getText();
        if (string.length() == 0 && !this.dirMode && (fileInfo = this.getSelectedFileInfo()) != null && fileInfo.isDirectory) {
            this.setDirectory(this.absolutePath(fileInfo.name));
            return;
        }
        if ((string = string.trim()).length() == 0) {
            DialogUtil.badField(this.nameField);
            return;
        }
        FileInfo fileInfo2 = this.model.getFileInfo(string);
        if (this.dirMode) {
            bl = this.saveMode ? fileInfo2 == null || fileInfo2.isDirectory : fileInfo2 != null && fileInfo2.isDirectory;
        } else if (this.saveMode) {
            bl = fileInfo2 == null || !fileInfo2.isDirectory;
        } else {
            boolean bl2 = bl = fileInfo2 != null && !fileInfo2.isDirectory;
        }
        if (!bl) {
            DialogUtil.badField(this.nameField);
            return;
        }
        this.selected = this.absolutePath(string);
        this.setVisible(false);
        this.dispose();
    }

    public void cancel() {
        this.selected = null;
        this.setVisible(false);
        this.dispose();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class FileNameRenderer
    extends DefaultTableCellRenderer {
        public ImageIcon dirIcon = new ImageIcon((class$com$xmlmind$xmleditapp$urlchooser$FileChooserDialog == null ? (class$com$xmlmind$xmleditapp$urlchooser$FileChooserDialog = FileChooserDialog.class$("com.xmlmind.xmleditapp.urlchooser.FileChooserDialog")) : class$com$xmlmind$xmleditapp$urlchooser$FileChooserDialog).getResource("dir.gif"));
        public Icon fileIcon = new PlaceholderIcon(this.dirIcon.getIconWidth(), this.dirIcon.getIconHeight());
        public ImageIcon lockedDirIcon = new ImageIcon((class$com$xmlmind$xmleditapp$urlchooser$FileChooserDialog == null ? (class$com$xmlmind$xmleditapp$urlchooser$FileChooserDialog = FileChooserDialog.class$("com.xmlmind.xmleditapp.urlchooser.FileChooserDialog")) : class$com$xmlmind$xmleditapp$urlchooser$FileChooserDialog).getResource("lockeddir.gif"));
        public ImageIcon lockedFileIcon = new ImageIcon((class$com$xmlmind$xmleditapp$urlchooser$FileChooserDialog == null ? (class$com$xmlmind$xmleditapp$urlchooser$FileChooserDialog = FileChooserDialog.class$("com.xmlmind.xmleditapp.urlchooser.FileChooserDialog")) : class$com$xmlmind$xmleditapp$urlchooser$FileChooserDialog).getResource("lockedfile.gif"));

        public FileNameRenderer() {
            this.setIconTextGap(2);
            this.setHorizontalTextPosition(11);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            DirectoryModel directoryModel = (DirectoryModel)jTable.getModel();
            FileInfo fileInfo = directoryModel.getFileInfo(n);
            Icon icon = fileInfo.isDirectory ? (fileInfo.lockOwner == null ? this.dirIcon : this.lockedDirIcon) : (fileInfo.lockOwner == null ? this.fileIcon : this.lockedFileIcon);
            this.setIcon(icon);
            return this;
        }
    }

    private static final class FileInfoComparator
    implements Comparator {
        private FileInfoComparator() {
        }

        public int compare(Object object, Object object2) {
            FileInfo fileInfo = (FileInfo)object;
            FileInfo fileInfo2 = (FileInfo)object2;
            if (fileInfo.isDirectory != fileInfo2.isDirectory) {
                return fileInfo.isDirectory ? Integer.MIN_VALUE : Integer.MAX_VALUE;
            }
            return fileInfo.name.compareTo(fileInfo2.name);
        }
    }

    private static final class DirectoryModel
    extends AbstractTableModel {
        private static final FileInfo[] NO_FILES = new FileInfo[0];
        private DirectoryLister lister;
        private String curDir;
        private FileInfo[] allFiles = NO_FILES;
        private FileInfo[] displayedFiles = NO_FILES;
        private FileFilter filter;
        private String fileNameSuffix;

        private DirectoryModel() {
        }

        public void setLister(DirectoryLister directoryLister) {
            this.lister = directoryLister;
            this.curDir = directoryLister != null ? directoryLister.getInitialDir() : null;
            this.update();
        }

        public DirectoryLister getLister() {
            return this.lister;
        }

        public void setDirectory(String string) {
            this.curDir = string;
            this.update();
        }

        public String getDirectory() {
            return this.curDir;
        }

        public void setFilter(FileFilter fileFilter) {
            this.filter = fileFilter;
            this.fileNameSuffix = fileFilter != null && fileFilter instanceof FilterByExtension ? ((FilterByExtension)fileFilter).getFileNameSuffix() : null;
            this.update();
        }

        public FileFilter getFilter() {
            return this.filter;
        }

        public void update() {
            if (this.lister == null || this.curDir == null) {
                this.allFiles = NO_FILES;
                this.displayedFiles = NO_FILES;
            } else {
                this.allFiles = this.lister.list(this.curDir);
                if (this.allFiles == null) {
                    this.allFiles = NO_FILES;
                }
                this.displayedFiles = this.allFiles;
                if (this.fileNameSuffix != null && this.displayedFiles.length > 0) {
                    ArrayList<FileInfo> arrayList = new ArrayList<FileInfo>();
                    int n = 0;
                    while (n < this.displayedFiles.length) {
                        FileInfo fileInfo = this.displayedFiles[n];
                        if (fileInfo.isDirectory || fileInfo.name.toLowerCase().endsWith(this.fileNameSuffix)) {
                            arrayList.add(fileInfo);
                        }
                        ++n;
                    }
                    this.displayedFiles = new FileInfo[arrayList.size()];
                    arrayList.toArray(this.displayedFiles);
                }
                if (this.displayedFiles.length > 1) {
                    Arrays.sort(this.displayedFiles, new FileInfoComparator());
                }
            }
            this.fireTableDataChanged();
        }

        public FileInfo getFileInfo(int n) {
            return this.displayedFiles[n];
        }

        public FileInfo getFileInfo(String string) {
            int n = 0;
            while (n < this.allFiles.length) {
                FileInfo fileInfo = this.allFiles[n];
                if (fileInfo.name.equals(string)) {
                    return fileInfo;
                }
                ++n;
            }
            return null;
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return this.displayedFiles.length;
        }

        public Object getValueAt(int n, int n2) {
            FileInfo fileInfo = this.displayedFiles[n];
            switch (n2) {
                case 1: {
                    return new Long(fileInfo.length);
                }
                case 2: {
                    return DateFormat.getDateTimeInstance(3, 3).format(new Date(fileInfo.lastModified));
                }
            }
            return fileInfo.name;
        }
    }

    private static final class FileTable
    extends JTable {
        public FileTable(DirectoryModel directoryModel) {
            super(directoryModel);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            if (point.x > 20) {
                return null;
            }
            int n = this.rowAtPoint(point);
            if (n < 0) {
                return null;
            }
            DirectoryModel directoryModel = (DirectoryModel)this.getModel();
            FileInfo fileInfo = directoryModel.getFileInfo(n);
            if (fileInfo.lockOwner == null) {
                return null;
            }
            if (fileInfo.lockOwner.indexOf(10) >= 0) {
                return "<html>" + StringUtil.replaceAll(fileInfo.lockOwner, "\n", "<br>");
            }
            return fileInfo.lockOwner;
        }
    }

    public static final class AcceptAll
    extends FileFilter {
        public boolean accept(File file) {
            return true;
        }

        public String getDescription() {
            return Msg.msg("allFiles");
        }

        public String toString() {
            return this.getDescription();
        }
    }
}

