/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.urlchooser;

import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmleditapp.urlchooser.DirectoryLister;
import com.xmlmind.xmleditapp.urlchooser.FileInfo;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class FileLister
extends DirectoryLister {
    public FileLister(URL uRL) {
        super(uRL);
    }

    protected boolean doIsDirectory(String string) {
        File file = FileLister.urlToFile(string);
        return file.isDirectory();
    }

    private static final File urlToFile(String string) {
        URL uRL;
        string = URIUtil.quotePath(string);
        try {
            uRL = new URL("file://" + string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        return FileUtil.urlToFile(uRL);
    }

    protected FileInfo[] doList(String string) {
        Object object;
        File file = FileLister.urlToFile(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return null;
        }
        ArrayList<FileInfo> arrayList = new ArrayList<FileInfo>();
        int n = 0;
        while (n < fileArray.length) {
            object = fileArray[n];
            String string2 = ((File)object).getName();
            if (!".".equals(string2) && !"..".equals(string2)) {
                arrayList.add(new FileInfo(string2, ((File)object).isDirectory(), ((File)object).length(), ((File)object).lastModified(), null));
            }
            ++n;
        }
        object = new FileInfo[arrayList.size()];
        return (FileInfo[])arrayList.toArray((T[])object);
    }

    protected void doDelete(String string) throws Exception {
        File file = FileLister.urlToFile(string);
        if (!FileUtil.removeFile(file, true)) {
            throw new IOException("'" + file + "' cannot be deleted");
        }
    }
}

