/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.urlchooser;

import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.ChooseFile;
import com.xmlmind.xmledit.guiutil.DialogBase;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.FilterByExtension;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmleditapp.urlchooser.DAVLister;
import com.xmlmind.xmleditapp.urlchooser.DirectoryLister;
import com.xmlmind.xmleditapp.urlchooser.FTPLister;
import com.xmlmind.xmleditapp.urlchooser.FileChooserDialog;
import com.xmlmind.xmleditapp.urlchooser.Msg;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class URLChooserDialog
extends DialogBase
implements MouseListener {
    private ButtonGroup protocolGroup;
    private JRadioButton fileToggle;
    private JRadioButton httpToggle;
    private JRadioButton httpsToggle;
    private JButton httpServersButton;
    private JPopupMenu httpServersMenu;
    private JTextField httpServerField;
    private JTextField httpPortField;
    private JRadioButton ftpToggle;
    private JButton ftpServersButton;
    private JPopupMenu ftpServersMenu;
    private JTextField ftpServerField;
    private JTextField ftpPortField;
    private ButtonGroup ftpUserGroup;
    private JRadioButton ftpAnonymousToggle;
    private JRadioButton ftpUserToggle;
    private JTextField ftpUserField;
    private JPasswordField ftpPasswordField;
    private JButton pathsButton;
    private JPopupMenu pathsMenu;
    private JLabel pathLabel;
    private JTextField pathField;
    private boolean dirMode = false;
    private boolean saveMode = false;
    private URL[] lastOpenedFiles = null;
    private URL selected = null;
    private static final int MAX_MENU_ENTRIES = 15;
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$urlchooser$URLChooserDialog;

    public URLChooserDialog(Component component) {
        this(component, false);
    }

    public URLChooserDialog(Component component, boolean bl) {
        super(component, "", true);
        int n = 26;
        if (bl) {
            n |= 0x40;
        }
        this.initialize(component, n);
    }

    protected Component createForm() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 17;
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 4, 0));
        jPanel2.setBorder(new CompoundBorder(LineBorder.createGrayLineBorder(), new EmptyBorder(2, 2, 2, 2)));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new CompoundBorder(LineBorder.createGrayLineBorder(), new EmptyBorder(2, 2, 2, 2)));
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(new CompoundBorder(LineBorder.createGrayLineBorder(), new EmptyBorder(2, 2, 2, 2)));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 15;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        String string = Msg.msg("file");
        this.fileToggle = new JRadioButton(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.fileToggle, string);
        this.fileToggle.setActionCommand("setProtocol");
        this.fileToggle.addActionListener(this);
        jPanel2.add((Component)this.fileToggle, (Object)this.fileToggle);
        this.protocolGroup = new ButtonGroup();
        this.protocolGroup.add(this.fileToggle);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.right = 2;
        gridBagConstraints.anchor = 17;
        JPanel jPanel6 = new JPanel(new FlowLayout(0, 2, 0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        jPanel3.add((Component)jPanel6, gridBagConstraints);
        string = Msg.msg("http");
        this.httpToggle = new JRadioButton(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.httpToggle, string);
        this.httpToggle.setActionCommand("setProtocol");
        this.httpToggle.addActionListener(this);
        jPanel6.add(this.httpToggle);
        this.protocolGroup.add(this.httpToggle);
        string = Msg.msg("https");
        this.httpsToggle = new JRadioButton(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.httpsToggle, string);
        this.httpsToggle.setActionCommand("setProtocol");
        this.httpsToggle.addActionListener(this);
        jPanel6.add(this.httpsToggle);
        this.protocolGroup.add(this.httpsToggle);
        ImageIcon imageIcon = new ImageIcon((class$com$xmlmind$xmleditapp$urlchooser$URLChooserDialog == null ? (class$com$xmlmind$xmleditapp$urlchooser$URLChooserDialog = URLChooserDialog.class$("com.xmlmind.xmleditapp.urlchooser.URLChooserDialog")) : class$com$xmlmind$xmleditapp$urlchooser$URLChooserDialog).getResource("list.gif"));
        String string2 = Msg.msg("listToolTip");
        this.httpServersButton = new JButton(imageIcon);
        DialogUtil.setIconic(this.httpServersButton);
        this.httpServersButton.setToolTipText(string2);
        this.httpServersButton.addMouseListener(this);
        jPanel6.add(this.httpServersButton);
        string = Msg.msg("httpServer");
        JLabel jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.bottom = 2;
        jPanel3.add((Component)jLabel, gridBagConstraints);
        this.httpServerField = new JTextField(15);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 3.0;
        jPanel3.add((Component)this.httpServerField, gridBagConstraints);
        jLabel.setLabelFor(this.httpServerField);
        string = Msg.msg("httpPort");
        jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel3.add((Component)jLabel, gridBagConstraints);
        this.httpPortField = new JTextField(5);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)this.httpPortField, gridBagConstraints);
        jLabel.setLabelFor(this.httpPortField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.right = 2;
        gridBagConstraints.anchor = 17;
        JPanel jPanel7 = new JPanel(new FlowLayout(0, 2, 0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        jPanel4.add((Component)jPanel7, gridBagConstraints);
        string = Msg.msg("ftp");
        this.ftpToggle = new JRadioButton(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.ftpToggle, string);
        this.ftpToggle.setActionCommand("setProtocol");
        this.ftpToggle.addActionListener(this);
        jPanel7.add(this.ftpToggle);
        this.protocolGroup.add(this.ftpToggle);
        this.ftpServersButton = new JButton(imageIcon);
        DialogUtil.setIconic(this.ftpServersButton);
        this.ftpServersButton.setToolTipText(string2);
        this.ftpServersButton.addMouseListener(this);
        jPanel7.add(this.ftpServersButton);
        string = Msg.msg("ftpServer");
        jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.bottom = 2;
        jPanel4.add((Component)jLabel, gridBagConstraints);
        this.ftpServerField = new JTextField(15);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 3.0;
        jPanel4.add((Component)this.ftpServerField, gridBagConstraints);
        jLabel.setLabelFor(this.ftpServerField);
        string = Msg.msg("ftpPort");
        jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel4.add((Component)jLabel, gridBagConstraints);
        this.ftpPortField = new JTextField(5);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel4.add((Component)this.ftpPortField, gridBagConstraints);
        jLabel.setLabelFor(this.ftpPortField);
        JPanel jPanel8 = new JPanel(new GridBagLayout());
        jPanel8.setBorder(new TitledBorder(Msg.msg("login")));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 4;
        jPanel4.add((Component)jPanel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.right = 2;
        gridBagConstraints.anchor = 17;
        string = Msg.msg("anonymous");
        this.ftpAnonymousToggle = new JRadioButton(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.ftpAnonymousToggle, string);
        this.ftpAnonymousToggle.setActionCommand("setFTPUser");
        this.ftpAnonymousToggle.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        jPanel8.add((Component)this.ftpAnonymousToggle, gridBagConstraints);
        this.ftpUserGroup = new ButtonGroup();
        this.ftpUserGroup.add(this.ftpAnonymousToggle);
        string = Msg.msg("user");
        this.ftpUserToggle = new JRadioButton(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.ftpUserToggle, string);
        this.ftpUserToggle.setActionCommand("setFTPUser");
        this.ftpUserToggle.addActionListener(this);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.bottom = 2;
        jPanel8.add((Component)this.ftpUserToggle, gridBagConstraints);
        this.ftpUserGroup.add(this.ftpUserToggle);
        this.ftpUserField = new JTextField(15);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel8.add((Component)this.ftpUserField, gridBagConstraints);
        string = Msg.msg("password");
        jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel8.add((Component)jLabel, gridBagConstraints);
        this.ftpPasswordField = new JPasswordField(15);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel8.add((Component)this.ftpPasswordField, gridBagConstraints);
        jLabel.setLabelFor(this.ftpPasswordField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.right = 2;
        JPanel jPanel9 = new JPanel(new FlowLayout(0, 2, 0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel5.add((Component)jPanel9, gridBagConstraints);
        string = Msg.msg("fileName");
        this.pathLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(this.pathLabel, string);
        jPanel9.add(this.pathLabel);
        this.pathsButton = new JButton(imageIcon);
        DialogUtil.setIconic(this.pathsButton);
        this.pathsButton.setToolTipText(string2);
        this.pathsButton.addMouseListener(this);
        jPanel9.add(this.pathsButton);
        JButton jButton = new JButton(new ImageIcon((class$com$xmlmind$xmleditapp$urlchooser$URLChooserDialog == null ? (class$com$xmlmind$xmleditapp$urlchooser$URLChooserDialog = URLChooserDialog.class$("com.xmlmind.xmleditapp.urlchooser.URLChooserDialog")) : class$com$xmlmind$xmleditapp$urlchooser$URLChooserDialog).getResource("browse.gif")));
        DialogUtil.setIconic(jButton);
        jButton.setToolTipText(Msg.msg("browseToolTip"));
        jButton.setActionCommand("browse");
        jButton.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        jPanel5.add((Component)jButton, gridBagConstraints);
        this.pathField = new JTextField(40);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.bottom = 2;
        gridBagConstraints.anchor = 17;
        jPanel5.add((Component)this.pathField, gridBagConstraints);
        this.pathLabel.setLabelFor(this.pathField);
        return jPanel;
    }

    public URL selectOpenFile(URL uRL) {
        return this.selectOpenFile(uRL != null ? URLUtil.getDirectory(uRL) : null, null);
    }

    public URL selectSaveFile(URL uRL) {
        if (uRL != null) {
            String string = URLUtil.getRawBaseName(uRL);
            if (string.length() == 0) {
                string = null;
            }
            return this.selectSaveFile(URLUtil.getDirectory(uRL), string, null);
        }
        return this.selectSaveFile(null, null, null);
    }

    public URL selectOpenDirectory(URL uRL) {
        return this.selectOpenDirectory(uRL != null ? URLUtil.getDirectory(uRL) : null, null);
    }

    public URL selectSaveDirectory(URL uRL) {
        if (uRL != null) {
            String string = URLUtil.getRawBaseName(uRL);
            if (string.length() == 0) {
                string = null;
            }
            return this.selectSaveDirectory(URLUtil.getDirectory(uRL), string, null);
        }
        return this.selectSaveDirectory(null, null, null);
    }

    public URL selectOpenFile(URL uRL, URL[] uRLArray) {
        this.dirMode = false;
        this.saveMode = false;
        return this.doSelect(uRL, null, uRLArray);
    }

    public URL selectSaveFile(URL uRL, String string, URL[] uRLArray) {
        this.dirMode = false;
        this.saveMode = true;
        return this.doSelect(uRL, string, uRLArray);
    }

    public URL selectOpenDirectory(URL uRL, URL[] uRLArray) {
        this.dirMode = true;
        this.saveMode = false;
        return this.doSelect(uRL, null, uRLArray);
    }

    public URL selectSaveDirectory(URL uRL, String string, URL[] uRLArray) {
        this.dirMode = true;
        this.saveMode = true;
        return this.doSelect(uRL, string, uRLArray);
    }

    private URL doSelect(URL uRL, String string, URL[] uRLArray) {
        Serializable serializable;
        block21: {
            this.setTitle(ChooseFile.getChooserTitle(this.dirMode, this.saveMode));
            String string2 = this.dirMode ? Msg.msg("dirName") : Msg.msg("fileName");
            this.pathLabel.setText(DialogUtil.buttonLabel(string2));
            DialogUtil.setDisplayedMnemonic(this.pathLabel, string2);
            this.lastOpenedFiles = uRLArray;
            this.httpServersMenu = null;
            this.ftpServersMenu = null;
            this.pathsMenu = null;
            this.pathsButton.setEnabled(false);
            if (uRLArray == null) break block21;
            serializable = new ArrayList();
            ArrayList<ServerMenuAction> arrayList = new ArrayList<ServerMenuAction>();
            ArrayList<PathMenuAction> arrayList2 = new ArrayList<PathMenuAction>();
            int n = 0;
            while (n < uRLArray.length) {
                block25: {
                    URL uRL2;
                    block23: {
                        String string3;
                        block24: {
                            ServerMenuAction serverMenuAction;
                            block22: {
                                uRL2 = uRLArray[n];
                                if (this.dirMode) {
                                    uRL2 = URLUtil.getDirectory(uRL2);
                                }
                                if (!"http".equals(string3 = uRL2.getProtocol()) && !"https".equals(string3)) break block22;
                                serverMenuAction = new ServerMenuAction(uRL2);
                                if (!((ArrayList)serializable).contains(serverMenuAction)) {
                                    ((ArrayList)serializable).add(serverMenuAction);
                                }
                                break block23;
                            }
                            if (!"ftp".equals(string3)) break block24;
                            serverMenuAction = new ServerMenuAction(uRL2);
                            if (!arrayList.contains(serverMenuAction)) {
                                arrayList.add(serverMenuAction);
                            }
                            break block23;
                        }
                        if (!"file".equals(string3)) break block25;
                    }
                    arrayList2.add(new PathMenuAction(uRL2));
                }
                ++n;
            }
            int n2 = ((ArrayList)serializable).size();
            if (n2 > 0) {
                if (n2 > 15) {
                    URLChooserDialog.limitSize((ArrayList)serializable, 15);
                    n2 = 15;
                }
                this.httpServersMenu = new JPopupMenu();
                int n3 = 0;
                while (n3 < n2) {
                    this.httpServersMenu.add((Action)((ArrayList)serializable).get(n3));
                    ++n3;
                }
            }
            if ((n2 = arrayList.size()) > 0) {
                if (n2 > 15) {
                    URLChooserDialog.limitSize(arrayList, 15);
                    n2 = 15;
                }
                this.ftpServersMenu = new JPopupMenu();
                int n4 = 0;
                while (n4 < n2) {
                    this.ftpServersMenu.add((Action)arrayList.get(n4));
                    ++n4;
                }
            }
            if ((n2 = arrayList2.size()) > 0) {
                if (n2 > 15) {
                    URLChooserDialog.limitSize(arrayList2, 15);
                    n2 = 15;
                }
                this.pathsMenu = new JPopupMenu();
                int n5 = 0;
                while (n5 < n2) {
                    this.pathsMenu.add((Action)arrayList2.get(n5));
                    ++n5;
                }
                this.pathsButton.setEnabled(true);
            }
        }
        if (uRL == null) {
            uRL = URLChooserDialog.getDefaultDir();
        }
        serializable = uRL;
        if (string != null) {
            try {
                serializable = new URL(uRL, string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.setPath((URL)serializable);
        this.getRootPane().setDefaultButton(this.dialogButtons[0]);
        this.pack();
        this.setLocationRelativeTo(this.dialogAnchor);
        this.pathField.requestFocus();
        this.setVisible(true);
        return this.selected;
    }

    private static final void limitSize(ArrayList arrayList, int n) {
        int n2 = arrayList.size() - 1;
        while (n2 >= n) {
            arrayList.remove(n2);
            --n2;
        }
    }

    private static final URL getDefaultDir() {
        String string = System.getProperty("user.home");
        if (string == null) {
            string = ".";
        }
        return FileUtil.fileToURL(string);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        JButton jButton = (JButton)mouseEvent.getSource();
        if (!jButton.isEnabled()) {
            return;
        }
        JPopupMenu jPopupMenu = null;
        if (jButton == this.httpServersButton) {
            jPopupMenu = this.httpServersMenu;
        } else if (jButton == this.ftpServersButton) {
            jPopupMenu = this.ftpServersMenu;
        } else if (jButton == this.pathsButton) {
            jPopupMenu = this.pathsMenu;
        }
        if (jPopupMenu != null) {
            jPopupMenu.show(jButton, 0, jButton.getHeight());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void setProtocol() {
        String string = null;
        if (this.fileToggle.isSelected()) {
            string = "file";
        } else if (this.httpToggle.isSelected()) {
            string = "http";
        } else if (this.httpsToggle.isSelected()) {
            string = "https";
        } else if (this.ftpToggle.isSelected()) {
            string = "ftp";
        }
        if (string != null) {
            this.setProtocol(string);
        }
    }

    private void setProtocol(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if ("file".equals(string)) {
            this.fileToggle.setSelected(true);
        } else if ("http".equals(string)) {
            this.httpToggle.setSelected(true);
            bl = true;
        } else if ("https".equals(string)) {
            this.httpsToggle.setSelected(true);
            bl = true;
            bl3 = true;
        } else if ("ftp".equals(string)) {
            this.ftpToggle.setSelected(true);
            bl2 = true;
        }
        this.httpServersButton.setEnabled(bl && this.httpServersMenu != null);
        this.httpServerField.setText("");
        this.httpServerField.setEnabled(bl);
        this.httpPortField.setText(bl ? (bl3 ? "443" : "80") : "");
        this.httpPortField.setEnabled(bl);
        this.ftpServersButton.setEnabled(bl2 && this.ftpServersMenu != null);
        this.ftpServerField.setText("");
        this.ftpServerField.setEnabled(bl2);
        this.ftpPortField.setText(bl2 ? "21" : "");
        this.ftpPortField.setEnabled(bl2);
        this.ftpUserToggle.setSelected(bl2);
        this.ftpAnonymousToggle.setSelected(!bl2);
        this.setFTPUser();
        this.ftpUserToggle.setEnabled(bl2);
        this.ftpAnonymousToggle.setEnabled(bl2);
        this.ftpUserField.setEnabled(bl2);
        this.ftpPasswordField.setEnabled(bl2);
        this.setDefaultPath(string);
    }

    public void setFTPUser() {
        boolean bl = this.ftpUserToggle.isSelected();
        String string = System.getProperty("user.name");
        if (string == null) {
            string = "";
        }
        this.ftpUserField.setText(bl ? string : "");
        this.ftpUserField.setEnabled(bl);
        this.ftpPasswordField.setText("");
        this.ftpPasswordField.setEnabled(bl);
    }

    private void setDefaultPath(String string) {
        String string2 = "file".equals(string) ? URLChooserDialog.getDefaultDir().getPath() : "/";
        this.setRawPath(string2);
    }

    private void setServer(URL uRL) {
        String string = uRL.getProtocol();
        boolean bl = "https".equals(string);
        if ("http".equals(string) || bl) {
            this.httpToggle.setSelected(!bl);
            this.httpsToggle.setSelected(bl);
            this.httpServerField.setText(uRL.getHost());
            int n = uRL.getPort();
            if (n < 0) {
                n = uRL.getDefaultPort();
            }
            this.httpPortField.setText(Integer.toString(n));
        } else if ("ftp".equals(string)) {
            this.ftpServerField.setText(uRL.getHost());
            int n = uRL.getPort();
            if (n < 0) {
                n = uRL.getDefaultPort();
            }
            this.ftpPortField.setText(Integer.toString(n));
            String string2 = URLUtil.getRawUserName(uRL);
            boolean bl2 = string2 != null;
            this.ftpUserToggle.setSelected(bl2);
            this.ftpAnonymousToggle.setSelected(!bl2);
            this.setFTPUser();
            if (bl2) {
                String string3 = URLUtil.getRawUserPassword(uRL);
                this.setRawFTPUser(string2);
                this.setRawFTPPassword(string3);
            }
        }
        this.setDefaultPath(string);
    }

    private void setPath(URL uRL) {
        this.setProtocol(uRL.getProtocol());
        this.setServer(uRL);
        this.setRawPath(uRL.getPath());
    }

    private void setRawFTPUser(String string) {
        this.ftpUserField.setText(string == null ? "" : URIUtil.unescape(string));
    }

    private String getRawFTPUser() {
        return URIUtil.quoteUserInfo(this.ftpUserField.getText().trim());
    }

    private void setRawFTPPassword(String string) {
        this.ftpPasswordField.setText(string == null ? "" : URIUtil.unescape(string));
    }

    private String getRawFTPPassword() {
        return URIUtil.quoteUserInfo(new String(this.ftpPasswordField.getPassword()));
    }

    private void setRawPath(String string) {
        this.pathField.setText(string == null ? "" : URIUtil.unescape(string));
    }

    private String getRawPath() {
        return URIUtil.quotePath(this.pathField.getText().trim());
    }

    public void browse() {
        Object object;
        URL uRL = this.getSelectedURL();
        if (uRL == null) {
            return;
        }
        ArrayList<Object> arrayList = null;
        Object object2 = null;
        if (this.lastOpenedFiles != null) {
            arrayList = new ArrayList<Object>();
            object = FilterByExtension.create(uRL);
            if (object != null) {
                arrayList.add(object);
                object2 = object;
            }
            int n = 0;
            while (n < this.lastOpenedFiles.length) {
                object = FilterByExtension.create(this.lastOpenedFiles[n]);
                if (object != null && !arrayList.contains(object)) {
                    arrayList.add(object);
                    if (object2 == null) {
                        object2 = object;
                    }
                }
                ++n;
            }
            object = new FilterByExtension("xml");
            if (!arrayList.contains(object)) {
                arrayList.add(object);
            }
            if (!this.saveMode) {
                object2 = null;
            }
        }
        if ("http".equals(object = uRL.getProtocol()) || "https".equals(object) || "ftp".equals(object)) {
            String string;
            String string2;
            DirectoryLister directoryLister;
            block22: {
                directoryLister = null;
                string2 = null;
                try {
                    directoryLister = "ftp".equals(object) ? new FTPLister(uRL) : new DAVLister(uRL);
                }
                catch (Exception exception) {
                    string2 = exception.getMessage();
                    if (string2 != null) break block22;
                    string2 = exception.getClass().getName();
                }
            }
            if (string2 != null) {
                Alert.showError(this, Msg.msg("cannotConnectToServer", URLUtil.getRoot(uRL).toExternalForm(), string2));
                return;
            }
            FileChooserDialog fileChooserDialog = new FileChooserDialog(this);
            if (this.dirMode) {
                string = this.saveMode ? fileChooserDialog.selectSaveDirectory(directoryLister) : fileChooserDialog.selectOpenDirectory(directoryLister);
            } else {
                FileFilter[] fileFilterArray = null;
                if (arrayList != null && arrayList.size() > 0) {
                    fileFilterArray = new FileFilter[arrayList.size()];
                    arrayList.toArray(fileFilterArray);
                }
                string = this.saveMode ? fileChooserDialog.selectSaveFile(directoryLister, fileFilterArray, (FileFilter)object2) : fileChooserDialog.selectOpenFile(directoryLister, fileFilterArray, (FileFilter)object2);
            }
            if (string != null) {
                this.pathField.setText(string);
            }
            directoryLister.dispose();
        } else {
            File file;
            int n;
            File file2 = FileUtil.urlToFile(URLUtil.getDirectory(uRL));
            JFileChooser jFileChooser = new JFileChooser(file2);
            String string = Msg.msg("browseToolTip");
            if (string.endsWith("...")) {
                string = string.substring(0, string.length() - 3);
            }
            jFileChooser.setDialogTitle(string);
            if (this.dirMode) {
                jFileChooser.setFileSelectionMode(1);
            } else {
                jFileChooser.setFileSelectionMode(0);
                if (arrayList != null && arrayList.size() > 0) {
                    ChooseFile.addFileFilters(jFileChooser, arrayList, (FileFilter)object2);
                }
            }
            int n2 = n = this.saveMode ? jFileChooser.showSaveDialog(this) : jFileChooser.showOpenDialog(this);
            if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                uRL = FileUtil.fileToURL(file);
                this.setRawPath(uRL.getPath());
            }
        }
    }

    public void ok() {
        this.selected = this.getSelectedURL();
        if (this.selected == null) {
            return;
        }
        if (this.dirMode) {
            if (!this.selected.getPath().endsWith("/")) {
                try {
                    this.selected = new URL(this.selected.toExternalForm() + '/');
                }
                catch (MalformedURLException malformedURLException) {}
            }
        } else if (this.selected.getPath().endsWith("/")) {
            this.selected = null;
            DialogUtil.badField(this.pathField);
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    private URL getSelectedURL() {
        String string;
        String string2 = "file";
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n = -1;
        int n2 = -1;
        if (this.httpToggle.isSelected() || this.httpsToggle.isSelected()) {
            if (this.httpsToggle.isSelected()) {
                string2 = "https";
                n2 = 443;
            } else {
                string2 = "http";
                n2 = 80;
            }
            string5 = this.checkHostField(this.httpServerField);
            if (string5 == null) {
                return null;
            }
            n = this.checkPortField(this.httpPortField, n2);
            if (n < 0) {
                return null;
            }
        } else if (this.ftpToggle.isSelected()) {
            string2 = "ftp";
            n2 = 21;
            string5 = this.checkHostField(this.ftpServerField);
            if (string5 == null) {
                return null;
            }
            n = this.checkPortField(this.ftpPortField, n2);
            if (n < 0) {
                return null;
            }
            if (this.ftpUserToggle.isSelected()) {
                string3 = this.getRawFTPUser();
                if (string3.length() == 0) {
                    DialogUtil.badField(this.ftpUserField);
                    return null;
                }
                string4 = this.getRawFTPPassword();
                if (string4.length() == 0) {
                    DialogUtil.badField(this.ftpPasswordField);
                    return null;
                }
            }
        }
        if ((string = this.getRawPath()).length() == 0 || !string.startsWith("/")) {
            DialogUtil.badField(this.pathField);
            return null;
        }
        String string6 = URIUtil.joinQuotedComponents(string2, string3, string4, string5, n != n2 ? n : -1, string, null, null);
        URL uRL = null;
        try {
            uRL = new URL(string6);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL == null) {
            Alert.showError(this, Msg.msg("malformedURL", string6));
        }
        return uRL;
    }

    private String checkHostField(JTextField jTextField) {
        String string = jTextField.getText().trim();
        if (string.length() == 0) {
            DialogUtil.badField(jTextField);
            return null;
        }
        String string2 = null;
        try {
            InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            string2 = MiscUtil.reason(unknownHostException);
        }
        if (string2 != null) {
            Alert.showError(this, Msg.msg("badHost", string, string2));
            DialogUtil.badField(jTextField);
            return null;
        }
        return string;
    }

    private int checkPortField(JTextField jTextField, int n) {
        String string = jTextField.getText().trim();
        if (string.length() == 0) {
            return n;
        }
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n2 <= 0 || n2 > 65535) {
            Alert.showError(this, Msg.msg("badPort", string));
            DialogUtil.badField(jTextField);
            return -1;
        }
        return n2;
    }

    public void cancel() {
        this.selected = null;
        this.setVisible(false);
        this.dispose();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class PathMenuAction
    extends MenuAction {
        public PathMenuAction(URL uRL) {
            super(uRL, URLUtil.toShortDisplayForm(uRL, 40));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            URLChooserDialog.this.setPath(this.url);
        }
    }

    private final class ServerMenuAction
    extends MenuAction {
        public ServerMenuAction(URL uRL) {
            super(uRL, URLUtil.toDisplayForm(URLUtil.getRoot(uRL)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            URLChooserDialog.this.setServer(this.url);
        }
    }

    private abstract class MenuAction
    extends AbstractAction
    implements Comparable {
        protected URL url;
        protected String label;

        public MenuAction(URL uRL, String string) {
            this.url = uRL;
            this.label = string;
            this.putValue("Name", string);
        }

        public int compareTo(Object object) {
            if (object == null || !(object instanceof MenuAction)) {
                return Integer.MAX_VALUE;
            }
            return this.label.compareTo(((MenuAction)object).label);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof MenuAction)) {
                return false;
            }
            MenuAction menuAction = (MenuAction)object;
            return this.label.equals(menuAction.label);
        }
    }
}

