/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.xmlapputil;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.view.ViewFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;

public class ComponentUtil {
    public static final int getFirstBaseLine(Component component) {
        int n = component.getHeight();
        FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
        int n2 = fontMetrics.getAscent();
        int n3 = n2 + fontMetrics.getDescent();
        return (n - n3) / 2 + n2;
    }

    public static final void addFocusGainedListener(Component component, final Element element, ViewFactory viewFactory) {
        final DocumentView documentView = viewFactory.getDocumentView();
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (focusEvent.isTemporary()) {
                    return;
                }
                if (element.getDocument() == null) {
                    return;
                }
                MarkManager markManager = documentView.getMarkManager();
                if (markManager == null) {
                    return;
                }
                NodeMark nodeMark = markManager.getSelected();
                if (nodeMark == null || nodeMark.getNode() != element) {
                    markManager.beginBatchMarking();
                    markManager.remove("SELECTED2");
                    markManager.remove("MARK");
                    markManager.set("SELECTED", element);
                    documentView.ensureDotIsInside(element);
                    markManager.endBatchMarking();
                }
            }
        };
        ComponentUtil.doAddFocusGainedListener(component, focusAdapter);
    }

    private static final void doAddFocusGainedListener(Component component, FocusAdapter focusAdapter) {
        component.addFocusListener(focusAdapter);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                ComponentUtil.doAddFocusGainedListener(container.getComponent(n2), focusAdapter);
                ++n2;
            }
        }
    }
}

