<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:html="http://www.w3.org/1999/xhtml">

  <xsl:import href="xhtml2fo.xsl"/>

  <xsl:output method="xml"
              version="1.0"
              encoding="UTF-8"
              indent="no"/>

  <xsl:preserve-space elements="html:pre html:style html:script"/>

  <!--======================================================================
      Parameters
  =======================================================================-->

  <!-- text-align: justify | start -->
  <xsl:param name="text-align">justify</xsl:param>

  <!-- hyphenate: true | false -->
  <xsl:param name="hyphenate">true</xsl:param>

  <xsl:param name="font-family">serif</xsl:param>
  <xsl:param name="font-size">10pt</xsl:param>

  <!--======================================================================
      Attribute Sets
  =======================================================================-->

  <xsl:attribute-set name="root">
    <xsl:attribute name="font-family">
      <xsl:value-of select="$font-family"/>
    </xsl:attribute>
    <xsl:attribute name="font-size">
      <xsl:value-of select="$font-size"/>
    </xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="page-header">
    <xsl:attribute name="font-family">sans-serif</xsl:attribute>
    <xsl:attribute name="color">gray</xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="page-footer">
    <xsl:attribute name="font-family">sans-serif</xsl:attribute>
    <xsl:attribute name="color">gray</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="h1">
    <xsl:attribute name="font-family">sans-serif</xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="h2">
    <xsl:attribute name="font-family">sans-serif</xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="h3">
    <xsl:attribute name="font-family">sans-serif</xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="h4">
    <xsl:attribute name="font-family">sans-serif</xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="h5">
    <xsl:attribute name="font-family">sans-serif</xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="h6">
    <xsl:attribute name="font-family">sans-serif</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="table">
    <xsl:attribute name="border-spacing">0px</xsl:attribute>
    <xsl:attribute name="space-before">1em</xsl:attribute>
    <xsl:attribute name="space-after">1em</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="pre">
    <xsl:attribute name="text-align">start</xsl:attribute>
    <xsl:attribute name="background-color">#F0F0F0</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="tt">
    <xsl:attribute name="font-size">0.83em</xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="code">
    <xsl:attribute name="font-size">0.83em</xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="kbd">
    <xsl:attribute name="font-size">0.83em</xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="samp">
    <xsl:attribute name="font-size">0.83em</xsl:attribute>
  </xsl:attribute-set>

</xsl:stylesheet>
