/*
 * Copyright (c) 2003-2005 Pixware. 
 *
 * Author: Hussein Shafie
 *
 * This file is part of the XMLmind XML Editor project.
 * For conditions of distribution and use, see the accompanying legal.txt file.
 */

import java.io.File;
import java.net.URL;
import java.net.MalformedURLException;
import com.apple.eawt.*;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmleditapp.kit.AppAction;
import com.xmlmind.xmleditapp.kit.OpenDocumentAction;
import com.xmlmind.xmleditapp.kit.App;

public class MacApplicationListener extends ApplicationAdapter {
    private App app;

    public MacApplicationListener(App app) {
        this.app = app;

        Application env = new Application();
        env.addApplicationListener(this);
        env.setEnabledPreferencesMenu(true);
    }

    public void handleAbout(ApplicationEvent event) {
        AppAction action = (AppAction) app.getPart("aboutAction");
	if (action == null) {
	    event.setHandled(false);
	    return;
	}

	action.doIt();
	event.setHandled(true);
    }

    public void handlePreferences(ApplicationEvent event) {
        AppAction action = (AppAction) app.getPart("editOptionsAction");
	if (action == null) {
	    event.setHandled(false);
	    return;
	}

	action.doIt();
	event.setHandled(true);
    }

    public void handleOpenFile(ApplicationEvent event) {
        OpenDocumentAction action = 
	    (OpenDocumentAction) app.getPart("openAction");
	if (action == null) {
	    event.setHandled(false);
	    return;
	}

        String fileName = event.getFilename();

	URL url = null;
        try {
             url = new URL(fileName);
        } catch (MalformedURLException ignored) {}

	if (url == null) {
	    File file = new File(fileName);
	    if (file.isFile())
		url = FileUtil.fileToURL(file);
	}

	if (url == null) {
	    event.setHandled(false);
	    return;
	}

	action.openDocument(url);
        event.setHandled(true);
    }

    public void handleQuit(ApplicationEvent event) {
        event.setHandled(false);

        AppAction action = (AppAction) app.getPart("quitAction");
	if (action != null)
	    action.doIt();
    }
}
