@echo off
setlocal

rem --------------------------------------------------------------------------
rem dist is the location of your XMLmind XML Editor install directory
rem (%~dp0 is expanded pathname of the current script under NT/2000/XP).
rem --------------------------------------------------------------------------

set dist=%~dp0

set jars=%dist%\xp.jar;%dist%\resolver.jar;%dist%\relaxng.jar;%dist%\xsc.jar;%dist%\jh.jar;%dist%\ftp.jar;%dist%\http.jar;%dist%\saxon.jar

if exist "%dist%\xxe.jar" goto jar
set cp=%dist%\..\class;%jars%
goto fi
:jar
set cp=%dist%\xxe_app.jar;%dist%\xxe.jar;%jars%;%dist%\xxe_help.jar
:fi

rem --------------------------------------------------------------------------
rem Supported Java properties not documented elsewhere
rem ==================================================
rem
rem XXE_JAVA_IMAGE_TOOLKIT_EXCLUDE
rem ------------------------------
rem Value: list of file extensions separated by semi-colons
rem
rem Example: -DXXE_JAVA_IMAGE_TOOLKIT_EXCLUDE="bmp;wbmp"
rem This would prevent the built-in Java[tm] 1.5 image toolkit 
rem from handing BMP images.
rem This is useful in case you find an external image toolkit 
rem which handles specified image extensions better than the built-in 
rem Java image toolkit.
rem --------------------------------------------------------------------------

rem --------------------------------------------------------------------------
rem Notes about the Java[tm] command line:
rem
rem * Replace "start javaw" by "start java" if you need to see 
rem   Java exception stack traces and other low-level error messages 
rem   printed on the console.
rem 
rem * Specify a HOME environment variable and add -DHOME="%HOME%" to the java 
rem   command line if you do not want xxe2 to be created under 
rem   C:\Documents and Settings\<user>.
rem
rem * -Xss1m is needed to support *really* large XML-Schemas.
rem   -Xmx128m is needed from Java[tm] 1.4.2 which by default sets 
rem   this to 64m.
rem
rem * -Dsun.java2d.noddraw=true is a workaround for a very severe bug 
rem   (reported on Windows 2000/ATI graphics card driver) which causes 
rem   a Windows machine to freeze. This bug was supposed to have been 
rem   fixed by Java[tm] 1.4.1_02. This property prevents using DirectX
rem   for rendering.
rem --------------------------------------------------------------------------

start javaw -Xss1m -Xmx128m -DXXE_GUI="%XXE_GUI%" -DXXE_ADDON_PATH="%XXE_ADDON_PATH%" -classpath "%cp%" com.xmlmind.xmleditapp.start.Start %*

endlocal
