<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:imgd="http://www.xmlmind.com/xmleditor/schema/imagedemo"
  xmlns:svg="http://www.w3.org/2000/svg"
  xmlns:fo="http://www.w3.org/1999/XSL/Format">

<xsl:strip-space elements="*" />

<xsl:output
  method="xml" 
  indent="yes" 
  encoding="ISO-8859-1" />

<xsl:template match="/">
  <fo:root>
    <fo:layout-master-set>
      <fo:simple-page-master master-name="A4" 
        page-width="210mm" page-height="297mm"
        margin-top="5mm" margin-bottom="5mm"
        margin-left="5mm" margin-right="5mm">
        <fo:region-body margin="10mm 5mm"/>

        <fo:region-after extent="20pt" display-align="center" />
      </fo:simple-page-master>
    </fo:layout-master-set>

    <fo:page-sequence master-reference="A4">
      <fo:static-content flow-name="xsl-region-after">
	<fo:block text-align="end" color="gray" font-size="8pt" 
	  font-family="sans-serif" border-top="0.5pt solid gray"
	  padding="3pt 0" margin="0 5mm"><fo:page-number/> /
          <fo:page-number-citation ref-id="on-last-page"/></fo:block>
      </fo:static-content>

      <fo:flow flow-name="xsl-region-body" 
               font-size="10pt" font-family="serif">
        <xsl:apply-templates />

        <fo:block id="on-last-page" />
      </fo:flow>
    </fo:page-sequence>
  </fo:root>
</xsl:template>

<xsl:template match="imgd:heading">
  <fo:block font-family="sans-serif" font-weight="bold" font-size="1.5em"
            color="maroon" hyphenate="false">
    <xsl:call-template name="VSpace" />
    <xsl:apply-templates />
  </fo:block>
</xsl:template>

<xsl:template name="VSpace">
  <xsl:if test="preceding-sibling::*">
    <xsl:attribute name="space-before.minimum">0.8em</xsl:attribute>
    <xsl:attribute name="space-before.optimum">1em</xsl:attribute>
    <xsl:attribute name="space-before.maximum">1.2em</xsl:attribute>
  </xsl:if>

  <xsl:if test="following-sibling::*">
    <xsl:attribute name="space-after.minimum">0.8em</xsl:attribute>
    <xsl:attribute name="space-after.optimum">1em</xsl:attribute>
    <xsl:attribute name="space-after.maximum">1.2em</xsl:attribute>
  </xsl:if>
</xsl:template>

<xsl:template match="imgd:para">
  <fo:block>
    <xsl:call-template name="VSpace" />
    <xsl:apply-templates />
  </fo:block>
</xsl:template>

<xsl:template match="imgd:item">
  <fo:block margin-left="40pt">
    <xsl:call-template name="VSpace" />
    <fo:external-graphic src="url(xslt_graphics/item.png)" 
     content-width="10px" content-height="9px" />
    &#160;
    <xsl:apply-templates />
  </fo:block>
</xsl:template>

<xsl:template match="imgd:bold">
  <fo:inline font-weight="bold"><xsl:apply-templates /></fo:inline>
</xsl:template>

<xsl:template match="imgd:italic">
  <fo:inline font-style="italic"><xsl:apply-templates /></fo:inline>
</xsl:template>

<xsl:template match="imgd:tt">
  <fo:inline font-family="Courier,monospace"
             font-size="0.83em"><xsl:apply-templates /></fo:inline>
</xsl:template>

<xsl:template match="imgd:image_au">
  <xsl:variable name="file">
    <xsl:value-of select="./@location" />
  </xsl:variable>

  <xsl:call-template name="Image">
    <xsl:with-param name="file" select="$file" />
    <xsl:with-param name="attrs" select="." />
  </xsl:call-template>
</xsl:template>

<xsl:template match="imgd:image_eu">
  <xsl:variable name="file">
    <xsl:value-of select="string(.)" />
  </xsl:variable>

  <xsl:call-template name="Image">
    <xsl:with-param name="file" select="$file" />
    <xsl:with-param name="attrs" select="." />
  </xsl:call-template>
</xsl:template>

<xsl:template match="imgd:image_ab | imgd:image_eb">
  <xsl:variable name="file">
    <xsl:value-of select="./processing-instruction('extracted')" />
  </xsl:variable>

  <xsl:call-template name="Image">
    <xsl:with-param name="file" select="$file" />
    <xsl:with-param name="attrs" select="." />
  </xsl:call-template>
</xsl:template>

<xsl:template name="Image">
  <xsl:param name="file" select="''" />
  <xsl:param name="attrs" select="''" />

  <xsl:variable name="filename">
    <xsl:choose>
      <xsl:when test="$file != '' and $file != '???'">
        <xsl:value-of select="$file" />
      </xsl:when>
      <xsl:otherwise>xslt_graphics/noimage.png</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="halign">
    <xsl:choose>
      <xsl:when test="$attrs/@anchor='north'">center</xsl:when>
      <xsl:when test="$attrs/@anchor='east'">right</xsl:when>
      <xsl:when test="$attrs/@anchor='south'">center</xsl:when>
      <xsl:when test="$attrs/@anchor='west'">left</xsl:when>
      <xsl:when test="$attrs/@anchor='north_west'">left</xsl:when>
      <xsl:when test="$attrs/@anchor='north_east'">right</xsl:when>
      <xsl:when test="$attrs/@anchor='south_east'">right</xsl:when>
      <xsl:when test="$attrs/@anchor='south_west'">left</xsl:when>
      <xsl:otherwise>center</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

   <xsl:variable name="valign">
    <xsl:choose>
      <xsl:when test="$attrs/@anchor='north'">before</xsl:when>
      <xsl:when test="$attrs/@anchor='east'">center</xsl:when>
      <xsl:when test="$attrs/@anchor='south'">after</xsl:when>
      <xsl:when test="$attrs/@anchor='west'">center</xsl:when>
      <xsl:when test="$attrs/@anchor='north_west'">before</xsl:when>
      <xsl:when test="$attrs/@anchor='north_east'">before</xsl:when>
      <xsl:when test="$attrs/@anchor='south_east'">after</xsl:when>
      <xsl:when test="$attrs/@anchor='south_west'">after</xsl:when>
      <xsl:otherwise>center</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <fo:block text-align="center">
    <fo:external-graphic src="url({$filename})"
                         text-align="{$halign}" display-align="{$valign}">
      <xsl:if test="$attrs/@width">
	<xsl:attribute name="width">
	  <xsl:call-template name="to-fo-length">
	    <xsl:with-param name="length" select="$attrs/@width"/>
	  </xsl:call-template>
	</xsl:attribute>
      </xsl:if>

      <xsl:if test="$attrs/@height">
	<xsl:attribute name="height">
	  <xsl:call-template name="to-fo-length">
	    <xsl:with-param name="length" select="$attrs/@height"/>
	  </xsl:call-template>
	</xsl:attribute>
      </xsl:if>

      <xsl:choose>
        <xsl:when test="$attrs/@content_width = 'scale_to_fit'">
          <xsl:attribute name="content-width">scale-to-fit</xsl:attribute>
        </xsl:when>

        <xsl:when test="$attrs/@content_width">
          <xsl:attribute name="content-width">
	    <xsl:call-template name="to-fo-length">
	      <xsl:with-param name="length" select="$attrs/@content_width"/>
	    </xsl:call-template>
          </xsl:attribute>
        </xsl:when>
      </xsl:choose>

      <xsl:choose>
        <xsl:when test="$attrs/@content_height = 'scale_to_fit'">
          <xsl:attribute name="content-height">scale-to-fit</xsl:attribute>
        </xsl:when>

        <xsl:when test="$attrs/@content_height">
          <xsl:attribute name="content-height">
	    <xsl:call-template name="to-fo-length">
	      <xsl:with-param name="length" select="$attrs/@content_height"/>
	    </xsl:call-template>
          </xsl:attribute>
        </xsl:when>
      </xsl:choose>

      <xsl:choose>
        <xsl:when test="$attrs/@preserve_aspect_ratio = 'false' or
		        ($attrs/@content_width and $attrs/@content_height and
                         $attrs/@content_width != 'scale_to_fit' and
		         $attrs/@content_height != 'scale_to_fit')">
          <xsl:attribute name="scaling">non-uniform</xsl:attribute>
        </xsl:when>
      </xsl:choose>
    </fo:external-graphic>
  </fo:block>
</xsl:template>

<xsl:template name="to-fo-length">
  <xsl:param name="length" select="'0pt'"/>
  <xsl:param name="em" select="10"/>
  <xsl:param name="ex" select="8"/>

  <xsl:variable name="unit">
    <xsl:value-of select="substring($length, 1 + string-length($length) - 2)"/>
  </xsl:variable>
  <xsl:variable name="value">
    <xsl:value-of select="substring($length, 1, string-length($length) - 2)" />
  </xsl:variable>

  <xsl:choose>
    <xsl:when test="$unit = 'em'">
      <xsl:value-of select="concat(round($value * $em), 'pt')"/>
    </xsl:when>
    <xsl:when test="$unit = 'ex'">
      <xsl:value-of select="concat(round($value * $ex), 'pt')"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$length"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="svg:svg">
  <xsl:variable name="file">
    <xsl:value-of select="./processing-instruction('extracted')" />
  </xsl:variable>

  <fo:block text-align="center">
    <xsl:choose>
      <xsl:when test="$file != ''">
	<fo:external-graphic src="url({$file})" />
      </xsl:when>

      <xsl:otherwise>
        <fo:instream-foreign-object>
          <xsl:copy-of select="." />
        </fo:instream-foreign-object>
      </xsl:otherwise>
    </xsl:choose>
  </fo:block>
</xsl:template>

</xsl:stylesheet>
