<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:imgd="http://www.xmlmind.com/xmleditor/schema/imagedemo"
  xmlns:svg="http://www.w3.org/2000/svg">

<xsl:strip-space elements="*" />

<xsl:output
  method="html" 
  indent="yes" 
  encoding="ISO-8859-1"
  doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" />

<xsl:template match="/">
  <html>
    <head>
      <style>
body     { background: white; font-family: sans-serif; }
.heading {  color: maroon; }
.item    {  margin: 1.33ex 0 1.33ex 4ex; }
      </style>
    </head>
    <xsl:apply-templates />
  </html>
</xsl:template>

<xsl:template match="imgd:imagedemo">
  <body>
    <xsl:apply-templates />
  </body>
</xsl:template>

<xsl:template match="imgd:heading">
  <h2 class="heading"><xsl:apply-templates /></h2>
</xsl:template>

<xsl:template match="imgd:para">
  <p class="para"><xsl:apply-templates /></p>
</xsl:template>

<xsl:template match="imgd:item">
  <div class="item">
    <img src="xslt_graphics/item.png" width="10" height="9" alt="" />
    <xsl:text> </xsl:text>
    <xsl:apply-templates />
  </div>
</xsl:template>

<xsl:template match="imgd:bold">
  <b class="bold"><xsl:apply-templates /></b>
</xsl:template>

<xsl:template match="imgd:italic">
  <i class="italic"><xsl:apply-templates /></i>
</xsl:template>

<xsl:template match="imgd:tt">
  <tt class="tt"><xsl:apply-templates /></tt>
</xsl:template>

<xsl:template match="imgd:image_au">
  <xsl:variable name="file">
    <xsl:value-of select="./@location" />
  </xsl:variable>

  <xsl:call-template name="Image">
    <xsl:with-param name="file" select="$file" />
    <xsl:with-param name="attrs" select="." />
  </xsl:call-template>
</xsl:template>

<xsl:template match="imgd:image_eu">
  <xsl:variable name="file">
    <xsl:value-of select="string(.)" />
  </xsl:variable>

  <xsl:call-template name="Image">
    <xsl:with-param name="file" select="$file" />
    <xsl:with-param name="attrs" select="." />
  </xsl:call-template>
</xsl:template>

<xsl:template match="imgd:image_ab | imgd:image_eb">
  <xsl:variable name="file">
    <xsl:value-of select="./processing-instruction('extracted')" />
  </xsl:variable>

  <xsl:call-template name="Image">
    <xsl:with-param name="file" select="$file" />
    <xsl:with-param name="attrs" select="." />
  </xsl:call-template>
</xsl:template>

<xsl:template name="Image">
  <xsl:param name="file" select="''" />
  <xsl:param name="attrs" select="''" />

  <xsl:variable name="filename">
    <xsl:choose>
      <xsl:when test="$file != '' and $file != '???'">
        <xsl:value-of select="$file" />
      </xsl:when>
      <xsl:otherwise>xslt_graphics/noimage.png</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="align">
    <xsl:choose>
      <xsl:when test="$attrs/@anchor='north'">center</xsl:when>
      <xsl:when test="$attrs/@anchor='east'">right</xsl:when>
      <xsl:when test="$attrs/@anchor='south'">center</xsl:when>
      <xsl:when test="$attrs/@anchor='west'">left</xsl:when>
      <xsl:when test="$attrs/@anchor='north_west'">left</xsl:when>
      <xsl:when test="$attrs/@anchor='north_east'">right</xsl:when>
      <xsl:when test="$attrs/@anchor='south_east'">right</xsl:when>
      <xsl:when test="$attrs/@anchor='south_west'">left</xsl:when>
      <xsl:otherwise>center</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

   <xsl:variable name="valign">
    <xsl:choose>
      <xsl:when test="$attrs/@anchor='north'">top</xsl:when>
      <xsl:when test="$attrs/@anchor='east'">middle</xsl:when>
      <xsl:when test="$attrs/@anchor='south'">bottom</xsl:when>
      <xsl:when test="$attrs/@anchor='west'">middle</xsl:when>
      <xsl:when test="$attrs/@anchor='north_west'">top</xsl:when>
      <xsl:when test="$attrs/@anchor='north_east'">top</xsl:when>
      <xsl:when test="$attrs/@anchor='south_east'">bottom</xsl:when>
      <xsl:when test="$attrs/@anchor='south_west'">bottom</xsl:when>
      <xsl:otherwise>middle</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <!-- Cannot do much with HTML -->

  <table border="0" cellspacing="0" cellpadding="0" align="center">
    <xsl:attribute name="width">
      <xsl:choose>
	<xsl:when test="$attrs/@width != ''">
	  <xsl:call-template name="to-html-length">
	    <xsl:with-param name="length" select="$attrs/@width"/>
	  </xsl:call-template>
	</xsl:when>
	<xsl:otherwise>100%</xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>

    <tr>
      <td align="{$align}" valign="{$valign}">
	<xsl:if test="$attrs/@height != '' and
                      not(contains($attrs/@height, '%'))">
	  <xsl:attribute name="height">
            <xsl:call-template name="to-html-length">
              <xsl:with-param name="length" select="$attrs/@height"/>
            </xsl:call-template>
	  </xsl:attribute>
	</xsl:if>

        <img class="image" src="{$filename}">
	  <xsl:choose>
	    <xsl:when test="$attrs/@preserve_aspect_ratio = 'false' and
                            $attrs/@content_width = 'scale_to_fit' and
                            $attrs/@content_height = 'scale_to_fit'">
              <!-- In HTML and in CSS, percentages are percentages of the
                   available space. -->
	      <xsl:attribute name="width">100%</xsl:attribute>
	      <xsl:attribute name="height">100%</xsl:attribute>
	    </xsl:when>

	    <xsl:when test="string($attrs/@preserve_aspect_ratio)!='false' and
                            ($attrs/@content_width = 'scale_to_fit' or
                             $attrs/@content_height = 'scale_to_fit')">
	      <xsl:attribute name="width">100%</xsl:attribute>
	    </xsl:when>

	    <xsl:otherwise>
	      <xsl:if test="$attrs/@content_width != '' and
			    not(contains($attrs/@content_width, '%')) and
			    $attrs/@content_width != 'scale_to_fit'">
		<xsl:attribute name="width">
		  <xsl:call-template name="to-html-length">
		    <xsl:with-param name="length"
                                    select="$attrs/@content_width"/>
		  </xsl:call-template>
		</xsl:attribute>
	      </xsl:if>

	      <xsl:if test="$attrs/@content_height != '' and
			    not(contains($attrs/@content_height, '%')) and
			    $attrs/@content_height != 'scale_to_fit'">
		<xsl:attribute name="height">
		  <xsl:call-template name="to-html-length">
		    <xsl:with-param name="length"
                                    select="$attrs/@content_height"/>
		  </xsl:call-template>
		</xsl:attribute>
	      </xsl:if>
            </xsl:otherwise>
	  </xsl:choose>
        </img>
      </td>
    </tr>
  </table>
</xsl:template>

<xsl:template name="to-html-length">
  <xsl:param name="length" select="'0pt'"/>
  <xsl:param name="em" select="12"/>
  <xsl:param name="ex" select="10"/>
  <xsl:param name="dpi" select="96"/>

  <xsl:variable name="unit">
    <xsl:value-of select="substring($length, 1 + string-length($length) - 2)"/>
  </xsl:variable>
  <xsl:variable name="value">
    <xsl:value-of select="substring($length, 1, string-length($length) - 2)" />
  </xsl:variable>

  <xsl:choose>
    <xsl:when test="$unit = 'in'">
      <xsl:value-of select="round($value * $dpi)"/>
    </xsl:when>
    <xsl:when test="$unit = 'cm'">
      <xsl:value-of select="round(($value div 2.54) * $dpi)"/>
    </xsl:when>
    <xsl:when test="$unit = 'mm'">
      <xsl:value-of select="round(($value div 25.4) * $dpi)"/>
    </xsl:when>
    <xsl:when test="$unit = 'pt'">
      <xsl:value-of select="round(($value div 72.0) * $dpi)"/>
    </xsl:when>
    <xsl:when test="$unit = 'pc'">
      <!-- 1pc = 12pt thus 1in = 6pc -->
      <xsl:value-of select="round(($value div 6.0) * $dpi)"/>
    </xsl:when>
    <xsl:when test="$unit = 'em'">
      <xsl:value-of select="round((($value * $em) div 72.0) * $dpi)"/>
    </xsl:when>
    <xsl:when test="$unit = 'ex'">
      <xsl:value-of select="round((($value * $ex) div 72.0) * $dpi)"/>
    </xsl:when>
    <xsl:when test="$unit = 'px'">
      <xsl:value-of select="round($value)"/>
    </xsl:when>
    <xsl:otherwise>
      <!-- Percentage or no unit or unknown unit -->
      <xsl:value-of select="$length"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="svg:svg">
  <xsl:variable name="file">
    <xsl:value-of select="./processing-instruction('extracted')" />
  </xsl:variable>

  <xsl:variable name="filename">
    <xsl:choose>
      <xsl:when test="$file != ''">
        <xsl:value-of select="$file" />
      </xsl:when>
      <xsl:otherwise>xslt_graphics/noimage.png</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:choose>
    <xsl:when 
      test="substring($filename, 1 + string-length($filename) - 4)='.svg' or
            substring($filename, 1 + string-length($filename) - 5)='.svgz'">
      <object class="image" type="image/svg-xml" data="{$filename}">
	<font color="red"><b><i>You need to install
	<a href="http://www.adobe.com/svg/">Adobe SVG plug-in</a>
	in your Web browser in order to be able 
        to view these graphics.</i></b></font>
      </object>
    </xsl:when>

    <xsl:otherwise>
      <div align="center"><img src="{$filename}" /></div>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>
