<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="xml" encoding="UTF-8" />

<xsl:template match="/*[./processing-instruction('select-child-nodes')]">
  <xsl:variable name="pi"
    select="./processing-instruction('select-child-nodes')" />
  <xsl:variable name="first" select="substring-before($pi, '-')" />
  <xsl:variable name="last" select="substring-after($pi, '-')" />

  <c:clipboard 
    xmlns:c="http://www.xmlmind.com/xmleditor/namespace/clipboard">

    <xsl:for-each select="child::node()[position() &gt;= $first and
					position() &lt;= $last]">
      <xsl:apply-templates select="." />
    </xsl:for-each>

  </c:clipboard>
</xsl:template>

<xsl:template match="para">
  <simpara>
    <xsl:copy-of select="./node()" />
  </simpara>
</xsl:template>

</xsl:stylesheet>
