@echo off
setlocal

if %1/=="/" goto usage
if %2/=="/" goto usage

set src=%~f1
set ext=%~x2
set dst=%~f2

if not exist "%src%" goto usage
goto process

:usage
echo "usage: texmathtoimg.bat in_file.tex out_file.png|.pdf|.eps|.ps"
exit /b 1

:process

if exist "%TEMP%\texmathtoimg.tex" del /q "%TEMP%\texmathtoimg.*"

echo \documentclass[12pt]{article} > "%TEMP%\texmathtoimg.tex"
echo \pagestyle{empty} >> "%TEMP%\texmathtoimg.tex"
echo \begin{document} >> "%TEMP%\texmathtoimg.tex"
type "%src%" >> "%TEMP%\texmathtoimg.tex"
echo \end{document} >> "%TEMP%\texmathtoimg.tex"

cd /d "%TEMP%"
latex --interaction batchmode texmathtoimg.tex

if exist "%TEMP%\texmathtoimg.dvi" goto convert
echo "%src%" has TeX errors
if exist "%TEMP%\texmathtoimg.tex" del /q "%TEMP%\texmathtoimg.*"
exit /b 2

:convert
dvips -E -o "%TEMP%\texmathtoimg.eps" "%TEMP%\texmathtoimg.dvi"

if "%ext%"==".png" goto png
if "%ext%"==".pdf" goto pdf

:ps
copy "%TEMP%\texmathtoimg.eps" "%dst%"
goto end

:png
gswin32c -q -dBATCH -dNOPAUSE -sDEVICE=png16m -r96 -dTextAlphaBits=4 -dGraphicsAlphaBits=4 -dEPSCrop "-sOutputFile=%dst%" "%TEMP%\texmathtoimg.eps"
goto end

:pdf
call ps2pdf12.bat -dEPSCrop "%TEMP%\texmathtoimg.eps" "%dst%"
goto end

:end
if exist "%TEMP%\texmathtoimg.tex" del /q "%TEMP%\texmathtoimg.*"

endlocal
exit /b 0
