<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl ld"
    xmlns:ld="http://namespaces.ens-lyon.fr/livredoc/">
    <xsl:template name="create-table">
        <xsl:param name="name"/>
        <xsl:param name="nbCols"/>
        <table name="{$name}" nbCols="{$nbCols}" nbRows="0" curRow="0" curCol="0"/>
    </xsl:template>
    <xsl:template name="new-row">
        <xsl:param name="table"/>
        <xsl:variable name="tableNS" select="exsl:node-set($table)"/>
        <xsl:for-each select="$tableNS/table">
            <xsl:variable name="nextRow" select="row[position() &gt; current()/@curRow and
                cell[@status='free'] ][1]"/>
            <xsl:choose>
                <xsl:when test="not($nextRow)">
                    <xsl:variable name="newTable">
                        <table curRow="{@nbRows + 1}" nbRows="{@nbRows                             +
                            1}" curCol="1">
                            <xsl:copy-of select="@name|@nbCols|text()|*"/>
                            <row/>
                        </table>
                    </xsl:variable>
                    <xsl:call-template name="appendCells">
                        <xsl:with-param name="table" select="exsl:node-set($newTable)"/>
                        <xsl:with-param name="nbCells" select="@nbCols"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="nextCol" select="$nextRow/cell[@status='free'][1]"/>
                    <table curRow="{count( $nextRow/preceding-sibling::* ) + 1}" curCol="{count(
                        $nextCol/preceding-sibling::* ) + 1}">
                        <xsl:copy-of select="@nbRows|@name|@nbCols|text()|*"/>
                    </table>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>
    <xsl:template name="appendCells">
        <xsl:param name="nbCells"/>
        <xsl:param name="table"/>
        <xsl:variable name="tableNS" select="exsl:node-set($table)"/>
        <xsl:variable name="newTable">
            <table>
                <xsl:copy-of
                    select="$tableNS/table/@*|$tableNS/table/text()|$tableNS/table/*[not(position()=last())]"/>
                <row>
                    <xsl:copy-of select="$tableNS/table/*[position()=last()]/*"/>
                    <cell status="free"/>
                </row>
            </table>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$nbCells = 1">
                <xsl:copy-of select="$newTable"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="appendCells">
                    <xsl:with-param name="nbCells" select="$nbCells - 1"/>
                    <xsl:with-param name="table" select="exsl:node-set($newTable)"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="cells">
        <xsl:param name="nbCols"/>
        <xsl:if test="$nbCols &gt; 0">
            <cell status="free"/>
            <xsl:if test="$nbCols &gt; 1">
                <xsl:call-template name="cells">
                    <xsl:with-param name="nbCols" select="$nbCols - 1"/>
                </xsl:call-template>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    <xsl:template name="row">
        <xsl:param name="nbCols"/>
        <row>
            <xsl:call-template name="cells">
                <xsl:with-param name="nbCols" select="$nbCols"/>
            </xsl:call-template>
        </row>
    </xsl:template>
    <xsl:template match="table" mode="nextCell">
        <xsl:param name="colspan"/>
        <xsl:param name="rowspan"/>
        <xsl:param name="width"/>
        <xsl:copy>
            <xsl:copy-of select="@*[not(name()='curCol' or name()='nbRows')]"/>
            <xsl:attribute name="curCol">
                <xsl:variable name="nextCell" select="row[number(current()/@curRow)]/cell[position()
                    &gt;=  current()/@curCol + $colspan and
                    @status='free'][1]"/>
                <xsl:choose>
                    <xsl:when test="$nextCell">
                        <xsl:value-of select="count($nextCell/preceding-sibling::*) + 1"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="@nbCols + 1"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            <xsl:attribute name="nbRows">
                <xsl:value-of select="@nbRows + $rowspan - 1"/>
            </xsl:attribute>
            <xsl:apply-templates select="row[1]" mode="nextCell">
                <xsl:with-param name="colspan" select="$colspan"/>
                <xsl:with-param name="rowspan" select="$rowspan"/>
                <xsl:with-param name="width" select="$width"/>
            </xsl:apply-templates>
        </xsl:copy>
    </xsl:template>
    <xsl:template match="row" mode="nextCell">
        <xsl:param name="colspan"/>
        <xsl:param name="rowspan"/>
        <xsl:param name="width"/>
        <xsl:variable name="pos" select="count(preceding-sibling::row) +1 "/>
        <xsl:variable name="curRow" select="ancestor::table/@curRow"/>
        <xsl:choose>
            <xsl:when test="$pos &lt; $curRow or $pos &gt;= $curRow + $rowspan">
                <xsl:copy-of select="."/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:apply-templates select="cell" mode="nextCell">
                        <xsl:with-param name="colspan" select="$colspan"/>
                        <xsl:with-param name="width" select="$width"/>
                    </xsl:apply-templates>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="following-sibling::row">
                <xsl:apply-templates select="following-sibling::row[1]" mode="nextCell">
                    <xsl:with-param name="rowspan" select="$rowspan"/>
                    <xsl:with-param name="colspan" select="$colspan"/>
                    <xsl:with-param name="width" select="$width"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:when test="$pos &lt; $curRow + $rowspan -1">
                <xsl:variable name="missingRowFreeCells">
                    <table curRow="1" curCol="{parent::table/@curCol}">
                        <xsl:call-template name="row">
                            <xsl:with-param name="nbCols" select="parent::table/@nbCols"/>
                        </xsl:call-template>
                    </table>
                </xsl:variable>
                <xsl:variable name="missingRows">
                    <xsl:apply-templates select="exsl:node-set($missingRowFreeCells)/table"
                        mode="nextCell">
                        <xsl:with-param name="colspan" select="$colspan"/>
                        <xsl:with-param name="rowspan" select="$curRow + $rowspan - $pos - 1"/>
                        <xsl:with-param name="width" select="$width"/>
                    </xsl:apply-templates>
                </xsl:variable>
                <xsl:copy-of select="exsl:node-set($missingRows)/table/*"/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="cell" mode="nextCell">
        <xsl:param name="colspan"/>
        <xsl:param name="width"/>
        <xsl:variable name="pos" select="count(preceding-sibling::cell) +1 "/>
        <xsl:variable name="curCol" select="ancestor::table/@curCol"/>
        <xsl:choose>
            <xsl:when test="$pos &lt; $curCol or $pos &gt;= $curCol + $colspan">
                <xsl:copy-of select="."/>
            </xsl:when>
            <xsl:otherwise>
                <cell status="reserved">
                    <xsl:if test="$width">
                        <xsl:attribute name="width">
                            <xsl:variable name="value" select="translate($width, '%ptxcm', '')"/>
                            <xsl:variable name="unit" select="substring-after($width, $value)"/>
                            <xsl:value-of select="concat($value div $colspan, $unit)"/>
                        </xsl:attribute>
                    </xsl:if>
                </cell>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="ld:cellule" mode="nextCell">
        <xsl:param name="table"/>
        <xsl:variable name="tableNS" select="exsl:node-set($table)"/>
        <table curCol="{$tableNS/table/@curCol +1}">
            <xsl:copy-of
                select="$tableNS/table/@*[not(name()='curCol')]|$tableNS/table/text()|$tableNS/table/*"
            />
        </table>
    </xsl:template>
    <xsl:template match="ld:cellule[@nombreDeColonnes]" mode="nextCell">
        <xsl:param name="table"/>
        <xsl:variable name="tableNS" select="exsl:node-set($table)"/>
        <table curCol="{$tableNS/table/@curCol +@nombreDeColonnes}">
            <xsl:copy-of
                select="$tableNS/table/@*[not(name()='curCol')]|$tableNS/table/text()|$tableNS/table/*"
            />
        </table>
    </xsl:template>
    <xsl:template match="ld:rangée" mode="nbcols">
        <xsl:apply-templates select="ld:cellule[1]" mode="nbcols"/>
    </xsl:template>
    <xsl:template match="ld:cellule" mode="nbcols">
        <xsl:param name="nbcols" select="0"/>
        <xsl:variable name="nbcols2">
            <xsl:choose>
                <xsl:when test="@nombreDeColonnes">
                    <xsl:value-of select="$nbcols + @nombreDeColonnes"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$nbcols + 1"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="following-sibling::ld:cellule">
                <xsl:apply-templates select="following-sibling::ld:cellule[1]" mode="nbcols">
                    <xsl:with-param name="nbcols" select="$nbcols2"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$nbcols2"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--<xsl:template match="ld:cellule" mode="colspec">
        <xsl:param name="idx" select="1"/>
        <xsl:param name="col" select="1"/>
        <colspec colname="table{count(preceding::ld:table|preceding::ld:tableAvecTitre) + 1}-{$col +
            $idx - 1}"/>
        <xsl:variable name="nombreDeColonnes">
            <xsl:choose>
                <xsl:when test="@nombreDeColonnes">
                    <xsl:value-of select="@nombreDeColonnes"/>
                </xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$idx &lt; $nombreDeColonnes ">
                <xsl:apply-templates select="." mode="colspec">
                    <xsl:with-param name="idx" select="$idx + 1"/>
                    <xsl:with-param name="col" select="$col"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="following-sibling::ld:cellule[1]" mode="colspec">
                    <xsl:with-param name="col" select="$col + $nombreDeColonnes"/>
                </xsl:apply-templates>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>-->
    <xsl:template match="ld:rangée" mode="colspec">
        <xsl:param name="table"/>
        <xsl:variable name="newTable">
            <xsl:call-template name="new-row">
                <xsl:with-param name="table" select="exsl:node-set($table)"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:apply-templates select="ld:cellule[1]" mode="colspec">
            <xsl:with-param name="table" select="exsl:node-set($newTable)"/>
        </xsl:apply-templates>
    </xsl:template>
    <xsl:template match="ld:cellule" mode="colspec">
        <xsl:param name="table"/>
        <xsl:variable name="colspan">
            <xsl:choose>
                <xsl:when test="@nombreDeColonnes &gt; 1">
                    <xsl:value-of select="@nombreDeColonnes"/>
                </xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="rowspan">
            <xsl:choose>
                <xsl:when test="@nombreDeRangées &gt; 1">
                    <xsl:value-of select="@nombreDeRangées"/>
                </xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="newTable">
            <xsl:apply-templates select="exsl:node-set($table)/table" mode="nextCell">
                <xsl:with-param name="colspan" select="$colspan"/>
                <xsl:with-param name="rowspan" select="$rowspan"/>
                <xsl:with-param name="width" select="@largeur"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="following-sibling::ld:cellule">
                <xsl:apply-templates select="following-sibling::ld:cellule[1]" mode="colspec">
                    <xsl:with-param name="table" select="exsl:node-set($newTable)"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:when test="../following-sibling::ld:rangée">
                <xsl:apply-templates select="../following-sibling::ld:rangée[1]" mode="colspec">
                    <xsl:with-param name="table" select="exsl:node-set($newTable)"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="$newTable"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="cell" mode="colspec">
        <xsl:param name="unspecifiedColSpan"/>
        <xsl:param name="totalColSpan"/>
        <xsl:variable name="pos" select="count(preceding-sibling::cell) + 1"/>
        <colspec colname="{ancestor::table/@name}-{$pos}">
            <xsl:if test="../../row/cell[$pos]/@width or $unspecifiedColSpan != ancestor::table/@nbCols">
                <xsl:attribute name="colwidth">
                    <xsl:variable name="width" select="../../row/cell[$pos][1]/@width"/>
                    <xsl:choose>
                        <xsl:when test="contains($width, '%')">
                            <xsl:variable name="percent" select="substring-before($width, '%')"/>
                            <xsl:value-of select="concat( $percent, '*' )"/>
                        </xsl:when>
                        <xsl:when test="$unspecifiedColSpan != ancestor::table/@nbCols">
                            <xsl:value-of select="concat(( 100 - $totalColSpan ) div
                                $unspecifiedColSpan, '*')"/>
                        </xsl:when>
                        <xsl:when test="contains($width, 'px')">
                            <xsl:value-of select="substring-before($width, 'px')"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$width"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
            </xsl:if>
        </colspec>
    </xsl:template>
    <xsl:template match="cell" mode="unspecifiedColSpan">
        <xsl:param name="unspecifiedColSpan" select="0"/>
        <xsl:variable name="pos" select="count(preceding-sibling::cell) + 1"/>
        <xsl:variable name="width"
            select="ancestor::table/row/cell[position()=$pos][contains(@width,
            '%')][1]/@width"/>
        <xsl:variable name="colSpan">
            <xsl:choose>
                <xsl:when test="$width"> 0 </xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="following-sibling::cell">
                <xsl:apply-templates select="following-sibling::cell[1]" mode="unspecifiedColSpan">
                    <xsl:with-param name="unspecifiedColSpan" select="$unspecifiedColSpan +
                        $colSpan"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$unspecifiedColSpan + $colSpan"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="cell" mode="totalColSpan">
        <xsl:param name="totalColSpan" select="0"/>
        <xsl:variable name="pos" select="count(preceding-sibling::cell) + 1"/>
        <xsl:variable name="width"
            select="ancestor::table/row/cell[position()=$pos][contains(@width,
            '%')][1]/@width"/>
        <xsl:variable name="colSpan">
            <xsl:choose>
                <xsl:when test="$width">
                    <xsl:value-of select="substring-before($width, '%')"/>
                </xsl:when>
                <xsl:otherwise>0</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="following-sibling::cell">
                <xsl:apply-templates select="following-sibling::cell[1]" mode="totalColSpan">
                    <xsl:with-param name="totalColSpan" select="$totalColSpan +
                        $colSpan"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$totalColSpan + $colSpan"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="tableContent">
        <xsl:apply-templates select="@*|ld:métadonnéesDeBloc|ld:titre"/>
        <xsl:variable name="nbCols">
            <xsl:apply-templates select="ld:rangée[1]" mode="nbcols"/>
        </xsl:variable>
        <xsl:variable name="table">
            <xsl:call-template name="create-table">
                <xsl:with-param name="name" select="concat('table',
                    count(preceding::ld:table|preceding::ld:tableAvecTitre) + 1)"/>
                <xsl:with-param name="nbCols" select="$nbCols"/>
            </xsl:call-template>
        </xsl:variable>
        <tgroup cols="{$nbCols}">
            <!--<xsl:apply-templates select="ld:rangée[1]/ld:cellule[1]" mode="colspec"/>-->
            <xsl:variable name="emptyTableForColspec">
                <xsl:copy-of select="$table"/>
            </xsl:variable>
            <xsl:variable name="tableForColspec">
                <xsl:apply-templates select="ld:rangée[1]" mode="colspec">
                    <xsl:with-param name="table" select="exsl:node-set($emptyTableForColspec)"/>
                </xsl:apply-templates>
            </xsl:variable>
            <!--<xsl:copy-of select="$tableForColspec"/>-->
            <xsl:variable name="unspecifiedColSpan">
                <xsl:apply-templates select="exsl:node-set($tableForColspec)/table/row[1]/cell[1]"
                    mode="unspecifiedColSpan"/>
            </xsl:variable>
            <xsl:variable name="totalColSpan">
                <xsl:apply-templates select="exsl:node-set($tableForColspec)/table/row[1]/cell[1]"
                    mode="totalColSpan"/>
            </xsl:variable>
            <xsl:apply-templates select="exsl:node-set($tableForColspec)/table/row[1]/cell"
                mode="colspec">
                <xsl:with-param name="unspecifiedColSpan" select="$unspecifiedColSpan"/>
                <xsl:with-param name="totalColSpan" select="$totalColSpan"/>
            </xsl:apply-templates>
            <tbody>
                <xsl:apply-templates select="ld:rangée[1]">
                    <xsl:with-param name="table" select="exsl:node-set($table)"/>
                </xsl:apply-templates>
            </tbody>
        </tgroup>
    </xsl:template>
    <xsl:template match="ld:tableAvecTitre" priority="1">
        <table>
            <xsl:call-template name="tableContent"/>
        </table>
    </xsl:template>
    <xsl:template match="ld:table" priority="1">
        <informaltable>
            <xsl:call-template name="tableContent"/>
        </informaltable>
    </xsl:template>
    <xsl:template match="ld:rangée" priority="1">
        <xsl:param name="table"/>
        <xsl:variable name="newTable">
            <xsl:call-template name="new-row">
                <xsl:with-param name="table" select="$table"/>
            </xsl:call-template>
        </xsl:variable>
        <row>
            <xsl:apply-templates select="@*|ld:cellule[1]">
                <xsl:with-param name="table" select="exsl:node-set($newTable)"/>
            </xsl:apply-templates>
        </row>
        <xsl:variable name="newNewTable">
            <xsl:apply-templates select="@*|ld:cellule[1]" mode="table">
                <xsl:with-param name="table" select="exsl:node-set($newTable)"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:apply-templates select="following-sibling::ld:rangée[1]">
            <xsl:with-param name="table" select="exsl:node-set($newNewTable)"/>
        </xsl:apply-templates>
    </xsl:template>
    <xsl:template match="ld:cellule" mode="table">
        <xsl:param name="table"/>
        <xsl:variable name="colspan">
            <xsl:choose>
                <xsl:when test="@nombreDeColonnes">
                    <xsl:value-of select="@nombreDeColonnes"/>
                </xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="rowspan">
            <xsl:choose>
                <xsl:when test="@nombreDeRangées">
                    <xsl:value-of select="@nombreDeRangées"/>
                </xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="newTable">
            <xsl:apply-templates select="exsl:node-set($table)/table" mode="nextCell">
                <xsl:with-param name="colspan" select="$colspan"/>
                <xsl:with-param name="rowspan" select="$rowspan"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:copy-of select="$newTable"/>
    </xsl:template>
    <xsl:template match="ld:cellule" priority="1">
        <xsl:param name="table"/>
        <xsl:variable name="colspan">
            <xsl:choose>
                <xsl:when test="@nombreDeColonnes &gt; 1">
                    <xsl:value-of select="@nombreDeColonnes"/>
                </xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="rowspan">
            <xsl:choose>
                <xsl:when test="@nombreDeRangées &gt; 1">
                    <xsl:value-of select="@nombreDeRangées"/>
                </xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <entry>
            <xsl:if test="$rowspan &gt; 1">
                <xsl:attribute name="morerows">
                    <xsl:value-of select="$rowspan - 1"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:if test="$colspan &gt; 1">
                <xsl:attribute name="namest">
                    <xsl:value-of select="concat($table/table/@name, '-', $table/table/@curCol)"/>
                </xsl:attribute>
                <xsl:attribute name="nameend">
                    <xsl:value-of select="concat($table/table/@name, '-', $table/table/@curCol +
                        $colspan - 1)"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates select="@*|node()"/>
        </entry>
        <xsl:variable name="newTable">
            <xsl:apply-templates select="exsl:node-set($table)/table" mode="nextCell">
                <xsl:with-param name="colspan" select="$colspan"/>
                <xsl:with-param name="rowspan" select="$rowspan"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:apply-templates select="following-sibling::ld:cellule[1]">
            <xsl:with-param name="table" select="exsl:node-set($newTable)"/>
        </xsl:apply-templates>
    </xsl:template>
    <xsl:template match="@cadre[.='partout']" priority="1">
        <xsl:attribute name="frame">all</xsl:attribute>
    </xsl:template>
    <xsl:template match="@cadre[.='aucun']" priority="1">
        <xsl:attribute name="frame">none</xsl:attribute>
    </xsl:template>
    <xsl:template match="@cadre[.='haut']" priority="1">
        <xsl:attribute name="frame">top</xsl:attribute>
    </xsl:template>
    <xsl:template match="@cadre[.='bas']" priority="1">
        <xsl:attribute name="frame">bottom</xsl:attribute>
    </xsl:template>
    <xsl:template match="@cadre[.='hautEtBas']" priority="1">
        <xsl:attribute name="frame">topbot</xsl:attribute>
    </xsl:template>
    <xsl:template match="@cadre[.='côtés']" priority="1">
        <xsl:attribute name="frame">sides</xsl:attribute>
    </xsl:template>
    <xsl:template match="@cadre" priority=".9">
        <xsl:attribute name="frame">sides</xsl:attribute>
    </xsl:template>
    <xsl:template match="@séparateurs[.='tous']" priority="1">
        <xsl:attribute name="rowsep">1</xsl:attribute>
        <xsl:attribute name="colsep">1</xsl:attribute>
    </xsl:template>
    <xsl:template match="@séparateurs[.='aucun']" priority="1">
        <xsl:attribute name="rowsep">0</xsl:attribute>
        <xsl:attribute name="colsep">0</xsl:attribute>
    </xsl:template>
    <xsl:template match="@séparateurs[.='lignes']" priority="1">
        <xsl:attribute name="rowsep">1</xsl:attribute>
        <xsl:attribute name="colsep">0</xsl:attribute>
    </xsl:template>
    <xsl:template match="@séparateurs[.='colonnes']" priority="1">
        <xsl:attribute name="rowsep">0</xsl:attribute>
        <xsl:attribute name="colsep">1</xsl:attribute>
    </xsl:template>
    <xsl:template match="@nombreDeRangées" priority="1"/>
    <xsl:template match="@nombreDeColonnes" priority="1"/>
    <xsl:template match="ld:cellule/@largeur" priority="1"/>
</xsl:stylesheet>
