unit des_vga;


interface


uses dos,crt,clavier,mouselib;


type
   une_trame = array [0..15,0..15] of boolean;
   trames    = array [0..15] of une_trame;
   pointtype = record
                  x,y : integer;
               end;
   fillpatterntype = array [0..7] of byte;

   t_gp   = function (x,y:integer) :byte;
   t_pp   = procedure(x,y:integer;c:byte);
   t_line = procedure(a,b,c,d:integer);


var
   getpixel     : t_gp;
   putpixel,
   putpixel_xor : t_pp;
   line         : t_line;

   getmaxx,
   getmaxy,
   getmaxcolor  : integer;

   x,y          : longint;
   trame        : trames;
   tramexy      : array [0..15] of pointtype;
   gch,drt      : boolean;


procedure setviewport  (a,b,c,d : integer; l:boolean);
procedure setcolor     (  c:integer);
procedure setfillstyle (t,c:integer);
procedure inivga2(mode:byte);
procedure ini_des_vga;
procedure setpalette   (i,j:integer);
procedure setrgbpalette(n : integer;     r,v,b : byte);
procedure getrgbpalette(n : integer; var r,v,b : byte);
procedure setfillpattern(fp:fillpatterntype;c:integer);
function  gp  (x,y:integer): byte;   {normal}
function  gpt (x,y:integer): byte;   {test bornes}
procedure pp  (x,y:integer;c:byte);  {normal}
procedure pptr(x,y:integer);         {trame et test}
procedure ppt (x,y:integer;c:byte);  {test}
procedure ppx (x,y:integer;c:byte);  {xor}
procedure pptx(x,y:integer;c:byte);  {test xor}
procedure ef_curs;
procedure af_curs(x,y:integer);
procedure palette(cm,tx,ty:integer);
procedure souris;
procedure linen (x0,y0,x,y:integer);  {normale}
procedure linetr(x0,y0,x,y:integer);  {trame et test}
procedure linet (x0,y0,x,y:integer);  {test}
procedure linex (x0,y0,x,y:integer);  {xor et test}
{procedure floodfill(x,y,b:integer);}
procedure floodfill (x,y,cc :integer);
procedure rectangle(a,b,c,d:integer);
procedure rectanglex(a,b,c,d:integer);
procedure bar(a,b,c,d:integer);
procedure fillpoly(n:integer;var p);
procedure restorecrtmode;
function  textwidth(s:string):integer;
function  textheight(s:string):integer;
procedure outtextxy(x,y:integer;s:string);


implementation


const
   nbi      =  26;
   tcursmax =  21;


type
   tabpoints = array[0..16000] of pointtype;
   t_caracs  = array[char,0..7] of byte;


var
   caracs           : t_caracs;

   s                : string;

   i,j,im,xm,ym,
   x2,y2,
   x1,y1,x0,y0      : longint;

   minx,maxx,
   miny,maxy,
   st,bt,xs,ys,
   cx,cy,nul,
   coulcour,
   coulfill,
   ntrame,
   trmx,trmy,
   xcurs,ycurs      : integer;

   tcurs            : 0..tcursmax;

   fond,
   cursx,cursy      : array[1..tcursmax] of integer;

   limites,
   debut,quitter    : boolean;




procedure setviewport  (a,b,c,d : integer; l:boolean);
   begin
      if a<0 then a:=0 else if a>getmaxx then a:=getmaxx;
      if b<0 then b:=0 else if b>getmaxy then b:=getmaxy;
      if c<0 then c:=0 else if c>getmaxx then c:=getmaxx;
      if d<0 then d:=0 else if d>getmaxy then d:=getmaxy;

      if c<a then begin  nul:=a; a:=c; c:=nul  end;
      if d<b then begin  nul:=b; b:=d; d:=nul  end;

      minx:=a;  miny:=b;
      maxx:=c;  maxy:=d;
      limites:=l;

      if l then begin
         getpixel    :=gpt;
         putpixel    :=ppt;
         putpixel_xor:=pptx;
         line        :=linet;
      end else begin
         getpixel    :=gp;
         putpixel    :=pp;
         putpixel_xor:=ppx;
         line        :=linen;
      end;
   end;


procedure setcolor     (  c:integer);     begin  coulcour:=c             end;
procedure setpalette   (i,j:integer);     begin  end;

procedure setfillstyle (t,c:integer);
   begin
      coulfill:=c;
      ntrame:=t;
      trmx:=tramexy[t].x;
      trmy:=tramexy[t].y;
   end;


procedure setfillpattern(fp:fillpatterntype;c:integer);
   begin
      ntrame:=12;
      trmx:=tramexy[12].x;
      trmy:=tramexy[12].y;
      coulfill:=c;
      for i:=0 to 7 do
         for j:=0 to 7 do
            trame[12,i,j]:= ( ( fp[j] shr i ) mod 2 ) = 1;
   end;


procedure inivga2(mode:byte);
   var r88srs  : registers;
   begin
      if mode=-1 then mode:=$30;

      with r88srs do begin
         ah:=$0;
         al:=mode;
         intr($10,r88srs)
      end;

      case mode of
         $30 : begin
                  getmaxx:=799;
                  getmaxy:=599;
                  getmaxcolor:=255;
               end;
      end;
   end;


procedure ini_des_vga;
   var
      i   : integer;
      fic : file of t_caracs;

   begin
      inivga2($30);

      dernier:=#0;

      assign(fic,'\pas5\travail\caracs.fnt');
      reset(fic);
      read(fic,caracs);
      close(fic);

      setviewport(0,0,getmaxx,getmaxy,false);
      setcolor(1);
      setfillstyle(1,1);

      x0:=0; y0:=0;

      xcurs:=1;  ycurs:=1;
      xs:=200;   ys:=200;
      tcurs:=21;
      for i:=1 to tcurs do begin
         cursx[i]:=0;
         cursy[i]:=0
      end;

      for i:=1 to 5 do begin
         cursx[i+ 1]:=-i;    cursy[i+ 6]:=-i;
         cursx[i+11]:= i;    cursy[i+16]:= i;
      end;

      for i:=1 to tcurs do fond[i]:=0;

      ntrame:=1;
      for i:=0 to 15 do begin
         tramexy[i].x:=1;
         tramexy[i].y:=1;
         trame[i,0,0]:=true;
      end;

      tramexy[2].x:=2;
      tramexy[2].y:=2;
      trame[2,0,0]:=true;
      trame[2,1,1]:=true;
      trame[2,1,0]:=false;
      trame[2,0,1]:=false;

      tramexy[3].x:=2;
      tramexy[3].y:=2;
      trame[3,1,0]:=true;
      trame[3,0,1]:=true;
      trame[3,0,0]:=false;
      trame[3,1,1]:=false;

      tramexy[12].x:=8;
      tramexy[12].y:=8;
   end;


procedure setrgbpalette(n : integer; r,v,b : byte);
   var r88srs  : registers;
   begin
      with r88srs do begin
         ah:=$10;
         al:=$10;
         bx:=n;
         dh:=r;
         ch:=v;
         cl:=b;
         intr($10,r88srs)
      end
   end;

procedure getrgbpalette(n : integer; var r,v,b : byte);
   var r88srs  : registers;
   begin
      with r88srs do begin
         ah:=$10;
         al:=$15;
         bx:=n;
         dh:=r;
         ch:=v;
         cl:=b;
         intr($10,r88srs)
      end
   end;

function gp(x,y:integer):byte;
   var r88srs  : registers;
   begin
      with r88srs do begin
         ah:=$d;
         bh:=0;
         cx:=x;
         dx:=y;
         intr($10,r88srs);
         gp:=al
      end
   end;

function gpt(x,y:integer):byte;
   var r88srs  : registers;
   begin
      x:=x+minx;
      y:=y+miny;
      if (x>=minx) and (y>=miny) and (x<=maxx) and (y<=maxy) then begin
         with r88srs do begin
            ah:=$d;
            bh:=0;
            cx:=x;
            dx:=y;
            intr($10,r88srs);
            gpt:=al
         end
      end
      else gpt:=0
   end;

procedure pp(x,y:integer;c:byte);
   var r88srs  : registers;
   begin
      with r88srs do begin
         ah:=$c;
         al:=c;
         bh:=0;
         cx:=x;
         dx:=y;
         intr($10,r88srs)
      end
   end;

procedure pptr(x,y:integer);
   var r88srs  : registers;
   begin
      x:=x+minx;
      y:=y+miny;
      if (x>=minx) and (y>=miny) and (x<=maxx) and (y<=maxy) then
         if trame[ntrame,x mod trmx,y mod trmy] then
            with r88srs do begin
               ah:=$c;
               al:=coulfill;
               bh:=0;
               cx:=x;
               dx:=y;
               intr($10,r88srs)
            end;
   end;

procedure ppt(x,y:integer;c:byte);
   var r88srs  : registers;
   begin
      x:=x+minx;
      y:=y+miny;
      if (x>=minx) and (y>=miny) and (x<=maxx) and (y<=maxy) then begin
         with r88srs do begin
            ah:=$c;
            al:=c;
            bh:=0;
            cx:=x;
            dx:=y;
            intr($10,r88srs)
         end
      end
   end;

procedure ppx(x,y:integer;c:byte);
   var r88srs  : registers;
   begin
      with r88srs do begin
         ah:=$c;
         al:=c xor gp(x,y);
         bh:=0;
         cx:=x;
         dx:=y;
         intr($10,r88srs)
      end
   end;

procedure pptx(x,y:integer;c:byte);
   var r88srs  : registers;
   begin
      x:=x+minx;
      y:=y+miny;
      if (x>=minx) and (y>=miny) and (x<=maxx) and (y<=maxy) then begin
         with r88srs do begin
            ah:=$c;
            al:=c xor gpt(x,y);
            bh:=0;
            cx:=x;
            dx:=y;
            intr($10,r88srs)
         end
      end
   end;


procedure ef_curs;
   var
      i : integer;

   begin
      for i:=1 to tcurs do
         ppt(xcurs+cursx[i],ycurs+cursy[i],fond[i]);
   end;


procedure af_curs(x,y:integer);
   var
      i : integer;

   begin
      for i:=1 to tcurs do begin
         fond[i]:=gpt(x+cursx[i],y+cursy[i]);
         ppt(x+cursx[i],y+cursy[i],1)
      end;
      xcurs:=x;   ycurs:=y
   end;


procedure palette(cm,tx,ty:integer);
   var
      i,j,k : integer;

   begin
      for i:=0 to cm do
         for j:=0 to tx-1 do
            for k:=0 to ty do
               pp(i*tx+j,k,i)
   end;


procedure souris;
   begin
      etatsouris(gch,drt,nul,nul);
      compteursouris(cx,cy);
      xs:=xs+cx;    ys:=ys+cy;
      x:=xs div 2;  y:=ys div 2;
      if x<0       then begin    xs:=0;             x:=0          end;
      if x>getmaxx then begin    xs:=getmaxx*2+1;   x:=getmaxx    end;
      if y<0       then begin    ys:=0;             y:=0          end;
      if y>getmaxy then begin    ys:=getmaxy*2+1;   y:=getmaxy    end;
      a:=' ';
      a:=auvol
   end;


procedure linen(x0,y0,x,y:integer);
   var
      i,i0,ii,j,k,n,m,r,s,s2  : integer;

   begin
      if y=y0 then begin

         if x0>x then begin   s:=x; x:=x0; x0:=s   end;
         if x0>0 then i0:=x0 else i0:=  0;
         if x<=getmaxx then ii:=x  else ii:=getmaxx;
         for i:=i0 to ii do pp(i,y,coulcour)

      end else
      if x=x0 then begin

         if y0>y then begin   s:=y; y:=y0; y0:=s   end;
         if y0>0 then i0:=y0 else i0:=  0;
         if y<=getmaxy then ii:=y  else ii:=getmaxy;
         for i:=i0 to ii do pp(x,i,coulcour)

      end else
      if (x-x0)=(y-y0) then begin

         if x0>x then begin   s:=x; x:=x0; x0:=s;   s:=y; y:=y0; y0:=s   end;
         if x0>0 then i0:=x0    else i0:=  0;
         if x<=getmaxx then ii:=x-i0  else ii:=getmaxx-i0;
         if (y0+ii)>getmaxy then ii:=getmaxy-y0;
         for i:=0 to ii do pp(x0+i,y0+i,coulcour)

      end else
      if (x-x0)=-(y-y0) then begin

         if x0>x then begin   s:=x; x:=x0; x0:=s;   s:=y; y:=y0; y0:=s   end;
         if x0>0 then i0:=x0    else i0:=  0;
         if x<=getmaxx then ii:=x-i0  else ii:=getmaxx-i0;
         if (y0-ii)<0 then ii:=y0;
         for i:=0 to ii do pp(x0+i,y0-i,coulcour)

      end else
      if abs(x-x0)>abs(y-y0) then begin

         if x0>x then begin   s:=x; x:=x0; x0:=s;   s:=y; y:=y0; y0:=s   end;
         n:=(x-x0) div abs(y-y0);
         r:=(x-x0) mod abs(y-y0);
         if y>y0 then m:=1 else m:=-1;
         s2:=abs(y-y0) div 2;
         s:=0;   i:=x0;   j:=y0;
         repeat
            ii:=i+n;   s:=s+r;
            if s>s2 then begin   s:=s-abs(y-y0);  ii:=ii+1   end;
            for k:=i to ii-1 do pp(k,j,coulcour);
            j:=j+m;    i:=ii
         until (i=x) or (j=0) or (i=getmaxx+1) or (j=getmaxy+1);
         ppt(x,y,coulcour)

      end else begin

         if y0>y then begin   s:=x; x:=x0; x0:=s;   s:=y; y:=y0; y0:=s   end;
         n:=(y-y0) div abs(x-x0);
         r:=(y-y0) mod abs(x-x0);
         if x>x0 then m:=1 else m:=-1;
         s2:=abs(x-x0) div 2;
         s:=0;   i:=y0;   j:=x0;
         repeat
            ii:=i+n;   s:=s+r;
            if s>s2 then begin   s:=s-abs(x-x0);  ii:=ii+1   end;
            for k:=i to ii-1 do pp(j,k,coulcour);
            j:=j+m;    i:=ii
         until (i=y) or (j=0) or (j=getmaxx+1) or (i=getmaxy+1);
         ppt(x,y,coulcour)

      end
   end;


procedure linetr(x0,y0,x,y:integer);
   var
      i,i0,ii,j,k,n,m,r,s,s2  : integer;

   begin
      if y=y0 then begin

         if x0>x then begin   s:=x; x:=x0; x0:=s   end;
         if x0>0 then i0:=x0 else i0:=  0;
         if x<=getmaxx then ii:=x  else ii:=getmaxx;
         for i:=i0 to ii do pptr(i,y)

      end else
      if x=x0 then begin

         if y0>y then begin   s:=y; y:=y0; y0:=s   end;
         if y0>0 then i0:=y0 else i0:=  0;
         if y<=getmaxy then ii:=y  else ii:=getmaxy;
         for i:=i0 to ii do pptr(x,i)

      end else
      if (x-x0)=(y-y0) then begin

         if x0>x then begin   s:=x; x:=x0; x0:=s;   s:=y; y:=y0; y0:=s   end;
         if x0>0 then i0:=x0    else i0:=  0;
         if x<=getmaxx then ii:=x-i0  else ii:=getmaxx-i0;
         if (y0+ii)>getmaxy then ii:=getmaxy-y0;
         for i:=0 to ii do pptr(x0+i,y0+i)

      end else
      if (x-x0)=-(y-y0) then begin

         if x0>x then begin   s:=x; x:=x0; x0:=s;   s:=y; y:=y0; y0:=s   end;
         if x0>0 then i0:=x0    else i0:=  0;
         if x<=getmaxx then ii:=x-i0  else ii:=getmaxx-i0;
         if (y0-ii)<0 then ii:=y0;
         for i:=0 to ii do pptr(x0+i,y0-i)

      end else
      if abs(x-x0)>abs(y-y0) then begin

         if x0>x then begin   s:=x; x:=x0; x0:=s;   s:=y; y:=y0; y0:=s   end;
         n:=(x-x0) div abs(y-y0);
         r:=(x-x0) mod abs(y-y0);
         if y>y0 then m:=1 else m:=-1;
         s2:=abs(y-y0) div 2;
         s:=0;   i:=x0;   j:=y0;
         repeat
            ii:=i+n;   s:=s+r;
            if s>s2 then begin   s:=s-abs(y-y0);  ii:=ii+1   end;
            for k:=i to ii-1 do pptr(k,j);
            j:=j+m;    i:=ii
         until (i=x) or (j=0) or (i=getmaxx+1) or (j=getmaxy+1);
         pptr(x,y)

      end else begin

         if y0>y then begin   s:=x; x:=x0; x0:=s;   s:=y; y:=y0; y0:=s   end;
         n:=(y-y0) div abs(x-x0);
         r:=(y-y0) mod abs(x-x0);
         if x>x0 then m:=1 else m:=-1;
         s2:=abs(x-x0) div 2;
         s:=0;   i:=y0;   j:=x0;
         repeat
            ii:=i+n;   s:=s+r;
            if s>s2 then begin   s:=s-abs(x-x0);  ii:=ii+1   end;
            for k:=i to ii-1 do pptr(j,k);
            j:=j+m;    i:=ii
         until (i=y) or (j=0) or (j=getmaxx+1) or (i=getmaxy+1);
         pptr(x,y)

      end
   end;


procedure linet(x0,y0,x,y:integer);
   var
      i,i0,ii,j,k,n,m,r,s,s2  : integer;

   begin
      if y=y0 then begin

         if x0>x then begin   s:=x; x:=x0; x0:=s   end;
         if x0>0 then i0:=x0 else i0:=  0;
         if x<=getmaxx then ii:=x  else ii:=getmaxx;
         for i:=i0 to ii do ppt(i,y,coulcour)

      end else
      if x=x0 then begin

         if y0>y then begin   s:=y; y:=y0; y0:=s   end;
         if y0>0 then i0:=y0 else i0:=  0;
         if y<=getmaxy then ii:=y  else ii:=getmaxy;
         for i:=i0 to ii do ppt(x,i,coulcour)

      end else
      if (x-x0)=(y-y0) then begin

         if x0>x then begin   s:=x; x:=x0; x0:=s;   s:=y; y:=y0; y0:=s   end;
         if x0>0 then i0:=x0    else i0:=  0;
         if x<=getmaxx then ii:=x-i0  else ii:=getmaxx-i0;
         if (y0+ii)>getmaxy then ii:=getmaxy-y0;
         for i:=0 to ii do ppt(x0+i,y0+i,coulcour)

      end else
      if (x-x0)=-(y-y0) then begin

         if x0>x then begin   s:=x; x:=x0; x0:=s;   s:=y; y:=y0; y0:=s   end;
         if x0>0 then i0:=x0    else i0:=  0;
         if x<=getmaxx then ii:=x-i0  else ii:=getmaxx-i0;
         if (y0-ii)<0 then ii:=y0;
         for i:=0 to ii do ppt(x0+i,y0-i,coulcour)

      end else
      if abs(x-x0)>abs(y-y0) then begin

         if x0>x then begin   s:=x; x:=x0; x0:=s;   s:=y; y:=y0; y0:=s   end;
         n:=(x-x0) div abs(y-y0);
         r:=(x-x0) mod abs(y-y0);
         if y>y0 then m:=1 else m:=-1;
         s2:=abs(y-y0) div 2;
         s:=0;   i:=x0;   j:=y0;
         repeat
            ii:=i+n;   s:=s+r;
            if s>s2 then begin   s:=s-abs(y-y0);  ii:=ii+1   end;
            for k:=i to ii-1 do ppt(k,j,coulcour);
            j:=j+m;    i:=ii
         until (i=x) or (j=0) or (i=getmaxx+1) or (j=getmaxy+1);
         ppt(x,y,coulcour)

      end else begin

         if y0>y then begin   s:=x; x:=x0; x0:=s;   s:=y; y:=y0; y0:=s   end;
         n:=(y-y0) div abs(x-x0);
         r:=(y-y0) mod abs(x-x0);
         if x>x0 then m:=1 else m:=-1;
         s2:=abs(x-x0) div 2;
         s:=0;   i:=y0;   j:=x0;
         repeat
            ii:=i+n;   s:=s+r;
            if s>s2 then begin   s:=s-abs(x-x0);  ii:=ii+1   end;
            for k:=i to ii-1 do ppt(j,k,coulcour);
            j:=j+m;    i:=ii
         until (i=y) or (j=0) or (j=getmaxx+1) or (i=getmaxy+1);
         ppt(x,y,coulcour)

      end
   end;


procedure linex(x0,y0,x,y:integer);
   var
      i,i0,ii,j,k,n,m,r,s,s2  : integer;

   begin
      if y=y0 then begin

         if x0>x then begin   s:=x; x:=x0; x0:=s   end;
         if x0>0 then i0:=x0 else i0:=  0;
         if x<=getmaxx then ii:=x  else ii:=getmaxx;
         for i:=i0 to ii do pptx(i,y,coulcour)

      end else
      if x=x0 then begin

         if y0>y then begin   s:=y; y:=y0; y0:=s   end;
         if y0>0 then i0:=y0 else i0:=  0;
         if y<=getmaxy then ii:=y  else ii:=getmaxy;
         for i:=i0 to ii do pptx(x,i,coulcour)

      end else
      if (x-x0)=(y-y0) then begin

         if x0>x then begin   s:=x; x:=x0; x0:=s;   s:=y; y:=y0; y0:=s   end;
         if x0>0 then i0:=x0    else i0:=  0;
         if x<=getmaxx then ii:=x-i0  else ii:=getmaxx-i0;
         if (y0+ii)>getmaxy then ii:=getmaxy-y0;
         for i:=0 to ii do pptx(x0+i,y0+i,coulcour)

      end else
      if (x-x0)=-(y-y0) then begin

         if x0>x then begin   s:=x; x:=x0; x0:=s;   s:=y; y:=y0; y0:=s   end;
         if x0>0 then i0:=x0    else i0:=  0;
         if x<=getmaxx then ii:=x-i0  else ii:=getmaxx-i0;
         if (y0-ii)<0 then ii:=y0;
         for i:=0 to ii do pptx(x0+i,y0-i,coulcour)

      end else
      if abs(x-x0)>abs(y-y0) then begin

         if x0>x then begin   s:=x; x:=x0; x0:=s;   s:=y; y:=y0; y0:=s   end;
         n:=(x-x0) div abs(y-y0);
         r:=(x-x0) mod abs(y-y0);
         if y>y0 then m:=1 else m:=-1;
         s2:=abs(y-y0) div 2;
         s:=0;   i:=x0;   j:=y0;
         repeat
            ii:=i+n;   s:=s+r;
            if s>s2 then begin   s:=s-abs(y-y0);  ii:=ii+1   end;
            for k:=i to ii-1 do pptx(k,j,coulcour);
            j:=j+m;    i:=ii
         until (i=x) or (j=0) or (i=getmaxx+1) or (j=getmaxy+1);
         pptx(x,y,coulcour)

      end else begin

         if y0>y then begin   s:=x; x:=x0; x0:=s;   s:=y; y:=y0; y0:=s   end;
         n:=(y-y0) div abs(x-x0);
         r:=(y-y0) mod abs(x-x0);
         if x>x0 then m:=1 else m:=-1;
         s2:=abs(x-x0) div 2;
         s:=0;   i:=y0;   j:=x0;
         repeat
            ii:=i+n;   s:=s+r;
            if s>s2 then begin   s:=s-abs(x-x0);  ii:=ii+1   end;
            for k:=i to ii-1 do pptx(j,k,coulcour);
            j:=j+m;    i:=ii
         until (i=y) or (j=0) or (j=getmaxx+1) or (i=getmaxy+1);
         pptx(x,y,coulcour)

      end
   end;


(* procedure surf(d1,g1,y,dep,b :integer);
   var
      d2,g2,xc  :integer;
      flg1,flg2 :boolean;

   begin
      flg2:=false;
      while not flg2 do begin
         xc:=g1+1;
         flg1:=false;
         while (not flg1) and (xc<>d1) do begin
            if (gp(xc,y+dep)<>b) and (xc>=0) and (xc<=getmaxx+1)
               and (y+dep>=0) and (y+dep<=getmaxy+1)
            then flg1:=true
            else xc:=xc+1;
         end;
         g2:=xc-1;

         if not flg1 then flg2:=true;
         flg1:=false;
         if not flg2 then begin
            if g2=g1 then begin
               while not flg1 do begin
                  if (gp(xc,y+dep)=b) or (xc>getmaxx+1) or (xc<0)
                     or (y+dep>getmaxy+1) or (y+dep<0)
                  then flg1:=true
                  else xc:=xc-1;
               end;
               g2:=xc;
            end;
            if (g2<g1-1) and (g1>=0) and (g1<=getmaxx+1)
               and (g2>=0) and (g2<=getmaxy+1)
            then surf(g1,g2,y+dep,-dep,b);
            xc:=g2+1;
            y:=y+dep;
            flg1:=false;
            while not flg1 do begin
               pptr(xc,y);
               if (gp(xc+1,y)=b) or (xc+1>getmaxx+1) or (xc+1<0)
                  or (y>getmaxy+1) or (y<0)
               then flg1:=true
               else xc:=xc+1;
            end;
            d2:=xc+1;
            if (d2>d1+1) and (d2>=0) and (d2<=getmaxx+1)
               and (d1>=0) and (d1<=getmaxy+1) then surf(d2,d1,y,-dep,b);
            if (d2<d1-1) and (d1>=0) and (d1<=getmaxx+1)
               and (d2>=0) and (d2<=getmaxy+1) then surf(d1,d2,y-dep,dep,b);
            d1:=d2;
            g1:=g2;
         end;
      end;
   end;

procedure floodfill(x,y,b : integer);
   var
      d,g,xt,yt : integer;
      flg       : boolean;

   begin
      flg:=false;
      g:=x+1;
      while not flg do begin
         if (gp(g-1,y)=b) or (g-1>getmaxx+1) or (g-1<0)
            or (y>getmaxy+1) or (y<0)
         then flg:=true
         else begin
            g:=g-1;
            pptr(g,y);
         end;
      end;
      flg:=false;
      g:=g-1;
      d:=x;
      while not flg do begin
         if (gp(d+1,y)=b) or (d+1>getmaxx+1) or (d+1<0)
            or (y>getmaxy+1) or (y<0) then flg:=true
         else begin
            d:=d+1;
            pptr(d,y);
         end;
      end;
      d:=d+1;
      surf(d,g,y,1,b);
      surf(d,g,y,-1,b)
   end;
   *)
procedure surf(d1,g1,y,dep,cb,cc :integer) ;
   var
      d2,g2,xc,point  :integer;
      flg1,flg2       :boolean;

   begin
      flg2:=false;
      while not flg2 do begin
         xc:=g1+1;
         flg1:=false;
         while (not flg1) and (xc<>d1) do
            if (gp (xc,y+dep)=cb) and (xc>=0) and (xc<=getmaxx)
               and (y+dep>=0) and (y+dep<=getmaxy) then flg1:=true
            else xc:=xc+1;
         g2:=xc-1;

         if not flg1 then flg2:=true;
         flg1:=false;
         if not flg2 then begin
            if g2=g1 then begin
               while not flg1 do begin
                  if (gp (xc,y+dep)<>cb) or (xc>getmaxx) or (xc<0)
                     or (y+dep>getmaxy) or (y+dep<0) then flg1:=true
                  else xc:=xc-1;
               end;
               g2:=xc;
            end;
            if (g2<g1-1) and (g1>=0) and (g1<=getmaxx)
               and (g2>=0) and (g2<=getmaxy) then surf(g1,g2,y+dep,-dep,cb,cc);
            xc:=g2+1;
            y:=y+dep;
            flg1:=false;
            while not flg1 do begin
               pptr(xc,y);
               if (gp(xc+1,y)<>cb) or (xc+1>getmaxx) or (xc+1<0)
                  or (y>getmaxy) or (y<0) then flg1:=true
               else xc:=xc+1;
            end;
            d2:=xc+1;
            if (d2>d1+1) and (d2>=0) and (d2<=getmaxx)
               and (d1>=0) and (d1<=getmaxy) then surf(d2,d1,y,-dep,cb,cc);
            if (d2<d1-1) and (d1>=0) and (d1<=getmaxx)
               and (d2>=0) and (d2<=getmaxy) then surf(d1,d2,y-dep,dep,cb,cc);
            d1:=d2;
            g1:=g2;
         end;
      end;
   end;

procedure floodfill (x,y,cc :integer);
   var
      cb,d,g,xt,yt,point :integer;
      flg                :boolean;
   begin
      cb:=gp(x,y);
      if cb<>cc then begin
         flg:=false;
         g:=x+1;
         while not flg do
            if (gp(g-1,y)<>cb) or (g-1>getmaxx) or (g-1<0)
               or (y>getmaxy) or (y<0) then flg:=true
         else begin
            g:=g-1;
            pptr(g,y);
         end;
         flg:=false;
         g:=g-1;
         d:=x;
         while not flg do
            if (gp(d+1,y)<>cb) or (d+1>getmaxx) or (d+1<0)
               or (y>getmaxy) or (y<0) then flg:=true
            else begin
               d:=d+1;
               pptr(d,y);
            end;
         d:=d+1;
         surf(d,g,y,1,cb,cc);
         surf(d,g,y,-1,cb,cc)
      end;
   end;


procedure rectangle(a,b,c,d:integer);
   begin
      line(a,b,c,b);
      line(c,b,c,d);
      line(c,d,a,d);
      line(a,d,a,b);
   end;


procedure rectanglex(a,b,c,d:integer);
   begin
      linex(a,b,c,b);
      linex(c,b,c,d);
      linex(c,d,a,d);
      linex(a,d,a,b);
   end;


procedure bar(a,b,c,d:integer);
   var
      i,j : word;
   begin
      for i:=a to c do
          for j:=b to d do pptr(i,j);
   end;


procedure fillpoly2(n:integer;var p);
   var
      i,x,y : integer;
      a     : longint;
      v     : real;
      pol   : ^tabpoints;

   begin
      a:=0;
      setcolor(coulfill);
      pol:=@p;

      for i:=0 to n-2 do begin
         line(pol^[i].x,pol^[i].y,pol^[i+1].x,pol^[i+1].y);
         a:=a + ( (pol^[i+1].x-pol^[i].x) * (pol^[i+1].y+pol^[i].y) ) div 2;
      end;

      line(pol^[n-1].x,pol^[n-1].y,pol^[0].x,pol^[0].y);
      a:=a + ( (pol^[0].x-pol^[n-1].x) * (pol^[0].y+pol^[n-1].y) ) div 2;

      if a<>0 then begin
         if a>0 then begin
            x:=pol^[2].y-pol^[0].y;
            y:=pol^[0].x-pol^[2].x;
            v:=sqrt(sqr(x)+sqr(y));
            x:=pol^[1].x+round(4*x/v);{*2}
            y:=pol^[1].y+round(4*y/v); {}
         end else begin
            x:=pol^[0].y-pol^[2].y;
            y:=pol^[2].x-pol^[0].x;
            v:=sqrt(sqr(x)+sqr(y));
            x:=pol^[1].x+round(4*x/v); {}
            y:=pol^[1].y+round(4*y/v); {}
         end;

         floodfill(x,y,coulfill);
      end;

      for i:=0 to n-2 do
         linetr(pol^[i].x,pol^[i].y,pol^[i+1].x,pol^[i+1].y);
      linetr(pol^[n-1].x,pol^[n-1].y,pol^[0].x,pol^[0].y);
   end;


procedure fillpoly(n:integer;var p);
   var
      nt,cf : integer;
   begin
      nt:=ntrame;
      cf:=coulfill;
      setfillstyle(0,255);
      fillpoly2(n,p);

      setfillstyle(nt,cf);
      fillpoly2(n,p);
   end;


procedure restorecrtmode;
   begin
      inivga2($2);
      clrscr;
   end;


function  textheight(s:string):integer;   begin  textheight:=8;           end;
function  textwidth (s:string):integer;   begin  textwidth:=8*length(s);  end;


procedure outchar(var x,y:integer;a:char);
   var
      i,j : integer;
   begin
      for i:=0 to 7 do
         for j:=0 to 7 do
            putpixel(x+i,y+j,((caracs[a,j] shr (7-i)) and 1)*coulcour);
      x:=x+8;
   end;


procedure outtextxy(x,y:integer;s:string);
   begin
      for i:=1 to length(s) do outchar(x,y,s[i]);
   end;

end.