UNIT GRAPHDA;

{---------------------------------------------------------------------------}
{         bibliothque                                                      }
{                  GRAPHISME POUR DESSINS ANIMES                            }
{                                                               03/05/91    }
{---------------------------------------------------------------------------}
{---------------------------------------------------------------------------}

INTERFACE

  USES
   printer,
   dos,
   crt,
   graph,                            { TP 55   - units standard }
   Graphism,                         { ARX     - initialisations graphiques }
   Fctmath;                          { ARX     - fonctions mathmatiques }

{---------------------------------------------------------------------------}
  Procedure def_trame      (l1, l2, l3, l4, l5, l6, l7, l8 : byte);

  Procedure peint          (x, y, cc, cf : integer);

  Procedure nbcoul         (nome,noms : string;               var test : boolean);
     {transforme 'nome', fichier .ima noir et blanc en fichier 'noms' couleur.}

  Procedure coulnb         (nome, noms : string; var test : boolean);

  Procedure chargeda       (nom : string);
     {nom sans extension,ne charge que les .seq cres par DA }

  Procedure animeda        (imaged, imagef, x, y, dx, dy, t, n, s : integer);
     {imaged  = n de l'image de depart
      imagef  = n de l'image de fin , 0 = dernire image
      x,y     = coordonnes de la position de la premire image
      dx,dy   = dplacement entre chaque image (en pixels)
      t       = tempo (20 par exemple)
      n       = nombre de rptitions de la squence imaged  imagef
      s       = sens de rotation (+1 ou -1) }

  Procedure afficheImage    (n, x, y, mode : integer);

  Procedure libereda;

  Procedure AfficheUneImage (nom : string; n, x, y, mode : integer);

  Procedure imprime       (xi, yi, xf, yf, q, video : integer);
     {q = qualit  : 1 -> 240 points/pouce
                     2 -> 120   "
                     3 -> 72    "
      video        : 0 -> pixel blanc donne point noir
                     1 -> pixel noir  donne point blanc  }

  Procedure eliminepoints (xi, yi, xf, yf : integer);

  Procedure contours      (xi, yi, xf, yf, c : integer);

  Procedure vecteur       (xi, yi, xf, yf : integer; nomf : string);

  Procedure fondu         (palet          : fixe);

{---------------------------------------------------------------------------}
IMPLEMENTATION

TYPE
   dess  = array [1..MAXIMAGE] of byte;

VAR
   taille              : word;
   image,sequence      : file;
   dessin,despb        : ^dess;
   x0                  : array [1..100] of integer;
   y0                  : array [1..100] of integer;
   lieu                : array [1..100] of pointer;
   num,i               : integer;
   pal2                : fixe;
   fond                : boolean;
   rvb                 : array [0..15] of record r,v,b :integer end;
   rvbdelta            : array [0..15] of record r,v,b :integer end;
   trame               : array [0..7]  of byte;
   plein               : boolean;

procedure def_trame(l1,l2,l3,l4,l5,l6,l7,l8 :byte);
   begin
      trame[0]:=l1;
      trame[1]:=l2;
      trame[2]:=l3;
      trame[3]:=l4;
      trame[4]:=l5;
      trame[5]:=l6;
      trame[6]:=l7;
      trame[7]:=l8;
      if l1 and l2 and l3 and l4 and l5 and l6 and l7 and l8 =$FF
         then plein:=true else plein:=false;
   end;

procedure surf(d1,g1,y,dep,cb,cc,cf :integer) ;
   var
      d2,g2,xc,point  :integer;
      flg1,flg2       :boolean;

   begin
      flg2:=false;
      while not flg2 do begin
         xc:=g1+1;
         flg1:=false;
         while (not flg1) and (xc<>d1) do
            if (getpixel(xc,y+dep)=cb) and (xc>=0) and (xc<=maxx)
               and (y+dep>=0) and (y+dep<=maxy) then flg1:=true
            else xc:=xc+1;
         g2:=xc-1;

         if not flg1 then flg2:=true;
         flg1:=false;
         if not flg2 then begin
            if g2=g1 then begin
               while not flg1 do begin
                  if (getpixel(xc,y+dep)<>cb) or (xc>maxx) or (xc<0)
                     or (y+dep>maxy) or (y+dep<0) then flg1:=true
                  else xc:=xc-1;
               end;
               g2:=xc;
            end;
            if (g2<g1-1) and (g1>=0) and (g1<=maxx)
               and (g2>=0) and (g2<=maxy) then surf(g1,g2,y+dep,-dep,cb,cc,cf);
            xc:=g2+1;
            y:=y+dep;
            flg1:=false;
            while not flg1 do begin
               if not plein then begin
                  point:=trunc(puissance(2,7-(xc mod 8)));
                  if (trame[y mod 8] and point)=point then
                     putpixel(xc,y,cc)
                  else putpixel(xc,y,cf)
               end
               else putpixel(xc,y,cc);
               if (getpixel(xc+1,y)<>cb) or (xc+1>maxx) or (xc+1<0)
                  or (y>maxy) or (y<0) then flg1:=true
               else xc:=xc+1;
            end;
            d2:=xc+1;
            if (d2>d1+1) and (d2>=0) and (d2<=maxx)
               and (d1>=0) and (d1<=maxy) then surf(d2,d1,y,-dep,cb,cc,cf);
            if (d2<d1-1) and (d1>=0) and (d1<=maxx)
               and (d2>=0) and (d2<=maxy) then surf(d1,d2,y-dep,dep,cb,cc,cf);
            d1:=d2;
            g1:=g2;
         end;
      end;
   end;

procedure peint(x,y,cc,cf :integer);
   var
      cb,d,g,xt,yt,point :integer;
      flg                :boolean;

   begin
      cb:=getpixel(x,y);
      if cb<>cc then begin
         flg:=false;
         g:=x+1;
         while not flg do
            if (getpixel(g-1,y)<>cb) or (g-1>maxx) or (g-1<0)
               or (y>maxy) or (y<0) then flg:=true
         else begin
            g:=g-1;
            point:=trunc(puissance(2,7-(g mod 8)));
            if (trame[y mod 8] and point)=point then
               putpixel(g,y,cc) else putpixel(g,y,cf);
         end;
         flg:=false;
         g:=g-1;
         d:=x;
         while not flg do
            if (getpixel(d+1,y)<>cb) or (d+1>maxx) or (d+1<0)
               or (y>maxy) or (y<0) then flg:=true
            else begin
               d:=d+1;
               point:=trunc(puissance(2,7-(d mod 8)));
               if (trame[y mod 8] and point)=point then
                  putpixel(d,y,cc) else putpixel(d,y,cf);
            end;
         d:=d+1;
         surf(d,g,y,1,cb,cc,cf);
         surf(d,g,y,-1,cb,cc,cf)
      end;
   end;

procedure nbcoul(nome,noms :string;var test:boolean);
   var
      nb,coul        : file of byte;
      b              :byte;
      i,x,y,j        :integer;
      t              :array[1..4] of byte;

   begin
      assign (nb,nome);
      assign (coul,noms);
      {$I-}
      reset(nb);
      {$I+}
      if ioresult=0 then begin
         rewrite(coul);
         test:=true;
         b:=0;
         for i:=1 to 4 do begin
            read(nb,t[i]);
            write(coul,t[i]);
         end;
         x:=round((t[2]*256+t[1]+8)/8);
         y:=t[4]*128+t[3];
         for j:=0 to y do
            for i:=1 to x do begin
               read(nb,b);
               seek(coul,4+(4*j+1)*x+i);
               write(coul,b);
               seek(coul,4+(4*j+2)*x+i);
               write(coul,b);
               seek(coul,4+(4*j+3)*x+i);
               write(coul,b);
               seek(coul,4+(4*j+4)*x+i);
               write(coul,b);
            end;
         close(coul);
      end else test:=false;
      close(nb);
   end;

procedure coulnb(nome,noms :string;var test:boolean);
   var
      nb,coul        : file of byte;
      b              : byte;
      i,x,y,j        : integer;
      t              : array[1..4] of byte;

   begin
      assign (coul,nome);
      assign (nb,noms);
      {$I-}
      reset(coul);
      {$I+}
      if ioresult=0 then begin
         rewrite(nb);
         test:=true;
         b:=0;
         for i:=1 to 4 do begin
            read(coul,t[i]);
            write(nb,t[i]);
         end;
         x:=round((t[2]*256+t[1]+8)/8);
         y:=t[4]*128+t[3];
         for j:=0 to y do
            for i:=1 to (x) do begin
               read(coul,b);
               write(nb,b);
               read(coul,b);
               read(coul,b);
               read(coul,b);
            end;
         close(nb);
      end else test:=false;
      close(coul);
   end;

procedure chargeda   (nom :string);
   type
      int = record x,y :integer end;

   var
      t,i :integer;
      p        :^int;

   begin
      new(p);
      nom:=concat(nom,'.seq');
      assign(sequence,nom);
      reset(sequence,1);
      blockread(sequence,num,2);
      for i:=1 to num-1 do begin
         blockread(sequence,x0[i],2);
         blockread(sequence,y0[i],2);
         blockread(sequence,p^,4);
         if maxcolor=1  then t:=trunc((p^.x+8)/8)*(p^.y+1)+6;
         if maxcolor=15 then t:=trunc((p^.x+8)/8)*(p^.y+1)*4+6;
         getmem(lieu[i],t);
         blockread(sequence,lieu[i]^,t);
      end;
      dispose(p);
      close(sequence);
   end;

procedure animeda;
   var
      i,j,xx,yy : integer;

   begin
      xx:=0;yy:=0;
      if (imagef=0) or (imagef>num-1) then imagef:=num-1;
      if imaged>num-1 then imaged:=num-1;
      if imaged<1 then imaged:=1;
      if imagef<1 then imagef:=1;
      x:=x-x0[1];
      y:=y-y0[1];

      for i:=1 to n do
         for j:=imaged to imagef do begin
            putimage(x+x0[j]+xx,y+y0[j]+yy,lieu[j]^,0);
            delay(t);
            xx:=xx+dx;yy:=yy+dy
         end;
   end;

procedure afficheImage(n,x,y,mode:integer);
   begin
      if (n=0) or (n>num-1) then n:=1;
      putimage(x+(x0[n]-x0[1]),y+(y0[n]-y0[1]),lieu[n]^,mode);
   end;

procedure libereda;
   var
      i : integer;

   begin
      for i:=1 to num-1 do libere(lieu[i]);
      num:=1
   end;

procedure AfficheUneImage (nom :string; n,x,y,mode : integer);
   begin
      ChargeDA (Nom);
      AfficheImage (n,x,y,mode);
      LibereDa;
   end;

procedure fondu;
   var
      i, j : integer;

   const
      d=6;

   begin
      if not fond then begin
         for i:=0 to 15 do begin
            getrgbpalette(i,rvb[i].r,rvb[i].v,rvb[i].b);
            rvbdelta[i].r:=rvb[i].r div d;
            rvbdelta[i].v:=rvb[i].v div d;
            rvbdelta[i].b:=rvb[i].b div d;
         end;
         for i:=1 to d do
            for j:=0 to 15 do begin
               if palet[j] then setrgbpalette(j,(rvb[j].r)-i*rvbdelta[j].r,
                                                (rvb[j].v)-i*rvbdelta[j].v,
                                                (rvb[j].b)-i*rvbdelta[j].b)
            end;
     end else
         for i:=1 to d do
            for j:=0 to 15 do begin
               if palet[j] then setrgbpalette(j,(rvb[j].r)-(d-i)*rvbdelta[j].r,
                                                (rvb[j].v)-(d-i)*rvbdelta[j].v,
                                                (rvb[j].b)-(d-i)*rvbdelta[j].b)
            end;
     fond:=not fond;
  end;

procedure imprime;
   var
      n1,n2,ny1,ny2,x,y,i,j,v,vv,n : integer;
      ini,ini2 : string;

   begin
      if xi>xf then begin x:=xi;xi:=xf;xf:=x end;
      if yi>yf then begin y:=yi;yi:=yf;yf:=y end;
      n1:=(xf-xi) mod 256;
      n2:=trunc(int(  ((xf-xi)/256)  ));
      ny1:=(yf-yi) mod 8;
      ny2:=trunc(int(((yf-yi)/8)));
      case q of

{lx 86}
         1:ini:=concat(chr(27),'3',chr(1),chr(27),'Z',chr(n1),chr(n2));
         2:ini:=concat(chr(27),'A',chr(8),chr(27),'L',chr(n1),chr(n2));
         3:ini:=concat(chr(27),'A',chr(8),chr(27),'*',chr(5),chr(n1),chr(n2));
{lq500 8}
         4:ini:=concat(chr(27),'A',chr(8),chr(27),'*',chr(0),chr(n1),chr(n2));
         5:ini:=concat(chr(27),'A',chr(8),chr(27),'*',chr(1),chr(n1),chr(n2));

      end;
      ini2:=concat(chr(27),'3',chr(15),chr(27),'Z',chr(n1),chr(n2));
      if (q=3) or (q=2) then begin
         for j:=1 to (ny2+1) do begin
            write(lst,ini);
            for i:=xi to xf do begin
               vv:=128;
               v:=0;
               for n:=1 to 8 do begin
                  v:=v+vv*abs(video-getpixel(i,yi+8*(j-1)+n-1));
                  vv:=vv div 2;
               end;
               write(lst,chr(v));
            end;
            writeln(lst);

         end;
      end else
         for j:=yi to yf do begin
           write(lst,ini);
            for i:=xi to xf do begin
                v:=abs(video-getpixel(i,j));
                write(lst,chr(v));
            end;
            writeln(lst);

         end;
   end;

procedure eliminepoints(xi,yi,xf,yf :integer);
   {limine les points isols N&B}

   var
      v,i,j,x,y :integer;
      t         :array [1..2,1..500] of boolean;

   begin
      for v:=1 to 500 do begin t[1,v]:=false;t[2,v]:=false end;
      if xi>xf then begin x:=xf;xf:=xi;xi:=x end;
      if yi>yf then begin y:=yf;yf:=yi;yi:=y end;

      for j:=yi to yf do begin
         v:=getpixel(xi,j+1)+getpixel(xi+1,j)+
            getpixel(xi-1,j)+getpixel(xi+1,j+1)+
            getpixel(xi-1,j+1)+getpixel(xi+1,j-1)+
            getpixel(xi-1,j-1)+getpixel(xi,j-1) ;
         if getpixel(i,j)=1 then t[2,j]:=true else t[2,j]:=false;
         if (getpixel(xi,j)=1) and ((v=1) or (v=0)) then t[2,j]:=false else t[2,j]:=true;
         if (getpixel(xi,j)=0) and ((v=7) or (v=8)) then t[2,j]:=true else t[2,j]:=false;
      end;
      for i:=xi to xf do begin
         for v:=1 to 500 do t[1,v]:=t[2,v];
         for j:=yi to yf do begin
            v:=getpixel(i,j+1)+getpixel(i+1,j)+
               getpixel(i-1,j)+getpixel(i+1,j+1)+
               getpixel(i-1,j+1)+getpixel(i+1,j-1)+
               getpixel(i-1,j-1)+getpixel(i,j-1) ;
            if getpixel(i,j)=1 then t[2,j]:=true else t[2,j]:=false;
            if (getpixel(i,j)=1) and ((v=1) or (v=0)) then t[2,j]:=false ;
            if (getpixel(i,j)=0) and ((v=7) or (v=8)) then t[2,j]:=true ;
         end;
         for v:=yi to yf do
            if t[1,v] then putpixel(i-1,v,1) else putpixel(i-1,v,0);
      end;
   end;

procedure contours (xi,yi,xf,yf,c :integer);
   var
      v,i,j,x,y : integer;
      t         : array [1..2,1..500] of boolean;

   begin
      for v:=1 to 500 do begin t[1,v]:=false;t[2,v]:=false end;
      if xi>xf then begin x:=xf;xf:=xi;xi:=x end;
      if yi>yf then begin y:=yf;yf:=yi;yi:=y end;
      for j:=yi to yf do begin
         if (getpixel(xi,j)=c) and (getpixel(xi,j+1)=c) and
            (getpixel(xi+1,j)=c) and (getpixel(xi-1,j)=c) and
            (getpixel(xi,j-1)=c) then t[2,j]:=true;
      end;

      for i:=xi to xf do begin
         for v:=1 to 500 do t[1,v]:=t[2,v];
         for j:=yi to yf do begin
            if (getpixel(i,j)=c) and (getpixel(i,j+1)=c) and
               (getpixel(i+1,j)=c) and (getpixel(i-1,j)=c) and
               (getpixel(i,j-1)=c) then t[2,j]:=true else t[2,j]:=false;
         end;
         for v:=yi to yf do
            if t[1,v] then putpixel(i-1,v,0);
      end;
   end;

procedure vecteur(xi,yi,xf,yf :integer; nomf:string);
   var
      i,j,x,y :integer;
      vect :text;
      f :byte;

   const
      rel : array[0..7] of record px,py:-1..1 end =
                  ((px:0;py:1),(px:0;py:-1),(px:-1;py:0),(px: 1;py: 0),
                   (px:1;py:1),(px:1;py:-1),(px:-1;py:1),(px:-1;py:-1));

   procedure recure(x,y :integer);
      var
         e    : boolean;
         i    : 0..7;
         expl : packed array[0..7] of boolean;

      begin
         e:=false;
         putpixel(x,y,0);

         for i:=0 to 7 do
            with rel[i] do
               expl[i] := (getpixel(x+px,y+py)=1)
                          and ((x+px)<=xf) and ((x+px)>=xi)
                          and ((y+py)<=yf) and ((y+py)>=yi);

         for i:=0 to 7 do
            with rel[i] do
               if expl[i] then begin
                  if e then
                     writeln(vect,x-xi,' ',y-yi,' ')
                  else
                     e:=true;
                  writeln(vect,x+px-xi,' ',y+py-yi,' ');
                  recure(x+px,y+py)
               end;

         if not e then writeln(vect);
      end;

   procedure compacte;
      var
         dx,dy,dxx,dyy,xx,yy,i,j,k,l : integer;
         v1,v2   : real;
         test,isole :boolean;
         ch      : char;
         fsortie : text;
         noms :string;
         x,y,v    :integer;

      procedure rc;
         var
            c   :char;

         begin
            if not eof(vect) then read(vect,c);
            if not eof(vect) then read(vect,c)
         end;

         function lire(car:char) : integer;
           var
              c       : char;
              v       : string;
              n,z,er  : integer;

           begin
                v:='';c:=car;
                repeat
                    v:=v+c;
                    read(vect,c);
                until c=' ';
                val(v,n,er);
                lire:=n;
           end;

         procedure lireligne(var x,y:integer;var test:boolean);
            var
               c : char;

            begin
               if not eof(vect) then read(vect,c);
               if not eof(vect) then
                  if (ord(c)=10) or (ord(c)=13) then begin read(vect,c);test:=true end
                     else begin test:=false;x:=lire(c);read(vect,c);y:=lire(c);rc end;
            end;

      begin
           assign(fsortie,nomf);
           rewrite(fsortie);
           lireligne(x,y,test);
           dxx:=0;dyy:=0;
           isole:=false;
           repeat
              writeln(fsortie,x,' ',y,' ');
              moveto(x+xi,y+yi);
              while not test do begin
                 xx:=x;yy:=y;
                 lireligne(x,y,test);
                 if not test then begin
                    lineto(x+xi,y+yi) ;
                    dx:=x-xx;dy:=y-yy;
                    if (dx<>dxx) or (dy<>dyy) then begin
                       if not isole then writeln(fsortie,xx,' ',yy,' ');
                       writeln(fsortie,x,' ',y,' ');
                       isole:=true;
                    end else isole:=false;
                    dxx:=dx;dyy:=dy;
                 end;
              end;
              if not isole then writeln(fsortie,x,' ',y,' ');
              writeln(fsortie);
              while test and (not eof(vect)) do lireligne(x,y,test);
           until eof(vect);
           close(fsortie)
      end;

   begin
      f:=2;
      assign(vect,'tampon.vec');
      rewrite(vect);
      for j:=yi to yf do
         for i:=xi to xf do
            if getpixel(i,j)=1 then begin
               writeln(vect,i-xi,' ',j-yi,' ');
               recure(i,j)
            end;
      close(vect);
      assign(vect,'tampon.vec');
      reset(vect);
      compacte;
      close(vect);
   end;

BEGIN
   fond := false;
END.

{------------------------------------------------------------ ARX - BALMA --}
