UNIT GRAPHUTI;

{---------------------------------------------------------------------------}
{         bibliothque                                                      }
{                          outils graphiques                                }
{                                                               29/01/93    }
{---------------------------------------------------------------------------}
{  A R X - Alain, Roger et Xavier CULOS - 6 avenue de Lagarde  31130 BALMA  }
{---------------------------------------------------------------------------}

(*
   Graphuti,                 { ARX     - utilitaires graphiques             }
*)

INTERFACE
{$O+,F+}

USES
   dos,
   graph,                    { TP 70   - units standard                    }
   Souris,                   { ARX     - gestion de la souris               }
   Clavier,                  { ARX     - gestion du clavier                 }
   Graphism,                 { ARX     - initialisations graphiques         }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Graphplt;                 { ARX     - graphisme 2D cran/traceur         }

TYPE
   dessin               = procedure;

VAR
   v_indef              : real;            { valeur indfinie pour contours }

{---------------------------------------------------------------------------}
Procedure ini_contour  (nomf : pathstr);
   { lecture d'un fichier au format .BLN disponible ensuite en mmoire      }

Procedure liberercontour ;
   { llibre les pointeurs sur les contours                                 }

Procedure dess_contour;
   { travaille sur l'image dynamique du fichier                             }

Procedure boite_graph_variable     (t           : chainecar;
                      btn_ferme,
                      clot_var,
                      asc_v,
                      asc_h,
                      bte_mobile,
                      prop_fixe
                                                : boolean;
                      rapz,
                      cor1,  cor2,  cor3,  cor4 : real;
                      maxc1, maxc2, maxc3, maxc4: integer;
                  var fv1,   fv2 ,  fv3,   fv4  : real;
                  var cv1,   cv2,   cv3,   cv4  : integer;
                      c_fenetre, c_dessin       : word;
                                    dessiner    : dessin;
                  var memok                     : boolean);

   { fentre avec ascenceurs Horizontal et Vertical,
                  bouton de fermeture,   (btn_ferme  = Vrai)
                  bouton agrandissement, (clot_var   = Vrai)
                  ascenseurs H et V,
                  barre de dplacement.  (bte_mobile = Vrai)
                  bouton zoom in,        (pas = rapz)
                  bouton zoom out,       (tout )

     un clic en dehors de la fentre provoque l'effacement des boutons et
     ascenseurs : seul le graphique est raffich.

     t = titre ; si texte vide, pas de barre de titre et boutons  l'intrieur
     si ascenseurs absents, bouton clture  l'intrieur.
     max...      clture maxi            ( val recalcules/coef_x )
     cor...      fentre maxi            ( repre utilisateur )
     Fc...       fentre courante        ( id )
     CC...       clture courante        ( val recalcules/coef_x )
     coulfenetre fond de la bote
     couldessin  dessin en paramtre
     DESSINER est le nom d'une procdure graphique compile avec direct. $F+
      ex : dess_contour                                                     }


{---------------------------------------------------------------------------}

IMPLEMENTATION

TYPE
   surpoint             = ^unpoint;
   unpoint              = record
                             x, y    : real;
                             suivant : surpoint
                          end;

   point                = record
                             x, y    : real;
                          end;

   tabpoint             = array [1..546] of point;
   surtabpoint          = ^tabpoint;

   surcontour           = ^uncontour;
   uncontour            = record
                             nbpts     : integer;
{                                  typ       : string;}
                             debut     : surpoint;
                             tabp      : surtabpoint;
                             modeliste : boolean;        { V = liste chane }
                             suivant   : surcontour
                          end;

VAR
   contour  : surcontour;

(*
procedure dess_bln (nmf : string ; co : couleur_palette);
   { travaille directement  partir du fichier : pas de mmorisation }
   { et prend en compte la valeur indfinie }
   var
      nbst, i     : integer;
      fentree     : text;
      l, p        : real;
      typ         : string;

   begin
      if not ftxt_present (nmf) then exit;
      assign  (fentree,nmf);
      reset   (fentree);
      fixecoul (co);
      while (not (eof (fentree))) do begin         { lire une ligne }
         readln (fentree, nbst, typ);              { lire entte    }
         if nbst > 1 then begin
            i := 1;
            readln (fentree, l, p);
            while i < nbst  do begin
               while (p >= v_indef) and (i < nbst) do begin
                                                   { sauter val indfinies }
                  readln (fentree, l, p);
                  inc    (i);
               end;
               deplaceen       (l, p);     { se dplacer sur le premier pt }
               while (p < v_indef) and (i < nbst) do begin
                  inc    (i);
                  readln (fentree, l, p);
                  tracevers       (l, p);
               end
            end
         end
      end;
      close (fentree);
   end;
*)

procedure liberercontour;
   var
      l_ct, l_sui       : surcontour;

   procedure liberer_points (var s : surpoint); { libere la liste de points }
      var
         p_ct, p_sui    : surpoint;

      begin
         p_sui  := s;
         p_ct   := s;
         while p_ct <> nil
         do begin
            p_sui := p_ct^.suivant;
            dispose (p_ct);
            p_ct  := p_sui;
         end;
         s := nil;
      end;

   procedure liberer_contour (var s : surcontour);     { librer une ligne }
      begin
         dispose ( s );
         s := nil;
      end;

   begin
      l_ct  := contour;
      l_sui := contour;
      while l_ct <> nil
      do begin            { ligne par ligne   }
         l_sui := l_ct^.suivant;
         if l_ct^.modeliste
         then
            liberer_points  (l_ct^.debut)
         else
            freemem (l_ct^.tabp, l_ct^.nbpts*sizeof(point));
         liberer_contour (l_ct);
         l_ct  := l_sui;
      end;
      contour := nil;
   end;

procedure change_mode (ligne : surcontour);
   var
      element_num       : integer;
      element_p         : surpoint;

   begin
      if ligne <> nil
      then begin
         change_mode (ligne^.suivant);
         if ligne^.modeliste
         then begin           { passer en mode tableau }
            if ligne^.nbpts > 546
            then
               ligne^.nbpts := 546;

            getmem (ligne^.tabp, ligne^.nbpts * sizeof (point));
            element_p := ligne^.debut;
            for element_num := 1 to ligne^.nbpts do
            begin
               ligne^.tabp^ [element_num].x := element_p^.x;
               ligne^.tabp^ [element_num].y := element_p^.y;
               element_p := element_p^.suivant;
               dispose (ligne^.debut);
               ligne^.debut := element_p;
            end;
            while ligne^.debut <> nil
            do begin             { supprimer fin de liste > 546 }
               element_p := ligne^.debut^.suivant;
               dispose (ligne^.debut);
               ligne^.debut := element_p;
            end;
         end;
         ligne^.modeliste := false;
      end;
   end;

procedure ini_contour (nomf : pathstr);
   { lecture d'un fichier au format .BLN }
   var
      nbst, i           : integer;
      fentree     : text;
      l, p        : real;
      typ         : string;
      n_ligne     : surcontour;
      n_point     : surpoint;
      ok          : boolean;

   procedure creer_ligne (var ligne : surcontour; nbp : integer; typ : string);
      { crr nouvelle ligne }
      begin
         new (ligne);
         ligne^.nbpts     := nbp;
{         ligne^.typ       := typ;      }
         ligne^.debut     := nil;
         ligne^.modeliste := true;
         ligne^.tabp      := nil;
         ligne^.suivant   := nil;
      end;

   procedure ajouter_ligne (var cont : surcontour ; ligne : surcontour);
      { chanage de LIGNE en fin de la liste CONT }
      var
         c              : surcontour;

      begin
         if cont = nil
         then
            cont := ligne
         else begin
            c := cont;
            while c^.suivant <> nil do c := c^.suivant;
            c^.suivant := ligne
         end
      end;

   procedure creer_point   (var pt : surpoint ; x, y : real);
      begin
         new (pt);
         pt^.x       := x;
         pt^.y       := y;
         pt^.suivant := nil;
      end;

   procedure ajouter_point (var ligne : surpoint; pt : surpoint);
      var
         p : surpoint;

      begin
         if ligne = nil
         then
            ligne := pt
         else begin
            p := ligne;
            while p^.suivant <> nil do
               p := p^.suivant;
            p^.suivant := pt
         end
      end;

   begin                               { ini contour  en mode liste }
      contour := nil;
      n_ligne := nil;
      n_point := nil;
  {    if not ftxt_present (nomf) then exit;}
      assign  (fentree, nomf);
      resetTxtErr   (fentree, nomf, ok);
      while (not (eof (fentree)))                  { lire une ligne }
      do begin
         readln (fentree, nbst, typ);              { lire entte    }
         if nbst > 1
         then begin
            i := 1;
            creer_ligne   (n_ligne, nbst, typ);
            ajouter_ligne (contour, n_ligne);       { creer nouvelle ligne }

            readln        (fentree, l, p);
            creer_point   (n_point, l, p);          { premier point }
            ajouter_point (n_ligne^.debut, n_point);
            while i < nbst
            do begin
                  inc    (i);
                  readln (fentree, l, p);
                  creer_point   (n_point, l, p);    { points suivants }
                  ajouter_point (n_ligne^.debut, n_point);
            end
         end
      end;
      close   (fentree);
      change_mode (contour);
   end;                                { ini contour }

procedure dess_contour;
          { travaille sur une image dynamique du fichier }
   var
      lignes            : surcontour;
      numelement        : integer;

   begin
{      cachersouris;}
      v_indef := 9999.9;
      lignes := contour;
      while lignes <> nil                         { ligne par ligne   }
      do begin
         numelement := 1;
         while numelement < lignes^.nbpts         { point par point   }
         do begin
            while (lignes^.tabp^[numelement].y >= v_indef)
                   and (numelement < lignes^.nbpts)
            do inc ( numelement);
                                                   { sauter val indfinies }
            deplaceen (lignes^.tabp^[numelement].x,
                       lignes^.tabp^[numelement].y);   { se dplacer sur le premier }
            while (lignes^.tabp^[numelement].y < v_indef)
                  and (numelement < lignes^.nbpts)
            do begin
               inc (numelement);
               tracevers (lignes^.tabp^[numelement].x,
                          lignes^.tabp^[numelement].y);
            end;
         end;
         lignes := lignes^.suivant;
      end;
(*         v_indef := 9999.9;
         lignes := contour;
         while lignes <> nil do begin            { ligne par ligne   }
            point := lignes^.debut;
            if lignes^.nbpts > 1 then begin      { point par point   }
               while (point^.y >= v_indef) and (point^.suivant <> nil)
                  do                             { sauter val indfinies }
                     point := point^.suivant;
               deplaceen (point^.x, point^.y);   { se dplacer sur le premier }
               while (point^.y < v_indef) and (point^.suivant <> nil)
                  do begin
                     point := point^.suivant;
                     tracevers (point^.x, point^.y);
                  end;
            end;
            lignes := lignes^.suivant;
      end; *)
{      montrersouris; }
   end;

procedure boite_graph_variable
                                      (t      : chainecar;
                   btn_ferme,
                   clot_var,
                   asc_v,
                   asc_h,
                   bte_mobile,
                   prop_fixe
                                              : boolean;
                   rapz,
                   cor1,  cor2,  cor3,  cor4  : real;
                   maxc1, maxc2, maxc3, maxc4 : integer;
               var fv1,  fv2 , fv3,  fv4      : real;
               var cv1,  cv2,  cv3,  cv4      : integer;
                   c_fenetre, c_dessin        : word;
                                dessiner      : dessin;
               var memok                      : boolean);

   const
      rapmax            = 500;

   var
      rest_mem,
      taille_image      : longint;
      p1, p2, p3, p4    : pointer;
      coef_c            : real;
      lx2,     ly2,
      csx,     csy,
      xx,      yy,
      dx,
      bx,      by,
      h,       ht,           { ht. titre int ; titre extrieur }
      sx,                    { suppl lgr. titre ext }
      hx,      hy,           { l et h bouton cloture }
      supx,    supy,         { l. ascenseurs }
      deplx,   deply,
      posx,    posy,         { position curseur }
      posxp,   posyp,        { position prcdente }
      x0,      y0,           { angle HG de la bote }
      lx,      ly ,          { dimensions bote }
      lgx,     lgy,          { longueur curseur }
      entier,
      Touche
                        : integer;

      ferme,
      deplace,
      change_cloture,
      dehors
                        : boolean;

   procedure redessine (deplx, deply : integer);
      var
         lc             : integer;
         { deplx, deply   dcalage ascenseurs                        }

      begin
         lc := 2*tx+2;
         setFillStyle (1, c_fenetre);            { q. fond boite }
         fenetre (fv1, fv2, fv3, fv4);
         cloture (cv1, cv2, cv3, cv4); { pour calculer xrap, yrap }
         bar (0, 0, cv2-cv1, cv4-cv3);
         cloture (cv1+lc, cv2-lc, cv3+lc, cv4-lc); {  clture utile }
      {   fv1   := xgfen +deplx / xrap;
         fv2   := xdfen +deplx / xrap;
         fv3   := ybfen -deply / yrap;
         fv4   := yhfen -deply / yrap;}

         fv1   := fv1 + (deplx/(cv2-cv1-2*lc)) * (cor2-cor1);
         fv2   := fv2 + (deplx/(cv2-cv1-2*lc)) * (cor2-cor1);
         fv3   := fv3 - (deply/(cv4-cv3-2*lc)) * (cor4-cor3);
         fv4   := fv4 - (deply/(cv4-cv3-2*lc)) * (cor4-cor3);

         fenetre (fv1, fv2, fv3, fv4); { recadrer }
         cloture (cv1, cv2, cv3, cv4);
         setcolor (c_dessin); { q. coul contour }
         dessiner ;           { DESSINER = nom de la procdure en paramtre }
         pleinecloture;
      end;

   procedure aff_boutons;
      begin
         settextjustify  (1, 1);
         setcolor           (c_t_boite_norm {colorf});
         setfillstyle    (1, c_f_boite_norm {colord});

         { bouton taille clture }
         if clot_var
         then begin
            bar             (x0+lx-2*tx+2, y0+ly-2*tx+2, x0+lx-2, y0+ly-2);
            rectangle       (x0+lx-2*tx+4, y0+ly-2*tx+4, x0+lx-4, y0+ly-4);
         end;

         { barre titre }
         if (ht <> 0) or (bte_mobile)
         then
            rectangle       (x0,           y0,           x0+lx-sx, y0+h);

         if t <> ''
         then begin
            bar             (x0+2,    y0+2,    x0+lx-2, y0+h-2);
            outtextxy       (x0+h +((lx-3*h) div 2), y0+(h div 2), t);
         end;

         { bouton fermeture }
         if btn_ferme
         then
            rectangle       (x0+4,              y0+4, x0+h-4,     y0+h-4);

         if rapz <> 0
         then begin
            outtextxy       (x0+lx-sx-h-(h div 2), y0+(h div 2), '-');
            rectangle       (x0+lx-sx-2*h+4,       y0+4, x0+lx-sx-h-4,  y0+h-4);
            { bouton zoom arr  }

            outtextxy       (x0+lx-sx-(h div 2),   y0+(h div 2), '+');
            rectangle       (x0+lx-sx-h+4,         y0+4, x0+lx-sx-4,    y0+h-4);
            { bouton zoom av   }
         end;
      end;

   procedure affiche_bte_graph ;
      begin
         { bote }
         setlinestyle    (0, 0, 1);
         setcolor        (c_t_boite_norm  {colord});
         (* setfillstyle    (0, 6 {c_f_boite_norm colorf});               *)
         {bar            (x0,               y0,    x0+lx,      y0+ly);}
         rectangle       (x0,               y0,    x0+lx,      y0+ly);

         { ascenseurs }
         setfillstyle    (0, c_f_boite_norm {colorf});
         settextjustify  (0, 2);

         if asc_v
         then
            affiche_ascenseur_v
               (0, csy, x0+lx-supx, y0+ht,      ly-ht-hy, lgy, posy);
         if asc_h
         then
            affiche_ascenseur_h
               (0, csx, x0,         y0+ly-supy, lx   -hx, lgx, posx);
      end;

   procedure calc_position;                        { paramtres du curseur }
      var
         lc             : integer;

      begin
         lc := 2*tx+2;            { valeur non lie mais id dans utildivs }
         fenetre (cor1, cor2, cor3, cor4);
{         cloture (cv1, cv2, cv3, cv4);}
         cloture (cv1+lc, cv2-lc, cv3+lc, cv4-lc); {  clture utile }

       {  xrap := (xdclot-xgclot) / (xdfen-xgfen);
         yrap := (yhclot-ybclot) / (yhfen-ybfen);}
         { COURSE en pixels }
         csx     := trunc (((cor2-cor1) - (fv2-fv1)) * xrap);
         csy     := trunc (((cor4-cor3) - (fv4-fv3)) * yrap);

         { longueur du curseur en pixels }
         {lgx     := trunc ( (fv2  - fv1)  * xrap);
         lgy     := trunc ( (fv4  - fv3)  * yrap);}
         lgx := (cv2-cv1)-2*lc-csx;
         lgy := (cv4-cv3)-2*lc-csy;

         { POSITION de la fentre en pixels }
         posx    := trunc ( (fv1  - cor1) * xrap);
         posy    := trunc ( (cor4 - fv4)  * yrap);

         pleinecloture;
      end;

   function bouton_fermeture : boolean;
      begin
         bouton_fermeture :=
                             btn_ferme
                         and (xs > x0+4)   and (ys > y0+4)
                         and (xs < x0+h-4) and (ys < y0+h-4)
                        { or  d};
      end;

   function bouton_ZOOM_AR : boolean;
      begin
         bouton_zoom_ar :=
                           (rapz <> 0)
                       and (xs > x0+lx-sx-2*h+4)   and (ys > y0+4)
                       and (xs < x0+lx-sx-h-4)     and (ys < y0+h-4);
      end;

   procedure zoom_arriere;
      begin
         fv1   := cor1;
         fv2   := cor2;
         fv3   := cor3;
         fv4   := cor4;
         calc_position;
      end;

   function bouton_ZOOM_AV : boolean;
      begin
         bouton_zoom_av :=
                           (rapz <> 0)
                       and (xs > x0+lx-sx-h+4)   and (ys > y0+4)
                       and (xs < x0+lx-sx-4)     and (ys < y0+h-4)
      end;

   procedure zoom_avant;
      var
         l1, l2         : real;

      begin
         l1 := (fv2 - fv1) * rapz;
         l2 := (fv4 - fv3) * rapz;
         if (fv2 < fv1) or (l1 < (cor2-cor1)/rapmax)
                        or (l2 < (cor4-cor3)/rapmax) then exit;
         fv1   := fv1 + l1 ;
         fv2   := fv2 - l1 ;
         fv3   := fv3 + l2 ;
         fv4   := fv4 - l2 ;
         calc_position;
      end;

   function bouton_deplace : boolean;
      begin
         bouton_deplace :=
                  bte_mobile  and
                  (xs > x0+h) and (xs < x0+lx-sx-h-tx*2) and
                  (ys > y0)   and (ys < y0+h) and (not d)
      end;

   procedure deplace_boite;
      var
         xxi,  yyi,
         cci1, cci2,
         cci3, cci4     : integer;

      begin
         xxi  := xx;
         yyi  := yy;
         cci1 := cv1;
         cci2 := cv2;
         cci3 := cv3;
         cci4 := cv4;
         setcolor (c_t_boite_norm {colord});
         dep_rec (xx, yy, lx, ly);                       { utildivs }
         cv1  := xx+1;
         cv2  := xx+lx-1-supx;
         cv3  := maxy-yy-ly+supy+1;
         cv4  := maxy-yy-ht-1;
         if (cv1 < maxc1) or (cv2 > maxc2)
         then begin
            xx  := xxi;
            cv1 := cci1;
            cv2 := cci2
         end;
         if (cv3 < maxc3) or (cv4 > maxc4)
         then begin
            yy  := yyi;
            cv3 := cci3;
            cv4 := cci4
         end;
      end;

   function curs_dehors : boolean;
      begin
         curs_dehors :=
                        (xs > x0+lx) or (ys > y0+ly)
                     or (xs < x0)    or (ys < y0);

      end;

   function bouton_cloture : boolean;
      begin
         bouton_cloture :=
                           clot_var
                    and (xs > x0+lx-2*tx+4) and (ys > y0+ly-2*tx+4)
                    and (xs < x0+lx-4)      and (ys < y0+ly-4);
      end;

   procedure cloture_graph;
      var
         xxi,  yyi,  xxf, yyf,
         xx1,  yy1,  xx2, yy2,
         varx, vary, dx,  dy        : integer;

      begin
         xx1  := cv1 ;
         yy1  := maxy-cv4;
         xxf  := cv2;
         yyf  := maxy-cv3;
         xx2  := xxf;
         yy2  := yyf;

         def_zone (2, 15, coef_c, xx1+((maxc2-maxc1) div 10),
                                  yy1+((maxc4-maxc3) div 10),
                                  maxc2, maxc4,
                                  xx1, yy1, xx2, yy2);
         {        type co rapp    xm
                                  ym
                                  xM     yM
                                  xi   yi   xf   yf }
         varx := xx2 - xxf;
         lx   := lx  + varx;
         cv2  := cv2 + varx;

         vary := yy2 - yyf;
         ly   := ly  + vary;
         cv3  := cv3 - vary;
      end;

   procedure capture_image (l1, l2 : longint);
      var
         t1, t2, t3, t4 : word;

      begin
         taille_image := trunc ((l1+8) / 8) * (l2+1) * 4 + 6;
         rest_mem := maxavail;
         if rest_mem > taille_image
         then begin
            if taille_image > maximage
            then begin
               lx2 := l1 div 2;
               ly2 := l2 div 2;
               t1  := imagesize (   0,        0,        lx2,    ly2);
               t2  := imagesize (   lx2+1,    0,        lx,     ly2);
               t3  := imagesize (   0,        ly2+1,    lx2,    ly) ;
               t4  := imagesize (   lx2+1,    ly2+1,    lx,     ly) ;
               getmem   (p1, t1);
               getmem   (p2, t2);
               getmem   (p3, t3);
               getmem   (p4, t4);
               getimage         (x0,       y0,       x0+lx2, y0+ly2,   p1^);
               getimage         (x0+lx2+1, y0,       x0+lx,  y0+ly2,   p2^);
               getimage         (x0,       y0+ly2+1, x0+lx2, y0+ly,    p3^);
               getimage         (x0+lx2+1, y0+ly2+1, x0+lx,  y0+ly,    p4^);
            end else begin
               t1  := imagesize  (   0,        0,        lx,     ly);
               getmem   (p1,  t1);
               getimage         (x0,       y0,       x0+lx,  y0+ly,    p1^);
            end;
         end;
      end;

   procedure affiche_image;
      begin
         if taille_image > maximage
         then begin
            putimage (x0,       y0       , p1^, 0);
            putimage (x0+lx2+1, y0       , p2^, 0);
            putimage (x0,       y0+ly2+1 , p3^, 0);
            putimage (x0+lx2+1, y0+ly2+1 , p4^, 0);
            libere   (p1);
            libere   (p2);
            libere   (p3);
            libere   (p4);
         end else begin
            putimage (x0,       y0       , p1^ , 0);
            libere   (p1);
         end;
      end;

   procedure ini_bte_graph;
      begin
         nouveau_style   (0, 0, 1);
         ecran   := true;
         traceur := false;
         if asc_v then supx := 2 * tx else supx := 0;
         if asc_h then supy := 2 * tx else supy := 0;
         ty      := 12;
         dx      :=  6;
         h       :=  2 * ty;      { hauteur barre titre vide au dessous cc4 }
                                  { ht      barre titre au dessus }
         ht := 0;
         sx := supx;
         if t <> ''
         then begin
            ht := h;
            sx := 0;
         end;

         hx := supx;
         hy := supy;
         if clot_var
         then begin
            if not asc_v then hx := 2 *tx ;
            if not asc_h then hy := 2 *tx ;
         end;

         {if cv1 > maxc1 then}
         x0 := cv1 - 1;
         {if cv4 < maxc4 then}
         y0 := maxy - cv4 - ht - 1;
         lx      := cv2  - cv1 + 2 + supx;
         ly      := cv4  - cv3 + 2 + supy + ht;
         taille_image := trunc ((lx+8) / 8) * (lx+1) * 4 + 6;
         if prop_fixe
         then
            coef_c := 0
         else
            coef_c := (cv2-cv1) / (cv4-cv3);

         calc_position;                { position cte. des curseurs }
         deplx   := 0;                 { dplacement prcdent      }
         deply   := 0;
         ferme   := false;
      end;

      procedure saisie_action;
         begin
            { saisir Xs Ys }
            if asc_v and (csy > 0)   { ascenseur V demand possible}                           { utildivs }
            then
               ascenseur_v
                  (0, csy, x0+lx-supx, y0+ht,      ly-ht-hy, lgy, posy, Touche);

            if asc_h and (csx > 0)   { ascenseur H demand possible }
            then
               ascenseur_h
                  (0, csx, x0,         y0+ly-supy, lx   -hx, lgx, posx, Touche);
            deplx := posx - posxp;
            deply := posy - posyp;

            if   (not asc_h) and (not asc_v)  { ascenseurs exclus }
              or ((asc_v and (csy = 0)) and (asc_h and (csx = 0)) )
                                             { ou demands impossibles }
            then begin
               MontrerSouris;
               clavsouris (Touche);
               LirePositionSouris (xs, ys);
               CacherSouris;
            end;
         end;

      procedure redess_ascenseurs;
         begin
            if bouton_zoom_av or bouton_zoom_ar
            then begin
               if asc_v
               then
                  affiche_ascenseur_v
                     (0, csy, x0+lx-supx, y0+ht,      ly-ht-hy, lgy, posy);
               if asc_h
               then
                  affiche_ascenseur_h
                     (0, csx, x0,         y0+ly-supy, lx   -hx, lgx, posx);
             end;
         end;

   begin
      ini_bte_graph;                   { initialise paramtres gl.  }

      memok := true;
      if taille_image > maxavail
      then begin
         style_menu;
         redessine (0, 0);
         memok := false;
         exit
      end;

      repeat                           { modif dimensions bote     }
         change_cloture := false;
         posxp    := posx;             { position prcdente        }
         posyp    := posy;
         repeat                        { Dplacement bote          }
            deplace := false;
            capture_image (lx, ly);    { Mmorise le fond           }
            calc_position;
            affiche_bte_graph ;        { dessine la bote           }
            aff_boutons;               { dessine vt. les boutons   }
            redessine  (deplx, deply); { dessine le contenu         }

            xx := x0;
            yy := y0;
            repeat                            { modif fentre       }
               saisie_action ;                { ascenceurs, xs, ys  }
               ferme          := bouton_fermeture;
               change_cloture := bouton_cloture;
               dehors         := curs_dehors;
               deplace        := bouton_deplace;

               if deplace        then deplace_boite;
               if bouton_zoom_ar then zoom_arriere;
               if bouton_zoom_av then zoom_avant;   { pb limites}

               if not ferme and not change_cloture
                            and not deplace
                            and not dehors
                        {   and not dans_fenetre (...(xs), ...(ys))}
               then begin
                  redess_ascenseurs;
                  redessine (deplx, deply);
                  aff_boutons;
               end;

               posxp := posx;                 { position prcdente fentre }
               posyp := posy;
            until ferme or change_cloture or deplace or dehors;

            if deplace then affiche_image;
                                       { restaure le fond avant de dplacer }
            x0 := xx;                  { position prcdente bote          }
            y0 := yy;
         until change_cloture or ferme or dehors;

         if change_cloture
         then begin
            cloture_graph;
            affiche_image;    { restaure le fond avant de modifier la taille }
         end;
      until ferme or dehors;           { sortie de la bote }

      affiche_image;                   { restaure le fond avant de sortir }

      if dehors then redessine (0, 0);
      style_menu;
   end;

END.

{--- GRAPHUTI -------------------------------- ARX - BALMA           - 1993 }

