unit math;


interface


uses crt;


{ dclarations utilitaires }

const
   infini = 1e38;


{ dclarations pour le calcul matriciel et vectoriel }
{ remarque : le premier indice d'une matrice dsigne la colone }

type
   crdn = (x,y,z);
   vect = array [crdn] of real;
   mat  = array [crdn] of vect;

const
   vzero : vect = (0,0,0);
   vux   : vect = (1,0,0);
   vuy   : vect = (0,1,0);
   vuz   : vect = (0,0,1);

   mzero : mat  = ((0,0,0),(0,0,0),(0,0,0));
   mid   : mat  = ((1,0,0),(0,1,0),(0,0,1));


{ dclarations pour le calcul complexe }

type
   complexe = record  r, i : real  end;

const
   czero : complexe = (r:0 ; i: 0);
   cun   : complexe = (r:1 ; i: 0);
   ci    : complexe = (r:0 ; i: 1);
   cmi   : complexe = (r:0 ; i:-1);

{}                                                                                 { les lignes sont }
{}                                                                                 { comptees       }
{}                                                                                 { partir  du  mot }
{}                                                                                 { implementation. }
{ algos utilitaires }

function  sequents    (xd, yd, xf, yf, xxd, yyd, xxf, yyf : longint) : boolean;      { ligne   70 }
procedure racines2    (a, b, c : integer; var nbsol : integer ; var x1, x2 : real);  { ligne    5 }
procedure diviseur    (a : longint ; var nb : integer);                              { ligne   53 }


{ oprateurs et fonctions relles }

function  arccos      (c          : real) : real;     {  0    < arccos      < pi    }{ ligne  395 }
function  arcsin      (v          : real) : real;     { -pi/2 < arcsin      < pi/2  }{ ligne   31 }
function  arctangente (sinus, cosinus : real) : real; {  0    < arctangente < 2.pi  }{ ligne   37 }
function  signe       (n          : real) : integer;                                 { ligne  118 }
function  sgn         (n          : real) : integer;                                 { ligne  123 }
function  puissance   (base, expo : real) : real;                                    { ligne  128 }

function  puis_3 (x : real) : real;                                                  { ligne  529 }
function  puis_i3(x : real) : real;                                                  { ligne  530 }
function  pn4d(a, b, c, d, e, x : real) : real;                                      { ligne  533 }


{ fonctions d'entiers }

function  fact        (n : integer) : longint;                                       { ligne   25 }
function  factorielle (x : integer) : real;                                          { ligne  138 }


{ calcul matriciel et vectoriel, dimension 3 }

{ notations frquentes :

  variables

   m          : matrice
   r          : rsultat
   u, v, w    : vecteurs
   i, j       : coordonne
   a, b, c, s : scalaires rels

  noms des procdures ou fonctions

   lig      : ligne
   n        : numrique
   s        : scalaire
   v        : vecteur, vectioriel
   m        : matrice, matriciel
   d        : droite
   p        : plan
   sph      : sphere
   proj     : projection
   trf      : transformation
   diag     : diagonale
   fixeXX   : affectation de XX
   XmultY   : multiplication de X par Y  / X, Y dans (s, v, m)
   sommeX   : somme de 2 X               / X    dans (v, m)
   diffX    : diffrence de 2 X          /   "
   negX     : ngation d'un X            /   "
   produitX : produit X                  / X    dans (s, v, m)
   afficheX : affichage de X             / X    dans (v, m)
}

function  suiv     (c       : crdn                              ) : crdn;            { ligne  158 }
procedure ligne    (m       : mat ; i : crdn; var v : vect      );                   { ligne  167 }
procedure lignen   (m       : mat ; i : crdn; var a, b, c : real);                   { ligne  168 }
procedure fixelig  (v       : vect; i : crdn; var m : mat       );                   { ligne  169 }
procedure fixelign (a, b, c : real; i : crdn; var m : mat       );                   { ligne  170 }
procedure fixevect (a, b, c : real;           var v : vect      );                   { ligne  171 }
procedure diag     (m       : mat ;           var v : vect      );                   { ligne  172 }
procedure fixediag (v       : vect;           var m : mat       );                   { ligne  173 }
procedure vmults   (v       : vect; s : real; var r : vect      );                   { ligne  174 }
procedure mmults   (m       : mat ; s : real; var r : mat       );                   { ligne  179 }
procedure sommev   (a, b    : vect;           var r : vect      );                   { ligne  175 }
procedure diffv    (a, b    : vect;           var r : vect      );                   { ligne  176 }
procedure sommem   (a, b    : mat ;           var r : mat       );                   { ligne  186 }
procedure negv     (v       : vect;           var r : vect      );                   { ligne  177 }
procedure negm     (m       : mat ;           var r : mat       );                   { ligne  193 }
procedure t        (m       : mat ;           var r : mat       );                   { ligne  200 }
function  auto_a   (m       : mat                               ) : boolean;         { ligne  207 }
function  anti_aa  (m       : mat                               ) : boolean;         { ligne  224 }
function  norme2v  (v       : vect                              ) : real;            { ligne  241 }
function  normev   (v       : vect                              ) : real;            { ligne  242 }
function  normerv  (                          var v : vect      ) : boolean;         { ligne  244 }
function  discrim  (m       : mat ; i, j : crdn                 ) : real;            { ligne  256 }
function  det      (m       : mat                               ) : real;            { ligne  265 }
function  trace    (m       : mat                               ) : real;            { ligne  276 }
procedure tmcofact (m       : mat ;           var r : mat       );                   { ligne  278 }
function  inversion(m       : mat ;           var r : mat       ) : boolean;         { ligne  287 }
function  produits (a, b    : vect                              ) : real;            { ligne  300 }
procedure mmultv   (m       : mat ; v : vect; var r : vect      );                   { ligne  302 }
procedure vmultm   (v       : vect; m : mat ; var r : vect      );                   { ligne  309 }
procedure produitm (a, b    : mat ;           var r : mat       );                   { ligne  316 }
procedure trfmat   (v       : vect;           var m : mat       );                   { ligne  331 }
function  trfvect  (m       : mat ;           var v : vect      ) : boolean;         { ligne  338 }
procedure produitv (a, b    : vect;           var r : vect      );                   { ligne  347 }
procedure creerbase(a, b    : vect;           var u, v, w : vect);                   { ligne  354 }
procedure mrotation(u       : vect; a : real; var m : mat       );                   { ligne  373 }
procedure mprojp   (u       : vect;           var m : mat       );                   { ligne  384 }
procedure mprojd   (u       : vect;           var m : mat       );                   { ligne  391 }
procedure projsph  (a,b,c,u : vect;           var aa,bb,r : real);                   { ligne  408 }

procedure affichev (v : vect; c, l : integer ; ch : string      );                   { ligne  420 }
procedure affichem (m : mat ; c, l : integer ; ch : string      );                   { ligne  433 }


{ calculs en nombres complexe }


procedure c       (r, i : real ;                var cc: complexe);                   { ligne  447 }
procedure sommec  (a, b : complexe ;            var c : complexe);                   { ligne  448 }
procedure diffc   (a, b : complexe ;            var c : complexe);                   { ligne  449 }
procedure produitc(a, b : complexe ;            var c : complexe);                   { ligne  450 }
procedure carrec  (a    : complexe ;            var c : complexe);                   { ligne  451 }
procedure conjugue(a    : complexe ;            var c : complexe);                   { ligne  452 }
procedure moinsc  (a    : complexe ;            var c : complexe);                   { ligne  453 }
procedure cmults  (a    : complexe ; f : real ; var c : complexe);                   { ligne  454 }

function  module2 (a    : complexe) : real;                                          { ligne  456 }
function  module  (a    : complexe) : real;                                          { ligne  464 }

procedure rc      (a    : complexe ; p : real ; var c : complexe);                   { ligne  466 }
procedure rapport (a, b : complexe ;            var c : complexe);                   { ligne  486 }
procedure inverser(var a: complexe ; f : real);                                      { ligne  505 }
procedure affichec(s : string ; c : complexe ; t, d : integer);                      { ligne  522 }


{ extraction de racine de polynmes, jusqu'au 4 degr. }

procedure racine1d(a1,b1         :real ; var x          :complexe ; var deg:integer);{ ligne  536 }
procedure racine2d(a1,b1,c1      :real ; var x1,x2      :complexe ; var deg:integer);{ ligne  545 }
procedure racine3d(a1,b1,c1,d1   :real ; var x1,x2,x3   :complexe ; var deg:integer);{ ligne  570 }
procedure racine4d(a1,b1,c1,d1,e1:real ; var x1,x2,x3,x4:complexe ; var deg:integer);{ ligne  620 }


{-----------------------------------------------------------------------------}
implementation

var
   cc : complexe;


{ origine : fctmath - xavier }

procedure racines2;
   var
      delta : real;
      test  : boolean;

   begin
      delta:=b*b-4*a*c;
      if a=0 then begin
         x1:=-c/b;
         nbsol:=1;
      end else begin
         if delta >=0 then begin
            nbsol:=2;
            if delta=0 then nbsol:=1;
            x1:=(-b+sqrt(delta))/(2*a);
            x2:=(-b-sqrt(delta))/(2*a);
         end else nbsol:=0;
      end;
   end;

function fact;
   begin
      if n=0 then fact:=1
             else fact:=fact(n-1)*n;
   end;

function arcsin;
   begin
      if (v=1) or (v=-1) then arcsin:=v*pi/2
                         else arcsin:=arctan(v/sqrt(1-v*v));
   end;

function  arctangente ( sinus,cosinus :real) :real;
   var
      arct : real;

   begin
      if abs(cosinus)<abs(sinus) then begin
         arct:=pi/2-arctan(cosinus/sinus);
         if sinus<0 then arct:=arct+pi;
      end else begin
         arct:=arctan(sinus/cosinus);
         if cosinus<0 then arct:=arct+pi;
         if arct<0    then arct:=arct+2*pi
      end;
      arctangente:=arct
   end;

procedure diviseur;
   var
      i, nb1 : integer;

   begin
      nb1:=1;
      while ((a mod 2)=0) and (2<=a) do begin   a:=a div 2; nb1:=nb1+1;   end;
      nb:=nb1;
      i:=3;
      while i<=a do begin
         nb1:=1;
         while ((a mod i)=0) and (i<=a) do begin   a:=a div i; nb1:=nb1+1;   end;
         nb:=nb*nb1;
         i:=i+2;
      end;
   end;

function sequents;
   var
      a, b, c, d : integer;
      num, den   : longint;
      la, mu     : real;
      s          : string;

   begin
      if xf<>xd then begin
         num:=(yd-yyd)*(xf-xd)+(xxd-xd)*(yf-yd);
         den:=(xf-xd)*(yyf-yyd)+(yd-yf)*(xxf-xxd);

         if den<>0 then
            mu:=num/den
         else if num<>0 then
            mu:=-1
         else begin
            if xd>xf then begin a:=xd;b:=xf end
                     else begin b:=xd;a:=xf end;
            if xxd>xxf then begin c:=xxd;d:=xxf end
                       else begin d:=xxd;c:=xxf end;
            if (b>c) or (d>a) then mu:=-1 else mu:=0;
         end;

         la:=((xxd-xd)+mu*(xxf-xxd))/(xf-xd)

      end else if yd<>yf then begin
         if xxf<>xxd then mu:=(xd-xxd)/(xxf-xxd)
         else if xd<>xxd then mu:=-1
         else begin
            if yd>yf   then begin  a:=yd;  b:=yf  end
                       else begin  b:=yd;  a:=yf  end;
            if yyd>yyf then begin  c:=yyd; d:=yyf end
                       else begin  d:=yyd; c:=yyf end;
            if (b>c) or (d>a) then mu:=-1 else mu:=0
         end;
         la:=((yyd-yd)+mu*(yyf-yyd))/(yf-yd)
      end else begin
         mu:=0;
         if (xxf=xxd) and (xxd<>xd)                     then mu:=-1
         else if (yyf=yyd) and (yyd<>yd)                then mu:=-1
         else if (xd-xxd)*(yyf-yyd)<>(yd-yyd)*(xxf-xxd) then mu:=-1;
         la:=0
      end;

      sequents:=(mu>=0) and (mu<=1) and (la>=0) and (la<=1);
   end;

function  signe(n : real) : integer;
   begin
      if n>=0 then signe:=1 else signe:=-1;
   end;

function  sgn(n : real) : integer;
   begin
      if n>=0 then sgn:=1 else if n=0 then sgn:=0 else sgn:=-1;
   end;

function  puissance(base, expo : real) : real;
   begin
      if abs(base)<1E-6 then
         if expo=0.0 then puissance:=1.0 else puissance:=0.0
      else if base>0 then puissance:=exp(expo*ln(base))
                     else if odd(round(expo))
                          then puissance:= signe(base)*exp(expo*ln(abs(base)))
                          else puissance:=-signe(base)*exp(expo*ln(abs(base)))
   end;

function  factorielle(x : integer) : real;
   var
      i : integer;
      f : real;

   begin
      if x<2 then factorielle:=1
      else begin
         f:=1;
         for i:=2 to x do f:=f*i;
         factorielle:=f;
      end;
   end;


{ origine : math3d_c - alain }

function suiv(c:crdn):crdn;
  begin
    case c of
      x : suiv:=y;
      y : suiv:=z;
      z : suiv:=x
    end
  end;

procedure ligne(m:mat;i:crdn;var v:vect);        begin  v[x]:=m[x,i];    v[y]:=m[y,i];    v[z]:=m[z,i]     end;
procedure lignen(m:mat;i:crdn;var a,b,c:real);   begin  a:=m[x,i];       b:=m[y,i];       c:=m[z,i]        end;
procedure fixelig(v:vect;i:crdn;var m:mat);      begin  m[x,i]:=v[x];    m[y,i]:=v[y];    m[z,i]:=v[z]     end;
procedure fixelign(a,b,c:real;i:crdn;var m:mat); begin  m[x,i]:=a;       m[y,i]:=b;       m[z,i]:=c        end;
procedure fixevect (a,b,c:real;var v:vect);      begin  v[x]:=a;         v[y]:=b;         v[z]:=c          end;
procedure diag(m:mat;var v:vect);                begin  v[x]:=m[x,x];    v[y]:=m[y,y];    v[z]:=m[z,z]     end;
procedure fixediag(v:vect;var m:mat);            begin  m[x,x]:=v[x];    m[y,y]:=v[y];    m[z,z]:=v[z]     end;
procedure vmults(v:vect;s:real;var r:vect);      begin  r[x]:=s*v[x];    r[y]:=s*v[y];    r[z]:=s*v[z]     end;
procedure sommev(a,b:vect;var r:vect);           begin  r[x]:=a[x]+b[x]; r[y]:=a[y]+b[y]; r[z]:=a[z]+b[z]  end;
procedure diffv (a,b:vect;var r:vect);           begin  r[x]:=a[x]-b[x]; r[y]:=a[y]-b[y]; r[z]:=a[z]-b[z]  end;
procedure negv(v:vect;var r:vect);               begin  r[x]:=-v[x];     r[y]:=-v[y];     r[z]:=-v[z]      end;

procedure mmults(m:mat ;s:real;var r:mat );
  begin
    r[x,x]:=s*m[x,x];r[y,x]:=s*m[y,x];r[z,x]:=s*m[z,x];
    r[x,y]:=s*m[x,y];r[y,y]:=s*m[y,y];r[z,y]:=s*m[z,y];
    r[x,z]:=s*m[x,z];r[y,z]:=s*m[y,z];r[z,z]:=s*m[z,z]
  end;

procedure sommem(a,b:mat ;var r:mat );
  begin
    r[x,x]:=a[x,x]+b[x,x];r[y,x]:=a[y,x]+b[y,x];r[z,x]:=a[z,x]+b[z,x];
    r[x,y]:=a[x,y]+b[x,y];r[y,y]:=a[y,y]+b[y,y];r[z,y]:=a[z,y]+b[z,y];
    r[x,z]:=a[x,z]+b[x,z];r[y,z]:=a[y,z]+b[y,z];r[z,z]:=a[z,z]+b[z,z]
  end;

procedure negm(m:mat ;var r:mat );
  begin
    r[x,x]:=-m[x,x];r[y,x]:=-m[y,x];r[z,x]:=-m[z,x];
    r[x,y]:=-m[x,y];r[y,y]:=-m[y,y];r[z,y]:=-m[z,y];
    r[x,z]:=-m[x,z];r[y,z]:=-m[y,z];r[z,z]:=-m[z,z]
  end;

procedure t(m:mat ;var r:mat );
  begin
    r[x,x]:=m[x,x];r[y,x]:=m[x,y];r[z,x]:=m[x,z];
    r[x,y]:=m[y,x];r[y,y]:=m[y,y];r[z,y]:=m[y,z];
    r[x,z]:=m[z,x];r[y,z]:=m[z,y];r[z,z]:=m[z,z]
  end;

function auto_a(m : mat) : boolean;
  var
     r    : mat;
     i, j : crdn;

  begin
    t(m,r);
    i:=x;j:=x;
    while ((i<>z) or (j<>z)) and (m[i,j]=r[i,j]) do begin
      i:=suiv(i);
      if i=x then j:=suiv(j)
    end;

    if ((i=z) and (j=z)) and (m[z,z]=r[z,z]) then auto_a:=true
                                             else auto_a:=false
  end;

function anti_aa(m : mat) : boolean;
  var
     r    : mat;
     i, j : crdn;

  begin
    t(m,r);negm(r,r);
    i:=x;j:=x;
    while ((i<>z) or (j<>z)) and (m[i,j]=r[i,j]) do begin
      i:=suiv(i);
      if i=x then j:=suiv(j)
    end;

    if ((i=z) and (j=z)) and (m[z,z]=r[z,z]) then anti_aa:=true
                                             else anti_aa:=false
  end;

function norme2v(v:vect):real;  begin  norme2v:=sqr(v[x])+sqr(v[y])+sqr(v[z])       end;
function normev(v:vect):real;   begin  normev:=sqrt(sqr(v[x])+sqr(v[y])+sqr(v[z]))  end;

function normerv(var v:vect):boolean;
  var
     n : real;
  begin
    n:=normev(v);
    if n=0 then normerv:=false
    else begin
      vmults(v,1/n,v);
      normerv:=true
    end
  end;

function discrim(m : mat ; i, j : crdn) : real;
  var
     a, b, c, d : crdn;
  begin
    a:=suiv(i);b:=suiv(a);
    c:=suiv(j);d:=suiv(c);
    discrim:=m[a,c]*m[b,d]-m[a,d]*m[b,c]
  end;

function det(m:mat):real;
   var
      i : crdn;
      d : real;

   begin
      d:=0;
      for i:=x to z do d:=d+m[i,x]*discrim(m,i,x);
      det:=d
   end;

function trace(m : mat) : real;   begin  trace:=m[x,x]+m[y,y]+m[z,z];  end;

procedure tmcofact(m:mat;var r:mat);
  var
     i, j : crdn;
  begin
    for i:=x to z do
     for j:=x to z do
      r[i,j]:=discrim(m,j,i)
  end;

function inversion(m:mat;var r:mat):boolean;
  var
     d : real;
  begin
    d:=det(m);
    if d=0 then inversion:=false
    else begin
      tmcofact(m,r);
      mmults(r,1/d,r);
      inversion:=true
    end
  end;

function produits(a, b : vect) : real;   begin  produits:=a[x]*b[x]+a[y]*b[y]+a[z]*b[z]  end;

procedure vmultm(v:vect;m:mat ;var r:vect);
  begin
    r[x]:=v[x]*m[x,x]+v[y]*m[x,y]+v[z]*m[x,z];
    r[y]:=v[x]*m[y,x]+v[y]*m[y,y]+v[z]*m[y,z];
    r[z]:=v[x]*m[z,x]+v[y]*m[z,y]+v[z]*m[z,z]
  end;

procedure mmultv(m:mat ;v:vect;var r:vect);
  begin
    r[x]:=v[x]*m[x,x]+v[y]*m[y,x]+v[z]*m[z,x];
    r[y]:=v[x]*m[x,y]+v[y]*m[y,y]+v[z]*m[z,y];
    r[z]:=v[x]*m[x,z]+v[y]*m[y,z]+v[z]*m[z,z]
  end;

procedure produitm(a,b:mat ;var r:mat );
  begin
    r[x,x]:= b[x,x]*a[x,x]+ b[x,y]*a[y,x]+ b[x,z]*a[z,x];
    r[y,x]:= b[y,x]*a[x,x]+ b[y,y]*a[y,x]+ b[y,z]*a[z,x];
    r[z,x]:= b[z,x]*a[x,x]+ b[z,y]*a[y,x]+ b[z,z]*a[z,x];

    r[x,y]:= b[x,x]*a[x,y]+ b[x,y]*a[y,y]+ b[x,z]*a[z,y];
    r[y,y]:= b[y,x]*a[x,y]+ b[y,y]*a[y,y]+ b[y,z]*a[z,y];
    r[z,y]:= b[z,x]*a[x,y]+ b[z,y]*a[y,y]+ b[z,z]*a[z,y];

    r[x,z]:= b[x,x]*a[x,z]+ b[x,y]*a[y,z]+ b[x,z]*a[z,z];
    r[y,z]:= b[y,x]*a[x,z]+ b[y,y]*a[y,z]+ b[y,z]*a[z,z];
    r[z,z]:= b[z,x]*a[x,z]+ b[z,y]*a[y,z]+ b[z,z]*a[z,z]
  end;

procedure trfmat(v:vect;var m:mat);
  begin
    m:=mzero;
    m[y,z]:= v[x];m[z,x]:= v[y];m[x,y]:= v[z];
    m[z,y]:=-v[x];m[x,z]:=-v[y];m[y,x]:=-v[z]
  end;

function trfvect(m:mat;var v:vect):boolean;
  var b:boolean;
  begin
    b:=anti_aa(m);trfvect:=b;
    if b then begin
      v[x]:=m[y,z];v[y]:=m[z,x];v[z]:=m[x,y]
    end
  end;

procedure produitv(a,b:vect;var r:vect);
  begin
    r[x]:=a[y]*b[z]-a[z]*b[y];
    r[y]:=a[z]*b[x]-a[x]*b[z];
    r[z]:=a[x]*b[y]-a[y]*b[x]
  end;

procedure creerbase (a,b:vect;var u,v,w:vect);
  procedure projp(a,b:vect;var r:vect);
    begin
      vmults(b,-produits(b,a),r);
      sommev(a,r,r)
    end;
  begin
    u:=a;if not normerv(u) then u:=vux;
    projp(b,u,v);  { v est la projection de b sur le plan orthogonal  u. }
    if not normerv(v) then begin
      projp(vuy,u,v);
      if not normerv(v) then begin
        projp(vuz,u,v);
        if normerv(v) then begin end
      end
    end;
    produitv(u,v,w)
  end;

procedure mrotation(u:vect;a:real;var m:mat);
  var mu:mat;
  begin
    trfmat(u,mu);
    mmults(mu,sin(a),m);
    sommem(mid,m,m);
    produitm(mu,mu,mu);
    mmults(mu,1-cos(a),mu);
    sommem(m,mu,m)
  end;

procedure mprojp(u:vect;var m:mat);
  begin
    trfmat(u,m);
    produitm(m,m,m);
    negm(m,m)
  end;

procedure mprojd(u:vect;var m:mat);
  begin
    trfmat(u,m);
    produitm(m,m,m);
    sommem(mid,m,m)
  end;

function arccos(c:real):real;
  var s,a:real;
  begin
    if c=0 then a:=pi/2 else begin
      s:=sqrt(1/(c*c)-1);a:=arctan(s);
      if c<0 then a:=pi-a
    end;
    arccos:=a
  end;

procedure projsph(a,b,c,u:vect;var aa,bb,r:real);
  var v:vect;
  begin
    aa:=0;bb:=0;r:=normev(u);
    if normerv(u) then begin
      bb:=arccos(produits(u,c));
      v[x]:=produits(u,a);v[y]:=produits(u,b);v[z]:=0;
      if normerv(v) then aa:=arccos(produits(v,a));
      if produits(v,b)<0 then aa:=-aa
    end
  end;

procedure affichev(v:vect;c,l:integer;ch:string);
  var i:crdn;
      j:0..1;

  begin
    j:=0;
    if ch<>'' then  begin   gotoxy(c,l);write(ch);j:=1   end;
    for i:=x to z do begin
      gotoxy(c,l+ord(i)+j);
      write(v[i]:3:2)
    end
  end;

procedure affichem(m:mat;c,l:integer;ch:string);
  var i,j:crdn;
      k  :0..1;

  begin
    k:=0;
    if ch<>'' then  begin   gotoxy(c,l);write(ch);k:=1   end;
    for i:=x to z do begin
      gotoxy(c,l+ord(i)+k);
      for j:=x to z do write(m[j,i]:3:2,'  ')
    end
  end;


procedure c       (r, i : real ;             var cc: complexe);    begin   cc.r:=r;                 cc.i:=i;               end;
procedure sommec  (a, b : complexe ;         var c : complexe);    begin   c.r:=a.r+b.r;            c.i:=a.i+b.i;          end;
procedure diffc   (a, b : complexe ;         var c : complexe);    begin   c.r:=a.r-b.r;            c.i:=a.i-b.i;          end;
procedure produitc(a, b : complexe ;         var c : complexe);    begin   c.r:=a.r*b.r-a.i*b.i;    c.i:=a.r*b.i+a.i*b.r;  end;
procedure carrec  (a    : complexe ;            var c : complexe); begin   c.r:=sqr(a.r)-sqr(a.i);  c.i:=2*a.r*a.i;        end;
procedure conjugue(a    : complexe ;            var c : complexe); begin   c.r:=a.r;                c.i:=-a.i;             end;
procedure moinsc  (a    : complexe ;            var c : complexe); begin   c.r:=-a.r;               c.i:=-a.i;             end;
procedure cmults  (a    : complexe ; f : real ; var c : complexe); begin   c.r:=a.r*f;              c.i:=a.i*f;            end;

function  module2 (a    : complexe) : real;
   begin
      if (abs(a.r)>1e19) or (abs(a.i)>1e19) then begin
         module2:=-1;
      end else begin
         module2:=sqr(a.r)+sqr(a.i);
      end;
   end;
function  module  (a    : complexe) : real;                        begin   module :=sqrt(sqr(a.r)+sqr(a.i))                end;

procedure rc(a : complexe ; p : real ; var c : complexe);
   var
      m,t : real;
   begin
      m:=module2(a);

      if m=-1 then begin
         cmults(a,1e-19,a);
         rc(a,p,c);
         cmults(c,exp(ln(1e19)/p),c);
      end else if m>0 then begin
         t:=arctangente(a.i,a.r)/p;
         m:=exp(ln(m)/(2*p));
         c.r:=cos(t)*m;
         c.i:=sin(t)*m;
      end else begin
         c:=czero;
      end;
   end;

procedure rapport(a, b : complexe ; var c : complexe);
   var
      m : real;
   begin
      m:=module2(b);

      if m=-1 then begin
         cmults(b,1e-19,b);
         rapport(a,b,c);
         cmults(c,1e19,c);
      end else if m=0 then begin
         c:=czero;
      end else begin
         conjugue(b,b);
         produitc(a,b,c);
         cmults(c,1/m,c);
      end;
   end;

procedure inverser(var a:complexe;f:real);
   var
      m : real;
   begin
      m:=module2(a);
      if m=-1 then begin
         cmults(a,1e-19,a);
         inverser(a,f);
         cmults(a,1e19,a);
      end else if m=0 then begin
         a:=czero;
      end else begin
         conjugue(a,a);
         cmults(a,f/m,a);
      end;
   end;

procedure affichec(s:string;c:complexe;t,d:integer);
   begin
      if c.i>=0 then writeln(s,c.r:t:d,' + ', c.i:t-1:d,' i')
                else writeln(s,c.r:t:d,' - ',-c.i:t-1:d,' i');
   end;


function puis_3(x:real):real;     begin  puis_3 :=sqr(x)*x      end;
function puis_i3(x:real):real;    begin  puis_i3:=exp(ln(x)/3)  end;


function pn4d(a,b,c,d,e,x:real):real;    begin  pn4d:=a*sqr(sqr(x)) + b*sqr(x)*x + c*sqr(x) + d*x + e;  end;


procedure racine1d(a1, b1 : real ; var x : complexe ; var deg : integer);
   begin
      if      (b1=0) then begin x:=czero;      deg:= 1;
                                if a1=0 then   deg:=-1  end
      else if (a1=0) then begin x:=czero;      deg:= 0  end   { <- impossible }
                     else begin c(-b1/a1,0,x); deg:= 1  end;

   end;

procedure racine2d(a1, b1, c1 : real ; var x1, x2 : complexe ; var deg : integer);
   var
      z : complexe;
   begin
      if (a1=0) then begin
         racine1d(b1, c1, x1, deg);
      end else if (c1=0) then begin
         racine1d(a1, b1, x1, deg);
         deg:=2;
         x2:=czero;
      end else if (b1=0) then begin
         deg:=2;
         c(-c1/a1, 0, x1);
         rc(x1, 2, x1);
         moinsc(x1, x2);
      end else begin
         deg:=2;
         c(sqr(b1/(2*a1))-c1/a1, 0, z);
         rc(z, 2, z);
         c(-b1/(2*a1), 0, x2);
         sommec(x2, z, x1);
         diffc (x2, z, x2);
      end;
   end;

procedure racine3d(a1, b1, c1, d1 : real ; var x1, x2, x3 : complexe ; var deg : integer);
   var
      b2,b3,e,f,e2,f3  : real;
      g,h,DD,AA,J,J2,z       : complexe;

   begin
      if (a1=0) then begin
         racine2d(b1, c1, d1, x1, x2, deg);
      end else if (d1=0) then begin
         racine2d(a1, b1, c1, x1, x2, deg);
         deg:=3;
         x3:=czero;
      end else if (b1=0) and (c1=0) then begin
         deg:=3;
         c(-1,0,z);
         rc(z,3,z);
         carrec(z,z);
         c(-d1/a1, 0, x1);
         rc(x1, 3, x1);
         produitc(x1,z,x2);
         produitc(x2,z,x3);
      end else begin
         deg:=3;
         b1:=b1/a1;
         c1:=c1/a1;
         d1:=d1/a1;
         b2:=sqr(b1);   b3:=b2*b1;

         e := -b3+9/2*b1*c1-27/2*d1;     e2:=sqr(e);
         f := b2-3*c1;                   f3:=sqr(f)*f;
         c( b2/3-c1, 0, h );
         c( -b1/3, 0, DD );

         c(e2-f3,0,g);
         rc(g, 2, g);
         c(e,0,cc);
         sommec(g,cc,g);
         rc(g, 3, g);

         c(-1/2, sqrt(3)/2, J);
         carrec(J, J2);
         rapport(h, g, AA);
         cmults(g, 1/3, g);

                                                    sommec(AA,  g, x1);  sommec(DD, x1, x1);
         produitc(J2, g, cc); produitc(J,  AA, x2); sommec(cc, x2, x2);  sommec(DD, x2, x2);
         produitc(J,  g, cc); produitc(J2, AA, x3); sommec(cc, x3, x3);  sommec(DD, x3, x3);
      end;
   end;

procedure racine4d(a1, b1, c1, d1, e1 : real ; var x1, x2, x3, x4 : complexe ; var deg : integer);
   var
      b2,c2,f2,
      b3,c3,f3,
      b4,c4,h2,m2,
      f,g,h,m,q,
      r,s,t,u,v,w,z     : real;

      J,BB,AB,AB1,p,zz,
      AB2,AB3,DD,AA     : complexe;

   begin
      if (a1=0) then begin
         racine3d(b1, c1, d1, e1, x1, x2, x3, deg);
         x4:=x3;
      end else if (e1=0) then begin
         racine3d(a1, b1, c1, d1, x1, x2, x3, deg);
         deg:=4;
         x4:=czero;
      end else if (b1=0) and (c1=0) and (d1=0) then begin
         deg:=4;
         zz:=ci;
         c(-e1/a1, 0, x1);
         rc(x1, 4, x1);
         produitc (x1, zz, x2);
         produitc (x2, zz, x3);
         produitc (x3, zz, x4);
      end else if (b1=0) and (d1=0) then begin
         racine2d(a1,c1,e1,x1,x2, deg);
         deg:=4;
         rc(x1, 2, x1);
         rc(x2, 2, x3);
         moinsc(x1, x2);
         moinsc(x3, x4);
      end else begin
         deg:=4;
         b1:=b1/a1;
         c1:=c1/a1;
         d1:=d1/a1;
         e1:=e1/a1;
         b2:=sqr(b1);   b3:=b2*b1;   b4:=sqr(b2);
         c2:=sqr(c1);   c3:=c2*c1;   c4:=sqr(c2);

         f:=-3*b2+8*c1;                             f2:=sqr(f); f3:=f2*f;
         g:=3*b4-16*b2*c1+16*b1*d1+16*c2-64*e1;
         h:=b3-4*b1*c1+8*d1;                        h2:=sqr(h);
         m:=-9*g*f+2*f3-27*h2;                      m2:=sqr(m);

         c(-puis_3(-3*g+f2)+m2/4, 0, p);
         rc(p, 2, p);
         c(4.5*g*f-f3+27/2*h2, 0, cc);
         sommec(cc, p, p);
         rc(p, 3, p);

         q:=16*c2;
         r:=16*b1*d1;
         s:=16*b2*c1;
         t:=-3*b4;

         u:=8/3*c1;
         v:=64*e1;
         w:=f2/3;

         z:=t+s-r-q+v+w;

         c(z, 0, cc);
         rapport(cc, p, cc);
         c(b2-u, 0, AA);
         sommec(AA, cc, cc);
         cmults(p, 1/3, AA);
         sommec(cc, AA, AA);
         rc(AA, 2, AA);

         c(-1/2, sqrt(3)/2, J);

         conjugue(J, BB);
         cmults(p, 1/3, cc);
         produitc(BB, cc, cc);
         c(b2-u, 0, BB);
         sommec(cc, BB, BB);
         cmults(J, z, cc);
         rapport(cc, p, cc);
         sommec(BB, cc, BB);

         rc(BB, 2, BB);

         produitc(AA, BB, AB);

         AB1:=AB;              inverser(AB1,2*d1);
         AB2:=AB;              inverser(AB2,b1*c1);
         cmults(AB, 4,   AB3); inverser(AB3,b3);

         diffc(AB1, AB2, AB);
         sommec(AB, AB3, AB);

         cmults(AA, 1/4, AA);
         cmults(BB, 1/4, BB);
         c(-b1/4, 0, DD);

         sommec(AA, BB, AB1);
         diffc (AA, BB, AB2);

         sommec(DD, AB1, X1); diffc (X1, AB, X1);
         sommec(DD, AB2, X2); sommec(X2, AB, X2);
         diffc (DD, AB2, X3); sommec(X3, AB, X3);
         diffc (DD, AB1, X4); diffc (X4, AB, X4);
      end;
   end;

end.
