unit
  Mouse;

{
    Logiciel LEMAN 2.0

    Thierry OLYNYK pour le CNDP

    De mars 1994  ???

    Unit Mouse : gestion de la souris en mode graphique
    ( modification de l'unit du mme nom provenant d'Image (CNDP)
      elle-mme provenant de l'unit Mouse fournie par Borland )
}

interface

const
  ButtonReleased = 0;
  ButtonLeft     = 1;
  ButtonRight    = 2;
  ButtonMiddle   = 3;

var
  MousePresent : Boolean;
  NormCurs     : Boolean; {TRUE si le curseur  l'apparence d'une flche}
  Combien      : Integer;

{ Microsoft Mouse functions }

function  XMouse    : Integer;     { function  3 }
{ Renvoie la position horizontale du Curseur }
function  YMouse    : Integer;     { function  3 }
{ Renvoie la position verticale du Curseur }
procedure SetMouse(X,Y : integer); { function 4 }
{ Place le Curseur  la position X,Y }
procedure ClearMouse;              { function 15 }
{ Rinitialise la souris }
procedure ShowMouse;               { function  1 }
{ Affiche le curseur }
procedure HideMouse;               { function  2 }
{ Cache le curseur }
function  ButtonPressed : byte;    { function  3 }
{ Renvoie le numro du bouton press et zro relch }
function  InitMouse: byte;         { function  0 }
{ Renvoie le nombre de boutons presss et zro si souris non installe }
procedure DoneMouse;
{ T.O. Dsactive le driver }
procedure WindowMouse(X1,Y1, X2,Y2 : integer);
{ Limite la souris  la fentre de diagonale (X1,Y1)  (X2,Y2) }

procedure Croix1Mouse;
{ Curseur Croix 1 }
procedure CursorVerticalLine;
{T.O. : curseur pour ligne de saisie}
procedure SandCursor;
{TO, sablier}
procedure NormalCursor;
{T.O. : curseur normal}

implementation

uses
  Dos;

var
   Regs   : Registers;

type
  GCursPtr = ^GCurs;
  GCurs    = Array [1..32] of Word;

{---------------------------------}
Function InitMouse : byte;
{ Dtecte la souris : renvoie le nombre de boutons }
 Function Interrupt_loaded:boolean;
 begin
     Regs.Ax := 0;
     Intr($33,Regs);
     Interrupt_Loaded :=  Regs.Ax <> 0;
 End;
Begin
    If Memw[$0000:$00CC] = 0 then
       InitMouse := 0 {don't call interrupt if vector is zero}
    else
    begin
      If Not Interrupt_loaded
         then InitMouse := 0
         else InitMouse := Regs.bx;
    end;
End;


procedure DoneMouse;
begin
  if MousePresent
  then begin
    Regs.AX:=$1F;
    Intr($33,Regs);
  end;
end;

{---------------------------------}
Function XMouse;
Begin
  Regs.AX := 3;
  Intr($33,Regs);
  XMouse := Regs.CX;
End;

{---------------------------------}
Function YMouse;
Begin
  Regs.AX := 3;
  Intr($33,Regs);
  YMouse := Regs.DX;
End;


{ --------------------------- }
Procedure ShowMouse;                 { Make Mouse cursor visible }
Begin
  Regs.ax := 1;
  Intr ($33, Regs);
End;

{ --------------------------- }
Procedure HideMouse;               { Make Mouse cursor invisible }
Begin
  Regs.ax := 2;
  Intr ($33, Regs);
End;

{ --------------------------- }
Procedure mGraphCursor (hHot, vHot : Integer;
                   MaskSeg, MaskOfs : word);   { function  9 }
{ Set Mouse graphics cursor }
Begin
  Regs.ax := 9;
  Regs.bx := hHot;
  Regs.cx := vHot;
  Regs.dx := MaskOfs;
  Regs.es := MaskSeg;
  Intr ($33, Regs);
End;

{ --------------------------- }

Procedure ClearMouse;        { Resets Mouse to default condition }
{ rinitialise la souris : veiller  ce que a souris soit installe...
   par MOUSE.COM ou par MOUSE.SYS }
Begin
  With Regs do
    begin
      ax := 15;
      cx := 8; { pas d'acclration }
      dx := 16; { pas d'acclration }
    end;
  Intr ($33, Regs);
End;

{---------------------------------}
Function ButtonPressed : byte;
{ renvoie numero bouton press ou zero }
Var b : byte;
Begin
  Regs.ax := 3;
  Intr($33,Regs); { appel du pilote de la souris }
  With Regs do
    begin
      If ((bx and 1)<>0) then b := ButtonLeft
      else If ((bx and 2)<>0) then b := ButtonRight
      else If ((bx and 4)<>0) then b := ButtonMiddle
      else b := ButtonReleased;
    end;
  ButtonPressed :=Byte( b);
End;


{ --------------------------- }
Procedure SetMouse(X,Y : integer);
{ Move Mouse cursor to new location }
Begin
  Regs.ax := 4;
  Regs.cx := X;
  Regs.dx := Y;
  Intr ($33, Regs);
End;

{---------------------------------}
Procedure MousePos(Var x,y : integer);
{ lit les coordonnes actuelles de la souris }
Begin
 x := XMouse;
 y := YMouse;
End;


Function lower (n1, n2 : Integer) : Integer;  { Local to unit}
Begin
  If n1 < n2 then lower := n1
  Else lower := n2;
End;

Function upper (n1, n2 : Integer) : Integer; { Local to unit }
Begin
  If n1 > n2 then upper := n1
  Else upper := n2;
End;

{ --------------------------- }
Procedure WindowMouse(X1,Y1, X2,Y2 : integer);
Begin
  { Set Col range for Mouse }
  Regs.ax := 7;
  Regs.cx := lower (X1, X2);
  Regs.dx := upper (X1, X2);
  Intr ($33, Regs);
  { Set row range for Mouse }
  Regs.ax := 8;
  Regs.cx := lower (Y1, Y2);
  Regs.dx := upper (Y1, Y2);
  Intr ($33, Regs);
End;

{ --------------------------- }

Procedure Croix1Mouse;
Const
   Croix1Im : GCurs =(
                      $fc7f,       { 1111110001111111 }
                      $fc7f,       { 1111110001111111 }
                      $fc7f,       { 1111110001111111 }
                      $ffff,       { 1111111111111111 }
                      $ffff,       { 1111111111111111 }
                      $ffff,       { 1111111111111111 }
                      $07e1,       { 0000111111100001 }
                      $07e1,       { 0000111111100001 }
                      $07e1,       { 0000111111100001 }
                      $ffff,       { 1111111111111111 }
                      $ffff,       { 1111111111111111 }
                      $ffff,       { 1111111111111111 }
                      $fc7f,       { 1111110001111111 }
                      $fc7f,       { 1111110001111111 }
                      $fc7f,       { 1111110001111111 }
                      $ffff,       { 1111111111111111 }
                  
                      $0000,       { 0000000000000000 }
                      $0100,       { 0000000100000000 }
                      $0100,       { 0000000100000000 }
                      $0100,       { 0000000100000000 }
                      $0100,       { 0000000100000000 }
                      $0100,       { 0000000100000000 }
                      $0000,       { 0000000000000000 }
                      $7c7c,       { 0111110001111100 }
                      $0000,       { 0000000000000000 }
                      $0100,       { 0000000100000000 }
                      $0100,       { 0000000100000000 }
                      $0100,       { 0000000100000000 }
                      $0100,       { 0000000100000000 }
                      $0100,       { 0000000100000000 }
                      $0000,       { 0000000000000000 }
                      $0000);      { 0000000000000000 }

Begin
    MGraphCursor(7, 7, Seg(Croix1Im), Ofs(Croix1Im));
    NormCurs:=FALSE;
End;

PROCEDURE CursorVerticalLine;
Const
   Cursor   : GCurs =(
                      $F11F,       { 1111000100011111 }
                      $F11F,       { 1111000100011111 }
                      $F83F,       { 1111100000111111 }
                      $FC7F,       { 1111110001111111 }
                      $FC7F,       { 1111110001111111 }
                      $FC7F,       { 1111110001111111 }
                      $FC7F,       { 1111110001111111 }
                      $FC7F,       { 1111110001111111 }
                      $FC7F,       { 1111110001111111 }
                      $FC7F,       { 1111110001111111 }
                      $FC7F,       { 1111110001111111 }
                      $FC7F,       { 1111110001111111 }
                      $FC7F,       { 1111110001111111 }
                      $F83F,       { 1111100000111111 }
                      $F11F,       { 1111000000011111 }
                      $F11F,       { 1111000100011111 }

                      $0000,       { 0000000000000000 }
                      $0440,       { 0000010001000000 }
                      $0280,       { 0000001010000000 }
                      $0100,       { 0000000100000000 }
                      $0100,       { 0000000100000000 }
                      $0100,       { 0000000100000000 }
                      $0100,       { 0000000100000000 }
                      $0100,       { 0000000100000000 }
                      $0100,       { 0000000100000000 }
                      $0100,       { 0000000100000000 }
                      $0100,       { 0000000100000000 }
                      $0100,       { 0000000100000000 }
                      $0100,       { 0000000100000000 }
                      $0280,       { 0000001010000000 }
                      $0440,       { 0000010000100000 }
                      $0000);      { 0000000000000000 }

BEGIN
    MGraphCursor(7, 7, Seg(Cursor), Ofs(Cursor));
    NormCurs:=FALSE;
END;

PROCEDURE SandCursor;
Const
   Cursor   : GCurs =(
                      $8003,       { 1000000000000011 }
                      $8003,       { 1000000000000011 }
                      $8003,       { 1000000000000011 }
                      $8003,       { 1000000000000011 }
                      $C007,       { 1100000000000111 }
                      $E00F,       { 1110000000001111 }
                      $F01F,       { 1111000000011111 }
                      $F83F,       { 1111100000111111 }
                      $F83F,       { 1111100000111111 }
                      $F01F,       { 1111000000011111 }
                      $E00F,       { 1110000000001111 }
                      $C007,       { 1100000000000111 }
                      $8003,       { 1000000000000011 }
                      $8003,       { 1000000000000011 }
                      $8003,       { 1000000000000011 }
                      $8003,       { 1000000000000011 }

                      $0000,       { 0000000000000000 }
                      $3FF8,       { 0011111111111000 }
                      $2008,       { 0010000000001000 }
                      $2008,       { 0010000000001000 }
                      $1FF0,       { 0001111111110000 }
                      $0FE0,       { 0000111111100000 }
                      $07C0,       { 0000011111000000 }
                      $0380,       { 0000001110000000 }
                      $0380,       { 0000001110000000 }
                      $0580,       { 0000010101000000 }
                      $0920,       { 0000100100100000 }
                      $13D0,       { 0001001110010000 }
                      $2FE8,       { 0010111111101000 }
                      $3FF8,       { 0011111111111000 }
                      $3FF8,       { 0011111111111000 }
                      $0000);      { 0000000000000000 }

BEGIN
    MGraphCursor(7, 7, Seg(Cursor), Ofs(Cursor));
    NormCurs:=FALSE;
END;

PROCEDURE NormalCursor;
VAR
  R:Registers;
BEGIN
  R.AX:=$03; Intr($33,R);
  Regs.AX:=$21; Intr($33,Regs);
  R.AX:=$04; Intr($33,R);
  NormCurs:=TRUE;
  ShowMouse;
END;

Begin
  MousePresent := FALSE;
  Combien := 0;
End.
