UNIT BLOC_1;

   {------------------------------------------------------------------------}
   { logiciel GEOCEAN - module BLOC                                         }
   {                                                                        }
   {                         menu FICHIERS                                  }
   {                                                       10/10/93         }
   {------------------------------------------------------------------------}

INTERFACE
{$O+,F+}

USES
   Dos,
   Utildivs,                 { ARX     - utilitaires divers                 }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Periphs,                  { ARX     - priphriques, impression, palettes}
   Dirinfo,                  { ARX     - gestion fichier INFO.DIR           }

   GEO_var,                  { GEO     - variables globales communes        }
   GEO_des,                  { GEO     - procdures graph. communes         }

   BLOC_var,                 { BLOC    - variables globales du module       }
   BLOC_ini,                 { BLOC    - initialisation                     }
   BLOC_des;                 { BLOC    - affichages propres au module       }

Procedure voir_parametres;
   { afficher les listes dans une bote  dfilement                        }

Procedure modifier_lien;
   { slectionner les noms des fichiers de donnes utiles au module BLOC    }
   { pas de changement de la rgion dfinie lors de l'appel (var dos)       }

Procedure supprimer_lien;
   { slectionner les noms des fichiers de donnes utiles au module BLOC    }

Procedure ouvrir_fichier;
   { slectionner un nom de fichier de paramtres existant dans le          }
   { rpertoire de travail (en cours) et rtablir l'environnement de        }
   { travail associ.                                                       }

Procedure nouveau_fichier;
   { slectionner un nouveau nom pour un nouveau fichier de paramtres      }
   { et rtablir l'environnement standard, vt  partir de BLOC.CRT         }

Procedure enregistrer_fichier;
   { enregistre les paramtres en cours sans changer l'tat de l'cran.     }
   { enregistre aussi les donnes                                           }

Procedure enregistrer_sous;
   { copie les paramtres en cours dans un autre fichier                    }
   { copie aussi les donnes                                                }

Procedure quitter;
   { demander confirmation avant de stopper l'excution                     }

{---------------------------------------------------------------------------}

IMPLEMENTATION

procedure voir_parametres;
   begin
      creeliste (c_travail, 1);
      creeliste (c_config, 2);

      liste     ('', l_params2, '', 35, chain, entier);
      case entier of
         1 : voir_ptrav;
         2 : voir_penv;
      end
   end;

procedure  FIC_DONNEES_noms;                  { 1 }
   begin
      liberer_noms;
      chang_noms_3d;
      visutoponym := true;
      redess_tout;
   end;

procedure  FIC_DONNEES_comm;                   { 1 }
   begin
      chang_comm (nomfcomm);
      visucomm     := true;
      redess_tout;
  end;

procedure modifier_lien;
   begin
      creeliste (c_toponymie    , 1);
      creeliste (c_comment      , 2);
      liste (l_lien1, l_lien2, l_lien3, 15, chain, entier);
      case entier of
         1 : FIC_DONNEES_noms;                  { 1 }
         2 : FIC_DONNEES_comm;                  { 1 }
      end;
      modipar := true;
   end;

procedure  s_FIC_DONNEES_noms;                  { 1 }
   begin
      liberer_noms;
      visutoponym := false;
      nomftop     := '';
      ini_par_noms;
      redess_tout;
   end;

procedure  s_FIC_DONNEES_comm;                  { 1 }
   begin
      visucomm := false;
      { librer la collection }
      liberer_commentaires;

      { effacer}
      nomfcomm := '';
      redess_tout;
   end;

procedure supprimer_lien;
   begin
      creeliste (c_toponymie , 1);
      creeliste (c_comment   , 2);
      liste (s_lien1, s_lien2, s_lien3, 15, chain, entier);
      case entier of
         1 : s_FIC_DONNEES_noms;                  { 1 }
         2 : s_FIC_DONNEES_comm;                  { 1 }
      end;
      modipar  := true;
   end;

procedure verif;
   begin
      ok := true;
      if modipar and not exempl
      then begin
         question (q_verif1,  q_verif2, ok);
         if ok
         then
            if ((nomfpar <> nomdumodule) )
            then begin
               ecrire_parametres (true);               { sauver_fichiers }
               modipar:= false;
            end else begin
               message (m_donner_nom);
               enregistrer_sous;
            end;
      end;
   end;

procedure ouvrir_fichier;
   begin
      verif;
      efftout;                                                      { des }
      dir_info                                                  { dirinfo }
         ('', d_chbloc2, '', nomfinfo, '*', extPAR, nomfpar);
      nomfpar :=  sansext (nomfpar);
      if nomfpar = ''
      then
         nomfpar := nomdumodule;
      lire_parametres;
      inidonnees;
      iniecran;                                                    { des }
      ini_noms_3d;
      redess_tout;
   end;

procedure nouveau_fichier;
   begin
      verif;
      efftout;
      nomfpar := nomdumodule;
      lire_parametres;
      inidonnees;
      iniecran;
      ini_noms_3d;
      redess_tout;
   end;

procedure enregistrer_fichier;
   begin
      inietat ;
      if nomfpar = nomdumodule
      then
         nomfpar  := nomfdefo (nomdumodule, nomfpar, nomutil);

      if nomfpar <> nomdumodule
      then begin
         ecrire_parametres (true);
         modipar := false
      end else
         message (m_donner_nom);
   end;

procedure enregistrer_sous;
   var
      ext               : extstr;

   begin
      inietat ;
      ext     := extpar;
      ok      := false;
      if nomfpar = nomdumodule
      then
         nomfpar  := nomfdefo (nomdumodule, nomfpar, nomutil);

      nomfichier_sortie                                    { menus5 }
         (nomf_nouveau +' ('+ extpar + ')', '', nomfpar, ext, ok);

      if (nomfpar = nomdumodule) and prof
      then begin
         ok := false;
         question (q_creer1, q_creer2, ok);
      end;

      if ((nomfpar <> nomdumodule) or prof) and ok
      then begin
         { enregistrer aussi les fichiers de donnes dfinitifs }
         nomfcomm := nomfpar;
         nomftop  := nomfpar;
         inietat  ;
         ecrire_parametres (true);
         modipar := false
      end else
         message (m_lefichier+' '+nomfpar+' '+m_lefichiers);
   end;

procedure quitter;
   begin
      question (q_quitter1, q_quitter2, fini);
      if fini
      then
         verif;
   end;


END.

{--- GEOCEAN - BLOC_1 ------------------------ R.C.- INRP - TOULOUSE - 1993 }
