PROGRAM CART;

{---------------------------------------------------------------------------}
{  Logiciel GEOCEAN - module CARTES                                         }
{  programme principal du  logiciel CARTES       version 1.x du  06/04/96   }
{---------------------------------------------------------------------------}

{---------------------------------------------------------------------------}
{  Institut National de Recherche Pdagogique - PARIS                       }
{  Equipe INRP  TOULOUSE                                                    }
{  S. DUPOUY, C. GROS, R. CULOS, F. BOULANGER, J. TONNELAT, J. Y. GUCHEREAU }
{  Ralisation :  93-96                                                     }
{  A R X - Alain, Roger et Xavier CULOS - 6 avenue de Lagarde 31130 BALMA   }
{---------------------------------------------------------------------------}

{---------------------------------------------------------------------------}
{ fichiers spciaux associs au logiciels GEOCEAN                           }
{ *  *       .SMB            symboles                         dans rep PRG  }
{ *  GEOCEAN .CFG            paramtres de configuration      dans rep PRG  }

{ fichiers spciaux associs  ce MODULE                                    }
{ *  CART    .ICN            images, icnes                   dans rep PRG  }
{ *  CART    .PAL            palette                          dans rep PRG  }
{ *  CART    .TXT            mini documentation du programme  dans rep PRG  }
{ *  CART    .AID            texte d'aide                     dans rep PRG  }

{---------------------------------------------------------------------------}
{ fichiers associs aux donnes utilises   (rpert de donnes/rgion )     }
{    *       .GRD            Grille rgulire des valeurs                   }
{                             cartographier (format INRP/BGI)              }
{    *       .BLN            carte                                          }
{    *       .DAT            valeurs ponctuelles                            }
{    *       .SMP            libells des colonnes DAT                      }
{    *       .DAP            informations/noms des lieux                    }
{---------------------------------------------------------------------------}
{ fichiers gnrs                 ( rpert. de travail )                   }
{    *       .CRT            paramtres du travail en cours                 }
{    *       .SMP            paramtres des symboles                        }
{    *       .DXT            Commentaires associs/carte                    }
{    *       .CRB            Courbes brutes sans lissage ni tiquettes      }
{    *       .PLT            Code HPGL ou imprimante                        }
{    *       .PCX            Copie cran PCX  N&B                           }
{    *       .BLF            Fond de carte : courbes                        }
{    *       .ETI            Fond de carte : tiquettes                     }
{    *       .BLZ            Fond de carte : courbes 3d pour NUAG           }
{---------------------------------------------------------------------------}

{$M 65520,0,655360}

USES
   CART_REC,         { gestion des recouvrements                            }

   CSI,              { gestion du Clavier, de la Souris et des Icnes       }
   MENUS,            { interface  menus droulants                          }

   GEO_VAR,          { variables globales communes                          }
   GEO_DES,          { procedures diverses communes                         }

   CART_VAR,         { variables globales propres au module                 }
   CART_DES,         { graphisme du module                                  }
   CART_INI,         { initialisations                                      }

   CART_5,           { menu : SORTIES                                       }
   CART_4,           { menu : ECRAN                                         }
   CART_3,           { menu : LEGENDES                                      }
   CART_2,           { menu : COURBES                                       }
   CART_1;           { menu : FICHIERS  gestion des rpertoires             }

{$O cart_var}        { dfinition des units en recouvrement                }
{$O cart_ini}
{$O cart_des}

{$O cart_5}
{$O cart_4}
{$O cart_3}
{$O cart_2}
{$O cart_1}

{$O geo_var}
{$O geo_des}

{$O courbdes}
{$O courbcal}
{$O grilles}
{$O Menus}
{$O CSI}
{$O Icones}

{$O symboles}
{$O curseurs}
{$O periphs}
{$O comment}
{$O dirinfo}
{$O graphuti}
{$O lipar}

{$O clavier}
{$O souris}

{$O graphplt}
{$O edition}
{$O utildivs}
{$O fichiers}
{$O graphism}
{$O rs2322}
{$O sekoplt}
{$O imprim}
{$O fctmath}

{$O objects}
{---------------------------------------------------------------------------}

procedure CasMenus;
   var
      Choix             : integer;

   begin
      if changemenus then exit;

      menu (a, b, codeclavier); { MENU2 }
                               { acquisition d'un choix valide dans un menu }

      if FF1 (codeclavier)     { CSI }
      then                     { appui sur la touche F1 dans un sous-menu   }
         aide (a, b)           { CART_INI }
      else  begin
         if b > 1
         then
            Choix := 100*a+b;
         case Choix of         { validation d'une option dans un sous-menu  }
          { menu FICHIERS }
            102  : NOUVEAU_FICHIER;                   { 1 }
            103  : OUVRIR_FICHIER;                    { 1 }
            104  : ENREGISTRER_FICHIER;               { 1 }
            105  : ENREGISTRER_SOUS;                  { 1 }
            106  : VOIR_CATALOGUE;                    { menus5 }

            108  : QUITTER;                           { 1  p }

            110  : SUPPRIMER_LIEN;                    { 1  p }
            111  : MODIFIER_LIEN;                     { 1  p }
            112  : VOIR_PARAMETRES;                   { 1  p }

            { menu COURBES  }
            202  : d_etiqs;                           { 2 }
            203  : v_ZONES_c;                         { 2 }
            204  : d_ZONE;                            { 2 }

            206  : CALCULER;                          { 2 }

            208  : SAUVER_COURBES;                    { 1 }
            209  : CHARGER_FOND;                      { 1 }
            210  : UNE_PAR_UNE;                       { 2 prof }
            211  : CHARGER_COURBES;                   { 1 prof }
            212  : SAUVER_TOPONYMIE;                  { 1 prof }

          { menu LEGENDES }
            302  : COMMENTAIRES;                      { 3 }
            303  : AXES;                              { 3 }
            304  : d_CONTOUR;                         { 3 }
            305  : d_SYMBOLES;                        { 3 }
            306  : v_ZONES_s;                         { 3 }
            307  : d_ZONESYMB;                        { 3 }
            308  : d_TOPONYMIE;                       { 3 }
            309  : ajouter_nom;
            310  : AUTRES_PARAMS;                     { 3  prof }

          { menu  ECRAN }
            402  : visu_commentaires;                 { 4 }
            403  : visu_graduations;                  { 4 }
            404  : visu_carte;                        { 4 }
            405  : visu_symboles;                     { 4 }

            407  : visu_toponymie;                    { 4 }
            408  : visu_quadr;                        { 4 }
            409  : visu_courbes;                      { 4 }
            410  : visu_fond;                         { 1 }
            411  : visu_etiqs;                        { 4 }
            412  : modif_fenetre_graph;               { 4 prof }

         { menu SORTIES }
            502  : COPECRAN;                          { 5 }
            504  : TRACE_GRAPH;                       { 5 }
            507  : geo_PALETTES (nomdumodule);            { geo_des }
            508  : CONFIG_PERIPH;                     { geo_des }
            509  : IMPR_PARAM;                        { 5  prof}

          { menu AIDES }
            602  : AIDE_MENUS_boites (cheminmodule+nomdumodule+exthlp);                        { ini }
            603  : aide (6, 3);
            604  : aide_geoc;
            605  : aide_module;
            606  : aide_region;
            608  : a_propos;
         end;
      end;
   end;

procedure CasIcones;
   var
      PosCur,
      Touche            : integer;

   begin
      if changemenus then exit;
      PosCur := 11;
      if affichetexte           { appui sur F1 au niveau d'une icne }
      then
         case Zi of                                { GEO_CSI }
             1 : aide_geoc;             {  }
             2 : version_logiciel;
             3 : aide (2, 6);           {  }
             4 : aide_module;           {  }
          5..6 : aide (3, 11);
         end
      else begin
         case Zi of                                              { GEO_CSI  }
             1 : a_propos;
             3 : CALCULER;                                       { CART_2   }
             4 : aide_region;
          5..6 : previsucrb;                                     { CART 4   }
           100      : edi_min_max;          { curseur double  }
           101..110 : edi_zone (zi-100);    { nbmaxzones = 10 }
           111      : edi_equi;
         end;
      end;
   end;

procedure CasFenetre;
   begin
      if changemenus then exit;
      if visucomm
      then
         Editer_Commentaires (xs, ys, db);

      if visutoponym
      then
         Editer_noms         (xs, ys, db);
   end;

procedure AutreCas;
   begin
      if changemenus then exit;
   end;

BEGIN                { programme principal }

   iniparam ;        { initialisation des paramtres par dfaut    CART_INI }
                     { lecture de fic.CFG                                   }
   inimenus ;        { initialisation de l'interface menus         CART_INI }
   iniparam2 ;       { initialisation des paramtres par dfaut    CART_INI }
                     { lecture des fichiers .CPS, .SMP, .TXP                }
   iniicones;        { initialisation des icnes                   CART_DES }
   inifondecran;
   inisymboles;      { initialisation des polices de symboles      CART_DES }
   inidonnees;       { initialisation des donnes                  CART_INI }


   iniecran ;        { initialisation de l'cran/CART              CART_DES }
   ini_noms ;        { initialisation des coord des noms des lieux }

   redess_carte (false);
   iniaide  ;        { initialisation de l'aide en ligne           CART_INI }
                     {      lecture de   fic.AID                            }

   repeat
      modif_menus;   { modifications fonction des paramtres CRT   CART_INI }
      case ZoneDuClick (maxc1, maxc2, maxc3, maxc4) of                                       { GEO_CSI }
         1 : CasMenus  ;
         2 : CasIcones ;
         3 : CasFenetre;
         4 : autreCas  ;
      end;
      if changemenus
      then
         inversemenus;
   until fini;
   fin;                                                          { CART_INI }

END.               { programme principal }


{--- GEOCEAN - CART -------------------------- R.C.- INRP - TOULOUSE - 1995 }
