PROGRAM COUP;

{---------------------------------------------------------------------------}
{  Logiciel GEOCEAN - module COUPES :  coupes en 2 d                        }
{                                                                           }
{  programme principal du  logiciel COUPES       version 1.x du  06/04/96   }
{---------------------------------------------------------------------------}

{---------------------------------------------------------------------------}
{  Institut National de Recherche Pdagogique - PARIS                       }
{  Equipe INRP  TOULOUSE                                                    }
{  S. DUPOUY, C. GROS, R. CULOS, F. BOULANGER, J. TONNELAT, J. Y. GUCHEREAU }
{  Ralisation :  93-96                                                     }
{  A R X - Alain, Roger et Xavier CULOS - 6 avenue de Lagarde 31130 BALMA   }
{---------------------------------------------------------------------------}

{---------------------------------------------------------------------------}
{ fichiers spciaux associs au logiciels GEOCEAN                           }
{ *  *       .SMB            symboles                         dans rep PRG  }
{ *  GEOCEAN .CFG            paramtres de configuration      dans rep PRG  }

{ fichiers spciaux associs  ce programme                                 }
{ *  COUP    .ICN            images, icnes                   dans rep PRG  }
{ *  COUP    .PAL            palette                          dans rep PRG  }
{ *  COUP    .TXT            mini documentation du programme  dans rep PRG  }
{ *  COUP    .AID            texte d'aide                     dans rep PRG  }

{---------------------------------------------------------------------------}
{ fichiers associs aux donnes utilises                                   }
{    *       .GRD            Grille rgulire des valeurs     dans rep DNN  }
{                             cartographier (format INRP/BGI)              }
{                                                                           }
{    CONTI   .BLN            carte                            dans rep DNN  }
{    *       .DAT            informations/symboles carte               DNN  }
{    *       .BLF            Fonds de carte : courbes                       }
{    *       .ETI            Fonds de carte : tiquettes                    }
{---------------------------------------------------------------------------}
{ fichiers gnrs                 ( rpert. de travail )                   }
{    *       .CPS            paramtres du travail en cours                 }
{    *       .DXT            Commentaires associs/carte                    }
{    *       .PLT            Code HPGL ou imprimante                        }
{    *       .PCX            Copie cran PCX  N&B                           }
{---------------------------------------------------------------------------}

{$M 65520,0,655360}

USES
   Coup_Rec,         { gestion des recouvrements                            }

   Csi,              { gestion du Clavier, de la Souris et des Icnes       }
   Menus,            { interface  menus droulants                          }

   GEO_VAR,          { variables globales communes                          }
   GEO_DES,                  { GEO     - procdures graph. communes         }

   COUP_VAR,         { variables globales propres au module                 }
   COUP_DES,         { graphisme du module                                  }
   COUP_INI,         { initialisations                                      }

   COUP_5,           { menu : SORTIES                                       }
   COUP_4,           { menu : ECRAN                                         }
   COUP_3,           { menu : LEGENDES                                      }
   COUP_2,           { menu : COUP                                          }
   COUP_1;           { menu : FICHIERS  gestion des rpertoires             }

{---------------------------------------------------------------------------}
{                      dfinition des units en recouvrement                }
{$O coup_var}
{$O coup_ini}
{$O coup_cal}
{$O coup_des}
{$O coup_5}
{$O coup_4}
{$O coup_3}
{$O coup_2}
{$O coup_1}

{$O geo_var}
{$O geo_des}

{$O coupes}
{$O grilles}
{$O Menus}
{$O CSI}
{$O Icones}

{$O symboles}
{$O periphs}
{$O comment}
{$O dirinfo}
{$O graphuti}
{$O lipar}

{$O clavier}
{$O souris}

{$O graphplt}
{$O edition}
{$O utildivs}
{$O fichiers}
{$O graphism}
{$O rs2322}
{$O sekoplt}
{$O imprim}

{$O objects}

{---------------------------------------------------------------------------}

procedure CasMenus;
   var
      Choix             : integer;

   begin
      if changemenus then exit;
      menu (a, b, codeclavier);{ MENU2 }
                               { acquisition d'un choix valide dans un menu }

      if FF1 (codeclavier)     { CSI }
      then                     { appui sur la touche F1 dans un sous-menu   }
         aide (a, b)           { COUP_INI }
      else begin
         if b > 1 then
            Choix := 100*a+b;
         case Choix of         { validation d'une option dans un sous-menu  }
            { menu FICHIERS }
            102  : NOUVEAU_FICHIER;                   { 1 }
            103  : OUVRIR_FICHIER;                    { 1 }
            104  : ENREGISTRER_FICHIER;               { 1 }
            105  : ENREGISTRER_SOUS;                  { 1 }
            106  : VOIR_CATALOGUE;                    { menus5 }

            108  : QUITTER;                           { 1 }

            110  : SUPPRIMER_LIEN;                    { 1  p }
            111  : MODIFIER_LIEN;                     { 1  p }
            112  : VOIR_PARAMETRES;                   { 1  prof }

            { menu COUP  }
            202  : ini_coupe;                         { 2 }
            203  : extremites;                        { 2 }
            204  : d_params_p;                        { 2 }
            205  : d_params_l;                        { 2 }
            206  : CALCULER;                          { 2 }

            { menu LEGENDES }
            302  : COMMENTAIRES;                      { 3 }
            303  : d_CONTOUR;                         { 3 }
            304  : d_toponymie;
            305  : ajouter_nom;
            306  : d_couleurs;

            { menu  ECRAN }
            402  : visu_commentaires;                 { 4 }
            403  : visu_compare;
            404  : visu_carte;                        { 4 }
            405  : visu_symboles;                     { 4 }
            406  : visu_coupes;                       { 4 }
            407  : prep_model;
            408  : change_echelle;                    { 2 }
            409  : visu_toponymie;                    { 4 }
            410  : modif_fenetre_coupe;               { 4 prof }
            411  : modif_fenetre_graph;               { 4 prof }

            { menu SORTIES }
            502  : COPECRAN;                          { 5 }
            504  : TRACE_GRAPH;                       { 5 }
            507  : geo_PALETTEs (nomdumodule);            { 5 prof }
            508  : CONFIG_PERIPH;                     { 5 prof }
            509  : IMPR_PARAM;                        { 5 }

            { menu AIDES }
            602  : AIDE_MENUS_boites (cheminmodule+nomdumodule+exthlp);                        { ini }
            603  : aide (6, 3);
            604  : aide_geoc;
            605  : aide_module;
            606  : aide_region;
            608  : a_propos;
         end;
      end;
   end;

procedure CasIcones;
   var
      PosCur,
      Touche            : integer;

   begin
      if changemenus then exit;
      PosCur := 11;
      if affichetexte            { appui sur F1 au niveau d'une icne       }
      then
         case ZI of
             1 : aide_geoc;
             2 : version_logiciel;
             3 : aide (2, 6);
             4 : aide_module;
         end
      else
         case ZI of
             1     : a_propos;
             3     : CALCULER;
             4     : aide_region;
             5     : visu_gravi;
             6     : visu_topo;
             7     : visu_sismi;
             8     : p_gravi;
             9     : p_topo;
            10     : p_sismi;
            11..12 : change_echelle;
            13..14 : visu_carte;
            15..16 : visu_symboles;
            17..18 : prep_model;
         end;
   end;

procedure CasFenetre;
   begin
      if changemenus then exit;
    (*  if visucomm
      then
         Editer_Commentaires (xs, ys, db)
      else
         if visutoponym
         then
            Editer_noms (xs, ys, db)
         else
            case zone_fenetre (xs, ys) of
               0 : chang_extremites (xs, ys);       { coup_2 }
               1 : chang_coupe (1);                 { coup_2 }
               2 : chang_coupe (2);                 { coup_2 }
               3 : chang_coupe (3);                 { coup_2 }
            end; *)

       if visucomm
       then
          Editer_Commentaires (xs, ys, db);

       if visucontours
       then begin
          if visutoponym
          then
             Editer_noms (xs, ys, db);
       end;

       case zone_fenetre (xs, ys) of
          0 : chang_extremites (xs, ys);       { coup_2 }
          1 : chang_coupe (1);                 { coup_2 }
          2 : chang_coupe (2);                 { coup_2 }
          3 : chang_coupe (3);                 { coup_2 }
       end;
   end;

procedure AutreCas;
   begin
      if changemenus then exit;
   end;

BEGIN                {                  programme principal                 }
   iniparam ;        { initialisation des paramtres par dfaut    COUP_INI }
                     { lecture de fic.CFG                                   }
   inimenus ;        { initialisation de l'interface menus         COUP_INI }
   iniparam2 ;       { initialisation des paramtres par dfaut    COUP_INI }
                     { lecture des fichiers .CPS, .SMP, .TXP                }
   iniicones;        { initialisation des icnes                   COUP_DES }
   inifondecran;     { }
   inidonnees;       { initialisation des donnes                  COUP_INI }

   inisymboles;      { initialisation des polices de symboles      COUP_DES }
   iniecran ;        { initialisation de l'cran/COUP              COUP_DES }
   ini_noms ;        { initialisation des coord des noms des lieux          }
   dessine_tout (false);
   iniaide  ;        { initialisation de l'aide en ligne           COUP_INI }
                     {      lecture de   fic.HLP                            }

   repeat
      modif_menus;      { modifications fonction des paramtres PAR   COUP_INI }
      ini_extrems;
      case ZoneDuClick (maxc1, maxc2, maxc3, maxc4) of                                       { GEO_CSI }
         1 : CasMenus  ;
         2 : CasIcones ;
         3 : CasFenetre;
         4 : autreCas  ;
      end;
      if changemenus
      then
         inversemenus;
   until fini;
   fin;                                                          { COUP_INI }

END.               { programme principal }


{--- GEOCEAN - COUP -------------------------- R.C.- INRP - TOULOUSE - 1995 }
