UNIT ICONES;

        {ͻ}
        {   Bibliothque  ICONES                             }
        {   Version 1.0                           27/01/93   }
        {͹}
        {   Gestion d'icnes graphiques.                     }
        {                                                    }
        {                                                    }
        {ͼ}
   (*
   Icones,                   { ARX     - gestion de icnes                  }
   *)

INTERFACE
   {$O+,F+}

USES
   crt,
   dos,
   Graph,                    { TP 70   - units  standard                   }
   Souris,                   { ARX     - gestion de la  souris              }
   Graphism,                 { ARX     - initialisations graphiques         }
   Utildivs;                 { ARX     - aide                               }

TYPE
   limites         = record
                        xg, xd, yb, yh : integer;
                     end;

Function  dans               (x, y : integer ; l : limites) : boolean;
   {------------------------------------------------------------------------}
   { ROLE Renvoyer vrai si le point x, y est dans les limites l, faux sinon.}
   {------------------------------------------------------------------------}

Function  IconeActive        (n : integer) : boolean;
   {------------------------------------------------------------------------}
   { ROLE   Retourner vrai si l'icne n n est active, faux sinon.          }
   { ENTREE n : entier, numro de l'icne.                                  }
   {------------------------------------------------------------------------}

Function  XGIcone            (n : integer) : integer;
   {------------------------------------------------------------------------}
   { ROLE   Retourner l'abscisse gauche de l'icne (en pixel).              }
   { ENTREE n : entier, numro de l'icne.                                  }
   {    n doit tre suprieur  0 sinon la valeur -1 est renvoye.          }
   {------------------------------------------------------------------------}

Function  XDIcone            (n : integer) : integer;
   {------------------------------------------------------------------------}
   { ROLE   Retourner l'abscisse droite de l'icne (en pixel).              }
   { ENTREE n : entier, numro de l'icne.                                  }
   {    n doit tre suprieur  0 sinon la valeur -1 est renvoye.          }
   {------------------------------------------------------------------------}

Function  YBIcone            (n : integer) : integer;
   {------------------------------------------------------------------------}
   { ROLE   Retourner l'ordonne basse de l'icne (en pixel).               }
   { ENTREE n : entier, numro de l'icne.                                  }
   {    n doit tre suprieur  0 sinon la valeur -1 est renvoye.          }
   {------------------------------------------------------------------------}

Function  YHIcone            (n : integer) : integer;
   {------------------------------------------------------------------------}
   { ROLE   Retourner l'ordonne haute de l'icne (en pixel).               }
   { ENTREE n : entier, numro de l'icne.                                  }
   {    n doit tre suprieur  0 sinon la valeur -1 est renvoye.          }
   {------------------------------------------------------------------------}

Function  Zone               (x, y : integer) : integer;
   {------------------------------------------------------------------------}
   { ROLE   Retourner le numro de l'icne si x,y y est inclu (0 sinon).    }
   { ENTREE x, y : entier, coordonnes du point  tester.                   }
   {------------------------------------------------------------------------}

Procedure  AfficheAide       (n : integer);
   {------------------------------------------------------------------------}
   { ROLE   Afficher le message d'aide associ  l'icne spcifie.         }
   { ENTREE n : entier, numro de l'icne.                                  }
   {------------------------------------------------------------------------}

Procedure ActiveListeIcones  (nomf : pathstr);
   {------------------------------------------------------------------------}
   { ROLE   Dfinir le fichier d'icnes.                                    }
   { ENTREE NomF : chane, nom complet du fichier.                          }
   {------------------------------------------------------------------------}

Procedure active_dess_icone  (num : integer);
   {------------------------------------------------------------------------}
   { ENTREE Num : entier, numro de l'icne.                                }
   {------------------------------------------------------------------------}

Procedure active_icone       (num : integer);
   {------------------------------------------------------------------------}
   { ROLE   Activer l'icne n num (l'affiche).                             }
   { ENTREE Num : entier, numro de l'icne.                                }
   {------------------------------------------------------------------------}

Procedure inactive_icone     (num : integer);
   {------------------------------------------------------------------------}
   { ROLE   Inactiver l'icne n num (affiche l'icne inactive).            }
   { ENTREE Num : entier, numro de l'icne.                                }
   {------------------------------------------------------------------------}

Procedure modi_bouton        (Aide                 : Longchaine;
                              numero, x, y, dx, dy : integer );
   {------------------------------------------------------------------------}
   { ROLE MODIfier une icne de la liste existante.                         }
   {------------------------------------------------------------------------}

Procedure modi_aide_bouton   (Aide : Longchaine; numero : integer);
   {------------------------------------------------------------------------}
   { ROLE MODIfier l'aide d'une icne de la liste existante.                }
   {------------------------------------------------------------------------}

Procedure bouton_icone       (Aide : Longchaine;
                              numero, x, y, dx, dy : integer);
   {------------------------------------------------------------------------}
   { ROLE   Crer une nouvelle icne.                                       }
   { ENTREE Aide : chane, aide associe.                                   }
   {        Numero : entier, numro de l'icne dans le fichier.             }
   {        x, y   : entier, coordonnes du coin haut-gauche (en pixels).   }
   {        dx, dy : entier, taille de la zone active (en pixels).          }
   {------------------------------------------------------------------------}

Procedure Iconetxt           (texte : t20;
                              n, cotxt, coext, coint : integer);
   {------------------------------------------------------------------------}
   { ROLE   Gnrer une ICONE texte                                         }
   { ENTREE texte : libell dans le cadre de l'icne                                    n     : entier, numro de l'icne.
            cotxt : couleur texte
            coext : couleur cadre
            coint : couleur fond                                            }
   {------------------------------------------------------------------------}

Procedure MarquerIcone       (n, co : integer);
   {------------------------------------------------------------------------}
   { ROLE   Encadrer l'icne n de la couleur co.                            }
   { ENTREE Num : entier, numro de l'icne.                                }
   {------------------------------------------------------------------------}

Procedure BorderIcone        (n, co : integer);
   {------------------------------------------------------------------------}
   { ROLE   Border le ct droit de l'icne n avec la couleur co            }
   { ENTREE Num : entier, numro de l'icne.                                }
   {------------------------------------------------------------------------}

Procedure DemarquerIcone     (N : integer);
   {------------------------------------------------------------------------}
   { ROLE   Effacer le cadre autour de l'icne n.                           }
   { ENTREE N : entier, numro de l'icne.                                  }
   {------------------------------------------------------------------------}

Procedure MarquerIconeg      (n, co : integer; var p : pointer);
   {------------------------------------------------------------------------}
   { ROLE   Encadrer l'icne n de la couleur co  et stocker le fond         }
   { ENTREE Num : entier, numro de l'icne.                                }
   {------------------------------------------------------------------------}

Procedure DemarquerIconeg    (n : integer; var p : pointer );
   {------------------------------------------------------------------------}
   { ROLE   Effacer le cadre autour de l'icne n  et restituer le fond      }
   { ENTREE N : entier, numro de l'icne.                                  }
   {------------------------------------------------------------------------}

Procedure LibereIcone        (n : integer);
   {------------------------------------------------------------------------}
   { libre la liste  partir de l'icne N+1                                }
   {------------------------------------------------------------------------}

Procedure LibererIcones;
   {------------------------------------------------------------------------}
   { ROLE   Liberer la place occupe dans le tas par la gestion des icnes. }
   {------------------------------------------------------------------------}

IMPLEMENTATION

TYPE
   liste_de_boites   = ^t_boite;

   t_boite           = record
                        numero    : integer;         { numro de l'icne   }
                        lim       : limites;         { dessin bord externe }
                        s         : liste_de_boites; { pointeur suivant    }
                        etat      : boolean;         { actif/inactif       }
                        aide      : Longchaine;      { aide associe       }
                       end;

VAR
   NomListeIcones       : pathstr;          { Nom du fichier                }
   boites               : liste_de_boites;  { Liste chane d'icnes        }
   NbIcones             : integer;          { Nombre d'icnes dans la liste }

procedure AfficheIcone (n : integer; x, y : integer);
   {------------------------------------------------------------------------}
   { ROLE   Afficher l'image n du fichier en (x, y).                        }
   {------------------------------------------------------------------------}
   type
      int               = record
                             x, y : integer
                          end;

   var
      t, i              : integer;
      p                 : ^int;
      Sequence          : file;
      image, im         : pointer;

   begin
      assign (sequence, NomListeIcones);
      filemode := 0;
      {$I-}
      reset (sequence, 1);
      {$I+}
      image := NIL;
      if ioresult = 0
      then begin
         blockread (sequence, NbIcones, sizeof (integer));
         for i := 1 to n
         do begin
            if image <> NIL
            then
               freeMem (image, t);
            new (p);
            blockread(sequence, p^,4);
            if maxcolor = 1
            then
               t := trunc ((p^.x+8)/8) * (p^.y+1)+6;
            if maxcolor = 15
            then
               t := trunc ((p^.x+8)/8) * (p^.y+1)*4+6;
            dispose (p);
            getmem  (image, t);
            blockread (sequence, image^, t);
         end;

         putimage (x, y, image^, 0);
         close   (sequence);
         libere (image);
      end;
      filemode := 2;
   end;

function  dans (x, y : integer ; l : limites) : boolean;
   {------------------------------------------------------------------------}
   { ROLE Renvoyer vrai si le point x, y est dans les limites l, faux sinon.}
   {------------------------------------------------------------------------}
   begin
      with l do dans := (y > yh) and (y < yb) and (x > xg) and (x < xd);
   end;

procedure cree_boite (num: integer; Aid: Longchaine; xg, yh, xd, yb: integer );
   {------------------------------------------------------------------------}
   { ROLE Empiler une nouvelle icne dans la liste.                         }
   {------------------------------------------------------------------------}
   var
      b                 : liste_de_boites;

   begin
      new (b);
      with b^
      do begin
         lim.xg := xg;     lim.xd := xd;
         lim.yh := yh;     lim.yb := yb;
         numero := num;
         s    := boites;
         etat := false;
         Aide   := Aid;
      end;
      boites := b;
   end;

procedure modi_boite (num: integer; Aid: Longchaine; xg, yh, xd, yb: integer );
   {------------------------------------------------------------------------}
   { ROLE MODIfier une icne de la liste existante.                         }
   {------------------------------------------------------------------------}
   var
      ok                : boolean;
      b                 : liste_de_boites;

   begin
      b    := boites;
      ok   := false;
      while (b <> nil) and (not ok)
      do begin
         if b^.numero = num
         then begin
            ok := true;
            with b^
            do begin
               Aide := aid;
               lim.xg := xg;     lim.xd := xd;
               lim.yh := yh;     lim.yb := yb;
               etat := false;
            end;
         end;
         b  := b^.s;
      end;
   end;

procedure modi_aide (num: integer; Aid: Longchaine);
   {------------------------------------------------------------------------}
   { ROLE MODIfier une icne de la liste existante.                         }
   {------------------------------------------------------------------------}
   var
      ok                : boolean;
      b                 : liste_de_boites;

   begin
      b    := boites;
      ok   := false;
      while (b <> nil) and (not ok)
      do begin
         if b^.numero = num
         then begin
            ok := true;
            with b^
            do begin
               Aide := aid;
            end;
         end;
         b  := b^.s;
      end;
   end;

function  zone ( x, y : integer) : integer;
   {------------------------------------------------------------------------}
   { ENTREE x, y : entier, coordonnes du point  tester.                   }
   {------------------------------------------------------------------------}
   var
      ok                : boolean;
      rep               : integer;
      b                 : liste_de_boites;

   begin
      b   := boites;
      rep := 0;
      while (b <> nil) and (rep = 0)
      do begin
         if dans (x, y, b^.lim) then  rep := b^.numero;
         ok := b^.etat;                { actif/non }
         b  := b^.s;                   { bte suivante }
      end;
      if ok
      then zone := rep
      else zone := 0;
   end;

procedure  AfficheAide (n : integer);
   {------------------------------------------------------------------------}
   { ENTREE n : entier, numro de l'icne.                                  }
   {------------------------------------------------------------------------}
   var
      aide              : Longchaine;
      ok                : boolean;
      b                 : liste_de_boites;

   begin
      b    := boites;
      ok   := false;
      Aide := '';
      while (b <> nil) and (not ok)
      do begin
         if b^.numero = n
         then begin
            ok := true;
            Aide := b^.Aide;
         end;
         b  := b^.s;
      end;
      cachersouris;
      Laide (Aide);
      montrersouris;
   end;

function  IconeActive (n : integer) : boolean;
   {------------------------------------------------------------------------}
   { ENTREE n : entier, numro de l'icne.                                  }
   {------------------------------------------------------------------------}
   var
      b                 : liste_de_boites;
      ok                : boolean;

   begin
      b   := boites;
      ok  := false;
      while (b <> nil) and (not ok)
      do begin
         if b^.numero = n
         then begin
            ok := true;
            IconeActive := b^.etat;
         end;
         b  := b^.s;
      end;
   end;

function  XGIcone (n : integer) : integer;
   {------------------------------------------------------------------------}
   { ENTREE n : entier, numro de l'icne.                                  }
   {    n doit tre suprieur  0 sinon la valeur -1 est renvoye.          }
   {------------------------------------------------------------------------}
   var
      b                 : liste_de_boites;
      ok                : boolean;

   begin
      b   := boites;
      ok  := false;
      XGIcone := -1;
      while (b <> nil) and (not ok)
      do begin
         if b^.numero = n
         then begin
            ok := true;
            XGIcone := b^.lim.xg;
         end;
         b  := b^.s;
      end;
   end;

function  XDIcone (n : integer) : integer;
   {------------------------------------------------------------------------}
   { ENTREE n : entier, numro de l'icne.                                  }
   {    n doit tre suprieur  0 sinon la valeur -1 est renvoye.          }
   {------------------------------------------------------------------------}
   var
      b                 : liste_de_boites;
      ok                : boolean;

   begin
      b   := boites;
      ok := false;
      XDIcone := -1;
      while (b <> nil) and (not ok)
      do begin
         if b^.numero = n
         then begin
            ok := true;
            XDIcone := b^.lim.xd;
         end;
         b  := b^.s;
      end;
   end;

function  YBIcone (n : integer) : integer;
   {------------------------------------------------------------------------}
   { ENTREE n : entier, numro de l'icne.                                  }
   {    n doit tre suprieur  0 sinon la valeur -1 est renvoye.          }
   {------------------------------------------------------------------------}
   var
      b              : liste_de_boites;
      ok             : boolean;

   begin
      b   := boites;
      ok  := false;
      YBIcone := -1;
      while (b <> nil) and (not ok)
      do begin
         if b^.numero = n
         then begin
            ok := true;
            YBIcone := b^.lim.yb;
         end;
         b  := b^.s;
      end;
   end;

function  YHIcone (n : integer) : integer;
   {------------------------------------------------------------------------}
   { ENTREE n : entier, numro de l'icne.                                  }
   {    n doit tre suprieur  0 sinon la valeur -1 est renvoye.          }
   {------------------------------------------------------------------------}
   var
      b                 : liste_de_boites;
      ok                : boolean;

   begin
      b   := boites;
      ok  := false;
      YHIcone := -1;
      while (b <> nil) and (not ok)
      do begin
         if b^.numero = n
         then begin
            ok := true;
            YHIcone := b^.lim.yh;
         end;
         b  := b^.s;
      end;
   end;

procedure des_icone (b : liste_de_boites);
   {------------------------------------------------------------------------}
   { ROLE   Afficher l'icne b de la liste en fonction de son tat.         }
   {------------------------------------------------------------------------}
   var
      n                 : byte;

   begin
      if b^.etat then n := 0 else n := 1;
      if b^.Numero <= NbIcones
      then
         AfficheIcone (2 * (b^.Numero)-1 + n, b^.lim.xg, b^.lim.yh);
   end;

procedure inactive_icone (num : integer);
   {------------------------------------------------------------------------}
   { ENTREE Num : entier, numro de l'icne.                                }
   {------------------------------------------------------------------------}
   var
      b                 : liste_de_boites;

   begin
      if iconeactive (num)
      then begin
         b  := boites;
         while (b <> nil) and (num <> b^.numero)
         do begin
            b  := b^.s;
         end;
         if b <> nil
         then begin
            b^.etat := false;
            des_icone (b);
         end;
      end;
   end;

procedure active_dess_icone ( num : integer);
   {------------------------------------------------------------------------}
   { ENTREE Num : entier, numro de l'icne.                                }
   {------------------------------------------------------------------------}
   var
      b                 : liste_de_boites;

   begin
         b  := boites;
         while (b <> nil) and (num <> b^.numero)
         do begin
            b  := b^.s;
         end;
         if b <> nil
         then begin
            b^.etat := true;
            des_icone (b);
         end;
   end;

procedure active_icone ( num : integer);
   {------------------------------------------------------------------------}
   { ENTREE Num : entier, numro de l'icne.                                }
   {------------------------------------------------------------------------}
   var
      b                 : liste_de_boites;

   begin
      if (not iconeactive (num))
      then
         Active_dess_icone (num);
   end;

procedure ActiveListeIcones (nomf : Pathstr);
   {------------------------------------------------------------------------}
   { ENTREE NomF : chane, nom complet du fichier.                          }
   {------------------------------------------------------------------------}
   var
      sequence          : file;

   begin
      NomListeIcones := nomf;
      filemode := 0;
      assign (sequence, NomListeIcones);
      {$I-}
      reset  (sequence, 1);
      {$I+}
      if ioresult = 0
      then begin
         blockread (sequence, NbIcones, sizeof (integer));
         close (sequence);
      end;
      filemode := 2;
   end;

procedure modi_bouton  (Aide : Longchaine; numero, x, y, dx, dy : integer );
   begin
      modi_boite  (numero, Aide, x, y, x+dx, y+dy);
   end;

procedure modi_aide_bouton (Aide : Longchaine; numero : integer);
   begin
      modi_aide   (numero, aide);
   end;

procedure bouton_icone ( Aide : Longchaine ; numero, x, y, dx, dy  : integer);
   {------------------------------------------------------------------------}
   { ENTREE Aide : chane, aide associe.                                   }
   {        Numero : entier, numro de l'icne dans le fichier.             }
   {        x, y   : entier, coordonnes du coin haut-gauche (en pixels).   }
   {        dx, dy : entier, taille de la zone active (en pixels).          }
   {------------------------------------------------------------------------}
   var
      nul               : boolean;

   begin
      cree_boite    (numero, Aide, x, y, x+dx, y+dy);
   end;

Procedure Iconetxt (texte : t20; n, cotxt, coext, coint : integer);
   {------------------------------------------------------------------------}
   { ENTREE texte : libell dans le cadre de l'icne
            n     : entier, numro de l'icne.
            cotxt : couleur texte
            coext : couleur cadre
            coint : couleur fond                                            }
   {------------------------------------------------------------------------}
   var
      b                 : liste_de_boites;

   begin
      b  := boites;
      while (b <> nil) and (n <> b^.numero)
      do begin
         b  := b^.s;
      end;
      if b <> nil
      then begin
         { remplissage }
         coulbar   (1, coint);
         bar       (b^.lim.xg, b^.lim.yh, b^.lim.xd, b^.lim.yb);

         { cadre }
{         setcolor (numcouleur (nomcouleur (coext)));  }
         setcolor (couleurnum (coext));
{         SetLineStyle (0, 1, 3); pais }
         Rectangle (b^.lim.xg, b^.lim.yh, b^.lim.xd, b^.lim.yb);
{         SetLineStyle (0, 1, 1); normal }

         { texte }
{         setcolor (couleurnum (cotxt));          ok si coext <> fond    }
         setcolor (numcouleur (nomcouleur (cotxt)));
         setusercharsize (1, 1, 1, 1);
         settextjustify  (1, 1 );
         outtextxy ((b^.lim.xg +b^.lim.xd) div 2 ,
                    (b^.lim.yh +b^.lim.yb) div 2 , texte);
         setusercharsize (3, 2, 3, 2);
         settextjustify  (0, 2);
      end;
   end;

procedure MarquerIcone (n, co : integer);
   {------------------------------------------------------------------------}
   { ENTREE Num : entier, numro de l'icne.                                }
   {------------------------------------------------------------------------}
   var
      b                 : liste_de_boites;

   begin
      b  := boites;
      while (b <> nil) and (n <> b^.numero)
      do begin
         b  := b^.s;
      end;
      if b <> nil
      then begin
         SetColor (co);
         SetLineStyle (0, 1, 3); { 1 normal  3 pais}
         Rectangle (b^.lim.xg-2, b^.lim.yh-2, b^.lim.xd+1, b^.lim.yb+1);
         SetLineStyle (0, 1, 1);
      end;
   end;

procedure DemarquerIcone (n : integer);
   {------------------------------------------------------------------------}
   { ENTREE N : entier, numro de l'icne.                                  }
   {------------------------------------------------------------------------}
   begin
      MarquerIcone (n, coulecran);
   end;

procedure BorderIcone (n, co : integer);
   var
      b                 : liste_de_boites;

   begin
      b  := boites;
      while (b <> nil) and (n <> b^.numero)
      do begin
         b  := b^.s;
      end;
      if b <> nil
      then begin
         SetColor (co);
         SetLineStyle (0, 1, 3); { 1 normal  3 pais}
         line (b^.lim.xd+1, b^.lim.yh-2, b^.lim.xd+1, b^.lim.yb+1);
         SetLineStyle (0, 1, 1);
      end;
   end;

procedure MarquerIconeg (n, co : integer; var p : pointer);
   {------------------------------------------------------------------------}
   { ENTREE Num : entier, numro de l'icne.                                }
   { SORTIE p   : pointeur sur l'image .                                    }
   {------------------------------------------------------------------------}
   var
      t                 : longint;
      b                 : liste_de_boites;

   begin
      b  := boites;
      while (b <> nil) and (n <> b^.numero)
      do begin
         b  := b^.s;
      end;
      if b <> nil
      then begin
         t := imagesize (b^.lim.xg-4, b^.lim.yh-4, b^.lim.xd+3, b^.lim.yb+3);
         getmem   (p, t);
         getimage (b^.lim.xg-4, b^.lim.yh-4, b^.lim.xd+3, b^.lim.yb+3, p^);
         SetColor (co);
         SetLineStyle (0, 1, 3);
         Rectangle (b^.lim.xg-3, b^.lim.yh-3, b^.lim.xd+2, b^.lim.yb+2);
         SetLineStyle (0, 1, 1);
      end;
   end;

procedure DemarquerIconeg (n : integer; var p : pointer);
   {------------------------------------------------------------------------}
   { ENTREE N : entier, numro de l'icne, pointeur sur l'image.            }
   {------------------------------------------------------------------------}
   var
      b                 : liste_de_boites;

   begin
      if n <> 0
      then begin
         b  := boites;
         while (b <> nil) and (n <> b^.numero)
            do  b  := b^.s;

         if (b <> nil) and (p <> nil)
         then begin
            putimage (b^.lim.xg-4, b^.lim.yh-4, p^, normalput);
            libere (p);
         end;
      end;
   end;

procedure  LibereIcone (n : integer);
   {------------------------------------------------------------------------}
   { libre la liste  partir de l'icne N+1                                }
   { libre la liste jusqu' l'icne N                                      }
   {------------------------------------------------------------------------}
   var
      b, bb             : liste_de_boites;
      i                 : integer;

   begin
      b   := boites;

      while b^.numero > n
      do begin
         bb := b;
         b  := b^.s;
         dispose (bb);
      end;
      boites := b;
   end;

procedure  LibererIcones;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      b, bb             : liste_de_boites;

   begin
      b   := boites;
      while (b <> nil)
      do begin
         bb := b;
         b  := b^.s;
         dispose (bb);
      end;
   end;

BEGIN

   boites := nil;

END.

   {-------------------------------- ICONES  -------------------------------}
