Procedure Calculer;
   const
      K = 6.67E-3;

   var
      Poly                          : PRoche;
      p1, p2                        : PPoint;
      x, y,
      Fac1, Fac2, ggg, Alpha, Beta,
      Gamma, dx1, dx2, dy1, dy2,
      rg1, rg2, resg, supg          : real;
      F                             : text;
      np, npt,
      Station                       : integer;
      ok                            : boolean;

   procedure arct (rn, d : real; var r : real);
   {----------------------------------------------------------------------}
   {----------------------------------------------------------------------}
   begin
      if d=0 then begin
         if rn = 0 then r:=0;
         if rn<0 then r := -pi/2;
         if rn>0 then r:=pi/2;
      end else
         if d>0 then
            r := arctan (rn/d)
         else if rn>=0 then
            r := arctan(rn/d)+pi
         else
            r := arctan(rn/d)-pi;
   end;

   procedure difarc (n1, d1, n2, d2 : real; var res : real);
   {----------------------------------------------------------------------}
   {----------------------------------------------------------------------}
   var
      r1, r2, r3 : real;
   begin
      arct (n1, d1, r1);
      arct (n2, d2, r2);
      r3 := r1-r2;
      if abs(r3)<=pi then
         res := r3
      else if r3<0 then
         res := r3+2*pi
      else
         res := r3-2*pi;
   end;

   begin
      if aidemenu then aide_menus;
      laide ('Calcul en cours ...');
      MontrerSouris;
      ChangerCurseur (Sablier);

      GenererContrastes;
{      contrastes := lemodele;}

      { MISE A ZERO DE L'ANOMALIE }
      for station := 1 to NbStations do
         Anomalie^[Station] := 0;

      { POUR CHAQUE POLYGONE p }
      for np := 1 to Contrastes^.count
      do begin
         Poly := Contrastes^.at (np-1);
         { POUR CHAQUE STATION s }
         for Station := 1 to NbStations
         do begin
            x := StationX^[Station];
            y := StationY^[Station];

            ggg := 0;

            { CALCUL POUR CHAQUE POINT i (Gp) }
            for npt := 1 to Poly^.count
            do begin
               p1 := Poly^.at (npt-1);
               p2 := Poly^.at (npt mod Poly^.count);

             {  if p1^.x < fc1+((fc2-fc1)/50)
               then dx1 := fc1-(fc2-fc1) - x
               else if p1^.x > fc2-((fc2-fc1)/50)
                    then dx1 := fc2+(fc2-fc1) - x
                    else} dx1 := p1^.x - x;

               dy1 := p1^.y - y;

               rg1 := dx1*dx1+dy1*dy1;

             {  if p2^.x < fc1+((fc2-fc1)/50)
               then dx2 := fc1-(fc2-fc1) - x
               else if p2^.x > fc2-((fc2-fc1)/50)
                    then dx2 := fc2+(fc2-fc1) - x
                    else} dx2 := p2^.x - x;

               dy2 := p2^.y - y;

               rg2 := dx2*dx2+dy2*dy2;

               Alpha := dx2-dx1;
               Beta  := dx1*dy2-dx2*dy1;
               gamma := dy2-dy1;

               if beta=0 then
                  supg := 0
               else begin
                  Difarc (dy1, dx1, dy2, dx2, resg);
                  fac1 := Beta/(Alpha*Alpha+Gamma*Gamma);
                  Fac2 := Alpha*Resg + Gamma*ln(rg2/rg1)/2;
                  supg := fac1*fac2;
               end;

               ggg := ggg+supg;

            end;

            { MISE A JOUR DE L'ANOMALIE POUR UNE STATION }
            anomalie^[station] := anomalie^[station] - 40*(ggg * Poly^.Densite)/3;
         end;
      end;

      changerCurseur (fleche);
      CacherSouris;
      dess_modele (false);
      laide ('');
   end;

